/*
    Copyright (C) 2000 - 2001 Kai Heitkamp, kai@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include <qvariant.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qprogressbar.h>
#include <qpushbutton.h>
#include <qtextedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

#include <klocale.h>

#include "processoutput.h"

static const char* const processoutput_image0_data[] = {
"32 32 253 2",
"Qt c None",
"#q c #000000",
"b5 c #000400",
"a8 c #080400",
"b4 c #080408",
"ba c #080800",
"#5 c #080808",
"b6 c #080c00",
"bj c #100c00",
"bs c #100c08",
"ae c #181c18",
"ap c #201c20",
".o c #313031",
".a c #313431",
".c c #393439",
"af c #393839",
"ax c #393c39",
"#4 c #414041",
".f c #414441",
".e c #4a484a",
".F c #525052",
"a# c #525552",
".E c #625d62",
".4 c #626162",
"#1 c #6a656a",
"#B c #830000",
"ay c #837d83",
".U c #838183",
"bt c #8b9d8b",
".D c #943094",
"a9 c #949194",
"ak c #949594",
"#J c #94b294",
".b c #9c349c",
"bn c #9c9d9c",
"aA c #9ca59c",
"a4 c #9caa9c",
"aq c #9cca9c",
"aU c #a440a4",
"b2 c #a48583",
".n c #a48d8b",
"aY c #a4a1a4",
"#T c #a4a5a4",
"bO c #ac4cac",
"aw c #ac5052",
"#f c #ac505a",
".5 c #ac595a",
".C c #ac8183",
"bX c #ac918b",
"#V c #ac999c",
"b3 c #aca5ac",
"aK c #acaaac",
"bb c #acb2ac",
"#z c #acdeac",
"bF c #ace2ac",
"#l c #b4505a",
".p c #b47d83",
"be c #b4ae9c",
".l c #b4b2b4",
".j c #b4b6b4",
"a. c #b4c2b4",
"bA c #b4d2b4",
"#p c #b4e2ac",
"bL c #b4e2b4",
".h c #bdbabd",
"aj c #bdbaff",
"bf c #bdbebd",
"ai c #bdbeff",
"#9 c #bdcaff",
"#0 c #bdcef6",
"bc c #bdd2ee",
"ah c #bdd2f6",
"bk c #bddeff",
"#Z c #bde2e6",
"bB c #bdeaff",
"bd c #bdffbd",
"ag c #bdffc5",
".T c #c591c5",
"#6 c #c5999c",
"aB c #c5bae6",
"aC c #c5bed5",
"as c #c5beff",
"ad c #c5c2c5",
"#K c #c5c6c5",
"#d c #c5d2ac",
"#Y c #c5ffbd",
"#8 c #c5ffc5",
"aT c #cdbe94",
"aM c #cdbebd",
"aD c #cdbec5",
"a3 c #cdbecd",
"aN c #cdc2b4",
"aX c #cdc2bd",
"aE c #cdcacd",
"#y c #cdffbd",
"#I c #cdffc5",
".d c #d5656a",
"bJ c #d5ba6a",
"av c #d5be6a",
"aR c #d5be94",
"a7 c #d5c26a",
"a1 c #d5c27b",
"aH c #d5c283",
"aQ c #d5c29c",
"a2 c #d5c683",
"aP c #d5c6a4",
".2 c #d5c6ac",
"aW c #d5c6b4",
"#A c #d5d6d5",
"bQ c #deba6a",
".S c #debaac",
"#s c #debe6a",
".8 c #debe73",
"b0 c #dec273",
".M c #dec27b",
".K c #dec66a",
"bi c #dec673",
"a6 c #deca7b",
"at c #dece94",
"az c #dedede",
"#e c #e681e6",
"bY c #e6aeac",
".3 c #e6b2e6",
"bK c #e6ca7b",
".I c #e6ce7b",
"#R c #e6d283",
"bx c #e6d683",
"ab c #e6d68b",
"aa c #e6d694",
"bv c #eeba94",
"#. c #eebe8b",
".O c #eec28b",
"bg c #eed68b",
"bT c #eeda8b",
".6 c #f67573",
"b1 c #f691f6",
"bz c #f6e294",
"bU c #f6e69c",
"#N c #f6e6a4",
"a5 c #f6f2f6",
"bG c #f6fabd",
"#x c #f6ffc5",
"#M c #ff0000",
"#L c #ff3c00",
"#2 c #ff4000",
".G c #ff505a",
".# c #ff50bd",
"#g c #ff656a",
".W c #ff7573",
".q c #ff95d5",
"bm c #ff999c",
".g c #ff99ff",
"#U c #ff9dff",
".m c #ffa1ff",
"aS c #ffa5ff",
".A c #ffb2b4",
".V c #ffb2ee",
"## c #ffbaa4",
"bP c #ffbaac",
"#u c #ffbab4",
"aV c #ffbaff",
"aZ c #ffbe6a",
"bC c #ffbe7b",
"#F c #ffbe83",
"#m c #ffbe9c",
".P c #ffbea4",
"#G c #ffbeac",
".0 c #ffbeb4",
".Q c #ffbebd",
"ar c #ffbeff",
".u c #ffc26a",
"b. c #ffc273",
"aI c #ffc27b",
".w c #ffc283",
".y c #ffc294",
".Z c #ffc29c",
"aO c #ffc2b4",
"bN c #ffc2c5",
"#h c #ffc2f6",
"#n c #ffc2ff",
"#E c #ffc673",
"aF c #ffc694",
"bV c #ffc6b4",
".H c #ffc6c5",
"#O c #ffc6cd",
"b# c #ffc6ff",
".s c #ffca7b",
"am c #ffca83",
"#W c #ffcabd",
"#b c #ffcac5",
"#i c #ffcacd",
"#j c #ffcaff",
"bo c #ffce7b",
"al c #ffce8b",
"bW c #ffcec5",
"#k c #ffceee",
".1 c #ffceff",
"ao c #ffd283",
"#H c #ffd2c5",
"aL c #ffd2ff",
"br c #ffd683",
"#C c #ffd68b",
"bH c #ffd6c5",
"#7 c #ffd6ff",
"#w c #ffdabd",
".B c #ffdaff",
"bq c #ffde94",
"#3 c #ffdea4",
"#o c #ffdec5",
"#S c #ffdeff",
".R c #ffe2ff",
"bE c #ffe69c",
"#c c #ffe6bd",
".k c #ffe6ff",
".i c #ffeaff",
"bR c #ffee6a",
"bw c #ffee7b",
"bD c #ffeecd",
"aJ c #ffeed5",
"bI c #ffeee6",
"#a c #ffeeff",
"bZ c #fff26a",
".L c #fff273",
".9 c #fff283",
"#P c #fff2b4",
"bp c #fff2bd",
".7 c #fff2d5",
"a0 c #fff2de",
"#t c #fff2e6",
"aG c #fff2ee",
".Y c #fff2f6",
".z c #fff2ff",
"#r c #fff673",
"by c #fff6bd",
"bl c #fff6c5",
".t c #fff6d5",
".v c #fff6de",
".N c #fff6e6",
".x c #fff6f6",
".r c #fff6ff",
"au c #fffa8b",
"bu c #fffabd",
"bM c #fffac5",
".J c #fffade",
"an c #fffae6",
"#v c #fffaff",
"bh c #ffff7b",
"bS c #ffff83",
"#X c #ffffc5",
"#D c #ffffe6",
"ac c #ffffee",
"#Q c #fffff6",
".X c #ffffff",
"QtQtQtQtQtQtQtQt.#QtQt.a.b.a.c.a.b.a.cQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQt.d.e.f.g.h.i.j.k.l.m.n.o.o.oQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.p.q.p.r.s.t.u.v.w.x.y.z.A.B.C.DQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQt.E.F.G.H.G.I.J.K.L.M.N.O.z.P.i.Q.R.S.o.eQtQtQtQtQtQtQt",
"QtQtQtQt.T.U.V.W.X.W.V.s.J.u.v.w.Y.Z.z.0.r.1.X.2.3.eQtQtQtQtQtQt",
"QtQtQt.4.5.G.6.X.X.X.6.G.p.7.8.9#..z###a#b.X#c.X#d#e.eQtQtQtQtQt",
"Qt#f.##g#h#i.X.X.X.X.X#j#k.d.##l.Y#m#a#n.X#o.X.X.X#p#qQtQtQtQtQt",
"QtQt.F.X.p.G.6.X.X.X.6.G.p#r#s#t.O#a#u#v#w.X#x.X#y.X#z#qQtQtQtQt",
"Qt.F.B#A.X#B.V.W.X.W.V#C#D#E.7#F.z#G.z#H.X.X.X#I.X.k.X#J#qQtQtQt",
"Qt.E#K.X#L#M#N.G#O.G#P#Q#R#S#T#U#V.i#W.X#X.X#Y.X#Z.X#0#v#qQtQtQt",
"Qt#1.X#2#M#3.X.p#h.p.X#n.i#4#q#5#4#6#7#v.X#8.X#S.X#9.ra.#qQtQtQt",
"a##S#L#Maa#Qabac.d#Qad.gaeaf#q#5#q#q.U.zag.Xah#vai#aaj#aak#qQtQt",
".T#2#Malacaman.s.#ao.iap.k.U.X.X.3#q#qaq.X#j.zaj#aar.zas.R#qQtQt",
"#L#Matau.M.7av.Law#Saxafay.XQtQtaz#e#q#4aA#aaB.zaC.zaD.z.j#qQtQt",
"#MaE.XaFaGaH#taIaJaK#q#q.XQtQtQtQt.X#q#qaLaM.z#n.zaN.raO.i#qQtQt",
".e.zaP.raQ.zaQ.zaRaS#5#5.XQtQtQtQt.X#5#5#T.YaT.zaQ.zaQ.r.h#qQtQt",
"aUaV.raW.zaO.zaX.zaY#4#q.3#SQtQt.X.Uaf#4#SaZa0a1#t.waGa2#a#qQtQt",
".c.kaX.za3.zaC.zaB#aa4#q#q#ea5.Xay.k#5.ka6.ta7.Lav.7a7.L.ja8QtQt",
".ca9.zar.zas#aaV.z#9#a.U#q#q#q#5afap#j#n#Qao#D#E.tb..tb.b#baQtQt",
"Qt.obb#aaj#aai#vbc.Xbd.zbe#4#q#5ax.Rbf.X#P.Xbg#D.Ibhbi.rbjQtQtQt",
"Qt.o#Sai.r#j.Xbk.X.X.Xbl.Xbm.1bn.Bbo#Qbp.X.r.Xbq#Qbr#D.hbsQtQtQt",
"Qt.obt#v#0.X#Z.X#8.Xbu.X#b.ibvbwav.Jbx.Xby.Xby.Xbz#Qad.B#qQtQtQt",
"QtQt#qbA.XbB.X.X.X#X.XaL.z.P.YbCbD#E#Dbq.Xby.X.r.XbE.X#qQtQtQtQt",
"QtQtQt#qbF.X#I.XbG.XbH#v#u#a#.bIbJ#rbKacbz.Xby.Xby.X#qQtQtQtQtQt",
"QtQtQt.e.3bL.XbM.X#S.XbN#a.P.YbC.7.u.Jbr#QbE.Xby.X.UbOQtQtQtQtQt",
"QtQtQtQt#4#e#d.X#o.X#W#abP.z#..9bQbRbibSbT#QbU.X.U.eQtQtQtQtQtQt",
"QtQtQtQtQt.e#qbV#abW.r.0.z.Z.Y.w.7av.taoac.j.X#qbOQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt#qbX#SbY.i.P.z.O#t.8bZb0.r.lb1#qQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQt#q#q#qb2.1.A.R.l.kb3aLbab4#qQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQt#q#q#q#qb5a8bsb6QtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const processoutput_image1_data[] = {
"397 24 134 2",
"#U c #00007b",
"#T c #00047b",
"#R c #00087b",
"#S c #080483",
"#Q c #080883",
"#6 c #080c7b",
"#N c #080c83",
"#5 c #08107b",
"#M c #081083",
"#P c #100c8b",
"#L c #101083",
"#O c #10108b",
"#J c #101483",
"#K c #10148b",
"#G c #101883",
"#I c #10188b",
"ad c #101c83",
"#F c #101c8b",
"ac c #10208b",
"#H c #18188b",
"#E c #181c8b",
"#C c #18208b",
"#D c #182094",
"#z c #18248b",
"#A c #182494",
"#4 c #18288b",
"#y c #20248b",
"#B c #202494",
"#x c #20288b",
"#w c #202894",
"#t c #202c94",
"#r c #203094",
"#8 c #20309c",
"#q c #203494",
"#v c #292c94",
"#u c #292c9c",
"#s c #29309c",
"#o c #293494",
"#p c #29349c",
"ab c #293894",
"#n c #29389c",
"#l c #293c9c",
"#i c #29409c",
"#k c #313c9c",
"#m c #313ca4",
"#h c #31409c",
"#j c #3140a4",
"#f c #31449c",
"#g c #3144a4",
"#e c #31489c",
"#d c #3148a4",
"#c c #3948a4",
"#b c #394ca4",
"#a c #394cac",
"#. c #3950a4",
".9 c #3950ac",
"#3 c #3955a4",
".8 c #3955ac",
"aa c #3959ac",
"## c #4150ac",
".7 c #4155ac",
"#2 c #4159a4",
".6 c #4159ac",
"#1 c #415da4",
".4 c #415dac",
"#7 c #415db4",
".2 c #4161ac",
".5 c #4a5dac",
".1 c #4a61ac",
".3 c #4a61b4",
".Z c #4a65ac",
".0 c #4a65b4",
"#0 c #4a69ac",
".X c #4a69b4",
".W c #5269b4",
".Y c #5269bd",
".V c #526db4",
".T c #526dbd",
".R c #5271b4",
".U c #5271bd",
".Q c #5275b4",
"#Z c #5279b4",
"a# c #5279bd",
".S c #5a71bd",
".P c #5a75bd",
".O c #5a79bd",
".L c #5a7dbd",
".M c #5a7dc5",
"#Y c #5a81bd",
".N c #627dc5",
".K c #6281bd",
".J c #6281c5",
".H c #6285c5",
".F c #6289c5",
".E c #628dc5",
"#X c #6a85c5",
".I c #6a85cd",
".G c #6a89cd",
".D c #6a8dcd",
".B c #6a91c5",
".C c #6a91cd",
".A c #6a95cd",
".y c #6a99cd",
".z c #7395cd",
".w c #7399cd",
".x c #7399d5",
".u c #739dcd",
".v c #739dd5",
".t c #73a1cd",
".r c #73a1d5",
"#W c #73a5cd",
".q c #73a5d5",
".s c #7ba1d5",
".p c #7ba5d5",
".o c #7baad5",
".n c #7baed5",
"#V c #7bb2d5",
".m c #83aede",
"a. c #83b2d5",
".l c #83b2de",
".j c #83b6de",
".g c #83bade",
".k c #8bb6de",
".i c #8bbade",
".h c #8bbae6",
".e c #8bbede",
".f c #8bbee6",
".d c #8bc2de",
".c c #8bc2e6",
"#9 c #8bc6e6",
".b c #94c2e6",
".# c #94c6e6",
".a c #94c6ee",
"Qt c #94caee",
"Qt.#Qt.#.a.#.a.#.a.b.#.c.#.c.b.c.b.d.b.d.b.e.c.e.f.e.f.g.f.g.f.g.h.i.h.j.h.j.h.j.k.j.j.l.j.l.j.l.l.l.l.m.l.m.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.r.u.v.u.v.w.v.w.x.y.x.z.x.A.x.A.z.A.z.A.A.B.A.B.C.B.C.D.C.D.C.D.D.E.D.E.D.F.D.F.F.F.G.H.G.H.I.H.H.H.H.J.H.K.J.K.J.L.J.M.J.L.J.L.N.L.M.O.L.O.L.O.O.O.O.P.O.P.O.P.P.Q.P.Q.P.R.P.R.R.R.S.T.U.V.T.V.T.V.T.W.T.X.Y.X.W.X.W.X.W.Z.W.0.0.Z.0.1.0.2.3.2.3.2.1.4.1.4.5.4.4.4.4.6.4.6.6.6.6.6.7.7.7.8.7.9.7#..7#..7#.###..9#.#a#b#a#b#a#c#b#c#b#c#b#d#c#d#c#e#c#f#d#f#g#f#g#f#g#h#g#i#j#i#j#i#j#k#j#l#m#l#m#l#k#n#l#n#n#n#n#n#n#o#n#o#n#o#p#q#p#r#p#r#s#r#r#t#u#t#v#t#v#w#t#w#w#w#w#x#w#y#w#z#w#A#w#z#B#z#B#z#A#C#A#C#D#C#C#C#C#E#C#F#E#F#E#F#E#G#E#G#H#G#I#G#H#J#I#J#K#J#J#L#J#L#J#M#L#M#L#N#O#N#O#N#P#N#N#Q#N#Q#N#R#Q#R#Q#R#Q#S#S#T#S#U#T#U#U#U#U#U#U",
".#.a.#.#.#.#.c.#.c.#.c.b.c.b.d.c.d.c.d.d.e.f.e.f.g.f.g.f.g.h.g.i.j.h.j.i.j.k.j.j.l.j.l.j.l.l#V.l.m.l.n.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.o.o.p.o#W.p.r.p.t.q.r.r.t.r.u.s.u.t.u.v.u.v.w.v.y.u.y.x.y.w.A.w.A.z.A.z.A.A.C.A.B.C.B.C.E.B.D.C.E.D.E.D.E.D.F.D.F.F.F.F.H.F.H#X.H.H.H.H.J.H.J.H#Y.J#Y.J.L.K.L.J.L.M.L.M.L.L.O.L.O.O.O.O#Z.O.P.O.Q.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.X.T.X.W.X.W.X.W.0.X#0.W.Z.X.Z.0.2.0.2.0.2.3.2.3.4.1.4.5#1.4.4.4#2.4.6.4.6.6.6.6#3.6.8.7#3.7#..7#..7#.###.#.#.#.#b#.#b#b#b#b#c#b#d#b#d#c#e#c#e#c#f#d#f#g#f#f#f#f#i#f#i#g#i#h#i#j#l#h#l#m#l#k#l#k#n#l#n#n#n#n#n#n#q#n#o#n#q#o#q#p#q#o#r#p#r#r#r#r#t#r#t#v#t#t#w#t#x#t#x#w#4#w#z#w#z#x#z#B#z#A#z#A#C#A#C#C#C#C#C#C#F#C#F#E#F#E#F#E#G#E#G#I#G#G#G#G#J#G#J#I#J#J#J#J#M#J#M#L#5#L#5#L#6#M#N#O#N#N#N#N#R#N#R#Q#R#Q#R#Q#T#Q#T#S#T#T#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.#.c.a.c.#.c.b.c.b.d.b.d.c.e.c.e.f.e.f.i.f.g.f.g.h.g.h.j.h.j.h.j.j.j.k.l.j.l.j.l.l.l.l.m.l.n.l.m.m.n.m.o.m.o.m.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.s.u.v.u.v.w.v.y.x.w.x.A.x.A.w.A.z.A.z.A.z.C.A.B.C.B.C.D.C.D.C.E.D.D.D.E.D.F.D.F.F.F.G.H.G.H#X.H#X.H.H.J.H.J.J#Y.J.L.J.L.J.L.J.L.N.L.L.O.M.O.L.O.O.O.O.P.O.P.O.Q.P.P.P.Q.P.R.P.R.R.R.U.T.S.T.T.V.T.V.T.X.T.X.W.X.W.X.W.X.W.Z.X.Z.0.Z.0.1.0.3.3.2.3.2.1.4.1.4.5.4.5.4.4.6#7.6.6.6.6.6.7.7.7.7.7#..7.9.7#..7#.###.###.#a#b#a#b#b#c#b#c#b#d#b#d#c#e#c#d#d#f#c#f#g#f#g#f#g#h#g#h#j#i#j#i#j#l#j#l#m#l#m#l#l#n#k#n#n#n#n#n#n#o#n#o#n#q#p#o#p#r#p#r#s#r#8#t#v#t#u#t#v#w#v#w#w#x#w#x#w#z#w#y#w#A#w#A#B#z#B#z#A#C#A#C#C#C#C#C#C#E#C#E#E#F#E#F#E#G#E#G#I#G#I#G#H#J#H#J#K#J#J#L#J#M#J#M#L#5#L#N#L#N#O#N#N#N#N#Q#N#Q#N#Q#Q#R#Q#R#Q#T#S#T#S#U#S#U#U#U#U#U#U",
".#.a.#.a#9.#.c.#.c.#.c.b.c.c.c.b.d.c.d.c.e.f.e.f.g.e.g.f.g.i.g.h.j.h.j.h.j.j.j.k.l.j.l.ja..la..l.n.l.m.l.n.m.n.m.o.n.o.n.o.o.o.o.o.o.o.o#W.o.q.p.t.p.r.p.r.r.r.r.u.r.u.r.u.v.u.v.y.v.w.v.y.w.y.x.A.w.A.z.A.A.A.z.B.A.B.C.B.C.E.C.E.C.D.D.E.D.E.D.F.D.F.F.F.F.H.F.H.H.H.H.H.H.J.H.K.H.K.J#Y.J.L.J.L.J.L.N.L.L.L.M.O.L.O.Oa#.Oa#.O.Q.O.P.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.W.T.X.W.X.W.X.X.0.W#0.X.Z.X.Z.0.1.0.2.0.2.3.2.3.4.1.4.4.4.4#1.4#2.4#2.4.6.6aa.6.8.6#3.7.8.7#..7#..7#..9#..9#.#.#b#.#b#b#b#b#d#b#d#b#e#c#d#c#e#d#f#c#f#f#f#f#f#f#h#f#i#f#i#h#i#h#l#j#l#m#l#m#l#l#n#k#n#n#n#nab#n#o#n#qab#o#o#q#o#q#p#r#o#r#8#r#r#t#r#t#t#t#t#w#t#w#t#4#w#x#w#z#x#z#w#z#B#z#B#z#A#C#A#C#C#C#Cac#C#F#C#F#E#F#Ead#E#G#E#G#I#G#I#G#G#J#G#J#I#J#J#J#J#M#J#5#L#M#L#5#M#6#L#N#M#N#N#N#N#Q#N#R#Q#R#Q#R#Q#T#Q#T#S#T#S#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.a.b.#.c.#.c.b.c.b.d.b.d.b.e.c.e.f.e.f.g.f.g.f.g.h.i.h.j.h.j.h.j.k.j.j.l.j.l.j.l.l.l.l.m.l.m.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.r.u.v.u.v.w.v.w.x.y.x.z.x.A.x.A.z.A.z.A.A.B.A.B.C.B.C.D.C.D.C.D.D.E.D.E.D.F.D.F.F.F.G.H.G.H.I.H.H.H.H.J.H.K.J.K.J.L.J.M.J.L.J.L.N.L.M.O.L.O.L.O.O.O.O.P.O.P.O.P.P.Q.P.Q.P.R.P.R.R.R.S.T.U.V.T.V.T.V.T.W.T.X.Y.X.W.X.W.X.W.Z.W.0.0.Z.0.1.0.2.3.2.3.2.1.4.1.4.5.4.4.4.4.6.4.6.6.6.6.6.7.7.7.8.7.9.7#..7#..7#.###..9#.#a#b#a#b#a#c#b#c#b#c#b#d#c#d#c#e#c#f#d#f#g#f#g#f#g#h#g#i#j#i#j#i#j#k#j#l#m#l#m#l#k#n#l#n#n#n#n#n#n#o#n#o#n#o#p#q#p#r#p#r#s#r#r#t#u#t#v#t#v#w#t#w#w#w#w#x#w#y#w#z#w#A#w#z#B#z#B#z#A#C#A#C#D#C#C#C#C#E#C#F#E#F#E#F#E#G#E#G#H#G#I#G#H#J#I#J#K#J#J#L#J#L#J#M#L#M#L#N#O#N#O#N#P#N#N#Q#N#Q#N#R#Q#R#Q#R#Q#S#S#T#S#U#T#U#U#U#U#U#U",
".#.a.#.#.#.#.c.#.c.#.c.b.c.b.d.c.d.c.d.d.e.f.e.f.g.f.g.f.g.h.g.i.j.h.j.i.j.k.j.j.l.j.l.j.l.l#V.l.m.l.n.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.o.o.p.o#W.p.r.p.t.q.r.r.t.r.u.s.u.t.u.v.u.v.w.v.y.u.y.x.y.w.A.w.A.z.A.z.A.A.C.A.B.C.B.C.E.B.D.C.E.D.E.D.E.D.F.D.F.F.F.F.H.F.H#X.H.H.H.H.J.H.J.H#Y.J#Y.J.L.K.L.J.L.M.L.M.L.L.O.L.O.O.O.O#Z.O.P.O.Q.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.X.T.X.W.X.W.X.W.0.X#0.W.Z.X.Z.0.2.0.2.0.2.3.2.3.4.1.4.5#1.4.4.4#2.4.6.4.6.6.6.6#3.6.8.7#3.7#..7#..7#.###.#.#.#.#b#.#b#b#b#b#c#b#d#b#d#c#e#c#e#c#f#d#f#g#f#f#f#f#i#f#i#g#i#h#i#j#l#h#l#m#l#k#l#k#n#l#n#n#n#n#n#n#q#n#o#n#q#o#q#p#q#o#r#p#r#r#r#r#t#r#t#v#t#t#w#t#x#t#x#w#4#w#z#w#z#x#z#B#z#A#z#A#C#A#C#C#C#C#C#C#F#C#F#E#F#E#F#E#G#E#G#I#G#G#G#G#J#G#J#I#J#J#J#J#M#J#M#L#5#L#5#L#6#M#N#O#N#N#N#N#R#N#R#Q#R#Q#R#Q#T#Q#T#S#T#T#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.#.c.a.c.#.c.b.c.b.d.b.d.c.e.c.e.f.e.f.i.f.g.f.g.h.g.h.j.h.j.h.j.j.j.k.l.j.l.j.l.l.l.l.m.l.n.l.m.m.n.m.o.m.o.m.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.s.u.v.u.v.w.v.y.x.w.x.A.x.A.w.A.z.A.z.A.z.C.A.B.C.B.C.D.C.D.C.E.D.D.D.E.D.F.D.F.F.F.G.H.G.H#X.H#X.H.H.J.H.J.J#Y.J.L.J.L.J.L.J.L.N.L.L.O.M.O.L.O.O.O.O.P.O.P.O.Q.P.P.P.Q.P.R.P.R.R.R.U.T.S.T.T.V.T.V.T.X.T.X.W.X.W.X.W.X.W.Z.X.Z.0.Z.0.1.0.3.3.2.3.2.1.4.1.4.5.4.5.4.4.6#7.6.6.6.6.6.7.7.7.7.7#..7.9.7#..7#.###.###.#a#b#a#b#b#c#b#c#b#d#b#d#c#e#c#d#d#f#c#f#g#f#g#f#g#h#g#h#j#i#j#i#j#l#j#l#m#l#m#l#l#n#k#n#n#n#n#n#n#o#n#o#n#q#p#o#p#r#p#r#s#r#8#t#v#t#u#t#v#w#v#w#w#x#w#x#w#z#w#y#w#A#w#A#B#z#B#z#A#C#A#C#C#C#C#C#C#E#C#E#E#F#E#F#E#G#E#G#I#G#I#G#H#J#H#J#K#J#J#L#J#M#J#M#L#5#L#N#L#N#O#N#N#N#N#Q#N#Q#N#Q#Q#R#Q#R#Q#T#S#T#S#U#S#U#U#U#U#U#U",
".#.a.#.a#9.#.c.#.c.#.c.b.c.c.c.b.d.c.d.c.e.f.e.f.g.e.g.f.g.i.g.h.j.h.j.h.j.j.j.k.l.j.l.ja..la..l.n.l.m.l.n.m.n.m.o.n.o.n.o.o.o.o.o.o.o.o#W.o.q.p.t.p.r.p.r.r.r.r.u.r.u.r.u.v.u.v.y.v.w.v.y.w.y.x.A.w.A.z.A.A.A.z.B.A.B.C.B.C.E.C.E.C.D.D.E.D.E.D.F.D.F.F.F.F.H.F.H.H.H.H.H.H.J.H.K.H.K.J#Y.J.L.J.L.J.L.N.L.L.L.M.O.L.O.Oa#.Oa#.O.Q.O.P.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.W.T.X.W.X.W.X.X.0.W#0.X.Z.X.Z.0.1.0.2.0.2.3.2.3.4.1.4.4.4.4#1.4#2.4#2.4.6.6aa.6.8.6#3.7.8.7#..7#..7#..9#..9#.#.#b#.#b#b#b#b#d#b#d#b#e#c#d#c#e#d#f#c#f#f#f#f#f#f#h#f#i#f#i#h#i#h#l#j#l#m#l#m#l#l#n#k#n#n#n#nab#n#o#n#qab#o#o#q#o#q#p#r#o#r#8#r#r#t#r#t#t#t#t#w#t#w#t#4#w#x#w#z#x#z#w#z#B#z#B#z#A#C#A#C#C#C#Cac#C#F#C#F#E#F#Ead#E#G#E#G#I#G#I#G#G#J#G#J#I#J#J#J#J#M#J#5#L#M#L#5#M#6#L#N#M#N#N#N#N#Q#N#R#Q#R#Q#R#Q#T#Q#T#S#T#S#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.a.b.#.c.#.c.b.c.b.d.b.d.b.e.c.e.f.e.f.g.f.g.f.g.h.i.h.j.h.j.h.j.k.j.j.l.j.l.j.l.l.l.l.m.l.m.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.r.u.v.u.v.w.v.w.x.y.x.z.x.A.x.A.z.A.z.A.A.B.A.B.C.B.C.D.C.D.C.D.D.E.D.E.D.F.D.F.F.F.G.H.G.H.I.H.H.H.H.J.H.K.J.K.J.L.J.M.J.L.J.L.N.L.M.O.L.O.L.O.O.O.O.P.O.P.O.P.P.Q.P.Q.P.R.P.R.R.R.S.T.U.V.T.V.T.V.T.W.T.X.Y.X.W.X.W.X.W.Z.W.0.0.Z.0.1.0.2.3.2.3.2.1.4.1.4.5.4.4.4.4.6.4.6.6.6.6.6.7.7.7.8.7.9.7#..7#..7#.###..9#.#a#b#a#b#a#c#b#c#b#c#b#d#c#d#c#e#c#f#d#f#g#f#g#f#g#h#g#i#j#i#j#i#j#k#j#l#m#l#m#l#k#n#l#n#n#n#n#n#n#o#n#o#n#o#p#q#p#r#p#r#s#r#r#t#u#t#v#t#v#w#t#w#w#w#w#x#w#y#w#z#w#A#w#z#B#z#B#z#A#C#A#C#D#C#C#C#C#E#C#F#E#F#E#F#E#G#E#G#H#G#I#G#H#J#I#J#K#J#J#L#J#L#J#M#L#M#L#N#O#N#O#N#P#N#N#Q#N#Q#N#R#Q#R#Q#R#Q#S#S#T#S#U#T#U#U#U#U#U#U",
".#.a.#.#.#.#.c.#.c.#.c.b.c.b.d.c.d.c.d.d.e.f.e.f.g.f.g.f.g.h.g.i.j.h.j.i.j.k.j.j.l.j.l.j.l.l#V.l.m.l.n.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.o.o.p.o#W.p.r.p.t.q.r.r.t.r.u.s.u.t.u.v.u.v.w.v.y.u.y.x.y.w.A.w.A.z.A.z.A.A.C.A.B.C.B.C.E.B.D.C.E.D.E.D.E.D.F.D.F.F.F.F.H.F.H#X.H.H.H.H.J.H.J.H#Y.J#Y.J.L.K.L.J.L.M.L.M.L.L.O.L.O.O.O.O#Z.O.P.O.Q.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.X.T.X.W.X.W.X.W.0.X#0.W.Z.X.Z.0.2.0.2.0.2.3.2.3.4.1.4.5#1.4.4.4#2.4.6.4.6.6.6.6#3.6.8.7#3.7#..7#..7#.###.#.#.#.#b#.#b#b#b#b#c#b#d#b#d#c#e#c#e#c#f#d#f#g#f#f#f#f#i#f#i#g#i#h#i#j#l#h#l#m#l#k#l#k#n#l#n#n#n#n#n#n#q#n#o#n#q#o#q#p#q#o#r#p#r#r#r#r#t#r#t#v#t#t#w#t#x#t#x#w#4#w#z#w#z#x#z#B#z#A#z#A#C#A#C#C#C#C#C#C#F#C#F#E#F#E#F#E#G#E#G#I#G#G#G#G#J#G#J#I#J#J#J#J#M#J#M#L#5#L#5#L#6#M#N#O#N#N#N#N#R#N#R#Q#R#Q#R#Q#T#Q#T#S#T#T#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.#.c.a.c.#.c.b.c.b.d.b.d.c.e.c.e.f.e.f.i.f.g.f.g.h.g.h.j.h.j.h.j.j.j.k.l.j.l.j.l.l.l.l.m.l.n.l.m.m.n.m.o.m.o.m.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.s.u.v.u.v.w.v.y.x.w.x.A.x.A.w.A.z.A.z.A.z.C.A.B.C.B.C.D.C.D.C.E.D.D.D.E.D.F.D.F.F.F.G.H.G.H#X.H#X.H.H.J.H.J.J#Y.J.L.J.L.J.L.J.L.N.L.L.O.M.O.L.O.O.O.O.P.O.P.O.Q.P.P.P.Q.P.R.P.R.R.R.U.T.S.T.T.V.T.V.T.X.T.X.W.X.W.X.W.X.W.Z.X.Z.0.Z.0.1.0.3.3.2.3.2.1.4.1.4.5.4.5.4.4.6#7.6.6.6.6.6.7.7.7.7.7#..7.9.7#..7#.###.###.#a#b#a#b#b#c#b#c#b#d#b#d#c#e#c#d#d#f#c#f#g#f#g#f#g#h#g#h#j#i#j#i#j#l#j#l#m#l#m#l#l#n#k#n#n#n#n#n#n#o#n#o#n#q#p#o#p#r#p#r#s#r#8#t#v#t#u#t#v#w#v#w#w#x#w#x#w#z#w#y#w#A#w#A#B#z#B#z#A#C#A#C#C#C#C#C#C#E#C#E#E#F#E#F#E#G#E#G#I#G#I#G#H#J#H#J#K#J#J#L#J#M#J#M#L#5#L#N#L#N#O#N#N#N#N#Q#N#Q#N#Q#Q#R#Q#R#Q#T#S#T#S#U#S#U#U#U#U#U#U",
".#.a.#.a#9.#.c.#.c.#.c.b.c.c.c.b.d.c.d.c.e.f.e.f.g.e.g.f.g.i.g.h.j.h.j.h.j.j.j.k.l.j.l.ja..la..l.n.l.m.l.n.m.n.m.o.n.o.n.o.o.o.o.o.o.o.o#W.o.q.p.t.p.r.p.r.r.r.r.u.r.u.r.u.v.u.v.y.v.w.v.y.w.y.x.A.w.A.z.A.A.A.z.B.A.B.C.B.C.E.C.E.C.D.D.E.D.E.D.F.D.F.F.F.F.H.F.H.H.H.H.H.H.J.H.K.H.K.J#Y.J.L.J.L.J.L.N.L.L.L.M.O.L.O.Oa#.Oa#.O.Q.O.P.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.W.T.X.W.X.W.X.X.0.W#0.X.Z.X.Z.0.1.0.2.0.2.3.2.3.4.1.4.4.4.4#1.4#2.4#2.4.6.6aa.6.8.6#3.7.8.7#..7#..7#..9#..9#.#.#b#.#b#b#b#b#d#b#d#b#e#c#d#c#e#d#f#c#f#f#f#f#f#f#h#f#i#f#i#h#i#h#l#j#l#m#l#m#l#l#n#k#n#n#n#nab#n#o#n#qab#o#o#q#o#q#p#r#o#r#8#r#r#t#r#t#t#t#t#w#t#w#t#4#w#x#w#z#x#z#w#z#B#z#B#z#A#C#A#C#C#C#Cac#C#F#C#F#E#F#Ead#E#G#E#G#I#G#I#G#G#J#G#J#I#J#J#J#J#M#J#5#L#M#L#5#M#6#L#N#M#N#N#N#N#Q#N#R#Q#R#Q#R#Q#T#Q#T#S#T#S#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.a.b.#.c.#.c.b.c.b.d.b.d.b.e.c.e.f.e.f.g.f.g.f.g.h.i.h.j.h.j.h.j.k.j.j.l.j.l.j.l.l.l.l.m.l.m.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.r.u.v.u.v.w.v.w.x.y.x.z.x.A.x.A.z.A.z.A.A.B.A.B.C.B.C.D.C.D.C.D.D.E.D.E.D.F.D.F.F.F.G.H.G.H.I.H.H.H.H.J.H.K.J.K.J.L.J.M.J.L.J.L.N.L.M.O.L.O.L.O.O.O.O.P.O.P.O.P.P.Q.P.Q.P.R.P.R.R.R.S.T.U.V.T.V.T.V.T.W.T.X.Y.X.W.X.W.X.W.Z.W.0.0.Z.0.1.0.2.3.2.3.2.1.4.1.4.5.4.4.4.4.6.4.6.6.6.6.6.7.7.7.8.7.9.7#..7#..7#.###..9#.#a#b#a#b#a#c#b#c#b#c#b#d#c#d#c#e#c#f#d#f#g#f#g#f#g#h#g#i#j#i#j#i#j#k#j#l#m#l#m#l#k#n#l#n#n#n#n#n#n#o#n#o#n#o#p#q#p#r#p#r#s#r#r#t#u#t#v#t#v#w#t#w#w#w#w#x#w#y#w#z#w#A#w#z#B#z#B#z#A#C#A#C#D#C#C#C#C#E#C#F#E#F#E#F#E#G#E#G#H#G#I#G#H#J#I#J#K#J#J#L#J#L#J#M#L#M#L#N#O#N#O#N#P#N#N#Q#N#Q#N#R#Q#R#Q#R#Q#S#S#T#S#U#T#U#U#U#U#U#U",
".#.a.#.#.#.#.c.#.c.#.c.b.c.b.d.c.d.c.d.d.e.f.e.f.g.f.g.f.g.h.g.i.j.h.j.i.j.k.j.j.l.j.l.j.l.l#V.l.m.l.n.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.o.o.p.o#W.p.r.p.t.q.r.r.t.r.u.s.u.t.u.v.u.v.w.v.y.u.y.x.y.w.A.w.A.z.A.z.A.A.C.A.B.C.B.C.E.B.D.C.E.D.E.D.E.D.F.D.F.F.F.F.H.F.H#X.H.H.H.H.J.H.J.H#Y.J#Y.J.L.K.L.J.L.M.L.M.L.L.O.L.O.O.O.O#Z.O.P.O.Q.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.X.T.X.W.X.W.X.W.0.X#0.W.Z.X.Z.0.2.0.2.0.2.3.2.3.4.1.4.5#1.4.4.4#2.4.6.4.6.6.6.6#3.6.8.7#3.7#..7#..7#.###.#.#.#.#b#.#b#b#b#b#c#b#d#b#d#c#e#c#e#c#f#d#f#g#f#f#f#f#i#f#i#g#i#h#i#j#l#h#l#m#l#k#l#k#n#l#n#n#n#n#n#n#q#n#o#n#q#o#q#p#q#o#r#p#r#r#r#r#t#r#t#v#t#t#w#t#x#t#x#w#4#w#z#w#z#x#z#B#z#A#z#A#C#A#C#C#C#C#C#C#F#C#F#E#F#E#F#E#G#E#G#I#G#G#G#G#J#G#J#I#J#J#J#J#M#J#M#L#5#L#5#L#6#M#N#O#N#N#N#N#R#N#R#Q#R#Q#R#Q#T#Q#T#S#T#T#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.#.c.a.c.#.c.b.c.b.d.b.d.c.e.c.e.f.e.f.i.f.g.f.g.h.g.h.j.h.j.h.j.j.j.k.l.j.l.j.l.l.l.l.m.l.n.l.m.m.n.m.o.m.o.m.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.s.u.v.u.v.w.v.y.x.w.x.A.x.A.w.A.z.A.z.A.z.C.A.B.C.B.C.D.C.D.C.E.D.D.D.E.D.F.D.F.F.F.G.H.G.H#X.H#X.H.H.J.H.J.J#Y.J.L.J.L.J.L.J.L.N.L.L.O.M.O.L.O.O.O.O.P.O.P.O.Q.P.P.P.Q.P.R.P.R.R.R.U.T.S.T.T.V.T.V.T.X.T.X.W.X.W.X.W.X.W.Z.X.Z.0.Z.0.1.0.3.3.2.3.2.1.4.1.4.5.4.5.4.4.6#7.6.6.6.6.6.7.7.7.7.7#..7.9.7#..7#.###.###.#a#b#a#b#b#c#b#c#b#d#b#d#c#e#c#d#d#f#c#f#g#f#g#f#g#h#g#h#j#i#j#i#j#l#j#l#m#l#m#l#l#n#k#n#n#n#n#n#n#o#n#o#n#q#p#o#p#r#p#r#s#r#8#t#v#t#u#t#v#w#v#w#w#x#w#x#w#z#w#y#w#A#w#A#B#z#B#z#A#C#A#C#C#C#C#C#C#E#C#E#E#F#E#F#E#G#E#G#I#G#I#G#H#J#H#J#K#J#J#L#J#M#J#M#L#5#L#N#L#N#O#N#N#N#N#Q#N#Q#N#Q#Q#R#Q#R#Q#T#S#T#S#U#S#U#U#U#U#U#U",
".#.a.#.a#9.#.c.#.c.#.c.b.c.c.c.b.d.c.d.c.e.f.e.f.g.e.g.f.g.i.g.h.j.h.j.h.j.j.j.k.l.j.l.ja..la..l.n.l.m.l.n.m.n.m.o.n.o.n.o.o.o.o.o.o.o.o#W.o.q.p.t.p.r.p.r.r.r.r.u.r.u.r.u.v.u.v.y.v.w.v.y.w.y.x.A.w.A.z.A.A.A.z.B.A.B.C.B.C.E.C.E.C.D.D.E.D.E.D.F.D.F.F.F.F.H.F.H.H.H.H.H.H.J.H.K.H.K.J#Y.J.L.J.L.J.L.N.L.L.L.M.O.L.O.Oa#.Oa#.O.Q.O.P.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.W.T.X.W.X.W.X.X.0.W#0.X.Z.X.Z.0.1.0.2.0.2.3.2.3.4.1.4.4.4.4#1.4#2.4#2.4.6.6aa.6.8.6#3.7.8.7#..7#..7#..9#..9#.#.#b#.#b#b#b#b#d#b#d#b#e#c#d#c#e#d#f#c#f#f#f#f#f#f#h#f#i#f#i#h#i#h#l#j#l#m#l#m#l#l#n#k#n#n#n#nab#n#o#n#qab#o#o#q#o#q#p#r#o#r#8#r#r#t#r#t#t#t#t#w#t#w#t#4#w#x#w#z#x#z#w#z#B#z#B#z#A#C#A#C#C#C#Cac#C#F#C#F#E#F#Ead#E#G#E#G#I#G#I#G#G#J#G#J#I#J#J#J#J#M#J#5#L#M#L#5#M#6#L#N#M#N#N#N#N#Q#N#R#Q#R#Q#R#Q#T#Q#T#S#T#S#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.a.b.#.c.#.c.b.c.b.d.b.d.b.e.c.e.f.e.f.g.f.g.f.g.h.i.h.j.h.j.h.j.k.j.j.l.j.l.j.l.l.l.l.m.l.m.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.r.u.v.u.v.w.v.w.x.y.x.z.x.A.x.A.z.A.z.A.A.B.A.B.C.B.C.D.C.D.C.D.D.E.D.E.D.F.D.F.F.F.G.H.G.H.I.H.H.H.H.J.H.K.J.K.J.L.J.M.J.L.J.L.N.L.M.O.L.O.L.O.O.O.O.P.O.P.O.P.P.Q.P.Q.P.R.P.R.R.R.S.T.U.V.T.V.T.V.T.W.T.X.Y.X.W.X.W.X.W.Z.W.0.0.Z.0.1.0.2.3.2.3.2.1.4.1.4.5.4.4.4.4.6.4.6.6.6.6.6.7.7.7.8.7.9.7#..7#..7#.###..9#.#a#b#a#b#a#c#b#c#b#c#b#d#c#d#c#e#c#f#d#f#g#f#g#f#g#h#g#i#j#i#j#i#j#k#j#l#m#l#m#l#k#n#l#n#n#n#n#n#n#o#n#o#n#o#p#q#p#r#p#r#s#r#r#t#u#t#v#t#v#w#t#w#w#w#w#x#w#y#w#z#w#A#w#z#B#z#B#z#A#C#A#C#D#C#C#C#C#E#C#F#E#F#E#F#E#G#E#G#H#G#I#G#H#J#I#J#K#J#J#L#J#L#J#M#L#M#L#N#O#N#O#N#P#N#N#Q#N#Q#N#R#Q#R#Q#R#Q#S#S#T#S#U#T#U#U#U#U#U#U",
".#.a.#.#.#.#.c.#.c.#.c.b.c.b.d.c.d.c.d.d.e.f.e.f.g.f.g.f.g.h.g.i.j.h.j.i.j.k.j.j.l.j.l.j.l.l#V.l.m.l.n.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.o.o.p.o#W.p.r.p.t.q.r.r.t.r.u.s.u.t.u.v.u.v.w.v.y.u.y.x.y.w.A.w.A.z.A.z.A.A.C.A.B.C.B.C.E.B.D.C.E.D.E.D.E.D.F.D.F.F.F.F.H.F.H#X.H.H.H.H.J.H.J.H#Y.J#Y.J.L.K.L.J.L.M.L.M.L.L.O.L.O.O.O.O#Z.O.P.O.Q.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.X.T.X.W.X.W.X.W.0.X#0.W.Z.X.Z.0.2.0.2.0.2.3.2.3.4.1.4.5#1.4.4.4#2.4.6.4.6.6.6.6#3.6.8.7#3.7#..7#..7#.###.#.#.#.#b#.#b#b#b#b#c#b#d#b#d#c#e#c#e#c#f#d#f#g#f#f#f#f#i#f#i#g#i#h#i#j#l#h#l#m#l#k#l#k#n#l#n#n#n#n#n#n#q#n#o#n#q#o#q#p#q#o#r#p#r#r#r#r#t#r#t#v#t#t#w#t#x#t#x#w#4#w#z#w#z#x#z#B#z#A#z#A#C#A#C#C#C#C#C#C#F#C#F#E#F#E#F#E#G#E#G#I#G#G#G#G#J#G#J#I#J#J#J#J#M#J#M#L#5#L#5#L#6#M#N#O#N#N#N#N#R#N#R#Q#R#Q#R#Q#T#Q#T#S#T#T#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.#.c.a.c.#.c.b.c.b.d.b.d.c.e.c.e.f.e.f.i.f.g.f.g.h.g.h.j.h.j.h.j.j.j.k.l.j.l.j.l.l.l.l.m.l.n.l.m.m.n.m.o.m.o.m.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.s.u.v.u.v.w.v.y.x.w.x.A.x.A.w.A.z.A.z.A.z.C.A.B.C.B.C.D.C.D.C.E.D.D.D.E.D.F.D.F.F.F.G.H.G.H#X.H#X.H.H.J.H.J.J#Y.J.L.J.L.J.L.J.L.N.L.L.O.M.O.L.O.O.O.O.P.O.P.O.Q.P.P.P.Q.P.R.P.R.R.R.U.T.S.T.T.V.T.V.T.X.T.X.W.X.W.X.W.X.W.Z.X.Z.0.Z.0.1.0.3.3.2.3.2.1.4.1.4.5.4.5.4.4.6#7.6.6.6.6.6.7.7.7.7.7#..7.9.7#..7#.###.###.#a#b#a#b#b#c#b#c#b#d#b#d#c#e#c#d#d#f#c#f#g#f#g#f#g#h#g#h#j#i#j#i#j#l#j#l#m#l#m#l#l#n#k#n#n#n#n#n#n#o#n#o#n#q#p#o#p#r#p#r#s#r#8#t#v#t#u#t#v#w#v#w#w#x#w#x#w#z#w#y#w#A#w#A#B#z#B#z#A#C#A#C#C#C#C#C#C#E#C#E#E#F#E#F#E#G#E#G#I#G#I#G#H#J#H#J#K#J#J#L#J#M#J#M#L#5#L#N#L#N#O#N#N#N#N#Q#N#Q#N#Q#Q#R#Q#R#Q#T#S#T#S#U#S#U#U#U#U#U#U",
".#.a.#.a#9.#.c.#.c.#.c.b.c.c.c.b.d.c.d.c.e.f.e.f.g.e.g.f.g.i.g.h.j.h.j.h.j.j.j.k.l.j.l.ja..la..l.n.l.m.l.n.m.n.m.o.n.o.n.o.o.o.o.o.o.o.o#W.o.q.p.t.p.r.p.r.r.r.r.u.r.u.r.u.v.u.v.y.v.w.v.y.w.y.x.A.w.A.z.A.A.A.z.B.A.B.C.B.C.E.C.E.C.D.D.E.D.E.D.F.D.F.F.F.F.H.F.H.H.H.H.H.H.J.H.K.H.K.J#Y.J.L.J.L.J.L.N.L.L.L.M.O.L.O.Oa#.Oa#.O.Q.O.P.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.W.T.X.W.X.W.X.X.0.W#0.X.Z.X.Z.0.1.0.2.0.2.3.2.3.4.1.4.4.4.4#1.4#2.4#2.4.6.6aa.6.8.6#3.7.8.7#..7#..7#..9#..9#.#.#b#.#b#b#b#b#d#b#d#b#e#c#d#c#e#d#f#c#f#f#f#f#f#f#h#f#i#f#i#h#i#h#l#j#l#m#l#m#l#l#n#k#n#n#n#nab#n#o#n#qab#o#o#q#o#q#p#r#o#r#8#r#r#t#r#t#t#t#t#w#t#w#t#4#w#x#w#z#x#z#w#z#B#z#B#z#A#C#A#C#C#C#Cac#C#F#C#F#E#F#Ead#E#G#E#G#I#G#I#G#G#J#G#J#I#J#J#J#J#M#J#5#L#M#L#5#M#6#L#N#M#N#N#N#N#Q#N#R#Q#R#Q#R#Q#T#Q#T#S#T#S#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.a.b.#.c.#.c.b.c.b.d.b.d.b.e.c.e.f.e.f.g.f.g.f.g.h.i.h.j.h.j.h.j.k.j.j.l.j.l.j.l.l.l.l.m.l.m.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.r.u.v.u.v.w.v.w.x.y.x.z.x.A.x.A.z.A.z.A.A.B.A.B.C.B.C.D.C.D.C.D.D.E.D.E.D.F.D.F.F.F.G.H.G.H.I.H.H.H.H.J.H.K.J.K.J.L.J.M.J.L.J.L.N.L.M.O.L.O.L.O.O.O.O.P.O.P.O.P.P.Q.P.Q.P.R.P.R.R.R.S.T.U.V.T.V.T.V.T.W.T.X.Y.X.W.X.W.X.W.Z.W.0.0.Z.0.1.0.2.3.2.3.2.1.4.1.4.5.4.4.4.4.6.4.6.6.6.6.6.7.7.7.8.7.9.7#..7#..7#.###..9#.#a#b#a#b#a#c#b#c#b#c#b#d#c#d#c#e#c#f#d#f#g#f#g#f#g#h#g#i#j#i#j#i#j#k#j#l#m#l#m#l#k#n#l#n#n#n#n#n#n#o#n#o#n#o#p#q#p#r#p#r#s#r#r#t#u#t#v#t#v#w#t#w#w#w#w#x#w#y#w#z#w#A#w#z#B#z#B#z#A#C#A#C#D#C#C#C#C#E#C#F#E#F#E#F#E#G#E#G#H#G#I#G#H#J#I#J#K#J#J#L#J#L#J#M#L#M#L#N#O#N#O#N#P#N#N#Q#N#Q#N#R#Q#R#Q#R#Q#S#S#T#S#U#T#U#U#U#U#U#U",
".#.a.#.#.#.#.c.#.c.#.c.b.c.b.d.c.d.c.d.d.e.f.e.f.g.f.g.f.g.h.g.i.j.h.j.i.j.k.j.j.l.j.l.j.l.l#V.l.m.l.n.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.o.o.p.o#W.p.r.p.t.q.r.r.t.r.u.s.u.t.u.v.u.v.w.v.y.u.y.x.y.w.A.w.A.z.A.z.A.A.C.A.B.C.B.C.E.B.D.C.E.D.E.D.E.D.F.D.F.F.F.F.H.F.H#X.H.H.H.H.J.H.J.H#Y.J#Y.J.L.K.L.J.L.M.L.M.L.L.O.L.O.O.O.O#Z.O.P.O.Q.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.X.T.X.W.X.W.X.W.0.X#0.W.Z.X.Z.0.2.0.2.0.2.3.2.3.4.1.4.5#1.4.4.4#2.4.6.4.6.6.6.6#3.6.8.7#3.7#..7#..7#.###.#.#.#.#b#.#b#b#b#b#c#b#d#b#d#c#e#c#e#c#f#d#f#g#f#f#f#f#i#f#i#g#i#h#i#j#l#h#l#m#l#k#l#k#n#l#n#n#n#n#n#n#q#n#o#n#q#o#q#p#q#o#r#p#r#r#r#r#t#r#t#v#t#t#w#t#x#t#x#w#4#w#z#w#z#x#z#B#z#A#z#A#C#A#C#C#C#C#C#C#F#C#F#E#F#E#F#E#G#E#G#I#G#G#G#G#J#G#J#I#J#J#J#J#M#J#M#L#5#L#5#L#6#M#N#O#N#N#N#N#R#N#R#Q#R#Q#R#Q#T#Q#T#S#T#T#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.#.c.a.c.#.c.b.c.b.d.b.d.c.e.c.e.f.e.f.i.f.g.f.g.h.g.h.j.h.j.h.j.j.j.k.l.j.l.j.l.l.l.l.m.l.n.l.m.m.n.m.o.m.o.m.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.s.u.v.u.v.w.v.y.x.w.x.A.x.A.w.A.z.A.z.A.z.C.A.B.C.B.C.D.C.D.C.E.D.D.D.E.D.F.D.F.F.F.G.H.G.H#X.H#X.H.H.J.H.J.J#Y.J.L.J.L.J.L.J.L.N.L.L.O.M.O.L.O.O.O.O.P.O.P.O.Q.P.P.P.Q.P.R.P.R.R.R.U.T.S.T.T.V.T.V.T.X.T.X.W.X.W.X.W.X.W.Z.X.Z.0.Z.0.1.0.3.3.2.3.2.1.4.1.4.5.4.5.4.4.6#7.6.6.6.6.6.7.7.7.7.7#..7.9.7#..7#.###.###.#a#b#a#b#b#c#b#c#b#d#b#d#c#e#c#d#d#f#c#f#g#f#g#f#g#h#g#h#j#i#j#i#j#l#j#l#m#l#m#l#l#n#k#n#n#n#n#n#n#o#n#o#n#q#p#o#p#r#p#r#s#r#8#t#v#t#u#t#v#w#v#w#w#x#w#x#w#z#w#y#w#A#w#A#B#z#B#z#A#C#A#C#C#C#C#C#C#E#C#E#E#F#E#F#E#G#E#G#I#G#I#G#H#J#H#J#K#J#J#L#J#M#J#M#L#5#L#N#L#N#O#N#N#N#N#Q#N#Q#N#Q#Q#R#Q#R#Q#T#S#T#S#U#S#U#U#U#U#U#U",
".#.a.#.a#9.#.c.#.c.#.c.b.c.c.c.b.d.c.d.c.e.f.e.f.g.e.g.f.g.i.g.h.j.h.j.h.j.j.j.k.l.j.l.ja..la..l.n.l.m.l.n.m.n.m.o.n.o.n.o.o.o.o.o.o.o.o#W.o.q.p.t.p.r.p.r.r.r.r.u.r.u.r.u.v.u.v.y.v.w.v.y.w.y.x.A.w.A.z.A.A.A.z.B.A.B.C.B.C.E.C.E.C.D.D.E.D.E.D.F.D.F.F.F.F.H.F.H.H.H.H.H.H.J.H.K.H.K.J#Y.J.L.J.L.J.L.N.L.L.L.M.O.L.O.Oa#.Oa#.O.Q.O.P.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.W.T.X.W.X.W.X.X.0.W#0.X.Z.X.Z.0.1.0.2.0.2.3.2.3.4.1.4.4.4.4#1.4#2.4#2.4.6.6aa.6.8.6#3.7.8.7#..7#..7#..9#..9#.#.#b#.#b#b#b#b#d#b#d#b#e#c#d#c#e#d#f#c#f#f#f#f#f#f#h#f#i#f#i#h#i#h#l#j#l#m#l#m#l#l#n#k#n#n#n#nab#n#o#n#qab#o#o#q#o#q#p#r#o#r#8#r#r#t#r#t#t#t#t#w#t#w#t#4#w#x#w#z#x#z#w#z#B#z#B#z#A#C#A#C#C#C#Cac#C#F#C#F#E#F#Ead#E#G#E#G#I#G#I#G#G#J#G#J#I#J#J#J#J#M#J#5#L#M#L#5#M#6#L#N#M#N#N#N#N#Q#N#R#Q#R#Q#R#Q#T#Q#T#S#T#S#U#T#U#U#U#U#U#U#U"};

ProcessOutput::ProcessOutput( QWidget* parent,  const char* name, bool modal, WFlags fl ) : QDialog( parent, name, modal, fl ){
    QPixmap image0( ( const char** ) processoutput_image0_data );
    QPixmap image1( ( const char** ) processoutput_image1_data );
    if ( !name )
	setName( "ProcessOutput" );
    resize( 462, 453 );
    setCaption( tr2i18n( "KOnCD - Writing CD..." ) );
    setIcon( image0 );
    ProcessOutputLayout = new QVBoxLayout( this, 11, 6, "ProcessOutputLayout");

    GroupBox = new QGroupBox( this, "GroupBox" );
    GroupBox->setFrameShape( QGroupBox::Box );
    GroupBox->setFrameShadow( QGroupBox::Sunken );
    GroupBox->setTitle( QString::null );
    GroupBox->setColumnLayout(0, Qt::Vertical );
    GroupBox->layout()->setSpacing( 6 );
    GroupBox->layout()->setMargin( 11 );
    GroupBoxLayout = new QVBoxLayout( GroupBox->layout() );
    GroupBoxLayout->setAlignment( Qt::AlignTop );

    Layout17 = new QHBoxLayout( 0, 0, 6, "Layout17");
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout17->addItem( spacer );

    StatusLabel = new QLabel( GroupBox, "StatusLabel" );
    StatusLabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, StatusLabel->sizePolicy().hasHeightForWidth() ) );
    StatusLabel->setMinimumSize( QSize( 400, 15 ) );
    QFont StatusLabel_font(  StatusLabel->font() );
    StatusLabel_font.setPointSize( 14 );
    StatusLabel_font.setBold( TRUE );
    StatusLabel->setFont( StatusLabel_font );
    StatusLabel->setText( tr2i18n( "Prepare for write..." ) );
    Layout17->addWidget( StatusLabel );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout17->addItem( spacer_2 );
    GroupBoxLayout->addLayout( Layout17 );

    Layout18 = new QHBoxLayout( 0, 0, 6, "Layout18");
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout18->addItem( spacer_3 );

    WriteProgress = new QProgressBar( GroupBox, "WriteProgress" );
    WriteProgress->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, WriteProgress->sizePolicy().hasHeightForWidth() ) );
    WriteProgress->setMinimumSize( QSize( 400, 25 ) );
    QPalette pal;
    QColorGroup cg;
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 228, 228, 228) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 241, 241, 241) );
    cg.setColor( QColorGroup::Dark, QColor( 114, 114, 114) );
    cg.setColor( QColorGroup::Mid, QColor( 152, 152, 152) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setBrush( QColorGroup::Highlight, QBrush( QColor( 10, 95, 137), image1 ) );
    cg.setColor( QColorGroup::HighlightedText, white );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 255) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 255, 0, 255) );
    pal.setActive( cg );
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 228, 228, 228) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, white );
    cg.setColor( QColorGroup::Dark, QColor( 114, 114, 114) );
    cg.setColor( QColorGroup::Mid, QColor( 152, 152, 152) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setBrush( QColorGroup::Highlight, QBrush( QColor( 10, 95, 137), image1 ) );
    cg.setColor( QColorGroup::HighlightedText, white );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 255) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 255, 0, 255) );
    pal.setInactive( cg );
    cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Button, QColor( 228, 228, 228) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, white );
    cg.setColor( QColorGroup::Dark, QColor( 114, 114, 114) );
    cg.setColor( QColorGroup::Mid, QColor( 152, 152, 152) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setBrush( QColorGroup::Highlight, QBrush( QColor( 10, 95, 137), image1 ) );
    cg.setColor( QColorGroup::HighlightedText, white );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 255) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 255, 0, 255) );
    pal.setDisabled( cg );
    WriteProgress->setPalette( pal );
    WriteProgress->setProgress( 0 );
    WriteProgress->setCenterIndicator( TRUE );
    WriteProgress->setIndicatorFollowsStyle( FALSE );
    Layout18->addWidget( WriteProgress );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout18->addItem( spacer_4 );
    GroupBoxLayout->addLayout( Layout18 );

    Layout20 = new QHBoxLayout( 0, 0, 6, "Layout20");
    QSpacerItem* spacer_5 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout20->addItem( spacer_5 );

    Layout19 = new QVBoxLayout( 0, 0, 6, "Layout19");

    BufferLabel = new QLabel( GroupBox, "BufferLabel" );
    BufferLabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, BufferLabel->sizePolicy().hasHeightForWidth() ) );
    BufferLabel->setMinimumSize( QSize( 400, 15 ) );
    BufferLabel->setText( tr2i18n( "Buffer Status:" ) );
    Layout19->addWidget( BufferLabel );

    BufferProgress = new QProgressBar( GroupBox, "BufferProgress" );
    BufferProgress->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, BufferProgress->sizePolicy().hasHeightForWidth() ) );
    BufferProgress->setMinimumSize( QSize( 400, 25 ) );
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 228, 228, 228) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 241, 241, 241) );
    cg.setColor( QColorGroup::Dark, QColor( 114, 114, 114) );
    cg.setColor( QColorGroup::Mid, QColor( 152, 152, 152) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setBrush( QColorGroup::Highlight, QBrush( QColor( 10, 95, 137), image1 ) );
    cg.setColor( QColorGroup::HighlightedText, white );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 255) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 255, 0, 255) );
    pal.setActive( cg );
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 228, 228, 228) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, white );
    cg.setColor( QColorGroup::Dark, QColor( 114, 114, 114) );
    cg.setColor( QColorGroup::Mid, QColor( 152, 152, 152) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setBrush( QColorGroup::Highlight, QBrush( QColor( 10, 95, 137), image1 ) );
    cg.setColor( QColorGroup::HighlightedText, white );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 255) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 255, 0, 255) );
    pal.setInactive( cg );
    cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Button, QColor( 228, 228, 228) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, white );
    cg.setColor( QColorGroup::Dark, QColor( 114, 114, 114) );
    cg.setColor( QColorGroup::Mid, QColor( 152, 152, 152) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setBrush( QColorGroup::Highlight, QBrush( QColor( 10, 95, 137), image1 ) );
    cg.setColor( QColorGroup::HighlightedText, white );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 255) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 255, 0, 255) );
    pal.setDisabled( cg );
    BufferProgress->setPalette( pal );
    BufferProgress->setProgress( 0 );
    BufferProgress->setCenterIndicator( TRUE );
    BufferProgress->setIndicatorFollowsStyle( FALSE );
    Layout19->addWidget( BufferProgress );
    Layout20->addLayout( Layout19 );
    QSpacerItem* spacer_6 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout20->addItem( spacer_6 );
    GroupBoxLayout->addLayout( Layout20 );

    Layout8 = new QHBoxLayout( 0, 0, 6, "Layout8");
    QSpacerItem* spacer_7 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout8->addItem( spacer_7 );

    Output = new QTextEdit( GroupBox, "Output" );
    Output->setMinimumSize( QSize( 400, 250 ) );
    Output->setReadOnly( TRUE );
    Layout8->addWidget( Output );
    QSpacerItem* spacer_8 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout8->addItem( spacer_8 );
    GroupBoxLayout->addLayout( Layout8 );
    QSpacerItem* spacer_9 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    GroupBoxLayout->addItem( spacer_9 );
    ProcessOutputLayout->addWidget( GroupBox );

    Layout1 = new QHBoxLayout( 0, 0, 6, "Layout1");
    QSpacerItem* spacer_10 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer_10 );

    QPushButton_OK = new QPushButton( this, "QPushButton_OK" );
    QPushButton_OK->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, 0, 0, QPushButton_OK->sizePolicy().hasHeightForWidth() ) );
    QPushButton_OK->setMinimumSize( QSize( 200, 25 ) );
    QPushButton_OK->setText( tr2i18n( "&Abort" ) );
    Layout1->addWidget( QPushButton_OK );
    QSpacerItem* spacer_11 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer_11 );
    ProcessOutputLayout->addLayout( Layout1 );

    // tab order
    setTabOrder( QPushButton_OK, Output );
}

ProcessOutput::~ProcessOutput(){
    // no need to delete child widgets, Qt does it all for us
}

#include "processoutput.moc"
