#include <noatun/pref.h>

#include <klocale.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <kglobal.h>
#include <kconfig.h>
#include <qslider.h>
#include <qframe.h>
#include <qstringlist.h>
#include <kstddirs.h>
#include <qdir.h>

#include "winSkinConfig.h"

WinSkinConfig::WinSkinConfig(QWidget * parent, WaSkin *waSkin) :
        CModule(i18n("Winskin"),
	        i18n("Skin selection for the Winskin plugin"),
	        "style",
	        parent)
{
    // This is a -very- simple UI
    // This will probably be enchanced for KDE 3.0.1 to be actually useful (tm)

    // Make a token horizontal layout box
    hbox = new QHBoxLayout(this);
    hbox->setSpacing( 6 );
    hbox->setMargin( 0 );
 
    // Add a simple list of skins, populated in WinSkinConfig::reopen()
    skin_list = new QListBox(this, "skin_list");
    hbox->addWidget(skin_list);

    // Set our private waSkin pointer
    this->waSkin = waSkin;

    reopen();
}

void WinSkinConfig::save()
{
    KConfig *config=KGlobal::config();
    config->setGroup("Winskin");
    config->writeEntry("CurrentSkin", skin_list->currentText());
    config->sync();

    if (skin_list->currentText() != orig_skin) {
        waSkin->loadSkin(skin_list->currentText());
        orig_skin = skin_list->currentText();
    }
}

void WinSkinConfig::reopen() {
    // Wipe out the old list
    skin_list->clear(); 

    // Get a list of directories in our skin dir
    QStringList skinDirs = KGlobal::dirs()->findDirs("data", "noatun/skins/winamp");

    // This loop adds them all to our skin list
    for(unsigned int x = 0;x < skinDirs.count();x++) {
        QDir skinQDir(skinDirs[x]);

        // We only want directories, although there shouldn't be anything else
        skinQDir.setFilter( QDir::Dirs );
        // I guess name is as good as any
        skinQDir.setSorting( QDir::Name );

        for (unsigned int y = 0;y < skinQDir.count();y++) {
            QStringList skins = skinQDir.entryList(QDir::Dirs, QDir::Name);

            // We really don't care for '.' and '..'
            if (skinQDir[y][0] != (char)'.') {
                // Add ourselves to the list, using our directory name
                skin_list->insertItem(skinQDir[y]);
            }
        }
    }

    // Figure out our current skin from KConfig
    KConfig *config=KGlobal::config();
    config->setGroup("Winskin");
    orig_skin = config->readEntry( "CurrentSkin", WaSkin::defaultSkin());

    // Where is that skin in our big-list-o-skins?
    QListBoxItem *item = skin_list->findItem(orig_skin);

    if (item) {
        // Aha, found it... make it the currently selected skin
        skin_list->setCurrentItem( item );
    }
    else {
        // Er, it's not there... select the current item
        // Maybe this should emit a warning? Oh well, it's not harmful
        skin_list->setCurrentItem( 0 );
    }
}

#include <winSkinConfig.moc>
