#ifndef _FILTER_H
#define _FILTER_H

#include "cmplx.h"

#define FilterLen	37
#define BufferLen	1024

/* ---------------------------------------------------------------------- */

#ifdef __i386__
#include "filter-i386.h"
#endif				/* __i386__ */

/* ---------------------------------------------------------------------- */

#ifndef __HAVE_ARCH_MAC
extern __inline__ float mac(const float *a, const float *b)
{
	float sum = 0;
	unsigned int i;

	for (i = 0; i < FilterLen; i++)
		sum += (*a++) * (*b++);
	return sum;
}
#endif				/* __HAVE_ARCH_MAC */

/* ---------------------------------------------------------------------- */

struct filter {
	float ifilter[FilterLen];
	float qfilter[FilterLen];
	float ibuffer[BufferLen];
	float qbuffer[BufferLen];
	int ptr;
};

extern struct filter *init_filter(float, float);
extern void clear_filter(struct filter *);

extern complex filter(struct filter *, complex);
extern float filterI(struct filter *, float);
extern float filterQ(struct filter *, float);

/* ---------------------------------------------------------------------- */
#endif				/* _FILTER_H */
