/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __k_mnu_h__
#define __k_mnu_h__

#include <qintdict.h>
#include <qpixmap.h>

#include "service_mnu.h"

class KickerClientMenu;
class KBookmarkMenu;
class KActionCollection;
class KBookmarkOwner;
class Panel;

class PanelKMenu : public PanelServiceMenu
{
    Q_OBJECT

public:
    PanelKMenu( ::Panel* panel );
    ~PanelKMenu();

    int insertClientMenu(KickerClientMenu *p);
    void removeClientMenu(int id);

    virtual QSize sizeHint() const;
    virtual void setMinimumSize(const QSize &);
    virtual void setMaximumSize(const QSize &);
    virtual void setMinimumSize(int, int);
    virtual void setMaximumSize(int, int);

public slots:
    virtual void initialize();

protected slots:
    void slotLock();
    void slotLogout();
    void slotNewSession();
    void slotSaveSession();
    void slotRunCommand();
    void paletteChanged();
    void configChanged();

protected:
    QRect sideImageRect();
    QMouseEvent translateMouseEvent( QMouseEvent* e );
    void resizeEvent(QResizeEvent *);
    void paintEvent(QPaintEvent *);
    void mousePressEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);
    void mouseMoveEvent(QMouseEvent *);
    bool loadSidePixmap();

private:
    QString                     xdmFifoName;
    QPixmap                     sidePixmap;
    QPixmap                     sideTilePixmap;
    int                         client_id;
    bool                        delay_init;
    QIntDict<KickerClientMenu>  clients;
    KBookmarkMenu              *bookmarkMenu;
    KActionCollection          *actionCollection;
    KBookmarkOwner             *bookmarkOwner;
    ::Panel*                      _panel;
};

#endif
