/***************************************************************************
                            kde_KDesktopFile.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDESKTOPFILE
#define KDE_KDESKTOPFILE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
* 
 KDE Desktop File Management.

 @author Pietro Iglio <iglio@kde.org>

 @version $Id: kde_KDesktopFile.h,v 1.4 2002/11/25 12:24:33 rdale Exp $

 @short KDE Desktop File Management class.
*/

/** *
 Constructs a KDesktopFile object and make it either read-write
 or read-only.

*/
kde_KDesktopFile * kde_new_KDesktopFile(qt_QString * fileName, int readOnly, char* resType);

/** *
 Destructs the KDesktopFile object.

 Writes back any dirty configuration entries.
   
*/
void kde_del_KDesktopFile( kde_KDesktopFile* p );

/** *
 Returns the value of the "Type=" entry.

*/
qt_QString * kde_KDesktopFile_readType(kde_KDesktopFile* instPointer);

/** *
 Returns the value of the "Icon=" entry.

*/
qt_QString * kde_KDesktopFile_readIcon(kde_KDesktopFile* instPointer);

/** *
 Returns the value of the "Name=" entry.

*/
qt_QString * kde_KDesktopFile_readName(kde_KDesktopFile* instPointer);

/** *
 Returns the value of the "Comment=" entry.

*/
qt_QString * kde_KDesktopFile_readComment(kde_KDesktopFile* instPointer);

/** *
 Returns the value of the "GenericName=" entry.

*/
qt_QString * kde_KDesktopFile_readGenericName(kde_KDesktopFile* instPointer);

/** *
 Returns the value of the "Path=" entry.

   
*/
qt_QString * kde_KDesktopFile_readPath(kde_KDesktopFile* instPointer);

/** *
 Returns the value of the "Dev=" entry.

*/
qt_QString * kde_KDesktopFile_readDevice(kde_KDesktopFile* instPointer);

/** *
 Returns the value of the "URL=" entry.

*/
qt_QString * kde_KDesktopFile_readURL(kde_KDesktopFile* instPointer);

/** *
 Returns a list of the "Actions=" entries.

*/
qt_QStringList* kde_KDesktopFile_readActions(kde_KDesktopFile* instPointer);

/** *
 Sets the desktop action group.

*/
void kde_KDesktopFile_setActionGroup(kde_KDesktopFile* instPointer,qt_QString * group);

/** *
 Returns true if the action group exists, false otherwise

*/
int kde_KDesktopFile_hasActionGroup(kde_KDesktopFile* instPointer,qt_QString * group);

/** *
 Checks whether there is a "Type=Link" entry.

 The link points to the "URL=" entry.

*/
int kde_KDesktopFile_hasLinkType(kde_KDesktopFile* instPointer);

/** *
 Checks whether there is an entry "Type=Application".

*/
int kde_KDesktopFile_hasApplicationType(kde_KDesktopFile* instPointer);

/** *
 Checks whether there is an entry "Type=MimeType".

*/
int kde_KDesktopFile_hasMimeTypeType(kde_KDesktopFile* instPointer);

/** *
 Checks whether there is an entry "Type=FSDev".

*/
int kde_KDesktopFile_hasDeviceType(kde_KDesktopFile* instPointer);

/** *
 Checks whether the TryExec field contains a binary
 which is found on the local system.

*/
int kde_KDesktopFile_tryExec(kde_KDesktopFile* instPointer);

/** *
 Returns the file name.

*/
qt_QString * kde_KDesktopFile_fileName(kde_KDesktopFile* instPointer);

/** *
 Returns the resource.

*/
qt_QString * kde_KDesktopFile_resource(kde_KDesktopFile* instPointer);

/** *
 Returns the value of the "DocPath=" entry.

*/
qt_QString * kde_KDesktopFile_readDocPath(kde_KDesktopFile* instPointer);

/** *
 Returns the entry of the "SortOrder=" entry.

*/
qt_QStringList* kde_KDesktopFile_sortOrder(kde_KDesktopFile* instPointer);

/** *
 Checks whether this is really a desktop file.

 The check is performed looking at the file extension (the file is not
 opened).
 Currently, valid extensions are ".kdelnk" and ".desktop".

*/
int kde_KDesktopFile_isDesktopFile( qt_QString * path);

/** *
 Checks whether the user is authorized to run this desktop file.
 By default users are authorized to run all desktop files but
 the KIOSK framework can be used to activate certain restrictions.
 See README.kiosk for more information.

*/
int kde_KDesktopFile_isAuthorizedDesktopFile( qt_QString * path);
void kde_KDesktopFile_virtual_hook(kde_KDesktopFile* instPointer,int identifier, void* data);

#endif
