/***************************************************************************
                            HTMLElement.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 All HTML element interfaces derive from this class. Elements that
 only expose the HTML core attributes are represented by the base
 <code> HTMLElement </code> interface. These elements are as
 follows:

  <ulist> <item> HEAD

  </item> <item> special: SUB, SUP, SPAN, BDO

  </item> <item> font: TT, I, B, U, S, STRIKE, BIG, SMALL

  </item> <item> phrase: EM, STRONG, DFN, CODE, SAMP, KBD, VAR,
 CITE, ACRONYM, ABBR

  </item> <item> list: DD, DT

  </item> <item> NOFRAMES, NOSCRIPT

  </item> <item> ADDRESS, CENTER

  </item> </ulist> Note. The <code> style </code> attribute for this
 interface is reserved for future usage.

 
 @short *
 All HTML element interfaces derive from this class.
*/
public class HTMLElement extends Element  {
	protected HTMLElement(Class dummy){super((Class) null);}

	private native void newHTMLElement();
	public HTMLElement() {
		super((Class) null);
		newHTMLElement();
	}
	private native void newHTMLElement( HTMLElement other);
	public HTMLElement( HTMLElement other) {
		super((Class) null);
		newHTMLElement( other);
	}
	private native void newHTMLElement( DOMNode other);
	public HTMLElement( DOMNode other) {
		super((Class) null);
		newHTMLElement( other);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 The element's identifier. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-id">
 id attribute definition </a> in HTML 4.0.

     
*/
	public native String id();

/** 
 see {@link id}
     
*/
	public native void setId( String arg1);

/** 
 The element's advisory title. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-title">
 title attribute definition </a> in HTML 4.0.

     
*/
	public native String title();

/** 
 see {@link title}
     
*/
	public native void setTitle( String arg1);

/** 
 Language code defined in RFC 1766. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/dirlang.html#adef-lang">
 lang attribute definition </a> in HTML 4.0.

     
*/
	public native String lang();

/** 
 see {@link lang}
     
*/
	public native void setLang( String arg1);

/** 
 Specifies the base direction of directionally neutral text and
 the directionality of tables. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/dirlang.html#adef-dir">
 dir attribute definition </a> in HTML 4.0.

     
*/
	public native String dir();

/** 
 see {@link dir}
     
*/
	public native void setDir( String arg1);

/** 
 The class attribute of the element. This attribute has been
 renamed due to conflicts with the "class" keyword exposed by
 many languages. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-class">
 class attribute definition </a> in HTML 4.0.

     
*/
	public native String className();

/** 
 see {@link className}
     
*/
	public native void setClassName( String arg1);

/** 
 The HTML code contained in this element.
 This function is not part of the DOM specifications as defined by the w3c.
     
*/
	public native String innerHTML();

/** 
 Set the HTML content of this node.

*/
	public native void setInnerHTML( String html);

/** 
 The text contained in this element.
 This function is not part of the DOM specifications as defined by the w3c.
     
*/
	public native String innerText();

/** 
 Set the text content of this node.

*/
	public native void setInnerText( String text);

/** 
 Retrieves a collection of nodes that are direct descendants of this node.
 IE-specific extension.
     
*/
	public native HTMLCollection children();

/** 
 Retrieves a collection of all nodes that descend from this node.
 IE-specific extension.
     
*/
	public native HTMLCollection all();
	public native void removeCSSProperty( String property);
	public native void addCSSProperty( String property, String value);
	protected native void assignOther( DOMNode other, int elementId);
}
