/***************************************************************************
                            KProgress.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A stylized progress bar.

 KProgress is derived from {@link QProgressBar}, so
 you can use all the methods from that class. The only real difference
 is that a signal is emitted on changes to the value and you do not need
 to subclass KProgress just to change the format of the indicator text. 

 See {@link KProgressSignals} for signals emitted by KProgress.

 

 @author Aaron Seigo

 @version $Id: KProgress.java,v 1.8 2002/11/26 04:17:33 rdale Exp $
 
 @short A progress indicator widget.

*/
public class KProgress extends QProgressBar  {
	protected KProgress(Class dummy){super((Class) null);}

	private native void newKProgress( QWidget parent, String name, int f);

/** 
 Construct a progress bar.
   
*/
	public KProgress( QWidget parent, String name, int f) {
		super((Class) null);
		newKProgress( parent, name, f);
	}
/**
 Construct a progress bar with parent QWidget, String name.

*/
	public KProgress( QWidget parent, String name) {
      this(parent,name,0);
	}
/**
 Construct a progress bar with parent QWidget.

*/
	public KProgress( QWidget parent) {
      this(parent,null,0);
	}
	private native void newKProgress();
	public KProgress() {
		super((Class) null);
		newKProgress();
	}
	private native void newKProgress( int totalSteps, QWidget parent, String name, int f);

/** 
 Construct a progress bar with a total number of steps.
 The totalSteps is the total number of steps that need to be completed for the operation which this progress
 bar represents. For example, if the operation is to examine 50 files, this value would be 50. Before examining
 the first file, call setProgress(0); call setProgress(50) after examining the last file.
   
*/
	public KProgress( int totalSteps, QWidget parent, String name, int f) {
		super((Class) null);
		newKProgress( totalSteps, parent, name, f);
	}
/**
 Construct a progress bar with int totalSteps, parent QWidget, String name.

*/
	public KProgress( int totalSteps, QWidget parent, String name) {
      this(totalSteps,parent,name,0);
	}
/**
 Construct a progress bar with int totalSteps, parent QWidget.

*/
	public KProgress( int totalSteps, QWidget parent) {
      this(totalSteps, parent,null,0);
	}
	private native void newKProgress( int totalSteps);
	public KProgress( int totalSteps) {
		super((Class) null);
		newKProgress( totalSteps);
	}

/** 
 Destruct the progress bar.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 If this is set to <code>true</code>, the progress text will be displayed.

   
*/
	public native void setTextEnabled( boolean arg1);

/** 

*/
	public native int value();

/** 
 Returns <code>true</code> if progress text will be displayed,
 <code>false</code> otherwise.

*/
	public native boolean textEnabled();

/** 
 Retrieve the current format for printing status text.

*/
	public native String format();

/** 

 Use {@link #setTotalSteps} instead
   
*/
	public native void setRange( int min, int max);

/** 

   
*/
	public native int maxValue();

/** 
 Set the format of the text to use to display status.

 The default format is "%p%" (which looks like "42%".)

*/
	public native void setFormat( String format);

/** 
 Set the current total number of steps in the action tat the progress bar
 is representing.
    
*/
	public native void setTotalSteps( int totalSteps);

/** 

    
*/
	public native void setValue( int progress);

/** 
 Advance the progress bar by <code>prog.</code>

 This method is
 provided for convenience and is equivalent with
 {@link #setValue}+prog).
   
*/
	public native void advance( int offset);
	protected native void virtual_hook( int identifier, int data);
}
