/***************************************************************************
                            KURIFilterPlugin.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KURIFILTERPLUGIN_H
#define KURIFILTERPLUGIN_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 Base class for URI filter plugins.

 This class applies a single filter to a URI.  All
 plugins designed to provide URI filtering functionalities
 should inherit from this abstract class and provide a
 specific filtering implementation.

 All inheriting classes need to implement the pure
 virtual function @ref filterURI.  Otherwise, they
 would also become abstract.

 @short Abstract class for URI filter plugins.
 
*/
@class KCModule; 
@class KURIFilterData; 

@interface KURIFilterPlugin : QObject 

/** 
 Returns the filter's name.

*/
- (NSString *) name;

/** 
 Returns the filter's priority.

 Each filter has an assigned priority, a float from 0 to 1. Filters
 with the lowest priority are first given a chance to filter a URI.

*/
- (double) priority;

/** 
 Filters a URI.

*/
- (BOOL) filterURI: (KURIFilterData*)data;

/** 
 Creates a configuration module for the filter.

 It is the responsability of the caller to delete the module
 once it is not needed anymore.

*/
- (KCModule*) configModule: (QWidget *)arg1 string: (NSString *)arg2;

/** 
 Returns the name of the configuration module for the filter.

*/
- (NSString *) configName;
@end

/** Override these methods in subclasses of KURIFilterPlugin to customise event handling behaviour */
@protocol KURIFilterPluginEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
