// -*- c++ -*-

/*
 *  Copyright (C) 2001-2002, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#ifndef KJSEMBEDJSBINDING_H
#define KJSEMBEDJSBINDING_H

#include <qstring.h>
#include <kjs/types.h>

/**
 * Implement QString-KJS::UString conversion methods. These methods are declared
 * by KJS, but libkjs doesn't actually contain their implementations.
 *
 * @version $Id: jsbinding.h,v 1.3 2002/03/08 18:53:34 rich Exp $
 */
namespace KJS {
    inline UString::UString( const QString &d )
    {
	uint len = d.length();
	UChar *dat = new UChar[len];
	memcpy( dat, d.unicode(), len * sizeof(UChar) );
	rep = UString::Rep::create(dat, len);
    }

    inline QString UString::qstring() const
    {
	return QString((QChar*) data(), size());
    }

    inline QConstString UString::qconststring() const
    {
	return QConstString((QChar*) data(), size());
    }
}

#endif // KJSEMBEDJSBINDING_H

// Local Variables:
// c-basic-offset: 4
// End:
