// QMenuData.cs - A Qt to C# binding.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// Regenerated by Adam Treat on August 03 2002
//
// TODO
// o The QMenu* and QPopupMenu classes need serious analysis. I've only added
//   functionality for C# slot support - I've not made sure its all working. :-)

namespace Qt {

    using Qt;
    using System;
	using System.Collections;
    using System.Runtime.InteropServices;

    public class QMenuData : QtSupport, IQMenuData, IDisposable {

		private Hashtable menuConnections;

		public Hashtable MenuConnections {
			get { return menuConnections; }
		}

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_new_QMenuData ();
        public QMenuData () : this (QNull.Instance)
        {
            rawObject = qt_new_QMenuData ();
            RegisterObject (this);
        }

        internal QMenuData (IntPtr ptr) : this (QNull.Instance)
        {
            rawObject = ptr;
            RegisterObject(this);
        }

        internal QMenuData (QNull dummy) : base (QNull.Instance)
		{
			menuConnections = new Hashtable();
		}

        ~QMenuData ()
        {
            Dispose(false);
        }

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_del_QMenuData (IntPtr obj);
		internal override void Delete ()
		{
			if (deleted) return;

			qt_del_QMenuData (rawObject);
			deleted = true;
		}

		// The next two static methods are here to service all IQMenuData implementors.

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_connectItem (IntPtr raw, int identifier, IntPtr receiver, string member);

		internal static bool ConnectItem (IQMenuData menu, IntPtr menudata, int id, QObject receiver, string slot)
		{
			if (QtSignal.traceConnects)
				ErrMsg ("ConnectItem: ({0}) {1}, {2}, ({3}) {4}, {5}", menudata, menu, id, receiver.RawObject, receiver, slot);

			QtSlot slotobj = new QtSlot(receiver, QtSignal.NormalizeParam(slot));

			if (slotobj.IsCSharpSlot) {
				ArrayList cxlist;

				if ((cxlist = (ArrayList)menu.MenuConnections[id]) == null)
					menu.MenuConnections[id] = cxlist = new ArrayList();
				else if (cxlist.Contains(slotobj))
					return false;

				Delegate del;

				switch (slotobj.Args) {
					case "()":
						del = Delegate.CreateDelegate (typeof (QtSignal.del_void), receiver, slotobj.Name);
						slotobj.WrapperPtr = csharp_connect_item_void (menudata, id, receiver.RawObject, del);
						break;
					case "(int)":
						del = Delegate.CreateDelegate (typeof (QtSignal.del_int), receiver, slotobj.Name);
						slotobj.WrapperPtr = csharp_connect_item_int (((QtSupport)menu).RawObject, id, receiver.RawObject, del);
						break;
					default:
						throw new ArgumentException("Unsupported slot arguments: " + slotobj.Args);
				}

				if (slotobj.WrapperPtr == IntPtr.Zero) {
					return false;
				}

				slotobj.Callback = del;
				cxlist.Add(slotobj);
				return true;
			}
			else {
				return qt_QMenuData_connectItem(menudata, id, receiver.RawObject, slot);
			}
		}

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_disconnectItem (IntPtr raw, int identifier, IntPtr receiver, string member);

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_del_QObject (IntPtr raw);

		internal static bool DisconnectItem (IQMenuData menu, IntPtr menudata, int id, QObject receiver, string slot)
		{
			if (QtSignal.traceConnects)
				ErrMsg ("DisconnectItem: ({0}) {1}, {2}, ({3}) {4}, {5}", menudata, menu, id, receiver.RawObject, receiver, slot);

			QtSlot slotobj = new QtSlot(receiver, QtSignal.NormalizeParam(slot));

			if (slotobj.IsCSharpSlot) {
				ArrayList cxlist;

				if ((cxlist = (ArrayList)menu.MenuConnections[id]) == null)
					return false;
				else if (!cxlist.Contains(slotobj))
					return false;

				// FIXME Make sure LastIndexOf tests equality with Equals. MS docs are unclear...
				slotobj = (QtSlot)cxlist[cxlist.LastIndexOf(slotobj)];
				cxlist.Remove(slotobj);
				if (cxlist.Count == 0)
					menu.MenuConnections.Remove (cxlist);

				// FIXME Make sure QObject's dtor auto-disconnects menu items.
				qt_del_QObject (slotobj.WrapperPtr);
				return true;
			}
			else {
				return qt_QMenuData_disconnectItem (menudata, id, receiver.RawObject, slot);
			}
		}

		// Hack so QMenuData implements IQMenuData...

		public bool setItemParameter (int identifier, int param)
		{
			return false;
		}

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern uint qt_QMenuData_count (IntPtr raw);
        public uint Count ()
        {
            return qt_QMenuData_count (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem4 (IntPtr raw, IntPtr text, int identifier, int index);
        public int InsertItem (string text, int identifier, int index)
        {
            return qt_QMenuData_insertItem4 (rawObject, new QString (text).RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem5 (IntPtr raw, IntPtr icon, IntPtr text, int identifier, int index);
        public int InsertItem (QIconSet icon, string text, int identifier, int index)
        {
            return qt_QMenuData_insertItem5 (rawObject, icon.RawObject, new QString (text).RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem6 (IntPtr raw, IntPtr text, IntPtr popup, int identifier, int index);
        public int InsertItem (string text, QPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem6 (rawObject, new QString (text).RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem7 (IntPtr raw, IntPtr icon, IntPtr text, IntPtr popup, int identifier, int index);
        public int InsertItem (QIconSet icon, string text, QPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem7 (rawObject, icon.RawObject, new QString (text).RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem8 (IntPtr raw, IntPtr pixmap, int identifier, int index);
        public int InsertItem (QPixmap pixmap, int identifier, int index)
        {
            return qt_QMenuData_insertItem8 (rawObject, pixmap.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem9 (IntPtr raw, IntPtr icon, IntPtr pixmap, int identifier, int index);
        public int InsertItem (QIconSet icon, QPixmap pixmap, int identifier, int index)
        {
            return qt_QMenuData_insertItem9 (rawObject, icon.RawObject, pixmap.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem10 (IntPtr raw, IntPtr pixmap, IntPtr popup, int identifier, int index);
        public int InsertItem (QPixmap pixmap, QPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem10 (rawObject, pixmap.RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem11 (IntPtr raw, IntPtr icon, IntPtr pixmap, IntPtr popup, int identifier, int index);
        public int InsertItem (QIconSet icon, QPixmap pixmap, QPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem11 (rawObject, icon.RawObject, pixmap.RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem12 (IntPtr raw, IntPtr widget, int identifier, int index);
        public int InsertItem (QWidget widget, int identifier, int index)
        {
            return qt_QMenuData_insertItem12 (rawObject, widget.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem13 (IntPtr raw, IntPtr icon, IntPtr custom, int identifier, int index);
        public int InsertItem (QIconSet icon, QCustomMenuItem custom, int identifier, int index)
        {
            return qt_QMenuData_insertItem13 (rawObject, icon.RawObject, custom.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem14 (IntPtr raw, IntPtr custom, int identifier, int index);
        public int InsertItem (QCustomMenuItem custom, int identifier, int index)
        {
            return qt_QMenuData_insertItem14 (rawObject, custom.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertSeparator (IntPtr raw, int index);
        public int InsertSeparator (int index)
        {
            return qt_QMenuData_insertSeparator (rawObject, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_removeItem (IntPtr raw, int identifier);
        public void RemoveItem (int identifier)
        {
            qt_QMenuData_removeItem (rawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_removeItemAt (IntPtr raw, int index);
        public void RemoveItemAt (int index)
        {
            qt_QMenuData_removeItemAt (rawObject, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_clear (IntPtr raw);
        public void Clear ()
        {
            qt_QMenuData_clear (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_accel (IntPtr raw, int identifier);
        public QKeySequence Accel (int identifier)
        {
            return (QKeySequence)LookupObject (qt_QMenuData_accel (rawObject, identifier), typeof(QKeySequence));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setAccel (IntPtr raw, IntPtr key, int identifier);
        public void SetAccel (QKeySequence key, int identifier)
        {
            qt_QMenuData_setAccel (rawObject, key.RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_iconSet (IntPtr raw, int identifier);
        public QIconSet IconSet (int identifier)
        {
            return (QIconSet)LookupObject (qt_QMenuData_iconSet (rawObject, identifier), typeof(QIconSet));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_text (IntPtr raw, int identifier);
        public string Text (int identifier)
        {
			QString qstr = new QString (qt_QMenuData_text (rawObject, identifier));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_pixmap (IntPtr raw, int identifier);
        public QPixmap Pixmap (int identifier)
        {
            return (QPixmap)LookupObject (qt_QMenuData_pixmap (rawObject, identifier), typeof(QPixmap));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setWhatsThis (IntPtr raw, int identifier, IntPtr arg1);
        public void SetWhatsThis (int identifier, string arg1)
        {
            qt_QMenuData_setWhatsThis (rawObject, identifier, new QString (arg1).RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_whatsThis (IntPtr raw, int identifier);
        public string WhatsThis (int identifier)
        {
			QString qstr = new QString (qt_QMenuData_whatsThis (rawObject, identifier));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem (IntPtr raw, int identifier, IntPtr text);
        public void ChangeItem (int identifier, string text)
        {
            qt_QMenuData_changeItem (rawObject, identifier, new QString (text).RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem1 (IntPtr raw, int identifier, IntPtr pixmap);
        public void ChangeItem (int identifier, QPixmap pixmap)
        {
            qt_QMenuData_changeItem1 (rawObject, identifier, pixmap.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem2 (IntPtr raw, int identifier, IntPtr icon, IntPtr text);
        public void ChangeItem (int identifier, QIconSet icon, string text)
        {
            qt_QMenuData_changeItem2 (rawObject, identifier, icon.RawObject, new QString (text).RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem3 (IntPtr raw, int identifier, IntPtr icon, IntPtr pixmap);
        public void ChangeItem (int identifier, QIconSet icon, QPixmap pixmap)
        {
            qt_QMenuData_changeItem3 (rawObject, identifier, icon.RawObject, pixmap.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem4 (IntPtr raw, IntPtr text, int identifier);
        public void ChangeItem (string text, int identifier)
        {
            qt_QMenuData_changeItem4 (rawObject, new QString (text).RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem5 (IntPtr raw, IntPtr pixmap, int identifier);
        public void ChangeItem (QPixmap pixmap, int identifier)
        {
            qt_QMenuData_changeItem5 (rawObject, pixmap.RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem6 (IntPtr raw, IntPtr icon, IntPtr text, int identifier);
        public void ChangeItem (QIconSet icon, string text, int identifier)
        {
            qt_QMenuData_changeItem6 (rawObject, icon.RawObject, new QString (text).RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_isItemActive (IntPtr raw, int identifier);
        public bool IsItemActive (int identifier)
        {
            return qt_QMenuData_isItemActive (rawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_isItemEnabled (IntPtr raw, int identifier);
        public bool IsItemEnabled (int identifier)
        {
            return qt_QMenuData_isItemEnabled (rawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setItemEnabled (IntPtr raw, int identifier, bool enable);
        public void SetItemEnabled (int identifier, bool enable)
        {
            qt_QMenuData_setItemEnabled (rawObject, identifier, enable);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_isItemChecked (IntPtr raw, int identifier);
        public bool IsItemChecked (int identifier)
        {
            return qt_QMenuData_isItemChecked (rawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setItemChecked (IntPtr raw, int identifier, bool check);
        public void SetItemChecked (int identifier, bool check)
        {
            qt_QMenuData_setItemChecked (rawObject, identifier, check);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_indexOf (IntPtr raw, int identifier);
        public int IndexOf (int identifier)
        {
            return qt_QMenuData_indexOf (rawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_idAt (IntPtr raw, int index);
        public int IdAt (int index)
        {
            return qt_QMenuData_idAt (rawObject, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setId (IntPtr raw, int index, int identifier);
        public void SetId (int index, int identifier)
        {
            qt_QMenuData_setId (rawObject, index, identifier);
        }

		//********************* A temporary hack to divert connections to CSharpConnect *****************//

		public bool ConnectItem (int identifier, QObject receiver, string slot)
		{
			return ConnectItem (this, this.RawObject, identifier, receiver, slot);
		}

		public bool DisconnectItem (int identifier, QObject receiver, string slot)
		{
			return DisconnectItem (this, this.RawObject, identifier, receiver, slot);
		}

		public int InsertItem (string text, QObject receiver, string member, QKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (text, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public int InsertItem (QIconSet icon, string text, QObject receiver, string member, QKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (icon, text, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public int InsertItem (QPixmap pixmap, QObject receiver, string member, QKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (pixmap, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public int InsertItem (QIconSet icon, QPixmap pixmap, QObject receiver, string member, QKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (icon, pixmap, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		//********************* A temporary hack to divert connections to CSharpConnect *****************//

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_setItemParameter (IntPtr raw, int identifier, int param);
        public bool SetItemParameter (int identifier, int param)
        {
            return qt_QMenuData_setItemParameter (rawObject, identifier, param);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_itemParameter (IntPtr raw, int identifier);
        public int ItemParameter (int identifier)
        {
            return qt_QMenuData_itemParameter (rawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_findItem (IntPtr raw, int identifier);
        public QMenuItem FindItem (int identifier)
        {
            return (QMenuItem)LookupObject (qt_QMenuData_findItem (rawObject, identifier), typeof(QMenuItem));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_findItem1 (IntPtr raw, int identifier, IntPtr parent);
        public QMenuItem FindItem (int identifier, QMenuData parent)
        {
            return (QMenuItem)LookupObject (qt_QMenuData_findItem1 (rawObject, identifier, parent.RawObject), typeof(QMenuItem));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_findPopup (IntPtr raw, IntPtr arg1, int[] index);
        public QMenuItem FindPopup (QPopupMenu arg1, int[] index)
        {
            return (QMenuItem)LookupObject (qt_QMenuData_findPopup (rawObject, arg1.RawObject, index), typeof(QMenuItem));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_menuInsPopup (IntPtr raw, IntPtr arg1);
        protected void MenuInsPopup (QPopupMenu arg1)
        {
            qt_QMenuData_menuInsPopup (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_menuDelPopup (IntPtr raw, IntPtr arg1);
        protected void MenuDelPopup (QPopupMenu arg1)
        {
            qt_QMenuData_menuDelPopup (rawObject, arg1.RawObject);
        }

        public int InsertItem (string text, QObject receiver, string member)
        {
            return InsertItem(text, receiver, member, new QKeySequence ());
        }

        public int InsertItem (string text, QObject receiver, string member, QKeySequence accel)
        {
            return InsertItem(text, receiver, member, accel, (int) -1);
        }

        public int InsertItem (string text, QObject receiver, string member, QKeySequence accel, int identifier)
        {
            return InsertItem(text, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, QObject receiver, string member)
        {
            return InsertItem(icon, text, receiver, member, new QKeySequence ());
        }

        public int InsertItem (QIconSet icon, string text, QObject receiver, string member, QKeySequence accel)
        {
            return InsertItem(icon, text, receiver, member, accel, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, QObject receiver, string member, QKeySequence accel, int identifier)
        {
            return InsertItem(icon, text, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, QObject receiver, string member)
        {
            return InsertItem(pixmap, receiver, member, new QKeySequence ());
        }

        public int InsertItem (QPixmap pixmap, QObject receiver, string member, QKeySequence accel)
        {
            return InsertItem(pixmap, receiver, member, accel, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, QObject receiver, string member, QKeySequence accel, int identifier)
        {
            return InsertItem(pixmap, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QObject receiver, string member)
        {
            return InsertItem(icon, pixmap, receiver, member, new QKeySequence ());
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QObject receiver, string member, QKeySequence accel)
        {
            return InsertItem(icon, pixmap, receiver, member, accel, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QObject receiver, string member, QKeySequence accel, int identifier)
        {
            return InsertItem(icon, pixmap, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (string text)
        {
            return InsertItem(text, (int) -1);
        }

        public int InsertItem (string text, int identifier)
        {
            return InsertItem(text, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text)
        {
            return InsertItem(icon, text, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, int identifier)
        {
            return InsertItem(icon, text, identifier, (int) -1);
        }

        public int InsertItem (string text, QPopupMenu popup)
        {
            return InsertItem(text, popup, (int) -1);
        }

        public int InsertItem (string text, QPopupMenu popup, int identifier)
        {
            return InsertItem(text, popup, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, QPopupMenu popup)
        {
            return InsertItem(icon, text, popup, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, QPopupMenu popup, int identifier)
        {
            return InsertItem(icon, text, popup, identifier, (int) -1);
        }

        public int InsertItem (QPixmap pixmap)
        {
            return InsertItem(pixmap, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, int identifier)
        {
            return InsertItem(pixmap, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap)
        {
            return InsertItem(icon, pixmap, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, int identifier)
        {
            return InsertItem(icon, pixmap, identifier, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, QPopupMenu popup)
        {
            return InsertItem(pixmap, popup, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, QPopupMenu popup, int identifier)
        {
            return InsertItem(pixmap, popup, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QPopupMenu popup)
        {
            return InsertItem(icon, pixmap, popup, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QPopupMenu popup, int identifier)
        {
            return InsertItem(icon, pixmap, popup, identifier, (int) -1);
        }

        public int InsertItem (QWidget widget)
        {
            return InsertItem(widget, (int) -1);
        }

        public int InsertItem (QWidget widget, int identifier)
        {
            return InsertItem(widget, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, QCustomMenuItem custom)
        {
            return InsertItem(icon, custom, (int) -1);
        }

        public int InsertItem (QIconSet icon, QCustomMenuItem custom, int identifier)
        {
            return InsertItem(icon, custom, identifier, (int) -1);
        }

        public int InsertItem (QCustomMenuItem custom)
        {
            return InsertItem(custom, (int) -1);
        }

        public int InsertItem (QCustomMenuItem custom, int identifier)
        {
            return InsertItem(custom, identifier, (int) -1);
        }

        public int InsertSeparator ()
        {
            return InsertSeparator((int) -1);
        }

        public QMenuItem FindPopup (QPopupMenu arg1)
        {
            return FindPopup(arg1, new int[]{0});
        }

		[DllImport("libqtsharp", CharSet=CharSet.Ansi)]
		private static extern IntPtr csharp_connect_item_void (IntPtr instance, int id, IntPtr receiver, Delegate method);

		[DllImport("libqtsharp", CharSet=CharSet.Ansi)]
		private static extern IntPtr csharp_connect_item_int (IntPtr instance, int id, IntPtr receiver, Delegate method);

    }
}
