/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStream
extends FilterOutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 512;
    protected byte[] buf;
    protected int count;

    public BufferedOutputStream(OutputStream out) {
        this(out, 512);
    }

    public BufferedOutputStream(OutputStream out, int size) {
        super(out);
        this.buf = new byte[size];
    }

    public synchronized void flush() throws IOException {
        if (this.count == 0) {
            return;
        }
        this.out.write(this.buf, 0, this.count);
        this.count = 0;
    }

    public synchronized void write(int b) throws IOException {
        this.buf[this.count] = (byte)b & 0xFFFFFFFF;
        ++this.count;
        if (this.count == this.buf.length) {
            this.flush();
        }
    }

    public synchronized void write(byte[] buf, int offset, int len) throws IOException {
        if (len < this.buf.length - this.count) {
            System.arraycopy(buf, offset, this.buf, this.count, len);
            this.count += len;
        } else {
            this.flush();
            this.out.write(buf, offset, len);
        }
    }
}

