/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;

public abstract class Certificate {
    private String type;

    protected Certificate(String type) {
        this.type = type;
    }

    public final String getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (other instanceof Certificate) {
            try {
                Certificate x = (Certificate)other;
                if (this.getEncoded().length != x.getEncoded().length) {
                    return false;
                }
                byte[] b1 = this.getEncoded();
                byte[] b2 = x.getEncoded();
                for (int i = 0; i < b1.length; ++i) {
                    if (b1[i] == b2[i]) continue;
                    return false;
                }
            }
            catch (CertificateEncodingException cee) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract String toString();

    public abstract PublicKey getPublicKey();

    static class CertificateRep
    implements Serializable {
        private String type;
        private byte[] data;

        protected CertificateRep(String type, byte[] data) {
            this.type = type;
            this.data = data;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                return new ObjectInputStream(new ByteArrayInputStream(this.data)).readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.toString());
            }
        }
    }
}

