/* The contents of this file are subject to the Netscape Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is Mozilla Communicator client code, released
 * March 31, 1998.
 *
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation. Portions created by Netscape are
 * Copyright (C) 1998-1999 Netscape Communications Corporation. All
 * Rights Reserved.
 *
 */ 

var prefService = null;
var smtpService = null;
var gCurrentAccountData;
var gDisableBackButton = false;
var gActivationBundle;
var glaunchMailAppOnFinish;

var messengerMigratorContractID = "@mozilla.org/messenger/migrator;1";
var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);

var gPrefSet = prefs.getBoolPref("browser.activation.checkedNNFlag");
    
function loadActivation()
{

    /* We are checking here for the start page */

    gActivationBundle = document.getElementById("bundle_activation");

    setEntryPoint("mainstreamActivation");

    if (!gPrefSet)
    {
      gPrefSet = true;
      try {
        // set this to true so that we do not bring up activation next time
        prefs.setBoolPref("browser.activation.checkedNNFlag", true);
        // get the screen that we got from previous successful activation
        // from a previous version
        gScreenName = prefs.getComplexValue("browser.activation.screenname" ,Components.interfaces.nsISupportsWString).data;
        prefs.clearUserPref("browser.activation.screenname");
      }
      catch(ex){}
    }
    if (window.arguments && window.arguments[0]) {
      if(window.arguments[0].page == "ispPage3") {
        SetNewPageMappings(window.arguments[0].page, "ispPage2", "activationdone");
        if (window.arguments[0].origin == "activationStartWindow") {
          gNewAccountUrl = window.arguments[0].newaccturl;

          // get all other urls too
          gAuthenticationUrl = window.arguments[0].authurl;
          gReadUrl = window.arguments[0].readurl;
          gWriteUrl = window.arguments[0].writeurl;
          gForgottenPwdUrl = window.arguments[0].forgotpwdurl;
          gSuggestSnUrl = window.arguments[0].suggestsnurl;
          gSetUserBrandUrl = window.arguments[0].setbrandurl;
          gAgeSuspendUrl = window.arguments[0].agesuspendurl;
          gCreditCardValidationUrl = window.arguments[0].creditvalidurl;
          gMigratedUserScreenName = window.arguments[0].collectedScreenName;
          gFirstName = window.arguments[0].collectedFirstName;
          gLastName = window.arguments[0].collectedLastName;
        }
        document.documentElement.advance(window.arguments[0].page);
      }
      else if (window.arguments[0].page == "ispPage4") {
        var progressWindow = getProgressDialog("activationStartWindow");
        if (progressWindow) 
          progressWindow.close();

        SetNewPageMappings(window.arguments[0].page, "ispPage5", "activationdone");
        if (window.arguments[0].origin == "activationStartWindow") {
          gNewAccountUrl = window.arguments[0].newaccturl;
          gDisableBackButton = true;

          // get all other urls too
          gAuthenticationUrl = window.arguments[0].authurl;
          gReadUrl = window.arguments[0].readurl;
          gWriteUrl = window.arguments[0].writeurl;
          gForgottenPwdUrl = window.arguments[0].forgotpwdurl;
          gSuggestSnUrl = window.arguments[0].suggestsnurl;
          gSetUserBrandUrl = window.arguments[0].setbrandurl;
          gAgeSuspendUrl = window.arguments[0].agesuspendurl;
          gCreditCardValidationUrl = window.arguments[0].creditvalidurl;
        }
        document.documentElement.advance(window.arguments[0].page);
      }
    }
    else
      window.close();
}

function ActivationWizFinish()
{
  if ((document.documentElement.currentPage.id == "ispPage14") ||
     (document.documentElement.currentPage.id == "ispPage13") ||
     (document.documentElement.currentPage.id == "ispPage15") ||
     (document.documentElement.currentPage.id == "ispPage16")) {
    try {
      actvInst.processScreenNameInfo(false, null, null)
    }
    catch (ex){}
    
  }
  else {
  try {
    actvInst.processScreenNameInfo(true, gScreenName, gEmailAddress)
    
    try {
       gFinalSideBarPanel = window.arguments[0].gFinalSideBarPanel
       }
       catch(ex){}
    
    if (gEntryPoint == "mainstreamActivation" && gFinalSideBarPanel==null){
       
       // get the profile's localstore
       var rdf = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
       var localStore = rdf.GetDataSource("rdf:local-store");
       
       // change the current last-selected-panel from old (e.g., search)
       // to the new default, buddy list (i.e., im-panel)
       // from: sidebar-panels ---[ last-selected-panel ]---> search
       //   to: sidebar-panels ---[ last-selected-panel ]---> im-panel
       // now buddy list will be the default sidebar panel upon activation
       var src = rdf.GetResource("chrome://navigator/content/navigator.xul#sidebar-panels");
       var prop = rdf.GetResource("last-selected-panel");
       var tgtOld = localStore.GetTarget(src,prop,true).QueryInterface(Components.interfaces.nsIRDFLiteral);
       var tgtNew = rdf.GetLiteral("urn:sidebar:panel:im-panel");
       
       // tell localstore to change the target
       localStore.Change(src, prop, tgtOld, tgtNew);
    }

    var accountCreated = false;
    if (!gFailedToCreateWebMailAccount) {
      accountCreated = CreateWebMailAccount();  
    }
  }
  catch (ex){}
  }
  return true;
}

function ActivationWizCancel()
{
  if (document.documentElement.currentPage.id == "ispPage12") {
    gCreditPageCancelled =true;
    document.documentElement.advance("ispPage13");
    return false;
  }

  var confirmMsg = gActivationBundle.getString("cancelActivationWizard");
  var confirmTitle = gActivationBundle.getString("activationWizard");
  var result;

  var accountCreated = false;
  if (document.documentElement.currentPage.id == "activationdone") {
    confirmMsg = gActivationBundle.getString("cancelAfterAccountCreation");
    accountCreated = true;
  }
  
  var closeWizard = true;
  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService();
  promptService = promptService.QueryInterface(Components.interfaces.nsIPromptService);
  result = promptService.confirmEx(window, confirmTitle, confirmMsg,
    (promptService.BUTTON_TITLE_IS_STRING*promptService.BUTTON_POS_0)+
    (promptService.BUTTON_TITLE_IS_STRING*promptService.BUTTON_POS_1),
    gActivationBundle.getString('ActivationWizardExit'),
    gActivationBundle.getString('ActivationWizardContinue'), 
    null, null, {value:0});

  if (result == 1)
    closeWizard = false;

  if (closeWizard && !accountCreated)
    actvInst.processScreenNameInfo(false, null, null)
  
  return closeWizard;
}


// Use ispUtils to grab the right values from corresponsing isp's rdf file 
// Use AccountWizard's functions to create a webmail account
function CreateWebMailAccount()
{
    try {
      if (prefs.prefIsLocked("mail.disable_new_account_addition"))
        return null;

      if (!gEmailAddress) return null;
      var emailData = gEmailAddress.split('@');

      var pageData = GetPageData();
      
      gCurrentAccountData = getIspDefaultsForUri('domain:netscape.net');

      AccountDataToPageData(gCurrentAccountData, pageData);

      var prettyName = gCurrentAccountData.incomingServer.prettyName; 
      // Get the polished account name - mail overlay is failing for some reason
      // accountName property added in activaton bundle. Check this one later.
      accountName = gActivationBundle.getFormattedString("accountName",
                                                         [prettyName,
                                                         gScreenName]);
      // Set that to be the name in the pagedata 
      setPageData(pageData, "accname", "prettyName", accountName);

      setPageData(pageData, "identity", "email", gEmailAddress);
      setPageData(pageData, "identity", "fullName", gUserFullName);
      setPageData(pageData, "login", "username", gScreenName);

      // try migration, in case there are any accounts to be brought on
      try {
        var accounts = am.accounts;
        var accountCount = accounts.Count();
        // if the number of accounts is ZERO at this time, try migration.
        if (accountCount == 0) {
          var messengerMigrator = Components.classes[messengerMigratorContractID].getService(Components.interfaces.nsIMessengerMigrator); 
          messengerMigrator.UpgradePrefs();
        }
      }
      catch (ex) {
      }

      try {
        gDefaultAccount = am.defaultAccount;
      }
      catch (ex) {
        // no default account, this is expected the first time you launch mail
        // on a new profile
        gDefaultAccount = null;
      }

      FinishAccount();
    }
    catch (ex)
    {
    }
    return true;
}

function activationDoneInit()
{

  if (gFailedToCreateWebMailAccount) {
    var webMailBox = document.getElementById("webMailAddressBox");
    webMailBox.setAttribute("collapsed", true);
  }

  disableButton("back");
  disableButton("cancel");

  // Show/Hide check box that can launch user into webmail directly based on 
  // success of webmail account creation

  var activatedScreenName = document.getElementById("activatedScreenName");
  activatedScreenName.setAttribute("value", gScreenName);

  var activatedEmailAddress = document.getElementById("activatedEmailAddress");
  activatedEmailAddress.setAttribute("value", gEmailAddress);
}

function launchMailAppOnFinish()
{
  glaunchMailAppOnFinish = document.getElementById("launchMailApp").checked;
}

