var enterCR_pref_value = false;
var Tab_pref_value = false;
var args;
var message="";
var sendAwayMessage = true;
var showTimestampVal;
var isChatContent = false;
var firstSend = 1;

/*
 * IMDocumentStateListener is the listener which the IM compose window uses.
 * NotifyDocumentCreated gets called by the editor whenever there is some change in the
 * compose window. If there is any IM message from the input arguments, then that is added 
 * to the compose window and the send button is enabled.
*/

var IMDocumentStateListener =
{
  NotifyDocumentCreated: function() 
  {
  setTimeout("sendButtonListeners()",0);
  var nsIPlaintextEditor = Components.interfaces.nsIPlaintextEditor;
  window.editorShell.editor.flags |= nsIPlaintextEditor.eEditorNoCSSMask;
  if ( message != "" ) {
    window.editorShell.InsertText(message);
    EnableSendButton();
  }

  },

  NotifyDocumentWillBeDestroyed: function() {},
  NotifyDocumentStateChanged:function( isNowDirty ) {
    // If the document is not empty, enable the send button
     if (isNowDirty)
       EnableSendButton();
  }
};

/*
 * Function:  KnockKnockAddDenyList()
 * Arguments: None
 * Return: None
 * Description:  This function is called when the user clicks on the deny button in the KnockKnock window.
 * It blocks screen name of the incoming message and closees the dialog window.
*/

function KnockKnockAddDenyList()
{
  val = cmdPeopleBlock();
  if ( val == true )
    window.close();
}

/*
 * Function:  toggleKnockKnockPref()
 * Arguments: None
 * Return: None
 * Description:  This function is called when the user chooses not to display the KnockKnock
 * message window. There is a checkbox in the first KnockKnock window which when checked,
 * sets a pref. Once this pref is set, from next time on, there will nit be KnockKnock again.
 * This function justs sets the pref according to the checkbox value.
*/

function toggleKnockKnockPref()
{
  var element = document.getElementById("IMKnockKnockCheckbox");
  if (aimPrefsManager() && element.checked == true ) {
    aimPrefsManager().SetBoolPref("aim.privacy.knockknock", false , null, false);
  }
  else if ( aimPrefsManager() && element ) {
    aimPrefsManager().SetBoolPref("aim.privacy.knockknock", true , null, false);
  }
}

/*
 * Function:  pokeKnockKnockMessage( scname )
 * Arguments: scname
 * Return: None
 * Description:  This function is called when there is a incoming KnockKnock message. It adds the 
 * necessary text to the knockknock window including the sender's screen name and their current warning percent.
 * The sender's screen name is obtained from the input parameter scname. The warning level of sender is obtained
 * by using the locatemanager. It puts up a Ok and Cancel button. clicking Ok will open a Im indow by calling the 
 * StartConveration function (See below). It also checks the KnockKnock pref to see if it has been set or not
 * and updates the checkbox in window.
*/

function pokeKnockKnockMessage(scname)
{
  var msg = aimString("knock.msg");
  var warning = aimString("knock.warning");
  var message = aimString("knock.preamble").replace(/%ScreenName%/, scname); 

  var element = document.getElementById("IMKnockKnockHtml");
  var textNode = document.createTextNode(message);
  element.appendChild(textNode);

  element = document.getElementById("IMKnockKnockMessage");
  textNode = document.createTextNode(msg);
  element.appendChild(textNode);

  document.getElementById("IMKnockKnockWarningTitle").setAttribute("label", scname);

  var locateManager = aimLocateManager();
  var LocateCallbackObject = new Object();

  LocateCallbackObject.OnRequestUserInfoDefaultComplete = function(screenname, userobj)
  {
    var element = document.getElementById("IMKnockKnockWarning");
    var percent = userobj.GetWarningPercent();
    var message = warning.replace(/%Level%/,  percent);
    document.getElementById("IMKnockKnockWarning").value = message;
  }

  LocateCallbackObject.OnRequestUserInfoDefaultError = function(screenname, error)
  {
    // do nothing
  }

  locateManager.RequestUserInfoDefault( LocateCallbackObject, scname );   

  labels = document.getElementById("okCancelButtons");
  element = document.getElementById("ok");
  element.setAttribute("label", labels.getAttribute("button1Label"));
  element = document.getElementById("cancel");
  element.setAttribute("label", labels.getAttribute("button2Label"));

  doSetOKCancel(StartConversation, CancelConversation);

  element = document.getElementById("IMKnockKnockCheckbox");
  var currentVal = aimPrefsManager().GetBoolPref("aim.privacy.knockknock" ,null,false);
  if ( currentVal == true ) 
    element.setAttribute("checked", false);
  else 
    element.setAttribute("checked", true);
}

/*
* gFirstTime is a global to determine if our onload handler has been called yet.
* For some reason, our onunload handler is getting called before onload
* on the first time we create IM.xul. This is a workaround.
*/

var gFirstTime = 1;

/*
 * Function:  AimIMOnWndLoad()
 * Arguments: None
 * Return: None
 * Description:  Onload handler for IM conversation window. It creates a IM Object which is 
 * used to store all the focus information and initialises it. It also retrieves the IM Mode and
 * screen name from the window arguments. It adds an event listener to capture keypress events 
 * which gets handles by ComposeKeyPress handler. This is in place to take care of IM specific keydown
 * handling like tab and enter key. If it is knockKnock mode then PokeKnockKnockMessage function (See Above)
 * gets called. Otherwise call StartConversation function ( See Below) brings up the IM window.
*/
 
function AimIMOnWndLoad()
{
  gFirstTime = 0;

  top.imObject = new Object();
  top.imObject.logHasFocus = false;
  top.imObject.editorHasFocus = false;   
  top.imObject.screenNameHasFocus = false;
   
  /**
   * retrieve window arguments, extract IM mode and screen name
   */

  args = aimGetArgs(top.arguments[0]);
  top.document.getElementById("IMAttribs").setAttribute("imMode", args.Mode);

  /* capture some events, BEFORE editor does */

  var bbox = document.getElementById("ComposeWnd");
  if (bbox) { 
    // bugscape bug 10832, Macintosh is not receiveing the keydown properly.
    if (navigator.appVersion.indexOf("Macintosh") != -1)
      bbox.addEventListener("keypress", composeKeyPress, true);
    else
      bbox.addEventListener("keydown", composeKeyPress, true);
  }
    

  // set initial timestamp value for this window, and seed the menu item

  showTimestampVal = aimPrefsManager().GetBoolPref("aim.general.im.timeStamp", 
    null, false);

  SetTimestampMenuItem();

  updateCurrentComposeWindow();

  window.setTimeout('delayedOnWndLoad()', 0);
}

/*
 * Name: delayedOnWndLoad
 * Arguments: None
 * Description: This is code that logically belongs to AimIMOnWndLoad.
 * It must executed after AimIMOnWndLoad has returned to its caller.
 * This was necessary to make the code in this function work. For some
 * reason it did not work when it was placed directly in AimIMOnWndLoad.
 * The theory is, this is caused by the callback mechanism used in this function,
 * which conflicts with the call frame in which AimIMOnWndLoad is executed.
 * Return Value: None
 * Original Code: portions moved from AimIMOnWndLoad, portions Kai Engert 10/2001
 *
 */
function delayedOnWndLoad()
{
  function CapabitiliesObtainer()
  {
  }

  CapabitiliesObtainer.prototype = {

    OnRequestUserInfoCapabilitiesError: function(aScreenName, ErrMsg)
    {
      // Unable to obtain, do not enable encryption
    },

    OnRequestUserInfoCapabilitiesComplete: function(aScreenName, aUserObj)
    {
      var capMask = aUserObj.GetCapabilities();
      var capEnums = Components.interfaces.nsAimCapabilitesMask;
      if (capEnums.secureIM & capMask) {
        var btnLock = document.getElementById("btnLock");
        if (btnLock) {
          btnLock.removeAttribute("hidden");
        }
        /* we don't want to show it, but we use it to keep track of a window's encryption status*/
        var chkboxCrypt = document.getElementById("chkboxCrypt");
        if (chkboxCrypt) {
          chkboxCrypt.checked = true;
          //chkboxCrypt.removeAttribute("hidden");
        }
        var encryptStatus = document.getElementById("encryptStatus");
        if (encryptStatus) {
          encryptStatus.removeAttribute("hidden");
        }
      }
    }
  }

  args = aimGetArgs(top.arguments[0]);

  var locateMgr = aimLocateManager();
  if (locateMgr) {
    try {
      var obtainer = new CapabitiliesObtainer();
      locateMgr.RequestUserInfoCapabilities(obtainer, args.ScreenName);
    } catch (ex) {
      dump("* ERROR: unable to retrieve AIM user capabilities for '"+args.ScreenName+"'\n* REASON: " + ex);
    }
  }

  /**
   * if knock knock, let user approve it, also, check to see if we should
   * autoreply, and do so if necessary
   */

  var pPAimIM = aimPIMObject();
  var screenName = AimIMGetFormScreenName();
  aimIM().SetIMWndIcon(screenName);

  if ( args.Mode == "KnockKnock" ) {
    pokeKnockKnockMessage( screenName ); 
  /**
   * we have to set this focus or ok/cancel buttons will not work
   * with the key equivalents. lame
   */
    setTimeout('window.focus()',300);
    return;
  }
  else
    doSetOKCancel(DoNothing, DoNothing);

  /**
   * otherwise, do what we have always done
   */
  StartConversation();
}

function composeKeyPress(event){
  if (event.keyCode == 46 || event.keyCode == 8)
  {
    /* If user hits backspace or delete key, check if the document will be emptied*/
     checkToDisable();
     return;
  }
        
  // This is how it really should be for control enter 
  // if ((event.ctrlKey) && (event.keyCode == 13))
  // Temporary hack since the above fails. Currently this condition is met by both control-enter 
  // and control-j (Depends bug). Control-j should not send IM -bug tracked in 9007.
  if ((event.ctrlKey) && (event.charCode == 106)) 
  {
     event.preventBubble();
     event.preventDefault();
     if (!window.editorShell.documentIsEmpty)
       window.setTimeout('AimIMCmdSend()', 1, true); 
     return false;
   }
   if ((event.keyCode == 13) || (event.keyCode == 10)){ 
      if (event.shiftKey)
         return;
      if (SendOnEnter() == true) { 
         event.preventBubble();
         event.preventDefault();
         /* Make sure user is not sending a empty message */
         if (!window.editorShell.documentIsEmpty)
            window.setTimeout('AimIMCmdSend(true)', 1, true); 
         return false; 
       } 
       
      return true;
   } 
   if (event.keyCode == 9) {
    if (OnTab() == true) { 
      if (!window.editorShell.documentIsEmpty) {
        document.getElementById('btnSend').focus();
        FocusSend();
       }
       else{
        //send focus to the right field
         var theLogWindow = document.getElementById('LogWnd');
         var theScreenNameField = document.getElementById('fldScreenName')
         var theWindow = document.getElementById('AimIM');
         var theWindowMode = theWindow.getAttribute("imMode")
        if(theWindowMode == "Normal") {
           theScreenNameField.focus();
        }
        if(theWindowMode == "Bound") {
          top.frames['LogWnd'].focus();
        }
       }
      event.preventDefault();
      return false;
 
    } 
    return true;                
   }
   composeSendButtonUpdate();  
}

function checkToDisable()
{
  var origLength=window.editorShell.documentLength;
  /* If there is only one element in the document and the user chooses to delete that element,
then the document will be emptied. Disable send button in this case */      
  if (origLength == 1)
  {
    DisableSendButton();
    return;
  }
  var selection=editorShell.editorSelection;
  if (!selection)
    return;
  var tempString=new String(selection);
  var selectLength=tempString.length;
  /* If the user chooses to delete all or more than the contents of the document, 
then the document will be emptied. Disable send button in this case */      
  if (origLength <= selectLength)
  {
    DisableSendButton();
    return;
  }
}

function composeMenuPaste()
{
  /* If the user chooses Edit->Paste, this function gets called.
  This will enable the send button if the user is online */
  
  var isOnline= aimSession().IsOnline();
  if (isOnline) 
    EnableSendButton();   
}
function composeSendButtonUpdate() {
  // Give time for editorShell to update the document after mosue events
  setTimeout("checkcomposeSend()", 300);
}

function checkcomposeSend()
{

  if (!window.editorShell.documentIsEmpty)
     EnableSendButton();
  else 
     DisableSendButton();
   
}

function DoNothing()
{
  return false;
}

function CancelConversation()
{
    args = aimGetArgs(top.arguments[0]);
    var screenName = AimIMGetFormScreenName();
    var session = aimSession();
    if ( session ) {
      session.AddKnockKnockReject(screenName);
    }
    window.close();
}

function StartConversation()
{
  doSetOKCancel(DoNothing, DoNothing);
    args = aimGetArgs(top.arguments[0]);
    var screenName;
    var displayName; 
  
  var isKnockKnock = false;
    if(args.ScreenName)
        screenName= args.ScreenName;
    else
        screenName = "";
    
    if(args.DisplayName)
      displayName= args.DisplayName;
    else
      displayName = "";

    if(args.Message) {
        message= args.Message;
  }
    else
        message = "";
    
  if ( args.Mode == "KnockKnock" ) {
    var session = aimSession();
    if ( session ) {
      session.AddKnockKnockAccept(screenName);
    }
    args.Mode = "Bound";
    isKnockKnock = true;
    if ( AimOnlineAway())
      ComeBack();   // return from away state if we are in it
  }
  
  top.document.getElementById("IMAttribs").setAttribute("imMode", args.Mode);
  top.imObject.logHasFocus = false;
  //top.imObject.editorHasFocus = true;   /* XXX */

  var editorElement = document.getElementById("ComposeWnd");
  if (!editorElement) {
    return;
  }
  
  var editorShell = editorElement.editorShell;
  if (!editorShell) {
    return;
  }

  if(editorShell) {     
    // save the editorShell in the window. The editor JS expects to find it there.
    editorShell.RegisterDocumentStateListener( IMDocumentStateListener );
    window.editorShell = editorShell;

    window.editorShell.editorType = "html";
    window.editorShell.webShellWindow = window;
    window.editorShell.contentWindow = window._content;
    
    window.editorShell.LoadUrl("about:blank");
    EditorSharedStartup();
  }

  top.document.getElementById("fldScreenName").value = screenName;
  top.document.getElementById("fldDisplayName").value = displayName;

    // if we have a screen name, put the focus on the content window
    // otherwise, put the focus in the "To:" field

  if(screenName != "") {
//    setTimeout('contentWindow.focus()',300);
    top.imObject.editorHasFocus = true; 
    LoadBuddyIcon(screenName);
  }
  else {
    //setTimeout('top.document.getElementById("fldScreenName").focus()', 350);
      setTimeout("DoFocusAdjust()",200);
      
  }
    
  AimIMSetFormScreenName(screenName, displayName);
  // XXX For some reason, we need to refresh the title after the
  // onload handler or it won't change
  setTimeout('AimIMRefreshScreenName()', 10);

  SetTimestampMenuItem();

  // since we overlay the edit menu from the editorOverlay.xul file,
  // we have to reset the oncommad to be AIM specific

  var pPAimIM = aimPIMObject();
  if(pPAimIM) {
    if(args.setWantBI)
      pPAimIM.OnWindowLoad(screenName, top, sendAwayMessage, true);
    else
      pPAimIM.OnWindowLoad(screenName, top, sendAwayMessage, false);
    if ( sendAwayMessage == true ) {
      var curVal = aimPrefsManager().GetBoolPref("aim.away.autoreply", null, false);
            if ( curVal == true )
        pPAimIM.SendAwayMessageMaybe(AimIMGetFormScreenName(), top);
      sendAwayMessage = false;
    }
  }
  
var DocumentStateListener =
{
  NotifyDocumentCreated: function()
  {
    //see bugzilla bug 112960 for why we have a timeout call
    setTimeout("setStyles()", 100);
  },
  NotifyDocumentWillBeDestroyed: function() {},
  NotifyDocumentStateChanged:function( isNowDirty ) {}
};

  // add a listener to be called when the editor is really done loading
  editorShell.RegisterDocumentStateListener( DocumentStateListener );

/*
  var theLogNode = top.frames['LogWnd'];
  var myRange = theLogNode.document.createRange();
  var theLogHead = theLogNode.document.getElementsByTagName("head").item(0);
  myRange.setStartAfter(theLogHead);
  var docFrag;
  docFrag = myRange.createContextualFragment("<style type='text/css'>body.timestampHidden span.logtimestamp { display: none}</style>");
  theLogHead.appendChild(docFrag);
*/

  return false;
}

function DoFocusAdjust()
{
  var ScrElement=document.getElementById("fldScreenName");
  if (top.imObject.screenNameHasFocus == false)
    setTimeout("DoFocusAdjust()",100);
  if (ScrElement.value == "")
  {
    ScrElement.focus();
    top.imObject.screenNameHasFocus=true;
    return;
  }

}
function AimIMOnWndUnload()
{
  // XXX See note at the top of the file
  if(gFirstTime == 1)
    return;
  var screenName = AimIMGetFormScreenName();
  var pPAimIM = aimPIMObject();
  if(pPAimIM)
    pPAimIM.OnWindowUnload(screenName, top);
}

function AimIMCmdSend( strip )
{
  AimIMSetFormAction(true);
  var isOnline= aimSession().IsOnline();
  if (isOnline == false) {
    if (isIcq() == false) {
      aimErrorBox(aimString("msg.LogInToSendIM"));
    }
    else {
      aimErrorBox(aimString("msg.LogInToSendIM_ICQ"));
    }
    toOpenWindowByType('Aim:AimApp', 'chrome://aim/content/App.xul');
    return false;
  }
  var screenName = AimIMGetFormScreenName();
  var displayName = AimIMGetFormDisplayName();

  if ( !screenName || screenName == "" ) {
    aimErrorBox(aimString("msg.EmptyScreenName"));
    top.document.getElementById("fldScreenName").focus();
    return false;
  }
  if(false == AimIMIsBound() ) {
    // XXX Should be handled when blur works.
    AimIMSetFormScreenName(top.document.getElementById("fldScreenName").value, top.document.getElementById("fldDisplayName").value);
    screenName = AimIMGetFormScreenName();

  }
  if (top.editorShell.documentLength >1024)
  {
    aimErrorBox(aimString("msg.BigIM").replace(/%BigBy%/, ""+(top.editorShell.documentLength-1024)));
    return;
  }
  
  var bodyText;
  var plainBodyText = null;
  var isUnification=getPreaknessFlag();
  if ((aimPrefsManager().GetSessionType()  == 2) || isUnification) {//ICQ
    plainBodyText = top.editorShell.GetContentsAs("text/plain", 2);
    // because of bug in dom text serializer, last call inserts additional new line at the end
    // we need to eliminate it
    plainBodyText = plainBodyText.replace(/\r\n$|\r$|\n$/, "");
  }

  bodyText = "<html>" + top.editorShell.GetContentsAs("text/html", 8 + 4) + "</html>";

  /* if user hit return, strip out the BR that was added */

  bodyText = bodyText.replace(/<\/span><\/span>/g,  " ");
  bodyText = bodyText.replace(/<span class="moz-smiley-s[0-9][0-9]?"><span>/g, " ");

  if ( strip == true ) {
    bodyText = bodyText.replace(/<br>/gi, "");
  }

  bodyText = bodyText.replace(/\r\n|\r|\n/g, " ");
  bodyText = bodyText.replace(/<big>/gi, "<font size=\"+1\">");
  bodyText = bodyText.replace(/<\/big>/gi, "<\/font>");
  bodyText = bodyText.replace(/<small>/gi, "<font size=\"-1\">");
  bodyText = bodyText.replace(/<\/small>/gi, "<\/font>");
  bodyText = bodyText.replace(/<br><br>/gi, "<br>");
  bodyText = bodyText.replace(/<br><\/body>/i, "<\/body>");
  bodyText = bodyText.replace(/\u00a0/gi, " ");

  var backgroundcolor = document.getElementById("cmd_backgroundColor");
  if (backgroundcolor) {
    backgroundcolor = backgroundcolor.getAttribute("state");
    bodyText = bodyText.replace(/<body bgcolor[^>]*>/gi, "<body><font BACK=\"" + backgroundcolor +"\"> ");
    bodyText = bodyText.replace(/<\/body>/gi, "<\/font><\/body>");
  }

  if ( AimOnlineAway() )
    ComeBack();   // if away, come back

  if (firstSend) {
    //if it is the first msg we are sending...load the BI. This shd execute for only the first outgoing IM.
    LoadBuddyIcon(screenName);
    aimIM().SetIMWndIcon(screenName);
    firstSend = 0;
  }
  aimPIMSendIM(top, screenName, bodyText, plainBodyText);

  var session = aimSession();
  if ( session )
    session.AddKnockKnockAccept( screenName );
  
  top.editorShell.SelectAll();
  getStyles();
  top.editorShell.DeleteSelection(null);
        /* After the contents have been emptied, disable the send button*/
  DisableSendButton();
  setStyles();

  //*** return focus to editor after clicking send ***
  top._content.focus();
  return true;
}

function AimIMIsBound()
{
  var mode = AimIMGetFormMode();

  if("Bound" == mode)
    return true;
  return false;
}

function AimIMUpdateWarningPercent()
{
  //AimIMUpdateWarningPercent
}

//************ Form Accessors ****************

function AimIMGetFormMode()
{
  return top.document.getElementById("IMAttribs").getAttribute("imMode");
}

function AimIMGetFormScreenName()
{
  //var myScreenName = top.document.getElementById("IMAttribs").getAttribute("imScreenName");
  //if (!myScreenName || myScreenName == "") {
    myScreenName = top.document.getElementById("fldScreenName").value;
    if (!myScreenName || myScreenName == "" || myScreenName == undefined)
      if(args && args.ScreenName)
        myScreenName = args.ScreenName;
  //}

  return myScreenName;
}

function AimIMGetFormDisplayName()
{
    var myDisplayName = top.document.getElementById("fldDisplayName").value;
    if (!myDisplayName || myDisplayName == "" || myDisplayName == undefined)
      if(args && args.DisplayName)
        myDisplayName = args.DisplayName;
  return myDisplayName;
}
 
function AimIMRefreshScreenName()
{
  AimIMSetFormScreenName(top.document.getElementById('fldScreenName').value, top.document.getElementById('fldDisplayName').value);
}

function toKeyPress(event) 
{
   switch(event.keyCode) {
   case 9: 
     if (!event.shiftKey) {
       var SN = top.document.getElementById('fldScreenName').value;
       if (SN && SN != "")
        LoadBuddyIcon(SN);
       window._content.focus();
       event.preventDefault();
     }
     break;
   case 13:
     var SN = top.document.getElementById('fldScreenName').value;
     if (SN && SN != "")
      LoadBuddyIcon(SN);
     window._content.focus();
     break;
   }
}


function AimIMSetFormScreenName(screenName, displayName)
{
  var pPAimIM = aimPIMObject();
  if(pPAimIM)
    pPAimIM.OnWindowScreenNameChange(screenName, top);
  var title;

  if("" == screenName || !screenName) {
    if (isIcq() == true)
      title = aimString("icq.title.Unbound");
    else
      title = aimString("im.title.Unbound");
  }
  else {
    if (isIcq() == true) {
      if ((displayName == "") || (!displayName))
        title = aimString("icq.title.Bound").replace(/%ScreenName%/, screenName);
      else
        title = aimString("icq.title.Bound").replace(/%ScreenName%/, displayName+", "+ screenName);
    }
    else {
      if ((displayName == "") || (!displayName))
      title = aimString("im.title.Bound").replace(/%ScreenName%/, screenName);
      else
        title = aimString("im.title.Bound").replace(/%ScreenName%/, displayName+", "+ screenName);
    }
  }

  top.title = title;
}

function AimIMSetFormAction(action)
{
  top.document.getElementById("IMAttribs").setAttribute("imAction", action);
}

//***********  Window Resizing *****************

function AimIMWindowResize(sWidth,sHeight){
  top.resizeTo(sWidth,sHeight)
}



//************  Command Handling ****************

function cmdFileNewIM()
{
  aimIMInvokeIMForm(null);
}

function cmdEditCut()
{
  if ( top.imObject.editorHasFocus == true  ) {
    EditorCut();
  }
}

function cmdEditCopy()
{
  if ( top.imObject.logHasFocus == true ) {
    //Focus window is log wnd
  } 
  else if ( top.imObject.editorHasFocus == true  ) {
    //Focus window is edit wnd
    EditorCopy();
  }
}

function cmdEditPaste()
{
  if ( top.imObject.editorHasFocus == true  ) {
  //Focus window is edit wnd
    EditorPaste();
  }
}

function cmdEditSelectAll()
{
  if ( top.imObject.logHasFocus == true ) {
    //Focus window is log wnd
  } 
  else if ( top.imObject.editorHasFocus == true  ) {
    //Focus window is edit wnd
    EditorSelectAll();
  }
}

function cmdAddressBook()
{
  // XXX DOES THIS STILL WORK, IS IT STILL NEEDED?
  var screenName = AimIMGetFormScreenName();
  var card = aimABInfo().getPersonalAbCardFromAttribute("_AimScreenName", screenName, false);
  // if no card, should we create one?    
  goEditCardDialog("moz-abmdbdirectory://abook.mab", card, null);
}

function cmdPeopleSendChatInvitation()
{
  //dump("Implement Menu Command cmdPeopleSendChatInvitation()\n");
}



function cmdPeopleBlock()
{
  var screenName = AimIMGetFormScreenName();
    if( !screenName )
      return false;
  var pIAimPrivacy = aimPrivacy();
  if ( !pIAimPrivacy )
    return false;
  pIAimPrivacy.BlockUser( screenName );
  return true;
}

function cmdAddABuddy()
{
  openDialog("chrome://aim/content/BuddyAddBuddy.xul", "", "modal=yes,titlebar,chrome", null, null, AimIMGetFormScreenName());
  
}

function cmdCmdWarn()
{
  //dump("Implement Menu Command cmdCmdWarn()\n");
}

/**** routines to track Focus */

function composeWndFocus(boolval)
{
  if ( top.imObject )
    top.imObject.editorHasFocus = boolval;
  if (boolval) {
    var SN = top.document.getElementById('fldScreenName').value;
    if (SN && SN != "")
      LoadBuddyIcon(SN);
  }
}

function logWndFocus(boolval)
{
  if ( top.imObject )
    top.imObject.logHasFocus = boolval;
}

function AimIMFldScreenNameFocus(focus)
{
  if(false == focus)
    AimIMSetFormScreenName(top.document.getElementById("fldScreenName").value, top.document.getElementById("fldDisplayName").value);
}

function SendOnEnter()
{
  // if enterCR_pref_value is true, the pref was set so that enter was a CR
  // if enterCR_pref_value is false, the user wants enter to send the IM message
  try {
    pref = aimPrefsManager();
    enterCR_pref_value = pref.GetBoolPref("aim.general.im.enterCR", null, false);
  }
  catch (ex) {
    // default to be "send on enter key"
    enterCR_pref_value = true;
  }
  return (!enterCR_pref_value);
}

function OnTab()
{ 
  try {
    Tab_pref_value = aimPrefsManager().GetBoolPref("aim.general.im.tabKey", null, false);
  }
  catch (ex) {
    // default 
    Tab_pref_value = true;
  }
  return (!Tab_pref_value);
}

function EnableSendButton()
{
  top.document.getElementById("btnSend").setAttribute("disabled", "false");
}

function DisableSendButton()
{
  top.document.getElementById("btnSend").setAttribute("disabled", "true");
  UnFocusSend();
} 

function UnFocusSend()
{
  top.document.getElementById("btnSend").removeAttribute("focus-ring");
}

function FocusSend()
{
  top.document.getElementById("btnSend").setAttribute("focus-ring", "true");
}
 
function sendButtonListeners()
{
  /* Add listeners to cut , copy and paste items in menu and context menu */
  var delmenu=document.getElementById("menu_delete");
  if (delmenu)
    delmenu.addEventListener("mouseup", checkToDisable, true);
  var cutmenu=document.getElementById("menu_cut");
  if (cutmenu)
    cutmenu.addEventListener("mouseup", checkToDisable, true);   
  var pastemenu=document.getElementById("menu_paste");
  if (pastemenu)
    pastemenu.addEventListener("mouseup", composeMenuPaste , true);    
  var cmdelmenu=document.getElementById("menu_delete_cm");
  if (cmdelmenu)
    cmdelmenu.addEventListener("mousedown", checkToDisable, true);
  var cmcutmenu=document.getElementById("menu_cut_cm");
  if (cmcutmenu)
    cmcutmenu.addEventListener("mousedown", checkToDisable, true);   
  var cmpastemenu=document.getElementById("menu_paste_cm");
  if (cmpastemenu)
    cmpastemenu.addEventListener("mousedown", composeMenuPaste , true);    
 var bbox = document.getElementById("ComposeWnd");
  if (bbox) {
    bbox.addEventListener("mousedown", composeSendButtonUpdate, true);
    bbox.addEventListener("mouseup", composeSendButtonUpdate, true);
    bbox.addEventListener("dragdrop", composeSendButtonUpdate, true);
   
  }

}


function converseKeyCodeListener()
{
  if (event.keyCode == 13 || event.keyCode == 9) 
  {
    aimAutoCompleteAddress('aimScreenNameType', 'fldScreenName');
    window._content.focus();
    setTimeout('AimIMRefreshScreenName()',50);
    return true;
  } 
  setTimeout('AimIMRefreshScreenName()',50);
  return false;
}


//////////////////////////////////////////////////////////////////////////////
// IM Log Context Menu helper routines --> The following routines are used by
// the context menu in the IM log overlay...
//////////////////////////////////////////////////////////////////////////////

function initializeIMLogContextPane(aContextMenu)
{
  // our base nsContextMenu class is going to take care of enabling/disabliing all our menu items
  // for us. All we need to do is make sure we show and hide the appropriate separators...

  aContextMenu.showItem( "context-sep-open", aContextMenu.onSaveableLink || (aContextMenu.inDirList && aContextMenu.onLink));
  aContextMenu.showItem( "context-sep-bookmark", aContextMenu.onLink );
  aContextMenu.showItem( "context-sep-save", aContextMenu.onSaveableLink || aContextMenu.onImage);
}


function LoadBuddyIcon(screenname)
{
  var aimPrefs = aimPrefsManager();
  if (aimPrefs)
    var biValue = aimPrefs.GetIntPref("aim.buddyicon.displayBuddyIcons", null, false);
  else
    return;

  //check for Never *display* BI pref before displaying...
  // 0 - Aceept BI from users in Buddy list.
  // 1 - Never accept BI
  // 2 - Never *display* BI's.
  if (biValue == 2)
    return;
  if ((screenname == "") || (screenname == null)) {
    return;
  }

  var nimSession = aimSession();
  var pictDir = nimSession.profileDir;
  var biPath = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
  biPath.initWithPath(pictDir.path);
  biPath.append("picture");
  if (!biPath.exists()) {
    return;
  }
  biPath.append(screenname+".gif");
  if (!biPath.exists()) {
    //The buddy doesn't have BI.
    return;
  }

  var ioService = GetIOService();
  var bifileurl = ioService.getURLSpecFromFile(biPath);
    
  var currentTime = new Date().getTime();
  var BIfield = top.document.getElementById("BuddyIcon");
  BIfield.setAttribute("src", bifileurl+"?foobar="+currentTime);

}


function GetIOService()
{
  var IOService = Components.classes["@mozilla.org/network/io-service;1"]
               .getService(Components.interfaces.nsIIOService);

  return IOService;
}

function updateCurrentComposeWindow()
{
  if (isIcq() == true ) {
    document.getElementById('icqDisplayFields').setAttribute('hidden', false);
    document.getElementById('fldDisplayName').setAttribute('hidden', false);
    var elems = document.getElementById("sessionComposeWatcher");
    elems.setAttribute("sessionMode", "Icq"); 
    var icqval=document.getElementById('composetoolbarmenu').getAttribute('icqlabel','value');
    document.getElementById('composetoolbarmenu').setAttribute('label', icqval);
    icqval=document.getElementById('AimIM').getAttribute('icqtitle','value');
    document.getElementById('AimIM').setAttribute('title', icqval);
    icqval=document.getElementById('menu_newMsg').getAttribute('icqlabel','value');
    document.getElementById('menu_newMsg').setAttribute('label', icqval);
    icqval=document.getElementById('menu_peopleadd').getAttribute('icqlabel','value');
    document.getElementById('menu_peopleadd').setAttribute('label', icqval);
    icqval=document.getElementById('tbAddBuddy').getAttribute('icqlabel','value');
    document.getElementById('tbAddBuddy').setAttribute('label', icqval);
    icqval=document.getElementById('tbAddBuddy').getAttribute('icqtooltip','value');
    document.getElementById('tbAddBuddy').setAttribute('tooltiptext', icqval);
    icqval=document.getElementById('tbBlock').getAttribute('icqlabel','value');
    document.getElementById('tbBlock').setAttribute('label', icqval);
    icqval=document.getElementById('tbBlock').getAttribute('icqtooltip','value');
    document.getElementById('tbBlock').setAttribute('tooltiptext', icqval);
    document.getElementById('formatMenu').setAttribute('hidden', true);
    icqval=document.getElementById('btnSend').getAttribute('icqtooltip','value');
    document.getElementById('btnSend').setAttribute('tooltiptext', icqval);
  }
  else
  {
    // App is aim, hide icq disp stuff
    document.getElementById('icqDisplayFields').setAttribute('hidden', true);
    document.getElementById('fldDisplayName').setAttribute('hidden', true);
  }
}

