// globals

var invitedScreenNames = window.arguments[0].invitedScreenNames;
//dump('got invitedScreenNames'+invitedScreenNames+"\n\n")	
var chatRoomName= window.arguments[0].chatRoomName;
//dump('got chatRoomName'+chatRoomName+"\n\n")	
var chatLanguage= window.arguments[0].chatLanguage;
//dump('got chatLanguage'+chatLanguage+"\n\n")	
var chatMsg = window.arguments[0].chatMsg;
//dump("got chatMsg "+chatMsg+"\n\n")
var chatPanelLoaded = false;

var chatFromURL = window.arguments[0].fromurl;                          
var chatExchange = window.arguments[0].exchange;                        
var chatInstance = window.arguments[0].instance; 
// globals for invite

var incomingChat = window.arguments[0].incomingChat;
var inviteProposalScreenName = window.arguments[0].incomingChatInviteProposalScreenName;
var inviteProposalObj= window.arguments[0].incomingChatInviteProposalObj;

var isChatContent = true;
var showTimestampVal;
	
// globals for conversion
 	
	var smileyCodes = new Array(7);
	smileyCodes[0] = /:-?\)/g;
    smileyCodes[1] = /:-D/g;
    smileyCodes[2] = /:-?\(/g;
	smileyCodes[3] = /:-\[/g;
    smileyCodes[4] = /;-?\)/g;
    smileyCodes[5] = /:-\\/g;
	smileyCodes[6] = /:-P/g;

	var smileyImgs = new Array('<img src="chrome://editor/content/images/smile_n.gif" class="moz-txt-smily" height=19 width=19 align=ABSCENTER>',
							   '<img src="chrome://editor/content/images/laughing_n.gif" class="moz-txt-smily" height=19 width=19 align=ABSCENTER>',
							   '<img src="chrome://editor/content/images/frown_n.gif" class="moz-txt-smily" height=19 width=19 align=ABSCENTER>',
							   '<img src="chrome://editor/content/images/embarrassed_n.gif" class="moz-txt-smily" height=19 width=19 align=ABSCENTER>',
							   '<img src="chrome://editor/content/images/wink_n.gif" class="moz-txt-smily" height=19 width=19 align=ABSCENTER>',
							   '<img src="chrome://editor/content/images/undecided_n.gif" class="moz-txt-smily" height=19 width=19 align=ABSCENTER>',
							   '<img src="chrome://editor/content/images/tongue_n.gif" class="moz-txt-smily" height=19 width=19 align=ABSCENTER>');


// timestamp
	
var IDateTime = Components.classes["@mozilla.org/intl/scriptabledateformat;1"].createInstance();
var aDateTime = IDateTime.QueryInterface(Components.interfaces.nsIScriptableDateFormat);

//ChatRoomManager setup 
//         ***start***
function chatRoomMemberObj(screenName,status,ignored,blocked){
	this.screenName=screenName;
	this.status=status;
	this.ignored=ignored;
	this.blocked=blocked;
	return this;
}


function chatRoomManagerObj(){
	this.members = new Array();
	this.roomname = "";
	
	return this;
	}	

function chatRoomManagerAddMember(managerObj,membername,status,ignored,blocked){
	managerObj.members[managerObj.members.length] = new chatRoomMemberObj(membername,status,ignored,blocked);
	//dump("chatRoomManagerAddMember: "+membername+"\n");
}

function chatRoomManagerShowMembers(managerObj){
	for(i=0;i<managerObj.members.length;i++){
		alert(managerObj.members[i].screenName);
	}
}

function chatRoomManagerDelMember(managerObj,membername){
	var tempMembersArray = new Array();
	for(k=0;k<managerObj.members.length;k++){
		if(managerObj.members[k].screenName.toLowerCase() == membername.toLowerCase()){
			//copy members to new Array, except for deleted one.
			for(m=0;m<managerObj.members.length;m++){
				if(m!=k){
					tempMembersArray[tempMembersArray.length] = managerObj.members[m];	
				}
			}
			//swap old array with new one.
			managerObj.members = tempMembersArray;
		}
	}
		//dump("chatRoomManagerDelMember: "+membername+"\n");

	
}

function chatRoomManagerUpdateMember(managerObj,membername,status){
	var changedFlag = false;
		for(i=0;i<managerObj.members.length;i++){
			if(managerObj.members[i].screenName.toLowerCase()==membername.toLowerCase()){
				managerObj.members[i].status = status
				changedFlag=true;
			}

		}
		if(!changedFlag){
			//didnt change anyone - must not be here yet!
			chatRoomManagerAddMember(managerObj,membername,status,false,false)
		}
		
		//dump("chatRoomManagerUpdateMember[of "+managerObj.members.length+" ]: "+membername+"\n");

}


 var myManager = new chatRoomManagerObj();

//ChatRoomManager setup ***end***






// Setup Callbacks


//Setup Room Callbacks (basically event capturing)

var RoomCallback= new Object();

RoomCallback.OnMessageReceived = function(screenName, rcvdMsg, language){
	//dump("OnMessageReceived:"+rcvdMsg+"\n");
	//dump (screenName + " SAYETH " + rcvdMsg + " IN " + language +"\n");
	chatContentRecieveMsg(screenName,rcvdMsg)
}

RoomCallback.OnWhisperReceived = function(screenName,  rcvdWhispMsg, language){
	//dump("OnWhisperReceived:"+rcvdWhispMsg+"\n");
	chatContentRecieveMsg(screenName,rcvdWhispMsg)
}


RoomCallback.OnLeft = function(errorMsg){
	//dump("Onleft: error["+errorMsg+"] \n");
	chatContentReceiveStatus(null, aimString("chat.YouLeft").replace(/%ChatRoom%/, chatRoomName));
	updateStatus(aimString("chat.YouLeft").replace(/%ChatRoom%/, chatRoomName));
}

RoomCallback.OnJoined = function(){
	//dump("OnJoin: \n")
	//dump("Yes I Joined\n");
	chatContentReceiveStatus(null, aimString("chat.YouJoined").replace(/%ChatRoom%/, chatRoomName));
	updateStatus(aimString("chat.YouJoined").replace(/%ChatRoom%/, chatRoomName));

}

RoomCallback.OnUserJoined = function(screenName){
  //dump("OnUserJoined:"+screenName+"\n");
  updateStatus(aimString("chat.OnUserJoined").replace(/%ScreenName%/, screenName));
	//update their status in the list
  top.frames['chatpanel'].chatPanelUpdateScreenName(screenName,"joined")
	
	//update their status in the global obj
	chatRoomManagerUpdateMember(myManager,screenName,"joined")
	try {
		chatAnnounce_pref=aimPrefsManager().GetBoolPref("aim.chat.AnnounceChatRoom", null, false);
		}
		catch (ex) {
			chatAnnounce_pref = true;
   		}

	var currentScreenName = aimSessionCurrentScreenName();      
    if ((chatAnnounce_pref && (currentScreenName != screenName)))
    {
		chatContentReceiveStatus(screenName, aimString("chat.OnUserJoined").replace(/%ScreenName%/,""));
	}
  chatRoomManagerUpdateMember(myManager,screenName,"joined")

}

RoomCallback.OnUserLeft = function(screenName){
  //dump("OnUserLeft:"+screenName+"\n");
  updateStatus(aimString("chat.OnUserLeft").replace(/%ScreenName%/, screenName));
	top.frames['chatpanel'].chatPanelRemoveScreenName(screenName)
	//update global obj
	chatRoomManagerDelMember(myManager,screenName)

	var chatAnnounce_pref;
	try {
		chatAnnounce_pref=aimPrefsManager().GetBoolPref("aim.chat.AnnounceChatRoom", null, false);
		}
	catch (ex) {
       	chatAnnounce_pref = true;
        }
    if (chatAnnounce_pref)
    {
		chatContentReceiveStatus(screenName, aimString("chat.OnUserLeft").replace(/%ScreenName%/, ""));
	}
	
	
}

RoomCallback.OnPaused = function(){
    //dump("OnPaused: \n");
    //chatContentReceiveStatus(null,aimString("chat.RoomPaused"));
    updateStatus(aimString("chat.RoomPaused"));

}

RoomCallback.OnResumed = function(){
    //dump("OnResumed: \n");
    //chatContentReceiveStatus(null,aimString("chat.RoomResumed"));
    updateStatus(aimString("chat.RoomResumed"));
}

RoomCallback.OnInfoUpdate = function(){
	//dump("OnInfoUpdate: \n")
	
}

RoomCallback.OnClientError = function(screenName,errMsg){
    //dump("OnClientError: error["+screenName+" : "+errMsg+"]\n");
    //chatContentReceiveStatus(screenName,aimString("chat.ClientError"));
    updateStatus(aimString("chat.ClientError").replace(/%ScreenName%/, screenName));
}


// end Setup Room Callback




// Setup ChatManager Callback 

var CallBack = new Object();
var RoomCreationTimeStamp = null;
CallBack.title = aimString("chat.WindowTitle");

CallBack.OnRequestRoomComplete =  function(roomName,chatRoomObj){
	//dump("OnRequestRoomComplete: success on "+roomName+"\n");
	//dump("chatRoomObj"+chatRoomObj+"\n")
	RoomCreationTimeStamp= new Date();
	chatRoomObj.SetChatRoomCallback( RoomCallback )
	top.chatRoomObj = chatRoomObj;
	
	//dump("roomName is " + roomName + "\n");
	//dump("chatRoomName is " + chatRoomName + "\n");
	//dump("roomObjName is " + chatRoomObj.GetName() + "\n");

	if (roomName)
		window.title= aimString("chat.WindowTitle").replace(/%ChatRoom%/, roomName);
	else if (chatRoomName)
		window.title= aimString("chat.WindowTitle").replace(/%ChatRoom%/, chatRoomName);
	else if (chatRoomObj.GetName())
		window.title= aimString("chat.WindowTitle").replace(/%ChatRoom%/, chatRoomObj.GetName());
	
	window.setTimeout('top.chatRoomObj.Join()', 1000);
	if(invitedScreenNames)
		window.setTimeout('chatContentInviteMany(invitedScreenNames,chatMsg)',1500);
	//window.setTimeout('top.chatRoomObj.SendMessage("This is working!!")', 30000);
	//window.setTimeout('top.chatRoomObj.SendWhisper("trip004", "Private message for vishy26aug")', 30000);
	
}


CallBack.OnRequestRoomError =  function(roomName,errMsg){
	//dump("OnRequestRoomError: there was an error \n");

}

CallBack.OnProposalReceived = function(screenName,proposalObj){
	//dump("OnProposalReceived:"+screenName+"  \n");

}



//Chat Sound handling

function chatSound(msg)
{
	aimSoundManager().ChatEvent(msg);
}

// first thing to do on startup

function chatContentStartup(){

	pChatManager = aimChatManager();
	if (!pChatManager)
	{
		//dump("chatContentStartup:unable to get pChatManager\n");
		return;
	}
	else{
			//dump("chatContentStartup:got  pChatManager\n");

	}


	//dump("chatContentStartup: calling pChatManager.GetMaxConcurrentRooms\n");

	var rooms = new Object();
	
	try {
		//dump("trying pChatManager.GetMaxConcurrentRooms(rooms) \n");
		pChatManager.GetMaxConcurrentRooms(rooms);
		}
	catch (e){
		//dump("!!!!! catching js error during pChatManager.GetMacConcurrentRooms !!!!! \n")
		//dump ("rooms.label: "+rooms.label + "\n");
	
	}
	
	

// got chatroom name from arguments passed to the opendialog


	if(incomingChat){
		//dump("About to CallbackIncoming\n");
		CallBack.OnRequestRoomComplete(window.arguments[0].chatRoomName, window.arguments[0].incomingChatRoom);	

	}
	else {	
		try {
			if(chatFromURL && (chatExchange != 0)) {                                               
				pChatManager.RequestRoom(CallBack, chatRoomName, chatLanguage, chatExchange, chatInstance)
			}                                                               
        		else { 
				//dump("chatContentStartup: trying pChatManager.RequestPrivateRoom\n");
				pChatManager.RequestPrivateRoom(CallBack,chatRoomName, chatLanguage)
			}
		}
		catch (e){
			//dump("chatContentStartup: E = " + e + "\n");
			alert("There was an error loading the Chat window");
		}	
	}
  showTimestampVal = aimPrefsManager().GetBoolPref("aim.general.im.timeStamp",
    null, false);

  SetTimestampMenuItem();
}

// One more level of callback in order that chat manager can be ready
myExecutionCallback = new Object();
myExecutionCallback.ExecuteIfReady = function()
{
// get chatroom and callbacks
  	//dump ("before chatContentStartup\n");
	chatContentStartup();
	//dump("after Chatcontentstartup\n");
	
	// startup the ender widget
	startUpEditor(document.getElementById("ComposeWnd"));
	
	updateMemberCount();
	//chatContentAddMsgToLog('goober','hi');

	try{
		if(!chatFromURL)
			window.opener.close();
	}
	catch (e){
		//dump("chat: where's my invite window?? \n")
	}	
}

// after the window has loaded:

function chatContentOnWinLoad(){

    var bbox = document.getElementById("ComposeWnd");
    if (bbox)
    { 
      bbox.addEventListener("keypress", composeKeyPress, true);
    }

    aimChatManager().OnWindowLoad(top);
    aimChatManager().ExecuteIfReady(myExecutionCallback);
	
	

}

function composeKeyPress(event)
{
  if (event.keyCode == 13) { 

    if (SendOnEnter() == true) { 
        event.preventBubble();
        event.preventDefault(); 
        window.setTimeout('chatContentSendMsg()', 1, true); 
        return false; 
        } 
    return true;
  } 

  if (event.keyCode == 9) {

    if (OnTab() == true) { 
      document.getElementById('btnSend').focus();
      event.preventDefault();
      return false;
      }
    return true;		
  }
			
}

// window is closing

function chatContentOnWinUnLoad(){
	aimChatManager().OnWindowUnload(top);
	try{
		top.chatRoomObj.Leave()
		}
	catch (e){
		//dump("chat: there was an error trying to call chatRoomObj.leave() \n");
	}	

}	



function startUpEditor(editorElement){

	if (!editorElement) {
		//dump("No editor element found\n");
		return;
	}
	
	var editorShell = editorElement.editorShell;
	if(editorShell) {			
		// save the editorShell in the window. The editor JS expects to find it there.
		window.editorShell = editorShell;

		//SetupToolbarElements(); //defined into editor.js
		window.editorShell.editorType = "html";

		window.editorShell.contentWindow = window._content;
		window.editorShell.webShellWindow = window;
		window.editorShell.LoadUrl("about:blank");
		EditorSharedStartup();
	} else {
		//dump("No editorShell found\n");
		return;
	}
  var DocumentStateListener =
  {
    NotifyDocumentCreated: function()
    {
      var nsIPlaintextEditor = Components.interfaces.nsIPlaintextEditor;
      window.editorShell.editor.flags |= nsIPlaintextEditor.eEditorNoCSSMask;
      //see bugzilla bug 112960 for why we have a timeout call
      setTimeout("setStyles()", 100);
    },
    NotifyDocumentWillBeDestroyed: function() {},
    NotifyDocumentStateChanged:function( isNowDirty ) {}
  };

  // add a listener to be called when the editor is really done loading
  editorShell.RegisterDocumentStateListener( DocumentStateListener );
}


// updates the number of chat members (use after an add or delete member)

function updateMemberCount(){
		//theTree = document.getElementById("cptChildren");
		
    var theTreeChildren = top.frames["chatpanel"].document.getElementsByTagName("listitem")
		var activeMembers=0;
		
		for(i=0 ; i<theTreeChildren.length;i++){
			
			//dump("updateMemberCount:class "+theTreeChildren.item(i).getAttribute("class")+"\n")
			//dump("updateMemberCount:label "+theTreeChildren.item(i).getAttribute("label")+"\n")
			
      if(theTreeChildren.item(i).getAttribute("class") == "joined") {
				activeMembers++;
			}
		}
		
		//dump("theTreeNode"+theTree+" \n")
		theMemberCountNode=document.getElementById("numberchatting")
		
		if(activeMembers!=1){
		  theMemberCountNode.setAttribute("label", aimString("chat.PeopleHere").replace(/%NumPeople%/, activeMembers));
		}
		else{
		  theMemberCountNode.setAttribute("label", aimString("chat.PersonHere"));
		}
}



//send your message out
function SendOnEnter()
{
	// if enterCR_pref_value is true, the pref was set so that enter was a CR
        // if enterCR_pref_value is false, the user wants enter to send the IM message
	try {
		enterCR_pref_value = aimPrefsManager().GetBoolPref("aim.general.im.enterCR", null, false);
	}
	catch (ex) {
		// default to be "send on enter key"
		enterCR_pref_value = true;
	}
	
	return (!enterCR_pref_value);
}

function OnTab()
{
    var Tab_pref_value = false;
    try {
        Tab_pref_value = aimPrefsManager().GetBoolPref("aim.general.im.tabKey", null, false);
    }
    catch (ex) {
        // default
        Tab_pref_value = true;
    }

    return (!Tab_pref_value);
}

/* Name: getMaxIndividualMessage
 *
 * Arguments: 
 *      none.
 * Return Value:
 *      maxIndividualMessageLength -- maximum length of an individual chat message.
 *
 * Description:
 *      This function caches maxIndividuaMessageLength, and calls
 *      nsIAimChatRoom::GetMaxIndividualMessageLength if the cache is empty.
 *
 * Author:
 *      Joseph Elwell 07/04/2001
 * 
*/
var maxIndividualMessageLength = -1;
function getMaxIndividualMessage(){
        if (maxIndividualMessageLength == -1) {
                maxIndividualMessageLength = top.chatRoomObj.GetMaxIndividualMessageLength();
        }
        return maxIndividualMessageLength;
}
        
function chatContentSendMsg(strip){

 	if (top.editorShell.documentLength > getMaxIndividualMessage())
    {
 		var bigChatError = aimString("msg.BigChat").replace(/%BigBy%/, ""+(top.editorShell.documentLength-getMaxIndividualMessage()));
 		bigChatError = bigChatError.replace(/471/, ""+(getMaxIndividualMessage()));
 		aimErrorBox(bigChatError);
 		return;
 	}

	var bodyText = editorShell.GetContentsAs("text/html", 8 + 4);
		
    /* smiley conversion */
    bodyText = bodyText.replace(/<\/span><\/span>/g,  " ");
    bodyText = bodyText.replace(/<span class="moz-smiley-s[0-9][0-9]?"><span>/g, " ");

	// *** placeholder for getting strip pref.
	//var strip=true

	if ( strip == true ) {
		bodyText = bodyText.replace(/<br>/gi, "");
		bodyText = bodyText.replace(/\n/g, "");
		bodyText = bodyText.replace(/\r/g, "");
	}

	bodyText = bodyText.replace(/\n/g, "");
	bodyText = bodyText.replace(/\r/g, "");
        bodyText = bodyText.replace(/<big>/gi, "<font size=\"+1\">");
        bodyText = bodyText.replace(/<\/big>/gi, "<\/font>");
        bodyText = bodyText.replace(/<small>/gi, "<font size=\"-1\">");
        bodyText = bodyText.replace(/<\/small>/gi, "<\/font>");
	bodyText = bodyText.replace(/<br><br>/gi, "<br>");
	bodyText = bodyText.replace(/<br><\/body>/i, "<\/body>");
	bodyText = bodyText.replace(/\u00a0/gi, " ");
	
	//chatContentAddMsgToLog('noone',bodyText)

        try {
	        top.chatRoomObj.SendMessage(bodyText);
        } catch( ex ) {
                aimErrorBox(aimString("chat.SendError"));
                return;
        }

	top.editorShell.SelectAll();
        getStyles();
	top.editorShell.DeleteSelection(null);
	//*** return focus to editor after clicking send ***
        setStyles();
	
	
	top._content.focus();

    //Chat Send Sound to hook
	//dump("Outgoing Sound works!\n");
		chatSound(Components.interfaces.nsAimChatSoundEvent.ChatSoundEvent_OutgoingMsg);	

}



// handle incoming messages

function chatContentRecieveMsg(screenName,msg){
	var chatflash=false;         
	try {
		chatflash=aimPrefsManager().GetBoolPref("aim.chat.FlashChatWin", null, false); 
    }
    catch (ex) {
        chatflash = true;
    }               
    if (chatflash)
        	top.window.getAttention();

	msg = msg.replace(/<pre>/gi, "");
	msg = msg.replace(/<\/pre>/gi, "");
	chatContentAddMsgToLog(screenName,msg,true)

	//Chat Receive Sound to Hook
	//dump("INCOMING SOUND\n");
	if (screenName != aimSessionCurrentScreenName()) {
		chatSound(Components.interfaces.nsAimChatSoundEvent.ChatSoundEvent_IncomingMsg);
	}
}

function chatContentReceiveStatus(screenName, msg) {
  chatContentAddMsgToLog(screenName,msg,false);
}

// sub timestamp generation
function getTimeStampStr()
{
  var strTimestamp;
    
  var curTime = new Date();
    
  var curHours   = curTime.getHours();  
  var curMinutes = curTime.getMinutes();
  var curSeconds = curTime.getSeconds();
           
  strTimestamp = aDateTime.FormatTime("", aDateTime.timeFormatSeconds,
    curHours, curMinutes, curSeconds);

  if (showTimestampVal)
    strTimestamp = "<SPAN class=\"logtimestamp\"style=\"visibility:visible\">" + "(" + strTimestamp + ")" + "</SPAN>";
  else  
    strTimestamp = "<SPAN class=\"logtimestamp\"style=\"display:none\">" + "(" + strTimestamp + ")" + "</SPAN>";

  return strTimestamp;
}

// sub function conversion smiley codes to images
function convertToSmileyImg(msg){
	var count;

	for (count = 0; count < smileyCodes.length; count++)		
		msg = msg.replace(smileyCodes[count], smileyImgs[count] );
	
	return msg;

}

// sub function of chatContentRecieveMsg
function chatContentAddMsgToLog(screenName,msg,isMsg){
	// There is no contract id for this interface now. mscott/myself will add one later and change this.
	var moz = Components.classesByID["{77c0e42a-1dd2-11b2-8ebf-edc6606f2f4b}"];
	var moztxt = moz.createInstance(Components.interfaces.mozITXTToHTMLConv);
	var iface = Components.interfaces.mozITXTToHTMLConv;
	var mozURL = iface.kURLs;
	
 	var smileyFeatureEnabled = aimPrefsManager().GetBoolPref("aim.general.im.smilies", null, false);
 	
 	if (smileyFeatureEnabled)
 		msg = convertToSmileyImg(msg);

      var timeStampStr = getTimeStampStr();

	var theLogNode = top.frames['LogWnd']
	
	var myRange = theLogNode.document.createRange();
	var theLogBody =theLogNode.document.body;
      myRange.setStartAfter(theLogBody);
	var docFrag;
	// XXXVISHY - this handles info messages also
	if (screenName) {
	  var colorpre = " ";
	  var colorpost = " </b> ";
	  if(msg)
		msg = moztxt.scanHTML(msg, mozURL);
	  if (isMsg) // otherwise it is a status
      {
	      if (screenName.toLowerCase() == aimSessionCurrentScreenName()) 
		    colorpre = '<font color=\"#ff0000\">';
	      else
		    colorpre = '<font color=\"#0000ff\">';
            
	      colorpost = '</b>: </font>';

          docFrag = myRange.createContextualFragment("<html>" + colorpre + "<b>"+ screenName + timeStampStr + colorpost+ msg+"</html><br>");

	  }
      else
	     docFrag = myRange.createContextualFragment("<html>" + colorpre + "<b>"+ timeStampStr + screenName + colorpost+ msg+"</html><br>");
	} else
	    docFrag = myRange.createContextualFragment("<html><b>"+ timeStampStr + "</b>" + msg+"</html><br>");
      
  var prevdocHeight = theLogNode.document.height;
  var isLocked=((theLogNode.scrollY + theLogNode.innerHeight) >= theLogNode.document.height) 
                  || (( theLogNode.document.height - theLogNode.scrollY ) <= 5)
	theLogBody.appendChild(docFrag)
			
	
  if (isLocked){
    if ((theLogNode.innerHeight - (prevdocHeight-theLogNode.scrollY)) <= 5)
                return;
    if ((theLogNode.innerHeight < theLogNode.document.height) && (theLogNode.scrollY == prevdocHeight))
               return;

	  theLogNode.scrollTo(theLogNode.scrollX, theLogNode.document.height)
    }
	
}






//send info to the status area
// defunct!
function updateStatus(statusMsg){
	var statusTextNode= document.getElementById("statustext");
	statusTextNode.setAttribute("value",statusMsg);

}


// handle status changes

function chatContentStatusChange(screenName,statusItem){
  //updateStatus(screenName+": "+statusItem)	
}


/*** Handle Proposal and ProposalOwner for Chat Invitations ***/
var proposals = new Array(); // of all the open proposals;
var aproposal = new Object();

function AimProposalOwner()
{
  this.OnProposalAcked = function(pProposal) {
    //dump("OnProposalAcked");
  }
  
  this.OnProposalError = function(pProposal, pErrMsg) {
    aimErrorBox(aimString("chat.NotAvailable").replace(/%ScreenName%/, pProposal.GetProposee()));
    top.frames['chatpanel'].chatPanelRemoveScreenName(pProposal.GetProposee());
    chatRoomManagerDelMember(myManager,pProposal.GetProposee());
  }
  
  this.OnProposalAccepted = function(pProposal) {
    //dump("OnProposalAccepted");
  }
  
  this.OnProposalRejected = function(pErrMsg, pScreenName, deleteFromChatPanel) {
    aimErrorBox(pErrMsg);
    if (deleteFromChatPanel) {
      top.frames['chatpanel'].chatPanelRemoveScreenName(pScreenName);
      chatRoomManagerDelMember(myManager,pScreenName);
    }
	}
  
  this.OnProposalCountered = function(pProposal, pCounterProposal) {
    //dump("OnProposalCountered");
  }
  
  this.OnProposalTimeout = function(pProposal) {
    aimErrorBox(aimString("chat.TimedOut"));
    top.frames['chatpanel'].chatPanelRemoveScreenName(pProposal.GetProposee());
    chatRoomManagerDelMember(myManager,pProposal.GetProposee());
  }   

  this.OnProposalCancelled = function(pProposal) {
    //dump("OnProposalCancelled"); 
    top.frames['chatpanel'].chatPanelRemoveScreenName(pProposal.GetProposee());
    chatRoomManagerDelMember(myManager,pProposal.GetProposee());
  }

  return this;
}

// handle many invitations
function chatContentInviteMany(inviteList,chatMsg){
	// convert carriage returns and newlines to commas 
	inviteList = inviteList.replace(/\n/gi, ",");
	inviteList = inviteList.replace(/\r/gi, ",");

	inviteArray=inviteList.split(",")
	for(inviteItem = 0; inviteItem<inviteArray.length; inviteItem++){
		//test to make sure the name isnt empty
		if(itemTest(inviteArray[inviteItem])){
		
			//dump("Inviting["+inviteArray[inviteItem]+"]\n")
			
			aproposal = top.chatRoomObj.Invite(inviteArray[inviteItem], chatMsg);
			proposals[proposals.length] = aproposal;
			//dump("proposals.length is " + proposals.length + "\n")
			proposals[proposals.length-1].SetOwner(new AimProposalOwner());
			//dump("proposals.length is " + proposals.length + "\n");
			//proposals.length++;
			
      top.frames['chatpanel'].chatPanelUpdateScreenName(inviteArray[inviteItem],"invited")
		
      chatRoomManagerAddMember(myManager,inviteArray[inviteItem],"invited",false,false)
		
			//dump("Invited: "+inviteArray[inviteItem]+"\n");
		}
	}
	

}



function itemTest(inviteItem){
	var passed = true;


	switch(inviteItem) {
	
		case "": 
		case " ": passed = false;
		break;
		
	
	}


	//dump("itemTest: "+passed+"\n");
	return passed;
}

// pop up invitation window:

function cmdPopUpInvite(screenNames){
	//window.openDialog('chrome://aim/content/chatInviteBuddy.xul','inviteBuddy','chrome,all,dialog=no','',true,"outgoingchat"); 

     var isOnline = aimSession().IsOnline();
     if ( isOnline == false ) {
             window.close();
             aimErrorBox(aimString("chat.NotOnline"));
     } else {
             var language = aimString("aim.LanguageCode");	
             inviteArgsObj = {
                inviteProposalScreenName: '', 
                inviteProposalObj: null,
                invitedScreenNames: screenNames,
                inviteToExistingWindow: true,
                inviteMode: 'outgoingchat',
                inviteToExistingRoom: chatRoomName,
                inviteLanguage: language
             }
                        
             window.openDialog('chrome://aim/content/chatInviteBuddy.xul','inviteBuddy','chrome,all,dialog=no',inviteArgsObj); 
     }
}

// display room info

function cmdRoomInfo(){
	window.openDialog('chrome://aim/content/chatRoomInfo.xul','charRoomInfo','chrome,all,dialog=no,resizable=no,titlebar',chatRoomName, top.chatRoomObj.GetLanguage(), top.chatRoomObj.GetMaxMessageLength(),RoomCreationTimeStamp.toLocaleString()); 
}

function createInstance( contractid, iidName )
{
	var iid = eval( "Components.interfaces." + iidName );
    	return Components.classes[ contractid ].createInstance( iid );
}


function fixScrolling(){
	var LogWindow = top.frames["LogWnd"]
	var pageY = LogWindow.pageYOffset
	var docHeight = LogWindow.innerHeight

}


// ignore user from chat - called this time from top level people menu
// simply accesses the cmdIgnoreFromChat() method present inside the chatpanel iframe


function cmdIgnoreFromChat_PeopleMenu(){
   top.frames['chatpanel'].cmdIgnoreFromChat();

}


// add buddy - get's the currently selected chat room
// buddy and prepopulates the add buddy dialog.

function cmdChatContentAddBuddy()
{
var targetValue = top.frames['chatpanel'].cmdGetSelectedScreenName()
if (targetValue) {
  openDialog("chrome://aim/content/BuddyAddBuddy.xul", "", "modal=yes,titlebar,chrome", null, null, targetValue);
  }
}

// get member info - accesses the currently selected chatroom buddy and 
// sends that info to the getmemeberinfo xul file

function cmdChatContentGetMemberInfo(){
   var targetValue = top.frames['chatpanel'].cmdGetSelectedScreenName()
   if(targetValue && targetValue != null){
   window.openDialog('chrome://aim/content/GetMemberInfo.xul','_blank','chrome,all,dialog=no', targetValue);
   }

}


function cmdChatContentSendIM(){
   top.frames['chatpanel'].cmdSendIMFromChat();
}