/*

ChatPanel.js


*/

//create template for user management.

function chatPanelObj(){

	this.chatPanelAddScreenName = chatPanelAddScreenName;
	this.chatPanelRemoveScreenName = chatPanelRemoveScreenName;
	this.chatPanelUpdateScreenName = chatPanelUpdateScreenName;
	
	return this;
}

myChatPanel = new chatPanelObj()


function chatPanelOnWinLoad(){
	
	try{
	
	if(parent.myManager && parent.chatPanelLoaded){
		// dump("chatPanelOnWinLoad - parent.myManager defined \n")
		for(z=0;z<parent.myManager.members.length;z++){
			chatPanelUpdateScreenName(parent.myManager.members[z].screenName,parent.myManager.members[z].status)
		}
	
	}
	else{
		//dump("chatPanelOnWinLoad -parent.myManager not defined \n")
	}
	}
	catch (e){
		//dump("chatPanelOnWinLoad : couldnt find parent.myManager (caught exception) \n")
	}
	
	parent.chatPanelLoaded=true;
}


function chatPanelAddScreenName(screenName,initialState){
	//dump('adding:'+screenName+"\n\n")

	var listbox = document.getElementById("chatPanelTree");

	listitem=document.createElement("listitem");
	listitem.setAttribute('label',screenName)
	listitem.setAttribute('class',initialState);
	
	//dump("chatPanelAddScreenName adding class value of"+initialState);
	
	listbox.appendChild(listitem)
	
	top.updateMemberCount();
	//top.updateStatus(screenName+" > "+initialState)
	top.chatContentStatusChange(screenName,initialState)

	if(listbox.childNodes.length == 1){
		//Im the first person here! Select me
		document.getElementById("chatPanelTree").selectedIndex=0;
	}else{
		//the length of the tree is more than one
	}

}


function chatPanelRemoveScreenName(screenName){
	//dump('removing:'+screenName+'\n\n')
		var listbox  = document.getElementById("chatPanelTree");
		
		var listitems = listbox.getElementsByTagName("listitem");
		var theDoomedScreenName = null;
		var theDoomedScreenNameWasSelected = false;
		
		for (k=0; k < listitems.length; k++){
			if (listitems[k].getAttribute("label").toLowerCase() == screenName.toLowerCase())
				theDoomedScreenName = listitems[k];
		}

		if(theDoomedScreenName != null){
			//dump("***the doomed screen name selected value: ["+theDoomedScreenName.selected+"]\n");
			if(theDoomedScreenName.selected){
				theDoomedScreenNameWasSelected = true;
			}
			listbox.removeChild(theDoomedScreenName)
			top.updateMemberCount();
			//top.updateStatus(screenName+"has left")
			top.chatContentStatusChange(screenName,"has left")

		}
		else{
			//dump("chatPanelRemoveScreenName: cannot remove "+screenName+"\n");
		}
		
		if (theDoomedScreenNameWasSelected){
			//it was selected - reset selection now 
			//dont need to check for 0 because if it's zero - you'd not be in the chatroom yourself
			listbox.selectedIndex= 0 ;

		}

}

//update the status of a given screenname

function chatPanelUpdateScreenName(screenName,snStatus){
	//dump("updating status of "+screenName+" to "+snStatus+"\n");
	//var searchingSN = screenName.toLowerCase()
	//var theSNtoUpdate = document.getElementById(searchingSN)
  var theTreeChildren = document.getElementsByTagName("listitem");
	var theSNtoUpdate= null;
	for (j=0; j<theTreeChildren.length; j++){
		if(aimIsSameScreenName(theTreeChildren.item(j).getAttribute("label"), screenName)){
			theSNtoUpdate = theTreeChildren.item(j);
			//dump("ChatPanelUpdate:found the child +\n" )
		}
	}


	
	if(theSNtoUpdate!=null){
		//dump("they already were here in some state.(invited?)\n")
		theSNtoUpdate.setAttribute("class",snStatus);

		// in case its formatting has changed
		theSNtoUpdate.setAttribute("label", screenName);
		top.updateMemberCount();

		top.chatContentStatusChange(screenName,snStatus)

	}
	else{
		//dump(" they joined without being invited? \n")
		chatPanelAddScreenName(screenName,snStatus)
	}

}


function cmdUserSelected(e){
	document.getElementById("userSelected").setAttribute("disabled","false")
	
	var theTree = document.getElementById("chatPanelTree")
	if(theTree.selectedItems.length >=1 ){
		document.getElementById("userSelected").setAttribute("selectedScreenName",theTree.selectedItems[0].getAttribute("label"))
		document.getElementById("userSelected").setAttribute("disabled","false");

	}
	if(theTree.selectedItems.length==0){
		document.getElementById("userSelected").setAttribute("disabled","true")
		document.getElementById("userSelected").setAttribute("selectedScreenName",'')

	}

	//dump("Currently Selected User is: "+document.getElementById("userSelected").getAttribute("selectedScreenName")+"\n");
}

function cmdUserBlurred(e){
	//document.getElementById("userSelected").setAttribute("disabled","true")
	//	dump("userBlurred:"+e.target.tagName+"\n")

}



function cmdSendIMFromChat(){
	var theTree = document.getElementById("chatPanelTree")
	if(theTree.selectedItems.length>=1){
		var selectedScreenName = cmdGetSelectedScreenName(); 
		aimIMInvokeIMForm(selectedScreenName);

	}
	else{
		aimIMInvokeIMForm(null, null);
	}
}

function cmdIgnoreFromChat() 
{
	var theTree = document.getElementById("chatPanelTree")
	var i;
	for (i = 0; i < theTree.selectedItems.length; i++)
	{
	    var selectedScreenName =theTree.selectedItems[i].getAttribute("label");

	    var wasIgnored = top.chatRoomObj.Ignore(selectedScreenName);
	    if (wasIgnored)
        top.frames['chatpanel'].chatPanelUpdateScreenName(selectedScreenName, "joined");
	   else
        top.frames['chatpanel'].chatPanelUpdateScreenName(selectedScreenName, "ignored");
		
	}
}

function getInfoFromChat()
{
  return;
}


function cmdGetSelectedScreenName(){
	
	return document.getElementById("userSelected").getAttribute("selectedScreenName")

}



