/////////////////////////////////////////////////////////////////////
// These are our hooks into the public mozilla
// header viewing code. This is where we can insert AIM presence 
// information into the message pane.
//////////////////////////////////////////////////////////////////////

var gPrefs = Components.classes["@mozilla.org/preferences-service;1"];
gPrefs = gPrefs.getService();
gPrefs = gPrefs.QueryInterface(Components.interfaces.nsIPrefBranch);

// list of emails we did not have a buddy list association with
var domNodes = new Object(); 
var emailList = new Array();
var emailNodeList = new Array();
var emailNodeList2 = new Array();

// callback for RequestGroupPresenceByEmailAddress()
var LocateCallback = new Object();

LocateCallback.OnRequestGroupInfoPresenceComplete = function(pArraySize, pEmailList, pScreenNameList, pPresenceList)
{
  for(i in emailNodeList)
  {
    var emailNode = emailNodeList[i];
    // always set the screen name...even if the user is not online...
    if (pScreenNameList[i])
    {
      emailNode.setTextAttribute("IMScreenName", pScreenNameList[i]);
      if (emailNodeList2[i])
        emailNodeList2[i].setTextAttribute("IMScreenName", pScreenNameList[i]);
    }

    if(pPresenceList[i])
    {
      emailNode.setAttribute("BuddyStateString", "ActiveOnline");
 
      // this silly align hack is because css isn't noticing the alignment
      // attribute unless I set it to something...then set it back to what
      // I really want...
      emailNode.setAttribute("align", "left");
      emailNode.setAttribute("align", "right");
      emailNode.setAttribute("max-height", "15px");
      SetSendIMTo (emailNode);

      if(emailNodeList2[i])
      {
        emailNode = emailNodeList2[i];
        emailNode.setAttribute("BuddyStateString", "ActiveOnline");
 
        // this silly align hack is because css isn't noticing the alignment
        // attribute unless I set it to something...then set it back to what
        // I really want...
        emailNode.setAttribute("align", "left");
        emailNode.setAttribute("align", "right");
        emailNode.setAttribute("max-height", "15px");
        SetSendIMTo (emailNode);
      }
    }
    else
    {
      // this is a hack to get the email addresses that do not have an aim
      // image to align with the addresses that do have an image next to
      // them.  This hack will add a 1pxX15px transparent image next to
      // the address that does not have the aim icon.
      emailNode.setAttribute("BuddyStateString", "Blank");
 
      // this silly align hack is because css isn't noticing the alignment
      // attribute unless I set it to something...then set it back to what
      // I really want...
      emailNode.setAttribute("align", "left");
      emailNode.setAttribute("align", "right");
      emailNode.setAttribute("max-height", "15px");
      emailNode.removeAttribute("padding-left");

      // Clear attributes in case they exist from a cached emailNode
      ClearSendIMTo (emailNode);
    }
  }
}

LocateCallback.OnRequestGroupInfoPresenceError = function(pErrMsg) 
{
	//dump("LocateCallback.OnRequestGroupInfoPresenceError\n");
  emailList.length = 0;
  emailNodeList.length = 0;
  emailNodeList2.length = 0;
}

/* AddExtraAddressProcessing is called by the msgHdrViewOverlay whenever it encounters
   an email address. This gives us the chance to insert presence information.
   
   It's important to realize that each email address is represented by a borderless
   title button. For presence, we just need to poke the image url associated
   with that title button
*/

function AddExtraAddressProcessing(emailAddress, emailNode)
{
  // take the email Address, figure out if we have an AIM uri for this
  // email address...if we do, create a titled button element and based on
  // the online presence, give that button a class. Add it to our watch list
  // so we can change this dom element later on. And then insert it into the enclosingNode


  if (emailAddress && aimBuddyManager())
  {
    if(gPrefs)
    {
      var showPresence = gPrefs.getBoolPref("aim.mail.presence");
      if(!showPresence)
        return;
    }
    else
      return;

    var screenName;
    try 
    {
      // Please DO NOT change the 3rd param of getPersonalAbCardFromAttribute() call to 
      // PR_TRUE (ie, case insensitive) without reading bugs #128535 and #121478.
      var card = aimABInfo().getPersonalAbCardFromAttribute("PrimaryEmail", emailAddress, false);
      if (card) {
        var mdbcard = card.QueryInterface(Components.interfaces.nsIAbMDBCard);
        screenName = mdbcard.getStringAttribute("_AimScreenName");
    }
      else {
        screenName = null;
      }
    }
    catch (ex)
    {
      screenName = null;
      dump("ex: " + ex + "\n");
    }
    if (screenName)
    {
       var rdfResourceForName = aimBuddyManager().GetUserResource(screenName);
       if (rdfResourceForName)
       {
          try {
          var target = aimRDFDataSource().GetTarget(rdfResourceForName, buddyStateString, true);
          if (target)
            SetPresence(emailNode, target);
          }
          catch (ex) {
          }
          domNodes[rdfResourceForName.Value] = emailNode;
       }
    }
    else
    {
      // add this email address to the list that will be processed later with the LocateManager

      var length = emailList.length;
      if(emailList[length-1] == emailAddress && length != 0)
      {
        emailNodeList2[length-1] = emailNode;
      }
      else
      {
        emailList[length] = emailAddress;
        emailNodeList[length] = emailNode;
      }
    }
    // be sure to set the screen name as an attribute on the node so we can get it later...
    emailNode.setTextAttribute("IMScreenName", screenName);
  }
}

// This will kick off the group processing of presence for email addresses
function FinishEmailProcessing()
{
  //dump("FinishEmailProcessing()\n");

  if(gPrefs)
  {
    var showPresence = gPrefs.getBoolPref("aim.mail.presence");
    if(!showPresence)
      return;
  }
  else
    return; 

  try
  { aimLocateManager().RequestGroupPresenceByEmailAddress(LocateCallback, emailList.length, emailList); }
  catch(ex)
  {  
    emailList.length = 0;
    emailNodeList.length = 0;
    emailNodeList2.length = 0;
  }
}

// NotifyClearAddresses --> use to clear any observers on the email
// addresses that maybe in the hdr view overlay. Each time a new
// message is loaded in message pane, we'll call this function...
function NotifyClearAddresses()
{
  for (i in emailNodeList)
    emailNodeList[i].removeAttribute("BuddyStateString");
      
  for (i in emailNodeList2)
    emailNodeList2[i].removeAttribute("BuddyStateString");
  
  for (i in domNodes)
    domNodes[i].removeAttribute("BuddyStateString");
     
// throw away our knowledge of old data sources..      
  domNodes = new Object(); 
  emailList = new Array();
  emailNodeList = new Array();
  emailNodeList2 = new Array();
}

// fillEmailAddressMenu - the onpopupshowing handler for the email address popu menu.
// node --> the popup node that has been selected.
function fillEmailAddressMenu(node)
{
  // we need to determine if we are online or not. If we aren't online, disable the
  // AIM related menu items. If we are online, then make sure they are enabled.
  var target = aimRDFDataSource().GetTarget(aimRDFSession(), aimRDFSessionState(), true);
  var state = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
  var online = false;
  if (state == "Online" || "OnlineAway" == state)
    online = true;

  var screenName = node.getAttribute("IMScreenName");
  var buddyStateString = node.getAttribute("BuddyStateString");
  var haveGoodBuddyStateString = true;
  var haveScreenName = false;
  if (screenName && screenName != "")
    haveScreenName = true;
  if(buddyStateString == "Blank" || buddyStateString == "")
    haveGoodBuddyStateString = false;

  ShowMenuItem("aimEmailAddressSeparator", online);

  ShowMenuItem("sendIMForAddress", online);
	EnableMenuItem("sendIMForAddress", online && haveScreenName && haveGoodBuddyStateString);

  ShowMenuItem("addAddressToBuddyList", online);
	EnableMenuItem("addAddressToBuddyList", online && haveScreenName && haveGoodBuddyStateString);
  
  return true;
}


function SetSendIMTo (node)
{
	if (node)
	{
    
    var screenName = node.getTextAttribute("IMScreenName");
	if (screenName)
		{
		node.GetIconNode().setAttribute("data", screenName);
		node.GetIconNode().setAttribute("ondblclick", "aimIMInvokeIMForm(getAttribute('data'))"); 
		}
    else
      node.GetIconNode().setAttribute("ondblclick", "aimIMInvokeIMForm(null)");
	}
}

// Clear attributes in case they exist from a cached node.
function ClearSendIMTo (node)
{
	if (node)
	{
		node.GetIconNode().removeAttribute("data");
		node.GetIconNode().removeAttribute("ondblclick");
	}
}

