/*
 * Name: cmdViewTimestamp
 *
 * Arguments: None
 *
 * Description:
 *
 * This function is the command handler for the timestamp menu item in
 * the IM view menu. It switches the global state stored on the document,
 * syncs the timestamp menu item to reflect its function now that the
 * state has changed, and it calls showTimestamps() to cause the content
 * to change to refect the new state
 *
 * Original Code: Syd Logan 1/4/2002
 *
*/

function cmdViewTimestamp()
{
  var timestampItem = top.document.getElementById("miTimestamp");
  if ( showTimestampVal == true ){
    timestampItem.setAttribute("label", aimString("miTimestamp.Show"));
    showTimestampVal = false;
  }
  else {
    timestampItem.setAttribute("label", aimString("miTimestamp.Hide"));
    showTimestampVal = true;
  }
  showTimestamps(showTimestampVal);
}

/*
 * Name: cmdCreateTimestamp
 *
 * Arguments: None
 *
 * Description:
 *
 * This function sets the timestamp menu item to its proper value 
 *
 * Original Code: Syd Logan 1/4/2002
 *
*/

function cmdCreateTimestamp()
{
  var timestampItem = top.document.getElementById("miTimestamp");
  if ( showTimestampVal == true )
    timestampItem.setAttribute("label", aimString("miTimestamp.Hide"));
  else
    timestampItem.setAttribute("label", aimString("miTimestamp.Show"));
}

/*
 * Name: SetTimestampMenuItem
 *
 * Arguments: None
 *
 * Description:
 *
 * This function looks at the document-global variable that holds the current
 * state of the timestamp menu (set before this function is called) and then
 * sets the label on the menu item appropriately. We also call across to the
 * backend to tell it, for this window, whether to poke in a timestamp or not.
 *
 * Original Code: Syd Logan 11/23/2001
 *
*/

function
SetTimestampMenuItem()
{
  var timestampItem = top.document.getElementById("miTimestamp");

  if ( showTimestampVal == true ) {
    timestampItem.setAttribute("label", aimString("miTimestamp.Hide"));
    showTimestamps( true );
  }
  else {
    timestampItem.setAttribute("label", aimString("miTimestamp.Show"));
    showTimestamps( false );
  }
  return false;
}

/*
 * Name: showTimestamps
 *
 * Arguments:
 *
 * boolean which -- if true, show the timestamps in the log, else hide them
 *
 * Description:
 *
 * This function iterates the document and searches for all spans that have
 * a class id that is equal to logtimestamp. If the argument passed to this
 * function is true, then any span that is found will be shown, otherwise,
 * it will be hidden.
 *
 * Original Code: 12/23/2001, Syd Logan (I should have implemented this a
 * year ago :-)
 *
 */

function
showTimestamps( which )
{
  var wind = top.frames["LogWnd"];
  var spanVec = wind.document.getElementsByTagName("SPAN");
  for ( var span = 0; span < spanVec.length; span++ ) {
    var attributes = spanVec[span].attributes;
    if ( attributes && attributes.length ) {
      var item, name, value;
      for ( var index = 0; index < attributes.length; index++ ) {
        item = attributes.item(index);
        name = item.nodeName;
        value = item.nodeValue;
        if ( name == 'class' && value == 'logtimestamp' ) {
          if ( which == true ) {
              spanVec[span].setAttribute('style', 'visibility:visible' );
          }
          else {
              // need display:none otherwise the span will still occupy space
              spanVec[span].setAttribute('style', 'display:none' );
          } 
          break;
        }
      }
    }
  }

  /* 
     If IM, gotta tell the backend so it can set the style on the SPAN
     correctly when new content is added (chat just looks at the state
     stored in the document, since it adds content in JS)
  */

  if ( isChatContent == false ) {
    var pIAimIM = aimIMObject();

    if(pIAimIM)
      pIAimIM.SetTimestamp(AimIMGetFormScreenName(), which);
  }
}


