/* Synaescope - a pretty noatun visualization (based on P. Harrison's Synaesthesia)
   Copyright (C) 1997 Paul Francis Harrison <pfh@yoyo.cc.monash.edu.au>
                 2001 Charles Samuels <charles@kde.org>

	this file is X11 source
 */

#include "synaescope.h"

#include "syna.h"
#include <kprocess.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kstandarddirs.h>

extern "C"
{
Plugin *create_plugin()
{
	KGlobal::locale()->insertCatalogue("synaescope");
	return new SynaeScope();
}
}


SynaeScope::SynaeScope() : Plugin()
{
	connect(&process, SIGNAL(processExited(KProcess *)), this, SLOT(processExited(KProcess *)));
}

SynaeScope::~SynaeScope()
{
	process.kill();
}

void SynaeScope::init()
{
	process << KStandardDirs::findExe("noatunsynaescope.bin");

	// Note that process.start() will fail if findExe fails, so there's no real need
	// for two separate checks.
	if(!process.start(KProcess::NotifyOnExit, (KProcess::Communication)(KProcess::Stdin | KProcess::Stdout)))
	{
		KMessageBox::error(0, i18n("Unable to start noatunsynaescope. Check your installation."));
		unload();
	}

}

void SynaeScope::processExited(KProcess *)
{
	unload();
}

#include  "synaescope.moc"

