/***************************************************************************
                            KXMLGUIClientInterface.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
public interface KXMLGUIClientInterface {

/** 
 Retrieves an action of the client by name.  If not found, it looks in its child clients.
 This method is provided for convenience, as it uses {@link #actionCollection}
 to get the action object.
   
*/
	KAction action( String name);

/** 
 Retrieves an action for a given {@link QDomElement}. The default
 implementation uses the "name" attribute to query the action
 object via the other action() method.
   
*/
	KAction action( QDomElement element);

/** 
 Retrieves the entire action collection for the GUI client
   
*/
	KActionCollection actionCollection();

/** 

*/
	KInstanceInterface instance();

/** 

*/
	QDomDocument domDocument();

/** 
 This will return the name of the XML file as set by {@link #setXMLFile}.
 If {@link #setXML} is used directly, then this will return NULL.

 The filename that this returns is obvious for components as each
 component has exactly one XML file.  In non-components, however,
 there are usually two: the global file and the local file.  This
 function doesn't really care about that, though.  It will always
 return the last XML file set.  This, in almost all cases, will
 be the local XML file.

*/
	String xmlFile();
	String localXMLFile();

/** 

   
*/
	void setXMLGUIBuildDocument( QDomDocument doc);

/** 

   
*/
	QDomDocument xmlguiBuildDocument();

/** 
 This method is called by the {@link KXMLGUIFactory} as soon as the client
 is added to the KXMLGUIFactory's GUI.
   
*/
	void setFactory( KXMLGUIFactory factory);

/** 
 Retrieves a pointer to the {@link KXMLGUIFactory} this client is
 associated with (will return null if the client's GUI has not been built
 by a KXMLGUIFactory.
   
*/
	KXMLGUIFactory factory();

/** 
 KXMLGUIClients can form a simple child/parent object tree. This
 method returns a pointer to the parent client or null if it has no
 parent client assigned.
   
*/
	KXMLGUIClientInterface parentClient();

/** 
 Use this method to make a client a child client of another client.
 Usually you don't need to call this method, as it is called
 automatically when using the second constructor, which takes a
 arent argument.
   
*/
	void insertChildClient( KXMLGUIClientInterface child);

/** 
 Removes the given <code>child</code> from the client's children list.
   
*/
	void removeChildClient( KXMLGUIClientInterface child);

/** 
 Retrieves a list of all child clients.
   
*/
//	KXMLGUIClientPtrList childClients();

/** 
 A client can have an own {@link KXMLGUIBuilder}.
 Use this method to assign your builder instance to the client (so that the
 {@link KXMLGUIFactory} can use it when building the client's GUI)

 Client specific guibuilders are useful if you want to create
 custom container widgets for your GUI.
   
*/
	void setClientBuilder( KXMLGUIBuilderInterface builder);

/** 
 Retrieves the client's GUI builder or null if no client specific
 builder has been assigned via {@link #setClientBuilder}
   
*/
	KXMLGUIBuilderInterface clientBuilder();

/** 
 Forces this client to re-read its XML resource file.  This is
 intended to be used when you know that the resource file has
 changed and you will soon be rebuilding the GUI.  It has no
 useful effect with non-KParts GUIs, so don't bother using it
 unless your app is component based.
   
*/
	void reloadXML();

/** 
 ActionLists are a way for XMLGUI to support dynamic lists of
 actions.  E.g. if you are writing a file manager, and there is a
 menu file whose contents depend on the mimetype of the file that
 is selected, then you can achieve this using ActionLists. It
 works as follows:
 In your xxxui.rc file ( the one that you set in {@link #setXMLFile}
 ), you put an <ActionList name="xxx"> tag.  E.g.
 \verbatim
 <kpartgui name="xxx_part" version="1">
 <MenuBar>
   <Menu name="file">
     ...  <!-- some useful actions-.
     <ActionList name="xxx_file_actionlist" />
     ...  <!-- even more useful actions-.
   </Menu>
   ...
 </MenuBar>
 </kpartgui>
 \endverbatim

 This tag will get expanded to a list of actions.  In the example
 above ( a file manager with a dynamic file menu ), you would call
 \code
 QPtrList<KAction> file_actions;
 for( ... )
   if( ... )
     file_actions.append( cool_action );
 unplugActionList( "xxx_file_actionlist" );
 plugActionList( "xxx_file_actionlist", file_actions );
 \endcode
 every time a file is selected, unselected or ...

 \note You should not call createGUI() after calling this
       function.  In fact, that would remove the newly added
       actionlists again...
 \note Forgetting to call unplugActionList() before
       plugActionList() would leave the previous actions in the
       menu too..
   
*/
//	void plugActionList( String name, KActionPtrList actionList);

/** 
 The complement of \ref plugActionList() ...
   
*/
	void unplugActionList( String name);
	void addStateActionEnabled( String state, String action);
	void addStateActionDisabled( String state, String action);
//	StateChange getActionsToChangeForState( String state);
	void beginXMLPlug( QWidget arg1);
	void endXMLPlug();
	void prepareXMLUnplug( QWidget arg1);
}
