/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.io.PrintStream;
import java.security.Provider;
import java.security.Security;
import org.kde.kjas.server.Console;
import org.kde.kjas.server.KJASProtocolHandler;
import org.kde.kjas.server.KJASSwingConsole;

public class Main {
    public static final PrintStream protocol_stdout;
    public static final KJASProtocolHandler protocol;
    public static final Console console;
    private static final boolean show_console;
    public static final boolean Debug;
    public static final boolean log;
    static final boolean cacheImages;
    public static String proxyHost;
    public static int proxyPort;
    private static boolean good_jdk;

    public static void debug(String string) {
        if (Debug) {
            System.out.println("KJAS: " + string);
        }
    }

    public static void info(String string) {
        System.err.println("KJAS: " + string);
    }

    public static void kjas_err(String string, Exception exception) {
        System.err.println(string);
        System.err.println("Backtrace: ");
        exception.printStackTrace();
    }

    public static void kjas_err(String string, Throwable throwable) {
        System.err.println(string);
        throwable.printStackTrace();
    }

    public static void main(String[] stringArray) {
        if (!good_jdk) {
            console.setVisible(true);
            System.err.println("ERROR: This version of Java is not supported for security reasons.");
            System.err.println("\t\tPlease use Java version 1.2 or higher.");
            return;
        }
        if (show_console) {
            console.setVisible(true);
        }
        try {
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            if (Security.getProvider("SunJSSE") == null) {
                Class<?> clazz = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
                if (clazz != null) {
                    Main.debug("adding Security Provider");
                    Provider provider = (Provider)clazz.newInstance();
                    Security.addProvider(provider);
                } else {
                    Main.debug("could not get class: com.sun.net.ssl.internal.ssl.Provider");
                }
            } else {
                Main.debug("could not get provider: SunJSSE");
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to load JSSE SSL stream handler, https support not available");
        }
        protocol.commandLoop();
    }

    static {
        proxyHost = null;
        proxyPort = 0;
        good_jdk = true;
        Debug = System.getProperty("kjas.debug") != null;
        show_console = System.getProperty("kjas.showConsole") != null;
        log = System.getProperty("kjas.log") != null;
        cacheImages = System.getProperty("kjas.noImageCache") == null;
        proxyHost = System.getProperty("http.proxyHost");
        String string = System.getProperty("http.proxyPort");
        try {
            proxyPort = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        protocol_stdout = System.out;
        console = new KJASSwingConsole();
        protocol = new KJASProtocolHandler(System.in, protocol_stdout);
        Main.debug("JVM version = " + System.getProperty("java.version"));
        String string2 = System.getProperty("java.version").substring(0, 3);
        Main.debug("JVM numerical version = " + string2);
        try {
            float f = Float.parseFloat(string2);
            if ((double)f < 1.2) {
                good_jdk = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            good_jdk = false;
        }
    }
}

