/***************************************************************************
                          krecord.h  -  description
                             -------------------
    begin                : Mon Jun 17 2002
    copyright            : (C) 2002 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRECORD_H
#define KRECORD_H

#include <kmainwindow.h>
#include <kaction.h>
#include <klistview.h>
#include <qtimer.h>
#include <qslider.h>
#include <qlcdnumber.h>

#include <kartsserver.h>
#include <kartsdispatcher.h>
#include <artsmodules.h>
#include <artsgui.h>
#include <kartswidget.h>
#include <kconfig.h>

class AKByteStreamSender;
class Session;
class VUMeter;
class RecordFile;
class StartUpWindow;
class KAudioRecordStream;

/// KDE Recording GUI.

/**
	Presents a GUI for Recording.

	Supports various takes, Play-Thru and Playing of previous takes.

	@author Arnold Krille
	*/

class KRecord : public KMainWindow  {
   Q_OBJECT
public:
	/// Constructor
	KRecord(QWidget *parent=0, const char *name=0);
	/// Destructor
	~KRecord();
public slots:
	/// Does nothing.
	void nothing() { }
	/// Starts Recording.
	void startRec();
	/// Starts Playback.
	void startPlay();
	/// ByteStreamSender informs of his playing.
	void playIsRunning() { playing=true; checkActions(); }
	/// ByteStreamSender informs of his playing.
	void playStops() { playing=false; checkActions(); }
	/// Stops Recording.
	void stopRec();
	/// Opens a new Session.
	void newSession();
	/// Opens a new File.
	void newFile();

	/// If we can play or not.
	void canPlay(bool b) { _canplay = b; checkActions(); }
	/// If we can record or not.
	void canRecord(bool b) { _canrecord = b; checkActions(); }

	/// Shows the contextmenu.
	/**
		Shows the Contextmenu at the mouseposition.
	*/
	void showContextMenu (KListView* list, QListViewItem* item, const QPoint& qpoint);

	/// Switches the StartUpWindow
	void startUpWindow( bool on );

protected slots:
	/// Checks all the Actions and sets Enabled/Disabled.
	void checkActions();
	/// Updates the VU-Meter.
	void updateVU();
	/// Changes the Recording-Level in the StereoVolumeControl.
	void changedVolume( int vol ) { volumecontrol.scaleFactor( float(vol)/100 ); }
	/// Enables Play-thru from the AMAN_RECORD to the AMAN_PLAY.
	void playthru( bool yes );
	/**
	 * Called from a Session or RecordFile when a RecordFile got selected.
	 */
	void setRecFile( RecordFile * );

/*	/// Close
	void close();
public slots:
	/// Testing
	void closeLast();*/
private:
	KAction *aRecord, *aPlay, *aStop, *aNewSession, *aNewFile;
	KToggleAction *aThru, *aStartUpWindow;
	KArtsServer *server;
	KArtsDispatcher *dispatcher;
	KAudioRecordStream * m_recStream;
	Arts::Synth_AMAN_PLAY aman_play;
	Arts::StereoEffectStack effects;
	Arts::StereoVolumeControl volumecontrol;
	Arts::Synth_STEREO_COMPRESSOR comp;
	KArtsWidget *w;
	Arts::ByteStreamToAudio bs2a;
	Arts::ByteSoundProducerV2 sender;
	AKByteStreamSender *aksender;
	bool recording, playing;
	KListView *_pListView;
	VUMeter *vu;
	QTimer *vutimer;
	QSlider *slider;
	long vc_id, comp_id;
	QLCDNumber *lcd;

	bool _canplay, _canrecord, b_arts, b_comp;

	KConfig *config;
	RecordFile * m_pCurrentRecordFile;
};

#endif

// vim:sw=4:ts=4
