#ifndef __bugsystem_h__
#define __bugsystem_h__

#include "package.h"
#include "bug.h"
#include "bugdetails.h"
#include "bugcache.h"

#include <qobject.h>
#include <qptrlist.h>
#include <qmap.h>
#include <qpair.h>

class BugCommand;
class BugServer;

class BugSystem : public QObject
{
    Q_OBJECT
public:
    BugSystem();
    virtual ~BugSystem();

    static BugSystem *self();

    BugCache *cache();
    BugServer *server() const { return mServer; }

    void retrievePackageList();
    void retrieveBugList( const Package &, const QString &component );
    void retrieveBugDetails( const Bug & );

    /**
      Queue a new command.
    */
    void queueCommand( BugCommand * );
    /**
      Forget all commands for a given bug.
    */
    void clearCommands( const QString &bug );
    /**
      Forget all commands for all bugs.
    */
    void clearCommands();
    /**
      Send all commands (generate the mails).
    */
    void sendCommands();

    void setDisconnected( bool );
    bool disconnected() const;

    Package::List packageList() const;

    Package package( const QString &pkgname ) const;
    Bug bug( const Package &pkg, const QString &component, const QString &number ) const;

signals:
    void packageListAvailable( const Package::List &pkgs );
    void bugListAvailable( const Package &pkg, const QString &, const Bug::List & );
    void bugDetailsAvailable( const Bug &, const BugDetails & );

    void packageListLoading();
    void bugListLoading( const Package &, const QString &component );
    void bugDetailsLoading( const Bug & );

    void packageListCacheMiss();
    void bugListCacheMiss( const Package & );
    void bugDetailsCacheMiss( const Bug & );

    void bugDetailsLoadingError();

    void infoMessage( const QString &message );
    void infoPercent( unsigned long percent );

    void commandQueued( BugCommand * );
    void commandCanceled( const QString & );

    void loadingError( const QString &text );

private slots:
    void setPackageList( const Package::List &pkgs );
    void setBugList( const Package &pkg, const QString &component, const Bug::List &bugs );
    void setBugDetails( const Bug &bug, const BugDetails &details );

private:
    bool m_disconnected;

    BugServer *mServer;

    static BugSystem *s_self;
};

#endif

/*
 * vim:sw=4:ts=4:et
 */
