/*
 * Decompiled with CFR 0.152.
 */
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class Font2DTest
extends JPanel
implements ActionListener,
ItemListener {
    private final JFrame parent;
    private final FontPanel fp;
    private final RangeMenu rm;
    private final ChoiceV2 fontMenu;
    private final JTextField sizeField;
    private final ChoiceV2 styleMenu;
    private final ChoiceV2 textMenu;
    private int currentTextChoice = 0;
    private final ChoiceV2 transformMenu;
    private final ChoiceV2 transformMenuG2;
    private final ChoiceV2 methodsMenu;
    private final JCheckBox useAntialiasCB;
    private final JCheckBox useFractionalCB;
    private CheckboxMenuItemV2 displayGridCBMI;
    private CheckboxMenuItemV2 force16ColsCBMI;
    private CheckboxMenuItemV2 showFontInfoCBMI;
    private JDialog userTextDialog;
    private JTextArea userTextArea;
    private JDialog printDialog;
    private JDialog fontInfoDialog;
    private LabelV2[] fontInfos = new LabelV2[2];
    private JFileChooser filePromptDialog = null;
    private ButtonGroup printCBGroup;
    private JRadioButton[] printModeCBs = new JRadioButton[3];
    private final LabelV2 statusBar;
    private final Font labelFont = new Font("dialog", 1, 12);
    private String tFileName;

    public Font2DTest(JFrame jFrame, boolean bl) {
        this.parent = jFrame;
        this.rm = new RangeMenu(this, this.parent);
        this.fp = new FontPanel(this, this.parent);
        this.statusBar = new LabelV2("");
        this.fontMenu = new ChoiceV2(this);
        this.sizeField = new JTextField("12", 3);
        this.styleMenu = new ChoiceV2(this);
        this.textMenu = new ChoiceV2();
        this.transformMenu = new ChoiceV2(this);
        this.transformMenuG2 = new ChoiceV2(this);
        this.methodsMenu = new ChoiceV2(this);
        this.useAntialiasCB = new JCheckBox("Antialiasing", false);
        this.useFractionalCB = new JCheckBox(" Fractional Metrics", false);
        this.useAntialiasCB.setFont(this.labelFont);
        this.useFractionalCB.setFont(this.labelFont);
        this.sizeField.addActionListener(this);
        this.useAntialiasCB.addItemListener(this);
        this.useFractionalCB.addItemListener(this);
        this.setupPanel();
        this.setupMenu(bl);
        this.setupDialog(bl);
    }

    private void setupPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.setLayout(gridBagLayout);
        this.addLabeledComponentToGBL("Font:", this.fontMenu, gridBagLayout, gridBagConstraints, this);
        this.addLabeledComponentToGBL("Size:", this.sizeField, gridBagLayout, gridBagConstraints, this);
        gridBagConstraints.gridwidth = 0;
        this.addLabeledComponentToGBL("Transform:", this.transformMenu, gridBagLayout, gridBagConstraints, this);
        gridBagConstraints.gridwidth = 1;
        this.addLabeledComponentToGBL("Range:", this.rm, gridBagLayout, gridBagConstraints, this);
        this.addLabeledComponentToGBL("Style:", this.styleMenu, gridBagLayout, gridBagConstraints, this);
        gridBagConstraints.gridwidth = 0;
        this.addLabeledComponentToGBL("Text to use:", this.textMenu, gridBagLayout, gridBagConstraints, this);
        gridBagConstraints.gridwidth = 1;
        this.addLabeledComponentToGBL("Method:", this.methodsMenu, gridBagLayout, gridBagConstraints, this);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        this.addLabeledComponentToGBL("Graphics2D Transform:", this.transformMenuG2, gridBagLayout, gridBagConstraints, this);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.useAntialiasCB, gridBagConstraints);
        this.add(this.useAntialiasCB);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.useFractionalCB, gridBagConstraints);
        this.add(this.useFractionalCB);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 2);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.fp, gridBagConstraints);
        this.add(this.fp);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagLayout.setConstraints(this.statusBar, gridBagConstraints);
        this.add(this.statusBar);
    }

    private void addLabeledComponentToGBL(String string, JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Container container) {
        LabelV2 labelV2 = new LabelV2(string);
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints2.insets = new Insets(2, 2, 2, 0);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 0.0;
        if (jComponent == null) {
            jComponent = new JLabel("");
        }
        gridBagLayout.setConstraints(labelV2, gridBagConstraints2);
        container.add(labelV2);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        container.add(jComponent);
    }

    private void setupMenu(boolean bl) {
        JMenu jMenu = new JMenu("File");
        JMenu jMenu2 = new JMenu("Option");
        jMenu.add(new MenuItemV2("Save Selected Options...", this));
        jMenu.add(new MenuItemV2("Load Options...", this));
        jMenu.addSeparator();
        jMenu.add(new MenuItemV2("Save as JPEG...", this));
        jMenu.add(new MenuItemV2("Load JPEG File to Compare...", this));
        jMenu.add(new MenuItemV2("Page Setup...", this));
        jMenu.add(new MenuItemV2("Print...", this));
        jMenu.addSeparator();
        if (!bl) {
            jMenu.add(new MenuItemV2("Exit", this));
        } else {
            jMenu.add(new MenuItemV2("Close", this));
        }
        this.displayGridCBMI = new CheckboxMenuItemV2("Display Grid", true, this);
        this.force16ColsCBMI = new CheckboxMenuItemV2("Force 16 Columns", false, this);
        this.showFontInfoCBMI = new CheckboxMenuItemV2("Display Font Info", false, this);
        jMenu2.add(this.displayGridCBMI);
        jMenu2.add(this.force16ColsCBMI);
        jMenu2.add(this.showFontInfoCBMI);
        JMenuBar jMenuBar = this.parent.getJMenuBar();
        if (jMenuBar == null) {
            jMenuBar = new JMenuBar();
        }
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.parent.setJMenuBar(jMenuBar);
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.fontMenu.addItem(stringArray[i]);
        }
        this.fontMenu.setSelectedItem("Dialog");
        this.styleMenu.addItem("Plain");
        this.styleMenu.addItem("Bold");
        this.styleMenu.addItem("Italic");
        this.styleMenu.addItem("Bold Italic");
        this.transformMenu.addItem("None");
        this.transformMenu.addItem("Scale");
        this.transformMenu.addItem("Shear");
        this.transformMenu.addItem("Rotate");
        this.transformMenuG2.addItem("None");
        this.transformMenuG2.addItem("Scale");
        this.transformMenuG2.addItem("Shear");
        this.transformMenuG2.addItem("Rotate");
        this.methodsMenu.addItem("drawString");
        this.methodsMenu.addItem("drawChars");
        this.methodsMenu.addItem("drawBytes");
        this.methodsMenu.addItem("drawGlyphVector");
        this.methodsMenu.addItem("TextLayout.draw");
        this.methodsMenu.addItem("GlyphVector.getOutline + draw");
        this.methodsMenu.addItem("TextLayout.getOutline + draw");
        this.textMenu.addItem("Unicode Range");
        this.textMenu.addItem("All Glyphs");
        this.textMenu.addItem("User Text");
        this.textMenu.addItem("Text File");
        this.textMenu.addActionListener(this);
    }

    private void setupDialog(boolean bl) {
        this.filePromptDialog = !bl ? new JFileChooser() : null;
        this.userTextDialog = new JDialog(this.parent, "User Text", false);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        LabelV2 labelV2 = new LabelV2("Enter text below and then press update");
        LabelV2 labelV22 = new LabelV2("(Unicode char can be denoted by \\uXXXX)");
        this.userTextArea = new JTextArea("Java2D!");
        ButtonV2 buttonV2 = new ButtonV2("Update", this);
        this.userTextArea.setFont(new Font("dialog", 0, 12));
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add("North", labelV2);
        jPanel.add("South", labelV22);
        jPanel2.add(buttonV2);
        JScrollPane jScrollPane = new JScrollPane(this.userTextArea);
        jScrollPane.setPreferredSize(new Dimension(300, 100));
        this.userTextDialog.getContentPane().setLayout(new BorderLayout());
        this.userTextDialog.getContentPane().add("North", jPanel);
        this.userTextDialog.getContentPane().add("Center", jScrollPane);
        this.userTextDialog.getContentPane().add("South", jPanel2);
        this.userTextDialog.pack();
        this.userTextDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Font2DTest.this.userTextDialog.hide();
            }
        });
        this.printCBGroup = new ButtonGroup();
        this.fp.getClass();
        this.printModeCBs[0] = new JRadioButton("Print one page from currently displayed character/line", true);
        this.fp.getClass();
        this.printModeCBs[1] = new JRadioButton("Print all characters in currently selected range", false);
        this.fp.getClass();
        this.printModeCBs[2] = new JRadioButton("Print all lines of text", false);
        LabelV2 labelV23 = new LabelV2("Note: Page range in native \"Print\" dialog will not affect the result");
        JPanel jPanel3 = new JPanel();
        this.fp.getClass();
        this.printModeCBs[2].setEnabled(false);
        jPanel3.add(new ButtonV2("Print", this));
        jPanel3.add(new ButtonV2("Cancel", this));
        this.printDialog = new JDialog(this.parent, "Print...", true);
        this.printDialog.setResizable(false);
        this.printDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Font2DTest.this.printDialog.hide();
            }
        });
        this.printDialog.getContentPane().setLayout(new GridLayout(this.printModeCBs.length + 2, 1));
        this.printDialog.getContentPane().add(labelV23);
        for (int i = 0; i < this.printModeCBs.length; ++i) {
            this.printModeCBs[i].setFont(this.labelFont);
            this.printCBGroup.add(this.printModeCBs[i]);
            this.printDialog.getContentPane().add(this.printModeCBs[i]);
        }
        this.printDialog.getContentPane().add(jPanel3);
        this.printDialog.pack();
        this.fontInfoDialog = new JDialog(this.parent, "Font info", false);
        this.fontInfoDialog.setResizable(false);
        this.fontInfoDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Font2DTest.this.fontInfoDialog.hide();
                Font2DTest.this.showFontInfoCBMI.setState(false);
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(this.fontInfos.length, 1));
        for (int i = 0; i < this.fontInfos.length; ++i) {
            this.fontInfos[i] = new LabelV2("");
            jPanel4.add(this.fontInfos[i]);
        }
        this.fontInfoDialog.getContentPane().add(jPanel4);
        this.userTextDialog.setLocation(200, 300);
        this.fontInfoDialog.setLocation(0, 400);
    }

    public void fireRangeChanged() {
        int[] nArray = this.rm.getSelectedRange();
        this.fp.getClass();
        this.fp.setTextToDraw(0, nArray, null, null);
        if (this.showFontInfoCBMI.getState()) {
            this.fireUpdateFontInfo();
        }
    }

    public void fireChangeStatus(String string, boolean bl) {
        this.statusBar.setText(string);
        this.fp.showingError = bl;
    }

    public void fireUpdateFontInfo() {
        if (this.showFontInfoCBMI.getState()) {
            String[] stringArray = this.fp.getFontInfo();
            for (int i = 0; i < this.fontInfos.length; ++i) {
                this.fontInfos[i].setText(stringArray[i]);
            }
            this.fontInfoDialog.pack();
        }
    }

    private String promptFile(boolean bl, String string) {
        File file;
        String string2;
        int n;
        String string3;
        if (this.filePromptDialog == null) {
            return null;
        }
        if (bl) {
            this.filePromptDialog.setDialogType(1);
            this.filePromptDialog.setDialogTitle("Save...");
            string3 = "Save";
        } else {
            this.filePromptDialog.setDialogType(0);
            this.filePromptDialog.setDialogTitle("Load...");
            string3 = "Load";
        }
        if (string != null) {
            this.filePromptDialog.setSelectedFile(new File(string));
        }
        if ((n = this.filePromptDialog.showDialog(this, string3)) == 0 && (string2 = (file = this.filePromptDialog.getSelectedFile()).getAbsolutePath()) != null) {
            return string2;
        }
        return null;
    }

    private String[] parseUserText(String string) {
        int n = string.length();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            int n3 = string2.length();
            int n4 = 0;
            int n5 = string2.indexOf("\\u");
            StringBuffer stringBuffer = new StringBuffer();
            while (n5 != -1) {
                if (n4 < n5) {
                    stringBuffer.append(string2.substring(n4, n5));
                }
                n4 = n5 + 6;
                try {
                    String string3 = string2.substring(n5 + 2, n5 + 6);
                    stringBuffer.append((char)Integer.parseInt(string3, 16));
                }
                catch (Exception exception) {
                    int n6 = n5 + 6 < n3 ? n5 + 6 : n3;
                    stringBuffer.append(string2.substring(n5, n6));
                }
                n5 = string2.indexOf("\\u", n4);
            }
            if (n4 < n3) {
                stringBuffer.append(string2.substring(n4, n3));
            }
            stringArray[n2++] = stringBuffer.toString();
        }
        return stringArray;
    }

    private void readTextFile(String string) {
        try {
            int n;
            int n2;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            int n3 = bufferedInputStream.available();
            if (n3 == 0) {
                throw new Exception("Text file " + string + " is empty");
            }
            byte[] byArray = new byte[n3];
            bufferedInputStream.read(byArray, 0, n3);
            bufferedInputStream.close();
            String string2 = n3 >= 2 && (byArray[0] == -1 && byArray[1] == -2 || byArray[0] == -2 && byArray[1] == -1) ? new String(byArray, "UTF-16") : new String(byArray);
            int n4 = string2.length();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            for (n2 = 0; n2 < n4; ++n2) {
                n = string2.charAt(n2);
                if (n == 13) {
                    if (n2 < n4 - 1 && string2.charAt(n2 + 1) == '\n') {
                        stringTokenizer = new StringTokenizer(string2, "\r\n");
                        break;
                    }
                    stringTokenizer = new StringTokenizer(string2, "\r");
                    break;
                }
                if (n == 10) break;
            }
            n2 = 0;
            n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null) {
                    string3 = " ";
                }
                stringArray[n2++] = string3;
            }
            this.fp.setTextToDraw(this.fp.FILE_TEXT, null, null, stringArray);
            this.rm.setEnabled(false);
            this.methodsMenu.setEnabled(false);
        }
        catch (Exception exception) {
            this.fireChangeStatus("ERROR: Failed to Read Text File; See Stack Trace", true);
            exception.printStackTrace();
        }
    }

    private void writeCurrentOptions(String string) {
        try {
            String string2 = this.fp.getCurrentOptions();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            int[] nArray = this.rm.getSelectedRange();
            String string3 = "Font2DTest Option File\n" + this.displayGridCBMI.getState() + "\n" + this.force16ColsCBMI.getState() + "\n" + this.showFontInfoCBMI.getState() + "\n" + this.rm.getSelectedItem() + "\n" + nArray[0] + "\n" + nArray[1] + "\n" + string2 + this.tFileName;
            byte[] byArray = string3.getBytes("UTF-16");
            bufferedOutputStream.write(byArray, 0, byArray.length);
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            this.fireChangeStatus("ERROR: Failed to Save Options File; See Stack Trace", true);
            exception.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateGUI() {
        var1_1 = this.textMenu.getSelectedIndex();
        this.fp.getClass();
        if (var1_1 == 2) {
            this.userTextDialog.show();
        } else {
            this.userTextDialog.hide();
        }
        this.fp.getClass();
        this.printModeCBs[0].setSelected(true);
        if (var1_1 == this.fp.FILE_TEXT) ** GOTO lbl-1000
        this.fp.getClass();
        if (var1_1 == 2) lbl-1000:
        // 2 sources

        {
            if (var1_1 == this.fp.FILE_TEXT) {
                this.methodsMenu.setSelectedItem("TextLayout.draw");
            }
            this.fp.getClass();
            this.methodsMenu.setEnabled(var1_1 == 2);
            this.fp.getClass();
            this.printModeCBs[1].setEnabled(false);
            this.fp.getClass();
            this.printModeCBs[2].setEnabled(true);
        } else {
            this.fp.getClass();
            if (var1_1 == 1) {
                this.methodsMenu.setSelectedItem("drawGlyphVector");
            }
            this.fp.getClass();
            this.methodsMenu.setEnabled(var1_1 == 0);
            this.fp.getClass();
            this.printModeCBs[1].setEnabled(true);
            this.fp.getClass();
            this.printModeCBs[2].setEnabled(false);
        }
        this.fp.getClass();
        if (var1_1 == 0) {
            this.fontInfos[1].setVisible(true);
            this.rm.setEnabled(true);
        } else {
            this.fontInfos[1].setVisible(false);
            this.rm.setEnabled(false);
        }
    }

    private void loadOptions(String string) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            int n = bufferedInputStream.available();
            byte[] byArray = new byte[n];
            bufferedInputStream.read(byArray, 0, n);
            bufferedInputStream.close();
            if (n < 2 || byArray[0] != -2 || byArray[1] != -1) {
                throw new Exception("Not a Font2DTest options file");
            }
            String string2 = new String(byArray, "UTF-16");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals("Font2DTest Option File")) {
                throw new Exception("Not a Font2DTest options file");
            }
            boolean bl = new Boolean(stringTokenizer.nextToken());
            boolean bl2 = new Boolean(stringTokenizer.nextToken());
            boolean bl3 = new Boolean(stringTokenizer.nextToken());
            String string4 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            String string5 = stringTokenizer.nextToken();
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            int n5 = Integer.parseInt(stringTokenizer.nextToken());
            int n6 = Integer.parseInt(stringTokenizer.nextToken());
            int n7 = Integer.parseInt(stringTokenizer.nextToken());
            int n8 = Integer.parseInt(stringTokenizer.nextToken());
            int n9 = Integer.parseInt(stringTokenizer.nextToken());
            boolean bl4 = new Boolean(stringTokenizer.nextToken());
            boolean bl5 = new Boolean(stringTokenizer.nextToken());
            String[] stringArray = new String[]{"Java2D!"};
            String string6 = "Java2D!";
            this.fp.getClass();
            if (n8 == 2) {
                int n10 = stringTokenizer.countTokens();
                int n11 = 0;
                if (n10 != 0) {
                    stringArray = new String[n10];
                    string6 = "";
                    while (stringTokenizer.hasMoreElements()) {
                        stringArray[n11] = stringTokenizer.nextToken();
                        string6 = string6 + stringArray[n11] + "\n";
                        ++n11;
                    }
                }
            }
            this.displayGridCBMI.setState(bl);
            this.force16ColsCBMI.setState(bl2);
            this.showFontInfoCBMI.setState(bl3);
            this.rm.setSelectedRange(string4, n2, n3);
            this.fontMenu.setSelectedItem(string5);
            this.sizeField.setText(String.valueOf(n4));
            this.styleMenu.setSelectedIndex(n5);
            this.transformMenu.setSelectedIndex(n6);
            this.transformMenuG2.setSelectedIndex(n7);
            this.textMenu.setSelectedIndex(n8);
            this.methodsMenu.setSelectedIndex(n9);
            this.useAntialiasCB.setSelected(bl4);
            this.useFractionalCB.setSelected(bl5);
            this.userTextArea.setText(string6);
            this.updateGUI();
            if (n8 == this.fp.FILE_TEXT) {
                this.tFileName = stringTokenizer.nextToken();
                this.readTextFile(this.tFileName);
            }
            this.fp.loadOptions(bl, bl2, n2, n3, string5, n4, n5, n6, n7, n8, n9, bl4, bl5, stringArray);
            if (bl3) {
                this.fireUpdateFontInfo();
                this.fontInfoDialog.show();
            } else {
                this.fontInfoDialog.hide();
            }
        }
        catch (Exception exception) {
            this.fireChangeStatus("ERROR: Failed to Load Options File; See Stack Trace", true);
            exception.printStackTrace();
        }
    }

    private void loadComparisonJPEG(String string) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)bufferedInputStream);
            BufferedImage bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
            bufferedInputStream.close();
            JFrame jFrame = new JFrame("Comparison JPEG");
            ImagePanel imagePanel = new ImagePanel(bufferedImage);
            jFrame.setResizable(false);
            jFrame.getContentPane().add(imagePanel);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ((JFrame)windowEvent.getSource()).dispose();
                }
            });
            jFrame.pack();
            jFrame.show();
        }
        catch (Exception exception) {
            this.fireChangeStatus("ERROR: Failed to Load JPEG File; See Stack Trace", true);
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            String string = jMenuItem.getLabel();
            if (string.equals("Save Selected Options...")) {
                String string2 = this.promptFile(true, "options.txt");
                if (string2 == null) return;
                this.writeCurrentOptions(string2);
                return;
            }
            if (string.equals("Load Options...")) {
                String string3 = this.promptFile(false, "options.txt");
                if (string3 == null) return;
                this.loadOptions(string3);
                return;
            }
            if (string.equals("Save as JPEG...")) {
                String string4 = this.promptFile(true, this.fontMenu.getSelectedItem() + ".jpeg");
                if (string4 == null) return;
                this.fp.doSaveJPEG(string4);
                return;
            }
            if (string.equals("Load JPEG File to Compare...")) {
                String string5 = this.promptFile(false, null);
                if (string5 == null) return;
                this.loadComparisonJPEG(string5);
                return;
            }
            if (string.equals("Page Setup...")) {
                this.fp.doPageSetup();
                return;
            }
            if (string.equals("Print...")) {
                this.printDialog.show();
                return;
            }
            if (string.equals("Close")) {
                this.parent.dispose();
                return;
            }
            if (!string.equals("Exit")) return;
            System.exit(0);
            return;
        }
        if (object instanceof JTextField) {
            JTextField jTextField = (JTextField)object;
            int n = 12;
            try {
                n = Integer.parseInt(this.sizeField.getText());
                if (n < 1 || n > 120) {
                    n = 12;
                    this.sizeField.setText("12");
                }
            }
            catch (Exception exception) {
                this.sizeField.setText("12");
            }
            if (jTextField != this.sizeField) return;
            this.fp.setFontParams(this.fontMenu.getSelectedItem(), n, this.styleMenu.getSelectedIndex(), this.transformMenu.getSelectedIndex());
            return;
        }
        if (object instanceof JButton) {
            String string = ((JButton)object).getLabel();
            if (string.equals("Print")) {
                int n = 0;
                while (n < this.printModeCBs.length) {
                    if (this.printModeCBs[n].isSelected()) {
                        this.printDialog.hide();
                        this.fp.doPrint(n);
                    }
                    ++n;
                }
                return;
            }
            if (string.equals("Cancel")) {
                this.printDialog.hide();
                return;
            }
            if (!string.equals("Update")) return;
            this.fp.getClass();
            this.fp.setTextToDraw(2, null, this.parseUserText(this.userTextArea.getText()), null);
            return;
        }
        if (!(object instanceof JComboBox)) return;
        JComboBox jComboBox = (JComboBox)object;
        if (jComboBox == this.fontMenu || jComboBox == this.styleMenu || jComboBox == this.transformMenu) {
            this.fp.setFontParams(this.fontMenu.getSelectedItem(), Integer.parseInt(this.sizeField.getText()), this.styleMenu.getSelectedIndex(), this.transformMenu.getSelectedIndex());
            return;
        }
        if (jComboBox == this.methodsMenu) {
            this.fp.setDrawMethod(this.methodsMenu.getSelectedIndex());
            return;
        }
        if (jComboBox != this.textMenu) {
            if (jComboBox != this.transformMenuG2) return;
            this.fp.setTransformG2(this.transformMenuG2.getSelectedIndex());
            return;
        }
        int n = this.textMenu.getSelectedIndex();
        this.fp.getClass();
        if (n == 0) {
            this.fp.getClass();
            this.fp.setTextToDraw(0, this.rm.getSelectedRange(), null, null);
        } else {
            this.fp.getClass();
            if (n == 2) {
                this.fp.getClass();
                this.fp.setTextToDraw(2, null, this.parseUserText(this.userTextArea.getText()), null);
            } else if (n == this.fp.FILE_TEXT) {
                String string = this.promptFile(false, null);
                if (string == null) {
                    jComboBox.setSelectedIndex(this.currentTextChoice);
                    return;
                }
                this.tFileName = string;
                this.readTextFile(string);
            } else {
                this.fp.getClass();
                if (n == 1) {
                    this.fp.getClass();
                    this.fp.setTextToDraw(1, null, null, null);
                }
            }
        }
        this.updateGUI();
        this.currentTextChoice = n;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)object;
            if (jCheckBoxMenuItem == this.displayGridCBMI) {
                this.fp.setGridDisplay(this.displayGridCBMI.getState());
            } else if (jCheckBoxMenuItem == this.force16ColsCBMI) {
                this.fp.setForce16Columns(this.force16ColsCBMI.getState());
            } else if (jCheckBoxMenuItem == this.showFontInfoCBMI) {
                if (this.showFontInfoCBMI.getState()) {
                    this.fireUpdateFontInfo();
                    this.fontInfoDialog.show();
                } else {
                    this.fontInfoDialog.hide();
                }
            }
        } else if (object instanceof JCheckBox) {
            this.fp.setRenderingHints(this.useAntialiasCB.isSelected(), this.useFractionalCB.isSelected());
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Font2DTest");
        final Font2DTest font2DTest = new Font2DTest(jFrame, false);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowOpening(WindowEvent windowEvent) {
                font2DTest.repaint();
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(font2DTest);
        jFrame.pack();
        jFrame.show();
    }

    private final class CheckboxMenuItemV2
    extends JCheckBoxMenuItem {
        public CheckboxMenuItemV2(String string, boolean bl, ItemListener itemListener) {
            super(string, bl);
            this.addItemListener(itemListener);
        }
    }

    private final class MenuItemV2
    extends JMenuItem {
        public MenuItemV2(String string, ActionListener actionListener) {
            super(string);
            this.addActionListener(actionListener);
        }
    }

    private final class LabelV2
    extends JLabel {
        public LabelV2(String string) {
            super(string);
            this.setFont(Font2DTest.this.labelFont);
        }
    }

    private final class ChoiceV2
    extends JComboBox {
        public ChoiceV2() {
        }

        public ChoiceV2(ActionListener actionListener) {
            this.addActionListener(actionListener);
        }
    }

    private final class ButtonV2
    extends JButton {
        public ButtonV2(String string, ActionListener actionListener) {
            super(string);
            this.setFont(Font2DTest.this.labelFont);
            this.addActionListener(actionListener);
        }
    }

    private final class ImagePanel
    extends JPanel {
        private final BufferedImage bi;

        public ImagePanel(BufferedImage bufferedImage) {
            this.bi = bufferedImage;
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.bi.getWidth(), this.bi.getHeight());
        }

        public void paintComponent(Graphics graphics) {
            graphics.drawImage(this.bi, 0, 0, this);
        }
    }
}

