/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.TabContext;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;

class GTKEngine {
    static final GTKEngine INSTANCE = new GTKEngine();
    static final int[] DEFAULT_FOCUS_PATTERN = new int[]{1, 1};

    GTKEngine() {
    }

    void _paintFocus(Graphics graphics, int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        int n7;
        graphics.translate(n2, n3);
        int n8 = n7 = n6 / 2;
        int n9 = 0;
        int n10 = n4 - n6;
        int n11 = n10 + n5 - n6;
        int n12 = n11 + n4 - n6;
        int n13 = n12 + n5;
        while (n8 < n13) {
            int n14 = n8 + nArray[n9];
            if (n9 % 2 == 0) {
                int n15;
                int n16;
                if (n8 < n10) {
                    graphics.fillRect(n8, 0, Math.min(n14, n4) - n8, n6);
                    n8 = Math.min(n14, n10);
                }
                if (n8 != n14 && n8 < n11) {
                    graphics.fillRect(n4 - n6, n8 - n10, n6, Math.min(n11, n14) - n8);
                    n8 = Math.min(n11, n14);
                }
                if (n8 != n14 && n8 < n12) {
                    n16 = n4 - (n8 - n11);
                    n15 = Math.min(n14 - n8, n12 - n8);
                    graphics.fillRect(n16 - n15, n5 - n6, n15, n6);
                    n8 += n15;
                }
                if (n8 != n14) {
                    n16 = n5 - (n8 - n12);
                    n15 = Math.min(n14 - n8, n13 - n8);
                    graphics.fillRect(0, n16 - n15, n6, n15);
                    n8 += n15;
                }
            } else {
                n8 = n14;
            }
            n9 = (n9 + 1) % nArray.length;
        }
        graphics.translate(-n2, -n3);
    }

    static int adjustAxisForComponentOrientation(JComponent jComponent, int n2) {
        if (jComponent.getComponentOrientation().isLeftToRight()) {
            return n2;
        }
        switch (n2) {
            case 3: {
                return 7;
            }
            case 7: {
                return 3;
            }
        }
        return n2;
    }

    Color getFocusColor(SynthContext synthContext, int n2) {
        return ((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n2, ColorType.FOREGROUND);
    }

    private void paintHollowTriangle(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n7 = n5 / 2;
        int n8 = n5 / 2 + 1;
        int n9 = Math.max(1, n5 / 7);
        graphics.translate(n3, n4);
        Color color = gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n2, GTKColorType.FOREGROUND);
        Color color2 = gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n2, GTKColorType.BACKGROUND);
        switch (n6) {
            case 1: {
                int n10;
                int n11;
                int n12 = n5 / 2 + n8 / 2 - 1;
                graphics.setColor(color2);
                for (n11 = n8 - 1; n11 > 0; --n11) {
                    graphics.drawLine(n7 - n11 + 1, n12, n7 + n11 - 1, n12);
                    --n12;
                }
                graphics.setColor(color);
                n12 = n5 / 2 + n8 / 2 - 1;
                int n13 = n9 - 1;
                for (n10 = 0; n10 < n9; ++n10) {
                    graphics.drawLine(0 - n13, n12 - n10, n5 + n13, n12 - n10);
                    --n13;
                }
                --n12;
                for (n11 = n8 - 1; n11 > 0; --n11) {
                    for (n10 = 0; n10 < n9; ++n10) {
                        graphics.drawLine(n7 - n11 + 1 - n10, n12, n7 - n11 + 1 - n10, n12);
                        graphics.drawLine(n7 + n11 - 1 + n10, n12, n7 + n11 - 1 + n10, n12);
                    }
                    --n12;
                }
                if (n9 <= 1) break;
                for (n10 = n9 - 2; n10 >= 0; --n10) {
                    graphics.drawLine(n7 - n10, n12, n7 + n10, n12);
                    --n12;
                }
                break;
            }
            case 5: {
                int n14;
                int n15;
                int n16 = n5 / 2 - n8 / 2 - 1;
                graphics.setColor(color2);
                for (n15 = n8 - 1; n15 > 0; --n15) {
                    graphics.drawLine(n7 - n15 + 1, n16, n7 + n15 - 1, n16);
                    ++n16;
                }
                graphics.setColor(color);
                n16 = n5 / 2 - n8 / 2 - 1;
                int n17 = n9 - 1;
                for (n14 = 0; n14 < n9; ++n14) {
                    graphics.drawLine(0 - n17, n16 + n14, n5 + n17, n16 + n14);
                    --n17;
                }
                ++n16;
                for (n15 = n8 - 1; n15 > 0; --n15) {
                    for (n14 = 0; n14 < n9; ++n14) {
                        graphics.drawLine(n7 - n15 + 1 - n14, n16, n7 - n15 + 1 - n14, n16);
                        graphics.drawLine(n7 + n15 - 1 + n14, n16, n7 + n15 - 1 + n14, n16);
                    }
                    ++n16;
                }
                if (n9 <= 1) break;
                for (n14 = n9 - 2; n14 >= 0; --n14) {
                    graphics.drawLine(n7 - n14, n16, n7 + n14, n16);
                    ++n16;
                }
                break;
            }
            case 7: {
                int n18;
                int n19;
                int n20 = n5 / 2 + n8 / 2 - 1;
                graphics.setColor(color2);
                for (n19 = n8 - 1; n19 > 0; --n19) {
                    graphics.drawLine(n20, n7 - n19 + 1, n20, n7 + n19 - 1);
                    --n20;
                }
                graphics.setColor(color);
                n20 = n5 / 2 + n8 / 2 - 1;
                int n21 = n9 - 1;
                for (n18 = 0; n18 < n9; ++n18) {
                    graphics.drawLine(n20 - n18, 0 - n21, n20 - n18, n5 + n21);
                    --n21;
                }
                --n20;
                for (n19 = n8 - 1; n19 > 0; --n19) {
                    for (n18 = 0; n18 < n9; ++n18) {
                        graphics.drawLine(n20, n7 - n19 + 1 - n18, n20, n7 - n19 + 1 - n18);
                        graphics.drawLine(n20, n7 + n19 - 1 + n18, n20, n7 + n19 - 1 + n18);
                    }
                    --n20;
                }
                if (n9 <= 1) break;
                for (n18 = n9 - 2; n18 >= 0; --n18) {
                    graphics.drawLine(n20, n7 - n18, n20, n7 + n18);
                    --n20;
                }
                break;
            }
            case 3: {
                int n22;
                int n23;
                int n24 = n5 / 2 - n8 / 2 - 1;
                graphics.setColor(color2);
                for (n23 = n8 - 1; n23 > 0; --n23) {
                    graphics.drawLine(n24, n7 - n23 + 1, n24, n7 + n23 - 1);
                    ++n24;
                }
                graphics.setColor(color);
                n24 = n5 / 2 - n8 / 2 - 1;
                int n25 = n9 - 1;
                for (n22 = 0; n22 < n9; ++n22) {
                    graphics.drawLine(n24 + n22, 0 - n25, n24 + n22, n5 + n25);
                    --n25;
                }
                ++n24;
                for (n23 = n8 - 1; n23 > 0; --n23) {
                    for (n22 = 0; n22 < n9; ++n22) {
                        graphics.drawLine(n24, n7 - n23 + 1 - n22, n24, n7 - n23 + 1 - n22);
                        graphics.drawLine(n24, n7 + n23 - 1 + n22, n24, n7 + n23 - 1 + n22);
                    }
                    ++n24;
                }
                if (n9 <= 1) break;
                for (n22 = n9 - 2; n22 >= 0; --n22) {
                    graphics.drawLine(n24, n7 - n22, n24, n7 + n22);
                    ++n24;
                }
                break;
            }
        }
        graphics.translate(-n3, -n4);
    }

    void paintBackground(SynthContext synthContext, Graphics graphics, int n2, Color color, int n3, int n4, int n5, int n6) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if (gTKStyle.fillBackground(synthContext, n2)) {
            graphics.setColor(color);
            graphics.fillRect(n3, n4, n5, n6);
        } else {
            int n7;
            int n8;
            Image image = gTKStyle.getBackgroundImage(synthContext, n2);
            if (image != null && (n8 = image.getWidth(null)) > 0 && (n7 = image.getHeight(null)) > 0) {
                Serializable serializable;
                int n9 = n3;
                int n10 = n4;
                Container container = synthContext.getComponent().getParent();
                while (container != null && !(container instanceof Window) && !(container instanceof Applet)) {
                    serializable = container.getParent();
                    if (container instanceof JRootPane && !(serializable instanceof Window) && !(serializable instanceof Applet)) {
                        n9 += container.getX();
                        n10 += container.getY();
                    }
                    container = serializable;
                }
                n9 %= n8;
                n10 %= n7;
                serializable = graphics.getClipRect();
                int n11 = ((Rectangle)serializable).x;
                int n12 = ((Rectangle)serializable).y;
                int n13 = n11 + ((Rectangle)serializable).width;
                int n14 = n12 + ((Rectangle)serializable).height;
                int n15 = n10;
                int n16 = n4 + n6;
                for (int i2 = n4; i2 < n16; i2 += n7 - n15) {
                    int n17 = n9;
                    int n18 = n3 + n5;
                    for (int i3 = n3; i3 < n18; i3 += n8 - n17) {
                        int n19 = Math.min(n18, i3 + n8 - n17);
                        int n20 = Math.min(n16, i2 + n7 - n15);
                        if (n19 > n11 && n20 > n12 && n13 > i3 && n14 > i2) {
                            graphics.drawImage(image, i3, i2, n19, n20, n17, n15, n17 + n19 - i3, n15 + n20 - i2, null);
                        }
                        n17 = 0;
                    }
                    n15 = 0;
                }
            }
        }
    }

    public void paintArrow(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, String string, int n5, int n6, int n7, int n8) {
        int n9 = n7 / 2;
        if (n7 % 2 == 1) {
            ++n9;
        }
        int n10 = n8 / 2;
        if (n8 % 2 == 1) {
            ++n10;
        }
        int n11 = Math.max(2, Math.min(n9, n10));
        switch (n4) {
            case 100: {
                n5 += n7 / 2 - 1;
                n6 += (n8 - n11) / 2;
                break;
            }
            case 101: {
                n5 += n7 / 2 - 1;
                n6 += (n8 - n11) / 2 + 1;
                break;
            }
            case 102: {
                n5 += (n7 - n11) / 2;
                n6 += n8 / 2 - 1;
                break;
            }
            case 103: {
                n5 += (n7 - n11) / 2 + 1;
                n6 += n8 / 2 - 1;
            }
        }
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n12 = 0;
        int n13 = n11 / 2 - 1;
        graphics.translate(n5, n6);
        if (n2 == 8) {
            graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n2, GTKColorType.WHITE));
        } else {
            graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n2, GTKColorType.FOREGROUND));
        }
        switch (n4) {
            case 100: {
                for (int i2 = 0; i2 < n11; ++i2) {
                    graphics.drawLine(n13 - i2, i2, n13 + i2, i2);
                }
                break;
            }
            case 101: {
                n12 = 0;
                for (int i3 = n11 - 1; i3 >= 0; --i3) {
                    graphics.drawLine(n13 - i3, n12, n13 + i3, n12);
                    ++n12;
                }
                break;
            }
            case 102: {
                for (int i4 = 0; i4 < n11; ++i4) {
                    graphics.drawLine(i4, n13 - i4, i4, n13 + i4);
                }
                break;
            }
            case 103: {
                n12 = 0;
                for (int i5 = n11 - 1; i5 >= 0; --i5) {
                    graphics.drawLine(n12, n13 - i5, n12, n13 + i5);
                    ++n12;
                }
                break;
            }
        }
        graphics.translate(-n5, -n6);
    }

    public void paintBox(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        Region region = synthContext.getRegion();
        this.paintBackground(synthContext, graphics, n2, gTKStyle.getGTKColor(synthContext.getComponent(), region, n2, GTKColorType.BACKGROUND), n4, n5, n6, n7);
        this.paintShadow(synthContext, graphics, n2, n3, string, n4, n5, n6, n7);
    }

    public void paintCheck(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        int n8 = synthContext.getComponentState();
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if ("checkbutton" == string) {
            if ((n8 & 4) == 0) {
                this.paintBox(synthContext, graphics, 1, 0, string, n4, n5, n6, n7);
                graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.WHITE));
            } else {
                this.paintBox(synthContext, graphics, 4, 0, string, n4, n5, n6, n7);
                graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.BACKGROUND));
            }
        }
        graphics.translate(n4, n5);
        int n9 = n7 / 2 - 1;
        if ("checkbutton" == string) {
            graphics.fillRect(2, 2, n6 - 4, n7 - 4);
        }
        if ((n8 & 0x200) != 0) {
            graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.BLACK));
            graphics.drawLine(3, n9 + 2, 4, n9 + 2);
            graphics.drawLine(5, n9 + 3, 6, n9 + 3);
            graphics.drawLine(6, n9 + 2, 6, n9 + 4);
            graphics.drawLine(7, n9 + 1, 7, n9);
            graphics.drawLine(7, n9, 8, n9);
            graphics.drawLine(8, n9, 8, n9 - 1);
            graphics.drawLine(8, n9 - 1, 9, n9 - 1);
            graphics.drawLine(9, n9 - 1, 9, n9 - 2);
            if ((n8 & 4) != 0) {
                graphics.setColor(gTKStyle.getGTKColor(jComponent, region, 4, GTKColorType.DARK));
            } else {
                graphics.setColor(gTKStyle.getGTKColor(jComponent, region, 1, GTKColorType.DARK));
            }
            graphics.drawLine(3, n9 + 1, 4, n9 + 1);
            graphics.drawLine(4, n9 + 3, 4, n9 + 3);
            graphics.drawLine(5, n9 + 2, 5, n9 + 2);
            graphics.drawLine(6, n9 + 1, 6, n9 + 1);
            graphics.drawLine(7, n9 + 2, 7, n9 + 2);
            graphics.drawLine(10, n9 - 2, 10, n9 - 2);
        }
        graphics.translate(-n4, -n5);
    }

    public void paintExpander(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        if (n3 == 0) {
            if (n2 != 2) {
                this.paintHollowTriangle(synthContext, graphics, n2, n4, n5, Math.min(n6, n7), GTKEngine.adjustAxisForComponentOrientation(synthContext.getComponent(), 3));
            }
        } else if (n2 != 2) {
            this.paintHollowTriangle(synthContext, graphics, n2, n4, n5, Math.min(n6, n7), 5);
        }
    }

    public void paintOption(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        graphics.translate(n4, n5);
        int n8 = synthContext.getComponentState();
        int n9 = n7 / 2 - 1;
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if ((n8 & 4) == 0) {
            graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.WHITE));
        } else {
            graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.MID));
        }
        if (region != Region.RADIO_BUTTON_MENU_ITEM) {
            graphics.fillOval(1, 0, 11, 11);
            graphics.drawLine(13, n9 - 1, 13, n9 + 2);
            graphics.drawLine(12, n9 + 3, 12, n9 + 4);
            graphics.drawLine(11, n9 + 5, 11, n9 + 5);
            graphics.drawLine(9, n9 + 6, 10, n9 + 6);
            graphics.drawLine(5, n9 + 7, 8, n9 + 7);
            graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.DARK));
            graphics.drawOval(1, 0, 11, 11);
            graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.BLACK));
            graphics.drawLine(5, n9 - 4, 8, n9 - 4);
            graphics.drawLine(9, n9 - 4, 10, n9 - 3);
            graphics.drawLine(3, n9 - 3, 4, n9 - 3);
            graphics.drawLine(3, n9 - 2, 2, n9 - 1);
            graphics.drawLine(2, n9, 2, n9 + 2);
            graphics.drawLine(2, n9 + 3, 3, n9 + 4);
        }
        if ((n8 & 0x200) != 0) {
            if (region == Region.RADIO_BUTTON_MENU_ITEM) {
                graphics.setColor(gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.BLACK));
            }
            graphics.fillRect(5, n9, 5, 3);
            graphics.drawLine(6, n9 - 1, 8, n9 - 1);
            graphics.drawLine(6, n9 + 3, 8, n9 + 3);
        }
        graphics.translate(-n4, -n5);
    }

    public void paintShadow(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        if (string == "buttondefault") {
            graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n2, GTKColorType.BLACK));
            graphics.drawRect(n4, n5, n6 - 1, n7 - 1);
            return;
        }
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        int n8 = gTKStyle.getXThickness();
        int n9 = gTKStyle.getYThickness();
        if (string == "trough" || string == "spinbutton" && jComponent instanceof JButton) {
            n9 = 1;
            n8 = 1;
        }
        if (n8 < 0 && n9 < 0) {
            return;
        }
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        Color color4 = null;
        switch (n3) {
            case 0: {
                if (string == "spinbutton" && jComponent instanceof JButton) {
                    color4 = color = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.DARK);
                    color3 = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.BLACK);
                    break;
                }
                color = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.DARK);
                color2 = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.BLACK);
                color3 = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.LIGHT);
                color4 = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.BACKGROUND);
                break;
            }
            case 1: {
                color = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.LIGHT);
                color2 = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.BACKGROUND);
                color3 = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.BLACK);
                color4 = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.DARK);
                break;
            }
        }
        if (string == "spinbutton" && jComponent instanceof JButton) {
            this._paintSpinButtonShadow(graphics, n4, n5, n6, n7, n8, n9, color, color2, color3, color4);
        } else {
            this._paintShadow(graphics, n4, n5, n6, n7, n8, n9, color, color2, color3, color4);
        }
    }

    public void paintExtension(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8) {
        this._paintExtension(synthContext, graphics, n2, n3, n4, n5, n6, n7, n8, GTKColorType.LIGHT, GTKColorType.BACKGROUND, GTKColorType.BLACK, GTKColorType.DARK, false);
    }

    public void paintHandle(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8) {
        this.paintBox(synthContext, graphics, n2, n3, string, n4, n5, n6, n7);
        graphics.translate(n4, n5);
        Region region = synthContext.getRegion();
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        JComponent jComponent = synthContext.getComponent();
        Color color = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.LIGHT);
        Color color2 = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.DARK);
        Color color3 = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.BLACK);
        if (string == "paned") {
            int n9;
            int n10;
            JSplitPane jSplitPane = (JSplitPane)jComponent;
            int n11 = 33;
            if (n8 == 0) {
                n10 = n6 / 2 - n11 / 2;
                n9 = jSplitPane.getDividerSize() / 2 - 1;
            } else {
                n10 = jSplitPane.getDividerSize() / 2 - 1;
                n9 = n7 / 2 - n11 / 2;
            }
            for (int i2 = 0; i2 < 7; ++i2) {
                if (n8 == 0) {
                    n10 += 5;
                } else {
                    n9 += 5;
                }
                graphics.setColor(color);
                graphics.fillRect(n10, n9, 2, 2);
                graphics.setColor(color3);
                graphics.fillRect(n10 + 1, n9 + 1, 2, 2);
                graphics.setColor(color2);
                graphics.fillRect(n10 + 1, n9 + 1, 1, 1);
            }
        } else if (string == "handlebox") {
            int n12;
            int n13;
            JToolBar jToolBar = (JToolBar)jComponent;
            if (jToolBar.getOrientation() == 0) {
                for (n13 = 2; n13 < n7; n13 += 3) {
                    graphics.setColor(color2);
                    graphics.fillRect(n12 + 1, n13 + 1, 2, 2);
                    graphics.fillRect(n12 + 4, n13 + 2, 2, 2);
                    graphics.setColor(color);
                    graphics.fillRect(n12, n13, 2, 2);
                    graphics.fillRect(n12 + 3, n13 + 1, 2, 2);
                }
            } else {
                boolean bl2 = true;
                for (n12 = 2; n12 < n6; n12 += 3) {
                    graphics.setColor(color2);
                    graphics.fillRect(n12 + 1, n13 + 1, 2, 2);
                    graphics.fillRect(n12 + 1, n13 + 4, 2, 2);
                    graphics.setColor(color);
                    graphics.fillRect(n12, n13, 2, 2);
                    graphics.fillRect(n12, n13 + 3, 2, 2);
                    if (bl2) {
                        ++n13;
                        bl2 = false;
                        continue;
                    }
                    --n13;
                    bl2 = true;
                }
            }
            this.paintShadow(synthContext, graphics, n2, n3, string, 0, 0, n6, n7);
        }
        graphics.translate(-n4, -n5);
    }

    public void paintSlider(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8) {
        this.paintBox(synthContext, graphics, n2, n3, string, n4, n5, n6, n7);
        if (synthContext.getRegion() == Region.SLIDER_THUMB) {
            if (n8 == 0) {
                this.paintVline(synthContext, graphics, n2, string, n4 + n6 / 2 - 1, n5 + 2, 2, n7 - 4);
            } else {
                this.paintHline(synthContext, graphics, n2, string, n4 + 2, n5 + n7 / 2 - 1, n6 - 4, 2);
            }
        }
    }

    public void paintBoxGap(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this._paintBoxGap(synthContext, graphics, n2, n3, n4, n5, n6, n7, n8, n9, n10, GTKColorType.BACKGROUND, GTKColorType.LIGHT, GTKColorType.BLACK, GTKColorType.DARK, false);
    }

    public void paintFlatBox(SynthContext synthContext, Graphics graphics, int n2, String string, int n3, int n4, int n5, int n6) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if (string == "cell_odd") {
            graphics.fillRect(n3, n4, n5, n6);
        } else {
            this.paintBackground(synthContext, graphics, n2, graphics.getColor(), n3, n4, n5, n6);
        }
        if (string == "tooltip") {
            graphics.setColor(Color.BLACK);
            graphics.drawRect(n3, n4, n5 - 1, n6 - 1);
        }
    }

    void paintFlatBoxNormal(SynthContext synthContext, Graphics graphics, int n2, String string, int n3, int n4, int n5, int n6) {
        graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n2, GTKColorType.BACKGROUND));
        this.paintFlatBox(synthContext, graphics, n2, string, n3, n4, n5, n6);
    }

    void paintFlatBoxText(SynthContext synthContext, Graphics graphics, int n2, String string, int n3, int n4, int n5, int n6) {
        graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n2, GTKColorType.TEXT_BACKGROUND));
        this.paintFlatBox(synthContext, graphics, n2, string, n3, n4, n5, n6);
    }

    public void paintFocus(SynthContext synthContext, Graphics graphics, int n2, String string, int n3, int n4, int n5, int n6) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int[] nArray = (int[])gTKStyle.getClassSpecificValue(synthContext, "focus-line-pattern");
        int n7 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        if (nArray == null) {
            nArray = DEFAULT_FOCUS_PATTERN;
        }
        if (n7 <= 0) {
            return;
        }
        graphics.setColor(this.getFocusColor(synthContext, n2));
        this._paintFocus(graphics, n3, n4, n5, n6, nArray, n7);
    }

    public void paintHline(SynthContext synthContext, Graphics graphics, int n2, String string, int n3, int n4, int n5, int n6) {
        graphics.translate(n3, n4);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n7 = n6 / 2;
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n2, GTKColorType.DARK));
        graphics.drawLine(0, n7, n5 - 2, n7);
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n2, GTKColorType.LIGHT));
        graphics.drawLine(0, n7 + 1, n5 - 1, n7 + 1);
        graphics.drawLine(n5 - 1, n7, n5 - 1, n7 + 1);
        graphics.translate(-n3, -n4);
    }

    public void paintVline(SynthContext synthContext, Graphics graphics, int n2, String string, int n3, int n4, int n5, int n6) {
        graphics.translate(n3, n4);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n7 = n5 / 2;
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n2, GTKColorType.DARK));
        graphics.drawLine(n7, 0, n7, n6 - 2);
        graphics.drawLine(n7, 0, n7 + 1, 0);
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n2, GTKColorType.LIGHT));
        graphics.drawLine(n7 + 1, 1, n7 + 1, n6 - 1);
        graphics.drawLine(n7, n6 - 1, n7 + 1, n6 - 1);
        graphics.translate(-n3, -n4);
    }

    void _paintShadow(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, Color color, Color color2, Color color3, Color color4) {
        graphics.translate(n2, n3);
        graphics.setColor(color);
        if (n6 > 0) {
            graphics.drawLine(0, 0, 0, n5 - 1);
        }
        if (n7 > 0) {
            graphics.drawLine(1, 0, n4 - 1, 0);
        }
        if (n6 > 1 || n7 > 1) {
            graphics.setColor(color2);
            if (n6 > 1) {
                graphics.drawLine(1, 1, 1, n5 - 2);
            }
            if (n7 > 1) {
                graphics.drawLine(2, 1, n4 - 2, 1);
            }
        }
        graphics.setColor(color3);
        if (n6 > 0) {
            graphics.drawLine(n4 - 1, 1, n4 - 1, n5 - 1);
        }
        if (n7 > 0) {
            graphics.drawLine(1, n5 - 1, n4 - 2, n5 - 1);
        }
        if (n6 > 1 || n7 > 1) {
            graphics.setColor(color4);
            if (n6 > 1) {
                graphics.drawLine(n4 - 2, 2, n4 - 2, n5 - 2);
            }
            if (n7 > 1) {
                graphics.drawLine(2, n5 - 2, n4 - 3, n5 - 2);
            }
        }
        graphics.translate(-n2, -n3);
    }

    void _paintSpinButtonShadow(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, Color color, Color color2, Color color3, Color color4) {
        graphics.translate(n2, n3);
        graphics.setColor(color);
        graphics.drawLine(0, 0, n4 - 1, 0);
        graphics.setColor(color4);
        graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
        graphics.setColor(color3);
        graphics.drawLine(0, 0, 0, n5 - 1);
        graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
        graphics.translate(-n2, -n3);
    }

    void _paintBoxGap(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, ColorType colorType, ColorType colorType2, ColorType colorType3, ColorType colorType4, boolean bl2) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        this.paintBackground(synthContext, graphics, n2, gTKStyle.getGTKColor(jComponent, region, n2, colorType), n4, n5, n6, n7);
        int n11 = n9 + n10;
        Color color = gTKStyle.getGTKColor(jComponent, region, n2, colorType2);
        Color color2 = gTKStyle.getGTKColor(jComponent, region, n2, colorType3);
        Color color3 = gTKStyle.getGTKColor(jComponent, region, n2, colorType4);
        Color color4 = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.WHITE);
        graphics.translate(n4, n5);
        if (n8 == 2) {
            graphics.setColor(color2);
            graphics.drawLine(0, n7 - 1, n6 - 1, n7 - 1);
            graphics.setColor(color3);
            graphics.drawLine(1, n7 - 2, n6 - 2, n7 - 2);
            graphics.setColor(color);
            graphics.drawLine(0, 0, 0, n7 - 2);
            if (bl2) {
                graphics.setColor(color4);
                graphics.drawLine(1, 0, 1, n7 - 3);
            }
            graphics.setColor(color2);
            graphics.drawLine(n6 - 1, 0, n6 - 1, n7 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n6 - 2, 0, n6 - 2, n7 - 2);
            if (n9 > 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, n9, 0);
            }
            graphics.setColor(color);
            graphics.drawLine(n11, 0, n6 - 2, 0);
            if (bl2) {
                graphics.setColor(color4);
                if (n9 > 0) {
                    graphics.drawLine(0, 1, n9, 1);
                }
                graphics.drawLine(n11, 1, n6 - 2, 1);
            }
        } else if (n8 == 3) {
            graphics.setColor(color);
            graphics.drawLine(0, 0, n6 - 1, 0);
            if (bl2) {
                graphics.setColor(color4);
                graphics.drawLine(0, 1, n6 - 1, 1);
            }
            graphics.setColor(color);
            graphics.drawLine(0, 0, 0, n7 - 1);
            if (bl2) {
                graphics.setColor(color4);
                graphics.drawLine(1, 1, 1, n7 - 2);
            }
            graphics.setColor(color2);
            graphics.drawLine(n6 - 1, 0, n6 - 1, n7 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n6 - 2, 1, n6 - 2, n7 - 2);
            if (n9 > 0) {
                graphics.setColor(color2);
                graphics.drawLine(0, n7 - 1, n9, n7 - 1);
                graphics.setColor(color3);
                graphics.drawLine(1, n7 - 2, n9, n7 - 2);
            }
            graphics.setColor(color2);
            graphics.drawLine(n11, n7 - 1, n6 - 1, n7 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n11, n7 - 2, n6 - 2, n7 - 2);
        } else if (n8 == 1) {
            graphics.setColor(color);
            graphics.drawLine(0, 0, n6 - 1, 0);
            if (bl2) {
                graphics.setColor(color4);
                graphics.drawLine(0, 1, n6 - 1, 1);
            }
            graphics.setColor(color2);
            graphics.drawLine(0, n7 - 1, n6 - 1, n7 - 1);
            graphics.setColor(color3);
            graphics.drawLine(1, n7 - 2, n6 - 2, n7 - 2);
            graphics.setColor(color);
            graphics.drawLine(0, 0, 0, n7 - 2);
            if (bl2) {
                graphics.setColor(color4);
                graphics.drawLine(1, 1, 1, n7 - 3);
            }
            if (n9 > 0) {
                graphics.setColor(color2);
                graphics.drawLine(n6 - 1, 0, n6 - 1, n9);
                graphics.setColor(color3);
                graphics.drawLine(n6 - 2, 1, n6 - 2, n9);
            }
            graphics.setColor(color2);
            graphics.drawLine(n6 - 1, n11, n6 - 1, n7 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n6 - 2, n11, n6 - 2, n7 - 2);
        } else if (n8 == 0) {
            graphics.setColor(color);
            graphics.drawLine(0, 0, n6 - 2, 0);
            if (bl2) {
                graphics.setColor(color4);
                graphics.drawLine(0, 1, n6 - 2, 1);
            }
            graphics.setColor(color2);
            graphics.drawLine(0, n7 - 1, n6 - 1, n7 - 1);
            graphics.setColor(color3);
            graphics.drawLine(1, n7 - 2, n6 - 2, n7 - 2);
            graphics.setColor(color2);
            graphics.drawLine(n6 - 1, 1, n6 - 1, n7 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n6 - 2, 0, n6 - 2, n7 - 2);
            if (n9 > 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, 0, n9);
            }
            graphics.setColor(color);
            graphics.drawLine(0, n11, 0, n7 - 2);
            if (bl2) {
                graphics.setColor(color4);
                if (n9 > 0) {
                    graphics.drawLine(1, 0, 1, n9);
                }
                graphics.drawLine(1, n11, 1, n7 - 3);
            }
        }
        graphics.translate(-n4, -n5);
    }

    void _paintExtension(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ColorType colorType, ColorType colorType2, ColorType colorType3, ColorType colorType4, boolean bl2) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        TabContext tabContext = (TabContext)synthContext;
        JComponent jComponent = synthContext.getComponent();
        Region region = synthContext.getRegion();
        int n9 = gTKStyle.getXThickness();
        int n10 = gTKStyle.getYThickness();
        if (n9 < 0 && n10 < 0) {
            return;
        }
        Color color = gTKStyle.getGTKColor(jComponent, region, n2, colorType);
        Color color2 = gTKStyle.getGTKColor(jComponent, region, n2, colorType2);
        Color color3 = gTKStyle.getGTKColor(jComponent, region, n2, colorType3);
        Color color4 = gTKStyle.getGTKColor(jComponent, region, n2, colorType4);
        Color color5 = gTKStyle.getGTKColor(jComponent, region, n2, GTKColorType.WHITE);
        int n11 = tabContext.getTabIndex();
        int n12 = ((JTabbedPane)jComponent).getSelectedIndex();
        graphics.translate(n4, n5);
        if (n8 == 3) {
            this.paintBackground(synthContext, graphics, n2, color2, 0, 1, n6, n7);
            if (n11 == n12 || n11 == 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 1, 0, n7 - 1);
                graphics.drawLine(1, 0, n6 - 2, 0);
                if (bl2) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 1, 1, n7 - 1);
                    graphics.drawLine(1, 1, n6 - 3, 1);
                }
            } else {
                graphics.setColor(color);
                graphics.drawLine(0, 0, n6 - 2, 0);
                if (bl2) {
                    graphics.setColor(color5);
                    graphics.drawLine(0, 1, n6 - 3, 1);
                }
            }
            if (n11 + 1 != n12) {
                graphics.setColor(color4);
                graphics.drawLine(n6 - 2, 2, n6 - 2, n7 - 1);
                graphics.setColor(color3);
                graphics.drawLine(n6 - 1, 1, n6 - 1, n7 - 1);
            }
        } else if (n8 == 2) {
            this.paintBackground(synthContext, graphics, n2, color2, 0, 0, n6, n7 - 1);
            if (n11 == n12 || n11 == 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, 0, n7 - 2);
                graphics.setColor(color3);
                graphics.drawLine(1, n7 - 1, n6 - 2, n7 - 1);
                graphics.setColor(color4);
                graphics.drawLine(2, n7 - 2, n6 - 2, n7 - 2);
                if (bl2) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 0, 1, n7 - 2);
                }
            } else {
                graphics.setColor(color3);
                graphics.drawLine(0, n7 - 1, n6 - 2, n7 - 1);
                graphics.setColor(color4);
                graphics.drawLine(0, n7 - 2, n6 - 2, n7 - 2);
                if (bl2) {
                    graphics.setColor(color5);
                    graphics.drawLine(0, 0, 0, n7 - 2);
                }
            }
            if (n11 + 1 != n12) {
                graphics.setColor(color3);
                graphics.drawLine(n6 - 1, 0, n6 - 1, n7 - 2);
                graphics.setColor(color4);
                graphics.drawLine(n6 - 2, 0, n6 - 2, n7 - 2);
            }
        } else if (n8 == 1) {
            this.paintBackground(synthContext, graphics, n2, color2, 1, 0, n6, n7);
            if (n11 == n12 || n11 == 0) {
                graphics.setColor(color);
                graphics.drawLine(1, 0, n6 - 1, 0);
                graphics.drawLine(0, 1, 0, n7 - 2);
                if (bl2) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 1, n6, 1);
                    graphics.drawLine(1, 1, 1, n7 - 3);
                }
            } else {
                graphics.setColor(color);
                graphics.drawLine(0, 0, 0, n7 - 2);
                if (bl2) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 1, 1, n7 - 3);
                }
            }
            if (n11 + 1 != n12) {
                graphics.setColor(color3);
                graphics.drawLine(1, n7 - 1, n6 - 1, n7 - 1);
                graphics.setColor(color4);
                graphics.drawLine(2, n7 - 2, n6 - 1, n7 - 2);
            }
        } else if (n8 == 0) {
            this.paintBackground(synthContext, graphics, n2, color2, 0, 0, n6 - 1, n7);
            if (n11 == n12 || n11 == 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, n6 - 2, 0);
                graphics.setColor(color3);
                graphics.drawLine(n6 - 1, 1, n6 - 1, n7 - 2);
                graphics.setColor(color4);
                graphics.drawLine(n6 - 2, 2, n6 - 2, n7 - 2);
                if (bl2) {
                    graphics.setColor(color5);
                    graphics.drawLine(0, 1, n6 - 2, 1);
                    graphics.drawLine(n6 - 2, 1, n6 - 2, n7 - 3);
                }
            } else {
                graphics.setColor(color3);
                graphics.drawLine(n6 - 1, 0, n6 - 1, n7 - 2);
                graphics.setColor(color4);
                graphics.drawLine(n6 - 2, 0, n6 - 2, n7 - 2);
                if (bl2) {
                    graphics.setColor(color5);
                    graphics.drawLine(n6 - 2, 1, n6 - 2, n7 - 3);
                }
            }
            if (n11 + 1 != n12) {
                graphics.setColor(color3);
                graphics.drawLine(0, n7 - 1, n6 - 2, n7 - 1);
                graphics.setColor(color4);
                graphics.drawLine(0, n7 - 2, n6 - 2, n7 - 2);
            }
        }
        graphics.translate(-n4, -n5);
    }
}

