/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.PixmapStyle;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.security.AccessController;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import sun.security.action.GetPropertyAction;

class PixmapEngine
extends GTKEngine
implements GTKConstants {
    private static final Object RENDERING_HINT = "true".equals((String)AccessController.doPrivileged(new GetPropertyAction("swing.pixmap.smoothScaling"))) ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : null;
    private int _clipX1;
    private int _clipX2;
    private int _clipY1;
    private int _clipY2;

    PixmapEngine() {
    }

    private boolean intersectsClip(int n2, int n3, int n4, int n5) {
        return !(n4 >= n2 && n4 <= this._clipX1 || n5 >= n3 && n5 <= this._clipY1 || this._clipX2 >= this._clipX1 && this._clipX2 <= n2 || this._clipY2 >= this._clipY1 && this._clipY2 <= n3);
    }

    private boolean paintPixmap(Graphics graphics, int n2, int n3, int n4, int n5, PixmapStyle.Info info) {
        if (info != null) {
            Rectangle rectangle = graphics.getClipBounds();
            this._clipX1 = rectangle.x;
            this._clipY1 = rectangle.y;
            this._clipX2 = this._clipX1 + rectangle.width;
            this._clipY2 = this._clipY1 + rectangle.height;
            this.paintImage(graphics, n2, n3, n4, n5, info.getImage(), info.getImageInsets(), info.getStretch(), false);
            this.paintImage(graphics, n2, n3, n4, n5, info.getOverlayImage(), info.getOverlayInsets(), info.getOverlayStretch(), true);
            return true;
        }
        return false;
    }

    private void drawChunk(Image image, Graphics graphics, boolean bl2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl3) {
        if (n4 - n2 <= 0 || n5 - n3 <= 0 || !this.intersectsClip(n2, n3, n4, n5)) {
            return;
        }
        if (bl2) {
            graphics.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, null);
        } else {
            int n10;
            int n11;
            int n12 = n8 - n6;
            int n13 = n9 - n7;
            if (bl3) {
                n11 = n12;
                n10 = 0;
            } else {
                n11 = 0;
                n10 = n13;
            }
            while (n2 < n4 && n3 < n5) {
                int n14;
                int n15 = Math.min(n4, n2 + n12);
                if (this.intersectsClip(n2, n3, n15, n14 = Math.min(n5, n3 + n13))) {
                    graphics.drawImage(image, n2, n3, n15, n14, n6, n7, n6 + n15 - n2, n7 + n14 - n3, null);
                }
                n2 += n11;
                n3 += n10;
            }
        }
    }

    private void paintGapImage(Graphics graphics, int n2, int n3, int n4, int n5, Image image, Insets insets, int n6, int n7, int n8, int n9) {
        if (image != null && n9 > 0) {
            switch (n6) {
                case 0: {
                    this.paintImage(graphics, n2, n3 + n8, Math.min(n4, n7), Math.min(n5 - n3 - n8, n9), image, insets, true, false);
                    break;
                }
                case 1: {
                    this.paintImage(graphics, n2 + n4 - Math.min(n4, n7), n3 + n8, Math.min(n4, n7), Math.min(n5 - n3 - n8, n9), image, insets, true, false);
                    break;
                }
                case 2: {
                    this.paintImage(graphics, n2 + n8, n3, Math.min(n4 - n2 - n8, n9), Math.min(n5, n7), image, insets, true, false);
                    break;
                }
                case 3: {
                    this.paintImage(graphics, n2 + n8, n3 + n5 - Math.min(n5, n7), Math.min(n4 - n2 - n8, n9), Math.min(n5, n7), image, insets, true, false);
                }
            }
        }
    }

    private void paintImage(Graphics graphics, int n2, int n3, int n4, int n5, Image image, Insets insets, boolean bl2, boolean bl3) {
        Object object;
        if (image == null) {
            return;
        }
        if (insets == null) {
            insets = GTKPainter.EMPTY_INSETS;
        }
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        if (n6 <= 0 || n7 <= 0) {
            return;
        }
        Object object2 = RENDERING_HINT;
        if (object2 != null && bl2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (object == null) {
                object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object2);
        } else {
            object = null;
        }
        if (!bl2) {
            if (bl3) {
                graphics.drawImage(image, n2 + n4 / 2 - n6 / 2, n3 + n5 / 2 - n7 / 2, null);
            } else {
                int n8 = 0;
                int n9 = n3 + n5;
                for (int i2 = n3; i2 < n9; i2 += n7 - n8) {
                    int n10 = 0;
                    int n11 = n2 + n4;
                    for (int i3 = n2; i3 < n11; i3 += n6 - n10) {
                        int n12;
                        int n13 = Math.min(n11, i3 + n6 - n10);
                        if (this.intersectsClip(i3, i2, n13, n12 = Math.min(n9, i2 + n7 - n8))) {
                            graphics.drawImage(image, i3, i2, n13, n12, n10, n8, n10 + n13 - i3, n8 + n12 - i2, null);
                        }
                        n10 = 0;
                    }
                    n8 = 0;
                }
            }
        } else {
            int n14 = insets.top;
            int n15 = insets.left;
            int n16 = insets.bottom;
            int n17 = insets.right;
            if (n14 + n16 >= n7 - 3) {
                n16 = n14 = Math.max(0, n7 / 2 - 1);
            }
            if (n15 + n17 >= n6 - 3) {
                n15 = n17 = Math.max(0, n6 / 2 - 1);
            }
            if (n14 + n16 > n5) {
                n14 = n16 = Math.max(2, n5 / 2 - 1);
            }
            if (n15 + n17 > n4) {
                n15 = n17 = Math.max(2, n4 / 2 - 1);
            }
            if (n15 > 0 && n14 + n16 < n7) {
                this.drawChunk(image, graphics, bl2, n2, n3 + n14, n2 + n15, n3 + n5 - n16, 0, n14, n15, n7 - n16, false);
            }
            if (n15 > 0 && n14 > 0) {
                graphics.drawImage(image, n2, n3, n2 + n15, n3 + n14, 0, 0, n15, n14, null);
            }
            if (n14 > 0 && n15 + n17 < n6) {
                this.drawChunk(image, graphics, bl2, n2 + n15, n3, n2 + n4 - n17, n3 + n14, n15, 0, n6 - n17, n14, true);
            }
            if (n17 < n6 && n14 > 0) {
                graphics.drawImage(image, n2 + n4 - n17, n3, n2 + n4, n3 + n14, n6 - n17, 0, n6, n14, null);
            }
            if (n17 < n6 && n14 + n16 < n7) {
                this.drawChunk(image, graphics, bl2, n2 + n4 - n17, n3 + n14, n2 + n4, n3 + n5 - n16, n6 - n17, n14, n6, n7 - n16, false);
            }
            if (n17 < n6 && n16 < n7) {
                graphics.drawImage(image, n2 + n4 - n17, n3 + n5 - n16, n2 + n4, n3 + n5, n6 - n17, n7 - n16, n6, n7, null);
            }
            if (n15 + n17 < n6 && n16 > 0) {
                this.drawChunk(image, graphics, bl2, n2 + n15, n3 + n5 - n16, n2 + n4 - n17, n3 + n5, n15, n7 - n16, n6 - n17, n7, true);
            }
            if (n15 > 0 && n16 > 0) {
                graphics.drawImage(image, n2, n3 + n5 - n16, n2 + n15, n3 + n5, 0, n7 - n16, n15, n7, null);
            }
            if (n15 + n17 < n6 && n14 + n16 < n7) {
                graphics.drawImage(image, n2 + n15, n3 + n14, n2 + n4 - n17, n3 + n5 - n16, n15, n14, n6 - n17, n7 - n16, null);
            }
        }
        if (object != null) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
        }
    }

    public void paintArrow(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, String string, int n5, int n6, int n7, int n8) {
        if (!this.paintPixmap(graphics, n5, n6, n7, n8, ((PixmapStyle)synthContext.getStyle()).getInfo("ARROW", string, n2, n3, -100, -100, n4))) {
            super.paintArrow(synthContext, graphics, n2, n3, n4, string, n5, n6, n7, n8);
        }
    }

    public void paintBox(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        Region region = synthContext.getRegion();
        int n8 = region == Region.SCROLL_BAR ? (((JScrollBar)synthContext.getComponent()).getOrientation() == 0 ? 0 : 1) : (region == Region.SLIDER_TRACK ? (((JSlider)synthContext.getComponent()).getOrientation() == 0 ? 0 : 1) : -100);
        if (!this.paintPixmap(graphics, n4, n5, n6, n7, ((PixmapStyle)synthContext.getStyle()).getInfo("BOX", string, n2, n3, n8, -100, -100))) {
            super.paintBox(synthContext, graphics, n2, n3, string, n4, n5, n6, n7);
        }
    }

    public void paintCheck(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        if (!this.paintPixmap(graphics, n4, n5, n6, n7, ((PixmapStyle)synthContext.getStyle()).getInfo("CHECK", string, n2, n3, -100, -100, -100))) {
            super.paintCheck(synthContext, graphics, n2, n3, string, n4, n5, n6, n7);
        }
    }

    public void paintExpander(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        super.paintExpander(synthContext, graphics, n2, n3, string, n4, n5, n6, n7);
    }

    public void paintOption(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        if (!this.paintPixmap(graphics, n4, n5, n6, n7, ((PixmapStyle)synthContext.getStyle()).getInfo("OPTION", string, n2, n3, -100, -100, -100))) {
            super.paintOption(synthContext, graphics, n2, n3, string, n4, n5, n6, n7);
        }
    }

    public void paintShadow(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        if (!this.paintPixmap(graphics, n4, n5, n6, n7, ((PixmapStyle)synthContext.getStyle()).getInfo("SHADOW", string, n2, n3, -100, -100, -100))) {
            super.paintShadow(synthContext, graphics, n2, n3, string, n4, n5, n6, n7);
        }
    }

    public void paintExtension(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8) {
        if (!this.paintPixmap(graphics, n4, n5, n6, n7, ((PixmapStyle)synthContext.getStyle()).getInfo("EXTENSION", string, n2, n3, -100, n8, -100))) {
            super.paintExtension(synthContext, graphics, n2, n3, string, n4, n5, n6, n7, n8);
        }
    }

    public void paintHandle(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8) {
        if (!this.paintPixmap(graphics, n4, n5, n6, n7, ((PixmapStyle)synthContext.getStyle()).getInfo("HANDLE", string, n2, n3, n8, -100, -100))) {
            super.paintHandle(synthContext, graphics, n2, n3, string, n4, n5, n6, n7, n8);
        }
    }

    public void paintSlider(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8) {
        if (!this.paintPixmap(graphics, n4, n5, n6, n7, ((PixmapStyle)synthContext.getStyle()).getInfo("SLIDER", string, n2, n3, n8, -100, -100))) {
            super.paintSlider(synthContext, graphics, n2, n3, string, n4, n5, n6, n7, n8);
        }
    }

    public void paintBoxGap(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        PixmapStyle.Info info = ((PixmapStyle)synthContext.getStyle()).getInfo("BOX_GAP", string, n2, n3, -100, n8, -100);
        if (info != null) {
            this.paintPixmap(graphics, n4, n5, n6, n7, info);
            int n11 = 0;
            Image image = info.getGapStartImage();
            Image image2 = info.getGapImage();
            Image image3 = info.getGapEndImage();
            if (n8 == 0 || n8 == 1) {
                if (image != null) {
                    n11 = image.getWidth(null);
                } else if (image2 != null) {
                    n11 = image2.getWidth(null);
                } else if (image3 != null) {
                    n11 = image3.getWidth(null);
                }
            } else if (image != null) {
                n11 = image.getHeight(null);
            } else if (image2 != null) {
                n11 = image2.getHeight(null);
            } else if (image3 != null) {
                n11 = image3.getHeight(null);
            }
            if (n11 <= 0) {
                return;
            }
            this.paintGapImage(graphics, n4, n5, n6, n7, image, info.getGapStartInsets(), n8, n11, 0, n9);
            this.paintGapImage(graphics, n4, n5, n6, n7, image2, info.getGapInsets(), n8, n11, n9, n10);
            this.paintGapImage(graphics, n4, n5, n6, n7, image3, info.getGapEndInsets(), n8, n11, n9 + n10, Integer.MAX_VALUE);
        } else {
            super.paintBoxGap(synthContext, graphics, n2, n3, string, n4, n5, n6, n7, n8, n9, n10);
        }
    }

    public void paintFlatBox(SynthContext synthContext, Graphics graphics, int n2, String string, int n3, int n4, int n5, int n6) {
        if (!this.paintPixmap(graphics, n3, n4, n5, n6, ((PixmapStyle)synthContext.getStyle()).getInfo("FLAT_BOX", string, n2, -100, -100, -100, -100))) {
            super.paintFlatBox(synthContext, graphics, n2, string, n3, n4, n5, n6);
        }
    }

    public void paintFocus(SynthContext synthContext, Graphics graphics, int n2, String string, int n3, int n4, int n5, int n6) {
        if (!this.paintPixmap(graphics, n3, n4, n5, n6, ((PixmapStyle)synthContext.getStyle()).getInfo("FOCUS", string, n2, -100, -100, -100, -100))) {
            super.paintFocus(synthContext, graphics, n2, string, n3, n4, n5, n6);
        }
    }

    public void paintHline(SynthContext synthContext, Graphics graphics, int n2, String string, int n3, int n4, int n5, int n6) {
        if (!this.paintPixmap(graphics, n3, n4, n5, n6, ((PixmapStyle)synthContext.getStyle()).getInfo("HLINE", string, n2, -100, -100, -100, -100))) {
            super.paintHline(synthContext, graphics, n2, string, n3, n4, n5, n6);
        }
    }

    public void paintVline(SynthContext synthContext, Graphics graphics, int n2, String string, int n3, int n4, int n5, int n6) {
        if (!this.paintPixmap(graphics, n3, n4, n5, n6, ((PixmapStyle)synthContext.getStyle()).getInfo("VLINE", string, n2, -100, -100, -100, -100))) {
            super.paintVline(synthContext, graphics, n2, string, n3, n4, n5, n6);
        }
    }
}

