/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import com.sun.jndi.cosnaming.CNCtx;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NamingException;

public final class IiopUrl {
    private static final int DEFAULT_IIOPNAME_PORT = 9999;
    private static final int DEFAULT_IIOP_PORT = 900;
    private static final String DEFAULT_HOST = "localhost";
    private Vector addresses;
    private String stringName;

    public String getStringName() {
        return this.stringName;
    }

    public IiopUrl(String string) throws MalformedURLException {
        int n2;
        boolean bl2;
        if (string.startsWith("iiopname://")) {
            bl2 = false;
            n2 = 11;
        } else if (string.startsWith("iiop://")) {
            bl2 = true;
            n2 = 7;
        } else {
            throw new MalformedURLException("Invalid iiop/iiopname URL: " + string);
        }
        int n3 = string.indexOf(47, n2);
        if (n3 < 0) {
            n3 = string.length();
            this.stringName = "";
        } else {
            this.stringName = UrlUtil.decode(string.substring(n3 + 1));
        }
        this.addresses = new Vector(3);
        if (bl2) {
            this.addresses.addElement(new Address(string.substring(n2, n3), bl2));
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n2, n3), ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.addresses.addElement(new Address(stringTokenizer.nextToken(), bl2));
            }
            if (this.addresses.size() == 0) {
                this.addresses.addElement(new Address("", bl2));
            }
        }
    }

    public Vector getAddresses() {
        return this.addresses;
    }

    public Name getCosName() throws NamingException {
        return CNCtx.parser.parse(this.stringName);
    }

    public static class Address {
        public int port;
        public int major;
        public int minor;
        public String host;

        public Address(String string, boolean bl2) throws MalformedURLException {
            int n2;
            int n3;
            int n4;
            if (bl2 || (n4 = string.indexOf(64)) < 0) {
                this.major = 1;
                this.minor = 0;
                n3 = 0;
            } else {
                n2 = string.indexOf(46);
                if (n2 < 0) {
                    throw new MalformedURLException("invalid version: " + string);
                }
                try {
                    this.major = Integer.parseInt(string.substring(0, n2));
                    this.minor = Integer.parseInt(string.substring(n2 + 1, n4));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedURLException("Nonnumeric version: " + string);
                }
                n3 = n4 + 1;
            }
            n2 = string.indexOf(58, n3);
            if (n2 < 0) {
                this.port = bl2 ? 900 : 9999;
                this.host = string.substring(n3);
            } else {
                try {
                    this.port = Integer.parseInt(string.substring(n2 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedURLException("Nonnumeric port number: " + string);
                }
                this.host = string.substring(n3, n2);
            }
            if (this.host.equals("")) {
                this.host = IiopUrl.DEFAULT_HOST;
            }
        }
    }
}

