/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.GraphicsDevice;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.VolatileImage;

public abstract class GraphicsConfiguration {
    private static BufferCapabilities defaultBufferCaps;
    private static ImageCapabilities defaultImageCaps;

    protected GraphicsConfiguration() {
    }

    public BufferCapabilities getBufferCapabilities() {
        if (defaultBufferCaps == null) {
            defaultBufferCaps = new DefaultBufferCapabilities(this.getImageCapabilities());
        }
        return defaultBufferCaps;
    }

    public abstract GraphicsDevice getDevice();

    public ImageCapabilities getImageCapabilities() {
        if (defaultImageCaps == null) {
            defaultImageCaps = new ImageCapabilities(false);
        }
        return defaultImageCaps;
    }

    public abstract Rectangle getBounds();

    public abstract AffineTransform getDefaultTransform();

    public abstract AffineTransform getNormalizingTransform();

    public abstract BufferedImage createCompatibleImage(int var1, int var2);

    public abstract BufferedImage createCompatibleImage(int var1, int var2, int var3);

    public abstract ColorModel getColorModel();

    public abstract ColorModel getColorModel(int var1);

    public abstract VolatileImage createCompatibleVolatileImage(int var1, int var2);

    public VolatileImage createCompatibleVolatileImage(int n2, int n3, ImageCapabilities imageCapabilities) throws AWTException {
        return this.createCompatibleVolatileImage(n2, n3);
    }

    private static class DefaultBufferCapabilities
    extends BufferCapabilities {
        public DefaultBufferCapabilities(ImageCapabilities imageCapabilities) {
            super(imageCapabilities, imageCapabilities, null);
        }
    }
}

