/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private int currentPosition = 0;
    private int newPosition = -1;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retDelims;
    private boolean delimsChanged = false;
    private char maxDelimChar;

    public int countTokens() {
        int n2 = 0;
        int n3 = this.currentPosition;
        while (n3 < this.maxPosition && (n3 = this.skipDelimiters(n3)) < this.maxPosition) {
            n3 = this.scanToken(n3);
            ++n2;
        }
        return n2;
    }

    private void setMaxDelimChar() {
        if (this.delimiters == null) {
            this.maxDelimChar = '\u0000';
            return;
        }
        char c2 = '\u0000';
        for (int i2 = 0; i2 < this.delimiters.length(); ++i2) {
            char c3 = this.delimiters.charAt(i2);
            if (c2 >= c3) continue;
            c2 = c3;
        }
        this.maxDelimChar = c2;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    private int scanToken(int n2) {
        char c2;
        int n3;
        for (n3 = n2; n3 < this.maxPosition && ((c2 = this.str.charAt(n3)) > this.maxDelimChar || this.delimiters.indexOf(c2) < 0); ++n3) {
        }
        if (this.retDelims && n2 == n3 && (c2 = this.str.charAt(n3)) <= this.maxDelimChar && this.delimiters.indexOf(c2) >= 0) {
            ++n3;
        }
        return n3;
    }

    private int skipDelimiters(int n2) {
        char c2;
        int n3;
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        for (n3 = n2; !this.retDelims && n3 < this.maxPosition && (c2 = this.str.charAt(n3)) <= this.maxDelimChar && this.delimiters.indexOf(c2) >= 0; ++n3) {
        }
        return n3;
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int n2 = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        return this.str.substring(n2, this.currentPosition);
    }

    public StringTokenizer(String string) {
        this(string, " \t\n\r\f", false);
    }

    public String nextToken(String string) {
        this.delimiters = string;
        this.delimsChanged = true;
        this.setMaxDelimChar();
        return this.nextToken();
    }

    public StringTokenizer(String string, String string2) {
        this(string, string2, false);
    }

    public StringTokenizer(String string, String string2, boolean bl2) {
        this.str = string;
        this.maxPosition = string.length();
        this.delimiters = string2;
        this.retDelims = bl2;
        this.setMaxDelimChar();
    }
}

