/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Iterator;
import sun.nio.ch.DevPollArrayWrapper;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.Util;

class DevPollSelectorImpl
extends SelectorImpl {
    protected int fd0;
    protected int fd1;
    DevPollArrayWrapper pollWrapper;
    private int totalChannels;
    private HashMap fdToKey;
    private boolean closed = false;
    private Object interruptLock = new Object();
    private boolean interruptTriggered = false;

    private int updateSelectedKeys() {
        int n2 = this.pollWrapper.updated;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.pollWrapper.getDescriptor(i2);
            SelectionKeyImpl selectionKeyImpl = (SelectionKeyImpl)this.fdToKey.get(new Integer(n4));
            if (selectionKeyImpl == null) continue;
            int n5 = this.pollWrapper.getReventOps(i2);
            if (this.selectedKeys.contains(selectionKeyImpl)) {
                if (!selectionKeyImpl.channel.translateAndSetReadyOps(n5, selectionKeyImpl)) continue;
                ++n3;
                continue;
            }
            selectionKeyImpl.channel.translateAndSetReadyOps(n5, selectionKeyImpl);
            if ((selectionKeyImpl.readyOps() & selectionKeyImpl.interestOps()) == 0) continue;
            this.selectedKeys.add(selectionKeyImpl);
            ++n3;
        }
        return n3;
    }

    static {
        Util.load();
    }

    protected void implClose() throws IOException {
        if (!this.closed) {
            this.closed = true;
            FileDispatcher.closeIntFD(this.fd0);
            FileDispatcher.closeIntFD(this.fd1);
            if (this.pollWrapper != null) {
                this.pollWrapper.release(this.fd0);
                this.pollWrapper.closeDevPollFD();
                this.pollWrapper = null;
                this.selectedKeys = null;
                Iterator iterator = this.keys.iterator();
                while (iterator.hasNext()) {
                    SelectionKeyImpl selectionKeyImpl = (SelectionKeyImpl)iterator.next();
                    this.deregister(selectionKeyImpl);
                    SelectableChannel selectableChannel = selectionKeyImpl.channel();
                    if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
                        ((SelChImpl)((Object)selectableChannel)).kill();
                    }
                    iterator.remove();
                }
                this.totalChannels = 0;
            }
            this.fd0 = -1;
            this.fd1 = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSelect(long l2) throws IOException {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        if (l2 == 0L && this.totalChannels == 1) {
            return 0;
        }
        try {
            this.begin();
            this.pollWrapper.poll(l2);
        }
        finally {
            this.end();
        }
        this.processDeregisterQueue();
        int n2 = this.updateSelectedKeys();
        if (this.pollWrapper.interrupted()) {
            this.pollWrapper.putReventOps(this.pollWrapper.interruptedIndex(), 0);
            Object object = this.interruptLock;
            synchronized (object) {
                this.pollWrapper.clearInterrupted();
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.pollWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    DevPollSelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider);
        int[] nArray = new int[2];
        IOUtil.initPipe(nArray, false);
        this.fd0 = nArray[0];
        this.fd1 = nArray[1];
        this.pollWrapper = new DevPollArrayWrapper();
        this.pollWrapper.initInterrupt(this.fd0, this.fd1);
        this.fdToKey = new HashMap();
        this.totalChannels = 1;
    }

    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        int n2 = selectionKeyImpl.channel.getFDVal();
        this.fdToKey.remove(new Integer(n2));
        this.pollWrapper.release(n2);
        --this.totalChannels;
        this.keys.remove(selectionKeyImpl);
        this.selectedKeys.remove(selectionKeyImpl);
        this.deregister(selectionKeyImpl);
        SelectableChannel selectableChannel = selectionKeyImpl.channel();
        if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
            ((SelChImpl)((Object)selectableChannel)).kill();
        }
    }

    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        int n2 = IOUtil.fdVal(selectionKeyImpl.channel.getFD());
        this.fdToKey.put(new Integer(n2), selectionKeyImpl);
        ++this.totalChannels;
        this.keys.add(selectionKeyImpl);
    }

    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n2) {
        int n3 = IOUtil.fdVal(selectionKeyImpl.channel.getFD());
        this.pollWrapper.setInterest(n3, n2);
    }
}

