/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;

class SinkChannelImpl
extends Pipe.SinkChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    FileDescriptor fd;
    int fdVal;
    private volatile long thread = 0L;
    private final Object lock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_INUSE = 0;
    private static final int ST_KILLED = 1;
    private volatile int state = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public int getFDVal() {
        return this.fdVal;
    }

    static {
        $assertionsDisabled = !SinkChannelImpl.class.desiredAssertionStatus();
        Util.load();
        nd = new FileDispatcher();
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            nd.preClose(this.fd);
            long l2 = this.thread;
            if (l2 != 0L) {
                NativeThread.signal(l2);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1) {
                return;
            }
            if (this.state == -1) {
                this.state = 1;
                return;
            }
            if (!$assertionsDisabled && (this.isOpen() || this.isRegistered())) {
                throw new AssertionError();
            }
            nd.close(this.fd);
            this.state = 1;
        }
    }

    protected void implConfigureBlocking(boolean bl2) throws IOException {
        IOUtil.configureBlocking(this.fd, bl2);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            int n2;
            int n3;
            block11: {
                boolean bl2;
                int n4;
                block10: {
                    n3 = 0;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n4 = 0;
                            Object var6_6 = null;
                            this.thread = 0L;
                            bl2 = n3 > 0 || n3 == -2;
                            break block10;
                        }
                        this.thread = NativeThread.current();
                        while ((n3 = IOUtil.write(this.fd, byteBuffer, -1L, nd, this.lock)) == -3 && this.isOpen()) {
                        }
                        n2 = IOStatus.normalize(n3);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        this.thread = 0L;
                        this.end(n3 > 0 || n3 == -2);
                        if (!$assertionsDisabled && !IOStatus.check(n3)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw new AssertionError();
                }
                return n4;
            }
            Object var6_7 = null;
            this.thread = 0L;
            this.end(n3 > 0 || n3 == -2);
            if (!$assertionsDisabled && !IOStatus.check(n3)) {
                throw new AssertionError();
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long write(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            long l2;
            long l3;
            block12: {
                boolean bl2;
                long l4;
                block11: {
                    l3 = 0L;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l4 = 0L;
                            Object var8_6 = null;
                            this.thread = 0L;
                            bl2 = l3 > 0L || l3 == -2L;
                            break block11;
                        }
                        this.thread = NativeThread.current();
                        while ((l3 = IOUtil.write(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
                        }
                        l2 = IOStatus.normalize(l3);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.thread = 0L;
                        this.end(l3 > 0L || l3 == -2L);
                        if (!$assertionsDisabled && !IOStatus.check(l3)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(l3)) {
                    throw new AssertionError();
                }
                return l4;
            }
            Object var8_7 = null;
            this.thread = 0L;
            this.end(l3 > 0L || l3 == -2L);
            if (!$assertionsDisabled && !IOStatus.check(l3)) {
                throw new AssertionError();
            }
            return l2;
        }
    }

    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.write(Util.subsequence(byteBufferArray, n2, n3));
    }

    public boolean translateReadyOps(int n2, int n3, SelectionKeyImpl selectionKeyImpl) {
        int n4 = selectionKeyImpl.interestOps();
        int n5 = selectionKeyImpl.readyOps();
        int n6 = n3;
        if ((n2 & 0x20) != 0) {
            throw new Error("POLLNVAL detected");
        }
        if ((n2 & 0x18) != 0) {
            n6 = n4;
            selectionKeyImpl.readyOps(n6);
            return (n6 & ~n5) != 0;
        }
        if ((n2 & 4) != 0 && (n4 & 4) != 0) {
            n6 |= 4;
        }
        selectionKeyImpl.readyOps(n6);
        return (n6 & ~n5) != 0;
    }

    public void translateAndSetInterestOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        if (n2 == 4) {
            n2 = 4;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    public boolean translateAndSetReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n2, 0, selectionKeyImpl);
    }

    public boolean translateAndUpdateReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n2, selectionKeyImpl.readyOps(), selectionKeyImpl);
    }

    SinkChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor) {
        super(selectorProvider);
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 0;
    }
}

