/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FilePermission;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import sun.awt.image.ByteInterleavedRaster;
import sun.print.OpenBook;
import sun.print.PageableDoc;
import sun.print.PathGraphics;
import sun.print.PeekGraphics;
import sun.print.ProxyGraphics2D;
import sun.print.ServiceDialog;
import sun.print.SunPrinterJobService;

public abstract class RasterPrinterJob
extends PrinterJob {
    protected static final int PRINTER = 0;
    protected static final int FILE = 1;
    protected static final int STREAM = 2;
    private static final int MAX_BAND_SIZE = 0x400000;
    private int cachedBandWidth = 0;
    private int cachedBandHeight = 0;
    private BufferedImage cachedBand = null;
    private int mNumCopies = 1;
    private boolean mCollate = false;
    private int mFirstPage = -1;
    private int mLastPage = -1;
    private Pageable mDocument = new Book();
    private String mDocName = new String("Java Printing");
    private boolean performingPrinting = false;
    private boolean userCancelled = false;
    private FilePermission printToFilePermission;
    private ArrayList redrawList = new ArrayList();
    private int copiesAttr;
    private String jobNameAttr;
    private String userNameAttr;
    private PageRanges pageRangesAttr;
    protected Sides sidesAttr;
    protected String destinationAttr;
    protected boolean noJobSheet = false;
    protected int mDestType = 1;
    protected String mDestination = "";
    protected boolean collateAttReq = false;
    protected PrintRequestAttributeSet attributes = null;
    private PrintService myService;
    static /* synthetic */ Class class$sun$print$SunAlternateMedia;

    protected abstract double getXRes();

    protected abstract double getYRes();

    protected int getCollatedCopies() {
        return this.isCollated() ? this.getCopiesInt() : 1;
    }

    public int getCopies() {
        return this.mNumCopies;
    }

    protected int getCopiesInt() {
        return this.copiesAttr > 0 ? this.copiesAttr : this.getCopies();
    }

    protected int getFirstPage() {
        return this.mFirstPage == -1 ? 0 : this.mFirstPage;
    }

    protected int getLastPage() {
        return this.mLastPage;
    }

    protected int getNoncollatedCopies() {
        return this.isCollated() ? 1 : this.getCopiesInt();
    }

    protected abstract void abortDoc();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            if (this.performingPrinting) {
                this.userCancelled = true;
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelDoc() throws PrinterAbortException {
        this.abortDoc();
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            this.userCancelled = false;
            this.performingPrinting = false;
            this.notify();
        }
        throw new PrinterAbortException();
    }

    protected abstract void endDoc() throws PrinterException;

    protected void initPrinter() {
    }

    public void print() throws PrinterException {
        this.print(this.attributes);
    }

    protected abstract void startDoc() throws PrinterException;

    private void throwPrintToFile() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.printToFilePermission == null) {
                this.printToFilePermission = new FilePermission("<<ALL FILES>>", "read,write");
            }
            securityManager.checkPermission(this.printToFilePermission);
        }
    }

    public boolean checkAllowedToPrintToFile() {
        try {
            this.throwPrintToFile();
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        boolean bl2 = false;
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            bl2 = this.performingPrinting && this.userCancelled;
            this.notify();
        }
        return bl2;
    }

    protected boolean isCollated() {
        return this.mCollate;
    }

    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(new Copies(this.getCopies()));
        hashPrintRequestAttributeSet.add(new JobName(this.getJobName(), null));
        boolean bl2 = this.printDialog(hashPrintRequestAttributeSet);
        if (bl2) {
            Destination destination;
            Copies copies;
            JobName jobName = (JobName)hashPrintRequestAttributeSet.get(JobName.class);
            if (jobName != null) {
                this.setJobName(jobName.getValue());
            }
            if ((copies = (Copies)hashPrintRequestAttributeSet.get(Copies.class)) != null) {
                this.setCopies(copies.getValue());
            }
            if ((destination = (Destination)hashPrintRequestAttributeSet.get(Destination.class)) != null) {
                try {
                    this.mDestType = 1;
                    this.mDestination = new File(destination.getURI()).getPath();
                }
                catch (Exception exception) {
                    this.mDestination = "out.prn";
                }
            } else {
                this.mDestType = 0;
                this.mDestination = this.getPrintService().getName();
            }
        }
        return bl2;
    }

    public void setCopies(int n2) {
        this.mNumCopies = n2;
    }

    protected void setPageRange(int n2, int n3) {
        if (n2 >= 0 && n3 >= 0) {
            this.mFirstPage = n2;
            this.mLastPage = n3;
            if (this.mLastPage < this.mFirstPage) {
                this.mLastPage = this.mFirstPage;
            }
        } else {
            this.mFirstPage = -1;
            this.mLastPage = -1;
        }
    }

    protected void setCollated(boolean bl2) {
        this.mCollate = bl2;
        this.collateAttReq = true;
    }

    protected abstract void printBand(byte[] var1, int var2, int var3, int var4, int var5) throws PrinterException;

    protected Pageable getPageable() {
        return this.mDocument;
    }

    public void setPageable(Pageable pageable) throws NullPointerException {
        if (pageable == null) {
            throw new NullPointerException();
        }
        this.mDocument = pageable;
    }

    protected int printPage(Pageable pageable, int n2) throws PrinterException {
        Printable printable;
        PageFormat pageFormat;
        try {
            pageFormat = pageable.getPageFormat(n2);
            printable = pageable.getPrintable(n2);
        }
        catch (Exception exception) {
            throw new PrinterException("No page or printable exists.");
        }
        Paper paper = pageFormat.getPaper();
        double d2 = this.getXRes() / 72.0;
        double d3 = this.getYRes() / 72.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(paper.getImageableX() * d2, paper.getImageableY() * d3, paper.getImageableWidth() * d2, paper.getImageableHeight() * d3);
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.scale(d2, d3);
        int n3 = (int)((RectangularShape)double_).getWidth();
        if (n3 % 4 != 0) {
            n3 += 4 - n3 % 4;
        }
        if (n3 <= 0) {
            throw new PrinterException("Paper's imageable width is too small.");
        }
        int n4 = (int)((RectangularShape)double_).getHeight();
        if (n4 <= 0) {
            throw new PrinterException("Paper's imageable height is too small.");
        }
        int n5 = 0x400000 / n3 / 3;
        int n6 = (int)Math.rint(paper.getImageableX() * d2);
        int n7 = (int)Math.rint(paper.getImageableY() * d3);
        AffineTransform affineTransform3 = new AffineTransform();
        affineTransform3.translate(-n6, n7);
        affineTransform3.translate(0.0, n5);
        affineTransform3.scale(1.0, -1.0);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 5);
        PeekGraphics peekGraphics = this.createPeekGraphics(bufferedImage.createGraphics(), this);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        this.initPrinterGraphics(peekGraphics, double_2);
        int n8 = printable.print(peekGraphics, pageFormat, n2);
        if (n8 == 0) {
            this.startPage(pageFormat, printable, n2);
            Graphics2D graphics2D = this.createPathGraphics(peekGraphics, this, printable, pageFormat, n2);
            if (graphics2D != null) {
                graphics2D.transform(affineTransform2);
                graphics2D.translate(-this.getPhysicalPrintableX(paper) / d2, -this.getPhysicalPrintableY(paper) / d3);
                graphics2D.transform(new AffineTransform(pageFormat.getMatrix()));
                this.initPrinterGraphics(graphics2D, double_2);
                this.redrawList.clear();
                printable.print(graphics2D, pageFormat, n2);
                for (int i2 = 0; i2 < this.redrawList.size(); ++i2) {
                    GraphicsState graphicsState = (GraphicsState)this.redrawList.get(i2);
                    graphics2D.setTransform(graphicsState.theTransform);
                    graphics2D.setClip(graphicsState.theClip);
                    ((PathGraphics)graphics2D).redrawRegion(graphicsState.region, graphicsState.sx, graphicsState.sy, graphicsState.imageSrcRect, graphicsState.imageTransform);
                }
            } else {
                BufferedImage bufferedImage2 = this.cachedBand;
                if (this.cachedBand == null || n3 != this.cachedBandWidth || n5 != this.cachedBandHeight) {
                    this.cachedBand = bufferedImage2 = new BufferedImage(n3, n5, 5);
                    this.cachedBandWidth = n3;
                    this.cachedBandHeight = n5;
                }
                Graphics2D graphics2D2 = bufferedImage2.createGraphics();
                Rectangle2D.Double double_3 = new Rectangle2D.Double(0.0, 0.0, n3, n5);
                this.initPrinterGraphics(graphics2D2, double_3);
                ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D2, this);
                Graphics2D graphics2D3 = bufferedImage2.createGraphics();
                graphics2D3.setColor(Color.white);
                ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)bufferedImage2.getRaster();
                byte[] byArray = byteInterleavedRaster.getDataStorage();
                int n9 = n7 + n4;
                int n10 = (int)this.getPhysicalPrintableX(paper);
                int n11 = (int)this.getPhysicalPrintableY(paper);
                for (int i3 = 0; i3 <= n4; i3 += n5) {
                    int n12;
                    graphics2D3.fillRect(0, 0, n3, n5);
                    graphics2D2.setTransform(affineTransform);
                    graphics2D2.transform(affineTransform3);
                    affineTransform3.translate(0.0, -n5);
                    graphics2D2.transform(affineTransform2);
                    graphics2D2.transform(new AffineTransform(pageFormat.getMatrix()));
                    Rectangle rectangle = graphics2D2.getClipBounds();
                    if (rectangle != null && (!peekGraphics.hitsDrawingArea(rectangle) || n3 <= 0 || n5 <= 0)) continue;
                    int n13 = n6 - n10;
                    if (n13 < 0) {
                        graphics2D2.translate((double)n13 / d2, 0.0);
                        n13 = 0;
                    }
                    if ((n12 = n7 + i3 - n11) < 0) {
                        graphics2D2.translate(0.0, (double)n12 / d3);
                        n12 = 0;
                    }
                    proxyGraphics2D.setDelegate((Graphics2D)graphics2D2.create());
                    printable.print(proxyGraphics2D, pageFormat, n2);
                    proxyGraphics2D.dispose();
                    this.printBand(byArray, n13, n12, n3, n5);
                }
                graphics2D3.dispose();
                graphics2D2.dispose();
            }
            this.endPage(pageFormat, printable, n2);
        }
        return n8;
    }

    protected abstract double getPhysicalPageHeight(Paper var1);

    protected abstract double getPhysicalPageWidth(Paper var1);

    protected abstract double getPhysicalPrintableHeight(Paper var1);

    protected abstract double getPhysicalPrintableWidth(Paper var1);

    protected abstract double getPhysicalPrintableX(Paper var1);

    protected abstract double getPhysicalPrintableY(Paper var1);

    public void setPrintable(Printable printable) {
        this.setPageable(new OpenBook(this.defaultPage(new PageFormat()), printable));
    }

    public String getJobName() {
        return this.mDocName;
    }

    protected String getJobNameInt() {
        return this.jobNameAttr != null ? this.jobNameAttr : this.getJobName();
    }

    public String getUserName() {
        return System.getProperty("user.name");
    }

    protected String getUserNameInt() {
        if (this.userNameAttr != null) {
            return this.userNameAttr;
        }
        try {
            return this.getUserName();
        }
        catch (SecurityException securityException) {
            return "";
        }
    }

    public void setJobName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.mDocName = string;
    }

    public PrintService getPrintService() {
        if (this.myService == null) {
            PrintService[] printServiceArray;
            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
            if (printService != null && printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PAGEABLE)) {
                try {
                    this.setPrintService(printService);
                    this.myService = printService;
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
            if (this.myService == null && (printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null)).length > 0) {
                try {
                    this.setPrintService(printServiceArray[0]);
                    this.myService = printServiceArray[0];
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
        }
        return this.myService;
    }

    protected static PrintService lookupDefaultPrintService() {
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        if (printService != null && printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
            return printService;
        }
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (printServiceArray.length > 0) {
            return printServiceArray[0];
        }
        return null;
    }

    public void setPrintService(PrintService printService) throws PrinterException {
        if (printService == null) {
            throw new PrinterException("Service cannot be null");
        }
        if (!printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || !printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
            throw new PrinterException("Not a 2D print service: " + printService);
        }
        this.myService = printService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        RasterPrinterJob rasterPrinterJob;
        int n2;
        PrintService printService = this.getPrintService();
        if (printService == null) {
            throw new PrinterException("No print service found.");
        }
        if (!(printService instanceof SunPrinterJobService) || !((SunPrinterJobService)((Object)printService)).usesClass(this.getClass())) {
            this.spoolToService(printRequestAttributeSet);
            return;
        }
        this.setAttributes(printRequestAttributeSet);
        this.initPrinter();
        int n3 = this.getCollatedCopies();
        int n4 = this.getNoncollatedCopies();
        int n5 = this.mDocument.getNumberOfPages();
        int n6 = this.getFirstPage();
        int n7 = this.getLastPage();
        if (n7 == -1 && (n2 = this.mDocument.getNumberOfPages()) != -1) {
            n7 = this.mDocument.getNumberOfPages() - 1;
        }
        try {
            RasterPrinterJob rasterPrinterJob2 = this;
            synchronized (rasterPrinterJob2) {
                this.performingPrinting = true;
                this.userCancelled = false;
            }
            this.startDoc();
            if (this.isCancelled()) {
                this.cancelDoc();
            }
            block10: for (int i2 = 0; i2 < n3; ++i2) {
                int n8 = 0;
                for (int i3 = n6; (i3 <= n7 || n7 == -1) && n8 == 0; ++i3) {
                    int n9;
                    if (this.pageRangesAttr != null) {
                        n9 = this.pageRangesAttr.next(i3);
                        if (n9 == -1) continue block10;
                        if (n9 != i3 + 1) continue;
                    }
                    for (n9 = 0; n9 < n4 && n8 == 0; ++n9) {
                        if (this.isCancelled()) {
                            this.cancelDoc();
                        }
                        n8 = this.printPage(this.mDocument, i3);
                    }
                }
            }
            if (this.isCancelled()) {
                this.cancelDoc();
            }
            Object var13_15 = null;
            rasterPrinterJob = this;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            RasterPrinterJob rasterPrinterJob3 = this;
            synchronized (rasterPrinterJob3) {
                if (this.performingPrinting) {
                    this.endDoc();
                }
                this.performingPrinting = false;
                this.notify();
            }
            throw throwable;
        }
        synchronized (rasterPrinterJob) {
            if (this.performingPrinting) {
                this.endDoc();
            }
            this.performingPrinting = false;
            this.notify();
        }
    }

    protected void setAttributes(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        JobName jobName;
        JobSheets jobSheets;
        Copies copies;
        Object object;
        this.setCollated(false);
        this.sidesAttr = null;
        this.pageRangesAttr = null;
        this.copiesAttr = 0;
        this.jobNameAttr = null;
        this.userNameAttr = null;
        this.destinationAttr = null;
        this.collateAttReq = false;
        if (printRequestAttributeSet == null) {
            return;
        }
        PrintService printService = this.getPrintService();
        boolean bl2 = false;
        Fidelity fidelity = (Fidelity)printRequestAttributeSet.get(Fidelity.class);
        if (fidelity != null && fidelity == Fidelity.FIDELITY_TRUE) {
            bl2 = true;
        }
        if (bl2 && (object = printService.getUnsupportedAttributes(DocFlavor.SERVICE_FORMATTED.PAGEABLE, printRequestAttributeSet)) != null) {
            throw new PrinterException("Fidelity cannot be satisfied");
        }
        object = (SheetCollate)printRequestAttributeSet.get(SheetCollate.class);
        if (this.isSupportedValue((Attribute)object, printRequestAttributeSet)) {
            this.setCollated(object == SheetCollate.COLLATED);
        }
        this.sidesAttr = (Sides)printRequestAttributeSet.get(Sides.class);
        if (!this.isSupportedValue(this.sidesAttr, printRequestAttributeSet)) {
            this.sidesAttr = Sides.ONE_SIDED;
        }
        this.pageRangesAttr = (PageRanges)printRequestAttributeSet.get(PageRanges.class);
        if (!this.isSupportedValue(this.pageRangesAttr, printRequestAttributeSet)) {
            this.pageRangesAttr = null;
        }
        this.copiesAttr = this.isSupportedValue(copies = (Copies)printRequestAttributeSet.get(Copies.class), printRequestAttributeSet) || !bl2 & copies != null ? copies.getValue() : this.getCopies();
        Destination destination = (Destination)printRequestAttributeSet.get(Destination.class);
        if (this.isSupportedValue(destination, printRequestAttributeSet)) {
            this.destinationAttr = "out.prn";
            try {
                this.destinationAttr = new File(destination.getURI()).getPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((jobSheets = (JobSheets)printRequestAttributeSet.get(JobSheets.class)) != null) {
            this.noJobSheet = jobSheets == JobSheets.NONE;
        }
        this.jobNameAttr = this.isSupportedValue(jobName = (JobName)printRequestAttributeSet.get(JobName.class), printRequestAttributeSet) || !bl2 & jobName != null ? jobName.getValue() : this.getJobName();
        RequestingUserName requestingUserName = (RequestingUserName)printRequestAttributeSet.get(RequestingUserName.class);
        if (this.isSupportedValue(requestingUserName, printRequestAttributeSet) || !bl2 & requestingUserName != null) {
            this.userNameAttr = requestingUserName.getValue();
        } else {
            try {
                this.userNameAttr = this.getUserName();
            }
            catch (SecurityException securityException) {
                this.userNameAttr = "";
            }
        }
        Media media = (Media)printRequestAttributeSet.get(Media.class);
        OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
        if ((orientationRequested != null || media != null || mediaPrintableArea != null) && this.getPageable() instanceof OpenBook) {
            Pageable pageable = this.getPageable();
            Printable printable = pageable.getPrintable(0);
            PageFormat pageFormat = (PageFormat)pageable.getPageFormat(0).clone();
            Paper paper = pageFormat.getPaper();
            if (this.isSupportedValue(orientationRequested, printRequestAttributeSet) || !bl2 & orientationRequested != null) {
                int n2 = orientationRequested.equals(OrientationRequested.REVERSE_LANDSCAPE) ? 2 : (orientationRequested.equals(OrientationRequested.LANDSCAPE) ? 0 : 1);
                pageFormat.setOrientation(n2);
            }
            if (this.isSupportedValue(mediaPrintableArea, printRequestAttributeSet) || !bl2 & mediaPrintableArea != null) {
                float[] fArray = mediaPrintableArea.getPrintableArea(25400);
                for (int i2 = 0; i2 < fArray.length; ++i2) {
                    fArray[i2] = fArray[i2] * 72.0f;
                }
                paper.setImageableArea(fArray[0], fArray[1], fArray[2], fArray[3]);
            }
            if ((this.isSupportedValue(media, printRequestAttributeSet) || !bl2 & media != null) && media instanceof MediaSizeName) {
                MediaSizeName mediaSizeName = (MediaSizeName)media;
                MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
                if (mediaSize == null && mediaSizeName == MediaSizeName.TABLOID) {
                    mediaSize = MediaSize.Other.LEDGER;
                }
                if (mediaSize != null) {
                    float f2 = mediaSize.getX(25400) * 72.0f;
                    float f3 = mediaSize.getY(25400) * 72.0f;
                    paper.setSize(f2, f3);
                }
            }
            pageFormat.setPaper(paper);
            pageFormat = this.validatePage(pageFormat);
            this.setPrintable(printable, pageFormat);
        }
    }

    private void spoolToService(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        DocPrintJob docPrintJob = this.getPrintService().createPrintJob();
        PageableDoc pageableDoc = new PageableDoc(this.getPageable());
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
        }
        try {
            docPrintJob.print(pageableDoc, printRequestAttributeSet);
        }
        catch (PrintException printException) {
            throw new PrinterException(printException.toString());
        }
    }

    public boolean printDialog(final PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PrintService[] printServiceArray;
                GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                PrintService printService = RasterPrinterJob.this.getPrintService();
                if (printService == null) {
                    ServiceDialog.showNoPrintService(graphicsConfiguration);
                    return Boolean.FALSE;
                }
                StreamPrintServiceFactory[] streamPrintServiceFactoryArray = null;
                if (printService instanceof StreamPrintService) {
                    streamPrintServiceFactoryArray = PrinterJob.lookupStreamPrintServices(null);
                    printServiceArray = new StreamPrintService[streamPrintServiceFactoryArray.length];
                    for (int i2 = 0; i2 < streamPrintServiceFactoryArray.length; ++i2) {
                        printServiceArray[i2] = streamPrintServiceFactoryArray[i2].getPrintService(null);
                    }
                } else {
                    printServiceArray = PrinterJob.lookupPrintServices();
                    if (printServiceArray == null || printServiceArray.length == 0) {
                        printServiceArray = new PrintService[]{printService};
                    }
                }
                Rectangle rectangle = graphicsConfiguration.getBounds();
                int n2 = rectangle.x + rectangle.width / 3;
                int n3 = rectangle.y + rectangle.height / 3;
                PrintService printService2 = ServiceUI.printDialog(graphicsConfiguration, n2, n3, printServiceArray, printService, DocFlavor.SERVICE_FORMATTED.PAGEABLE, printRequestAttributeSet);
                if (printService2 == null) {
                    return Boolean.FALSE;
                }
                if (!((Object)printService).equals(printService2)) {
                    try {
                        RasterPrinterJob.this.setPrintService(printService2);
                    }
                    catch (PrinterException printerException) {
                        // empty catch block
                    }
                }
                return Boolean.TRUE;
            }
        });
        return bl2;
    }

    void initPrinterGraphics(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.setClip(rectangle2D);
        graphics2D.setPaint(Color.black);
    }

    public PageFormat defaultPage(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        pageFormat2.setOrientation(1);
        Paper paper = new Paper();
        String string = Locale.getDefault().getCountry();
        if (string != null && !string.equals(Locale.US.getCountry()) && !string.equals(Locale.CANADA.getCountry())) {
            double d2 = 25.4;
            double d3 = 72.0;
            double d4 = Math.rint(210.0 * d3 / d2);
            double d5 = Math.rint(297.0 * d3 / d2);
            paper.setSize(d4, d5);
            paper.setImageableArea(d3, d3, d4 - 2.0 * d3, d5 - 2.0 * d3);
        }
        pageFormat2.setPaper(paper);
        return pageFormat2;
    }

    public PageFormat pageDialog(PageFormat pageFormat) throws HeadlessException {
        OrientationRequested orientationRequested;
        float f2;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        PrintService printService = this.getPrintService();
        if (printService == null) {
            ServiceDialog.showNoPrintService(graphicsConfiguration);
            return pageFormat;
        }
        float f3 = (float)Math.rint(pageFormat.getPaper().getWidth() * 25400.0 / 72.0) / 25400.0f;
        Media media = MediaSize.findMedia(f3, f2 = (float)Math.rint(pageFormat.getPaper().getHeight() * 25400.0 / 72.0) / 25400.0f, 25400);
        if (media == null || !printService.isAttributeValueSupported(media, null, null)) {
            media = (Media)printService.getDefaultAttributeValue(Media.class);
        }
        switch (pageFormat.getOrientation()) {
            case 0: {
                orientationRequested = OrientationRequested.LANDSCAPE;
                break;
            }
            case 2: {
                orientationRequested = OrientationRequested.REVERSE_LANDSCAPE;
                break;
            }
            default: {
                orientationRequested = OrientationRequested.PORTRAIT;
            }
        }
        if (this.attributes == null) {
            this.attributes = new HashPrintRequestAttributeSet();
        }
        this.attributes.add(media);
        this.attributes.add(orientationRequested);
        PageFormat pageFormat2 = this.pageDialog(this.attributes);
        if (pageFormat2 == null) {
            return pageFormat;
        }
        return pageFormat2;
    }

    public PageFormat validatePage(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        Paper paper = new Paper();
        this.validatePaper(pageFormat2.getPaper(), paper);
        pageFormat2.setPaper(paper);
        return pageFormat2;
    }

    public void setPrintable(Printable printable, PageFormat pageFormat) {
        this.setPageable(new OpenBook(pageFormat, printable));
    }

    public PageFormat pageDialog(final PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        PageFormat pageFormat = (PageFormat)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                Rectangle rectangle = graphicsConfiguration.getBounds();
                int n2 = rectangle.x + rectangle.width / 3;
                int n3 = rectangle.y + rectangle.height / 3;
                PrintService printService = RasterPrinterJob.this.getPrintService();
                if (printService == null) {
                    ServiceDialog.showNoPrintService(graphicsConfiguration);
                    return null;
                }
                ServiceDialog serviceDialog = new ServiceDialog(graphicsConfiguration, n2, n3, printService, DocFlavor.SERVICE_FORMATTED.PAGEABLE, printRequestAttributeSet);
                serviceDialog.show();
                if (serviceDialog.getStatus() == 1) {
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    MediaSize mediaSize;
                    Class clazz;
                    PrintRequestAttributeSet printRequestAttributeSet2 = serviceDialog.getAttributes();
                    Class clazz2 = clazz = class$sun$print$SunAlternateMedia == null ? (class$sun$print$SunAlternateMedia = RasterPrinterJob.class$("sun.print.SunAlternateMedia")) : class$sun$print$SunAlternateMedia;
                    if (printRequestAttributeSet.containsKey(clazz) && printRequestAttributeSet2.containsKey(clazz)) {
                        printRequestAttributeSet.remove(clazz);
                    }
                    printRequestAttributeSet.addAll(printRequestAttributeSet2);
                    PageFormat pageFormat = RasterPrinterJob.this.defaultPage();
                    OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = RasterPrinterJob.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested);
                    int n4 = 1;
                    if (orientationRequested != null) {
                        if (orientationRequested == OrientationRequested.REVERSE_LANDSCAPE) {
                            n4 = 2;
                        } else if (orientationRequested == OrientationRequested.LANDSCAPE) {
                            n4 = 0;
                        }
                    }
                    pageFormat.setOrientation(n4);
                    Media media = (Media)printRequestAttributeSet.get(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = RasterPrinterJob.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media);
                    if (media == null) {
                        media = (Media)printService.getDefaultAttributeValue(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = RasterPrinterJob.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media);
                    }
                    if (!(media instanceof MediaSizeName)) {
                        media = MediaSizeName.NA_LETTER;
                    }
                    if ((mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media)) == null) {
                        mediaSize = MediaSize.NA.LETTER;
                    }
                    int n5 = 352;
                    Paper paper = new Paper();
                    float[] fArray = mediaSize.getSize(n5);
                    double d6 = Math.rint(fArray[0]);
                    double d7 = Math.rint(fArray[1]);
                    paper.setSize(d6, d7);
                    MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = RasterPrinterJob.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea);
                    if (mediaPrintableArea != null) {
                        d5 = Math.rint(mediaPrintableArea.getX(n5));
                        d4 = Math.rint(mediaPrintableArea.getY(n5));
                        d3 = Math.rint(mediaPrintableArea.getWidth(n5));
                        d2 = Math.rint(mediaPrintableArea.getHeight(n5));
                    } else {
                        if (d6 >= 432.0) {
                            d5 = 72.0;
                            d3 = d6 - 144.0;
                        } else {
                            d5 = d6 / 6.0;
                            d3 = d6 * 0.75;
                        }
                        if (d7 >= 432.0) {
                            d4 = 72.0;
                            d2 = d7 - 144.0;
                        } else {
                            d4 = d7 / 6.0;
                            d2 = d7 * 0.75;
                        }
                    }
                    paper.setImageableArea(d5, d4, d3, d2);
                    pageFormat.setPaper(paper);
                    return pageFormat;
                }
                return null;
            }
        });
        return pageFormat;
    }

    protected void validatePaper(Paper paper, Paper paper2) {
        if (paper == null || paper2 == null) {
            return;
        }
        double d2 = paper.getWidth();
        double d3 = paper.getHeight();
        double d4 = paper.getImageableX();
        double d5 = paper.getImageableY();
        double d6 = paper.getImageableWidth();
        double d7 = paper.getImageableHeight();
        Paper paper3 = new Paper();
        d2 = d2 > 0.0 ? d2 : paper3.getWidth();
        d3 = d3 > 0.0 ? d3 : paper3.getHeight();
        d4 = d4 > 0.0 ? d4 : paper3.getImageableX();
        d5 = d5 > 0.0 ? d5 : paper3.getImageableY();
        d6 = d6 > 0.0 ? d6 : paper3.getImageableWidth();
        double d8 = d7 = d7 > 0.0 ? d7 : paper3.getImageableHeight();
        if (d6 > d2) {
            d6 = d2;
        }
        if (d7 > d3) {
            d7 = d3;
        }
        if (d4 + d6 > d2) {
            d4 = d2 - d6;
        }
        if (d5 + d7 > d3) {
            d5 = d3 - d7;
        }
        paper2.setSize(d2, d3);
        paper2.setImageableArea(d4, d5, d6, d7);
    }

    protected abstract void endPage(PageFormat var1, Printable var2, int var3) throws PrinterException;

    protected abstract void startPage(PageFormat var1, Printable var2, int var3) throws PrinterException;

    protected boolean isSupportedValue(Attribute attribute, PrintRequestAttributeSet printRequestAttributeSet) {
        return attribute != null && this.getPrintService().isAttributeValueSupported(attribute, DocFlavor.SERVICE_FORMATTED.PAGEABLE, printRequestAttributeSet);
    }

    protected PeekGraphics createPeekGraphics(Graphics2D graphics2D, PrinterJob printerJob) {
        return new PeekGraphics(graphics2D, printerJob);
    }

    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n2) {
        return null;
    }

    public void saveState(AffineTransform affineTransform, Shape shape, Rectangle2D rectangle2D, double d2, double d3, Rectangle2D rectangle2D2, AffineTransform affineTransform2) {
        GraphicsState graphicsState = new GraphicsState();
        graphicsState.theTransform = affineTransform;
        graphicsState.theClip = shape;
        graphicsState.region = rectangle2D;
        graphicsState.sx = d2;
        graphicsState.sy = d3;
        graphicsState.imageTransform = affineTransform2;
        graphicsState.imageSrcRect = rectangle2D2;
        this.redrawList.add(graphicsState);
    }

    private class GraphicsState {
        Rectangle2D region;
        Shape theClip;
        AffineTransform theTransform;
        double sx;
        double sy;
        Rectangle2D imageSrcRect;
        AffineTransform imageTransform;

        private GraphicsState() {
        }
    }
}

