/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import sun.security.provider.SHA;

public class DSAParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int modLen = 1024;
    private SecureRandom random;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private SHA sha = new SHA();

    private byte[] SHA(byte[] byArray) {
        this.sha.engineReset();
        this.sha.engineUpdate(byArray, 0, byArray.length);
        return this.sha.engineDigest();
    }

    private void xor(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = i2;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[i2]);
        }
    }

    private byte[] toByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        return byArray;
    }

    BigInteger[] generatePandQ(byte[] byArray, int n2) {
        int n3 = byArray.length * 8;
        int n4 = (n2 - 1) / 160;
        int n5 = (n2 - 1) % 160;
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = TWO.pow(2 * n3);
        byte[] byArray2 = this.SHA(byArray);
        byte[] byArray3 = this.SHA(this.toByteArray(bigInteger.add(ONE).mod(bigInteger2)));
        this.xor(byArray2, byArray3);
        byte[] byArray4 = byArray2;
        byArray4[0] = (byte)(byArray4[0] | 0x80);
        byArray4[19] = (byte)(byArray4[19] | 1);
        BigInteger bigInteger3 = new BigInteger(1, byArray4);
        if (!bigInteger3.isProbablePrime(80)) {
            return null;
        }
        BigInteger[] bigIntegerArray = new BigInteger[n4 + 1];
        BigInteger bigInteger4 = TWO;
        for (int i2 = 0; i2 < 4096; ++i2) {
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            BigInteger bigInteger7;
            for (int i3 = 0; i3 <= n4; ++i3) {
                bigInteger7 = BigInteger.valueOf(i3);
                bigInteger6 = bigInteger.add(bigInteger4).add(bigInteger7).mod(bigInteger2);
                bigIntegerArray[i3] = new BigInteger(1, this.SHA(this.toByteArray(bigInteger6)));
            }
            BigInteger bigInteger8 = bigIntegerArray[0];
            for (int i4 = 1; i4 < n4; ++i4) {
                bigInteger8 = bigInteger8.add(bigIntegerArray[i4].multiply(TWO.pow(i4 * 160)));
            }
            bigInteger6 = (bigInteger8 = bigInteger8.add(bigIntegerArray[n4].mod(TWO.pow(n5)).multiply(TWO.pow(n4 * 160)))).add(bigInteger7 = TWO.pow(n2 - 1));
            BigInteger bigInteger9 = bigInteger6.subtract((bigInteger5 = bigInteger6.mod(bigInteger3.multiply(TWO))).subtract(ONE));
            if (bigInteger9.compareTo(bigInteger7) > -1 && bigInteger9.isProbablePrime(80)) {
                BigInteger[] bigIntegerArray2 = new BigInteger[]{bigInteger9, bigInteger3, bigInteger, BigInteger.valueOf(i2)};
                return bigIntegerArray2;
            }
            bigInteger4 = bigInteger4.add(BigInteger.valueOf(n4)).add(ONE);
        }
        return null;
    }

    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters algorithmParameters = null;
        try {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            BigInteger[] bigIntegerArray = this.generatePandQ(this.random, this.modLen);
            BigInteger bigInteger = bigIntegerArray[0];
            BigInteger bigInteger2 = bigIntegerArray[1];
            BigInteger bigInteger3 = this.generateG(bigInteger, bigInteger2);
            DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(bigInteger, bigInteger2, bigInteger3);
            algorithmParameters = AlgorithmParameters.getInstance("DSA", "SUN");
            algorithmParameters.init(dSAParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.getMessage());
        }
        return algorithmParameters;
    }

    protected void engineInit(int n2, SecureRandom secureRandom) {
        if (n2 < 512 || n2 > 1024 || n2 % 64 != 0) {
            throw new InvalidParameterException("Prime size must range from 512 to 1024 and be a multiple of 64");
        }
        this.modLen = n2;
        this.random = secureRandom;
    }

    BigInteger[] generatePandQ(SecureRandom secureRandom, int n2) {
        BigInteger[] bigIntegerArray = null;
        byte[] byArray = new byte[20];
        while (bigIntegerArray == null) {
            for (int i2 = 0; i2 < 20; ++i2) {
                byArray[i2] = (byte)secureRandom.nextInt();
            }
            bigIntegerArray = this.generatePandQ(byArray, n2);
        }
        return bigIntegerArray;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Invalid parameter");
    }

    BigInteger generateG(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = ONE;
        BigInteger bigInteger4 = bigInteger.subtract(ONE).divide(bigInteger2);
        BigInteger bigInteger5 = ONE;
        while (bigInteger5.compareTo(TWO) < 0) {
            bigInteger5 = bigInteger3.modPow(bigInteger4, bigInteger);
            bigInteger3 = bigInteger3.add(ONE);
        }
        return bigInteger5;
    }
}

