/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import sun.security.util.ObjectIdentifier;

public class OIDMap {
    private static final String ROOT = "x509.info.extensions";
    private static final String AUTH_KEY_IDENTIFIER = "x509.info.extensions.AuthorityKeyIdentifier";
    private static final String SUB_KEY_IDENTIFIER = "x509.info.extensions.SubjectKeyIdentifier";
    private static final String KEY_USAGE = "x509.info.extensions.KeyUsage";
    private static final String PRIVATE_KEY_USAGE = "x509.info.extensions.PrivateKeyUsage";
    private static final String POLICY_MAPPINGS = "x509.info.extensions.PolicyMappings";
    private static final String SUB_ALT_NAME = "x509.info.extensions.SubjectAlternativeName";
    private static final String ISSUER_ALT_NAME = "x509.info.extensions.IssuerAlternativeName";
    private static final String BASIC_CONSTRAINTS = "x509.info.extensions.BasicConstraints";
    private static final String NAME_CONSTRAINTS = "x509.info.extensions.NameConstraints";
    private static final String POLICY_CONSTRAINTS = "x509.info.extensions.PolicyConstraints";
    private static final String CRL_NUMBER = "x509.info.extensions.CRLNumber";
    private static final String CRL_REASON = "x509.info.extensions.CRLReasonCode";
    private static final String NETSCAPE_CERT = "x509.info.extensions.NetscapeCertType";
    private static final String CERT_POLICIES = "x509.info.extensions.CertificatePolicies";
    private static final String EXT_KEY_USAGE = "x509.info.extensions.ExtendedKeyUsage";
    private static final String INHIBIT_ANY_POLICY = "x509.info.extensions.InhibitAnyPolicy";
    private static final String CRL_DIST_POINTS = "x509.info.extensions.CRLDistributionPoints";
    private static final Map oidMap = new HashMap();
    private static final Map nameMap = new HashMap();

    static {
        try {
            OIDMap.addInternal(SUB_KEY_IDENTIFIER, "2.5.29.14", "sun.security.x509.SubjectKeyIdentifierExtension");
            OIDMap.addInternal(KEY_USAGE, "2.5.29.15", "sun.security.x509.KeyUsageExtension");
            OIDMap.addInternal(PRIVATE_KEY_USAGE, "2.5.29.16", "sun.security.x509.PrivateKeyUsageExtension");
            OIDMap.addInternal(SUB_ALT_NAME, "2.5.29.17", "sun.security.x509.SubjectAlternativeNameExtension");
            OIDMap.addInternal(ISSUER_ALT_NAME, "2.5.29.18", "sun.security.x509.IssuerAlternativeNameExtension");
            OIDMap.addInternal(BASIC_CONSTRAINTS, "2.5.29.19", "sun.security.x509.BasicConstraintsExtension");
            OIDMap.addInternal(CRL_NUMBER, "2.5.29.20", "sun.security.x509.CRLNumberExtension");
            OIDMap.addInternal(CRL_REASON, "2.5.29.21", "sun.security.x509.CRLReasonCodeExtension");
            OIDMap.addInternal(NAME_CONSTRAINTS, "2.5.29.30", "sun.security.x509.NameConstraintsExtension");
            OIDMap.addInternal(POLICY_MAPPINGS, "2.5.29.33", "sun.security.x509.PolicyMappingsExtension");
            OIDMap.addInternal(AUTH_KEY_IDENTIFIER, "2.5.29.35", "sun.security.x509.AuthorityKeyIdentifierExtension");
            OIDMap.addInternal(POLICY_CONSTRAINTS, "2.5.29.36", "sun.security.x509.PolicyConstraintsExtension");
            OIDMap.addInternal(NETSCAPE_CERT, "2.16.840.1.113730.1.1", "sun.security.x509.NetscapeCertTypeExtension");
            OIDMap.addInternal(CERT_POLICIES, "2.5.29.32", "sun.security.x509.CertificatePoliciesExtension");
            OIDMap.addInternal(EXT_KEY_USAGE, "2.5.29.37", "sun.security.x509.ExtendedKeyUsageExtension");
            OIDMap.addInternal(INHIBIT_ANY_POLICY, "2.5.29.54", "sun.security.x509.InhibitAnyPolicyExtension");
            OIDMap.addInternal(CRL_DIST_POINTS, "2.5.29.31", "sun.security.x509.CRLDistributionPointsExtension");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Internal error: " + iOException, iOException);
        }
    }

    private OIDMap() {
    }

    public static Class getClass(String string) throws CertificateException {
        OIDInfo oIDInfo = (OIDInfo)nameMap.get(string);
        return oIDInfo == null ? null : oIDInfo.getClazz();
    }

    public static Class getClass(ObjectIdentifier objectIdentifier) throws CertificateException {
        OIDInfo oIDInfo = (OIDInfo)oidMap.get(objectIdentifier);
        return oIDInfo == null ? null : oIDInfo.getClazz();
    }

    public static String getName(ObjectIdentifier objectIdentifier) {
        OIDInfo oIDInfo = (OIDInfo)oidMap.get(objectIdentifier);
        return oIDInfo == null ? null : oIDInfo.name;
    }

    public static ObjectIdentifier getOID(String string) {
        OIDInfo oIDInfo = (OIDInfo)nameMap.get(string);
        return oIDInfo == null ? null : oIDInfo.oid;
    }

    public static void addAttribute(String string, String string2, Class clazz) throws CertificateException {
        ObjectIdentifier objectIdentifier;
        try {
            objectIdentifier = new ObjectIdentifier(string2);
        }
        catch (IOException iOException) {
            throw new CertificateException("Invalid Object identifier: " + string2);
        }
        OIDInfo oIDInfo = new OIDInfo(string, objectIdentifier, clazz);
        if (oidMap.put(objectIdentifier, oIDInfo) != null) {
            throw new CertificateException("Object identifier already exists: " + string2);
        }
        if (nameMap.put(string, oIDInfo) != null) {
            throw new CertificateException("Name already exists: " + string);
        }
    }

    private static void addInternal(String string, String string2, String string3) throws IOException {
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(string2);
        OIDInfo oIDInfo = new OIDInfo(string, objectIdentifier, string3);
        oidMap.put(objectIdentifier, oIDInfo);
        nameMap.put(string, oIDInfo);
    }

    private static class OIDInfo {
        final ObjectIdentifier oid;
        final String name;
        final String className;
        private volatile Class clazz;

        Class getClazz() throws CertificateException {
            try {
                Class clazz = this.clazz;
                if (clazz == null) {
                    this.clazz = clazz = Class.forName(this.className);
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (CertificateException)new CertificateException("Could not load class: " + classNotFoundException).initCause(classNotFoundException);
            }
        }

        OIDInfo(String string, ObjectIdentifier objectIdentifier, Class clazz) {
            this.name = string;
            this.oid = objectIdentifier;
            this.className = clazz.getName();
            this.clazz = clazz;
        }

        OIDInfo(String string, ObjectIdentifier objectIdentifier, String string2) {
            this.name = string;
            this.oid = objectIdentifier;
            this.className = string2;
        }
    }
}

