/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.tools.doclets.Util;
import java.util.ArrayList;
import java.util.List;

public class ImplementedMethods {
    private List methlist = new ArrayList();
    private final ClassDoc classdoc;
    private final MethodDoc method;

    private void buildImplementedMethodList(ClassDoc[] classDocArray) {
        int n = 0;
        while (n < classDocArray.length) {
            MethodDoc methodDoc = Util.findMethod(classDocArray[n], this.method);
            if (methodDoc != null) {
                this.removeOverriddenMethod(methodDoc);
                if (!this.overridingMethodFound(methodDoc)) {
                    this.methlist.add(methodDoc);
                }
            }
            ClassDoc[] classDocArray2 = classDocArray[n].interfaces();
            this.buildImplementedMethodList(classDocArray2);
            ++n;
        }
    }

    public MethodDoc[] build() {
        ClassDoc classDoc = this.classdoc;
        while (classDoc != null) {
            this.buildImplementedMethodList(classDoc.interfaces());
            classDoc = classDoc.superclass();
        }
        return this.methlist.toArray(new MethodDoc[this.methlist.size()]);
    }

    public ImplementedMethods(MethodDoc methodDoc) {
        this.method = methodDoc;
        this.classdoc = methodDoc.containingClass();
    }

    private void removeOverriddenMethod(MethodDoc methodDoc) {
        ClassDoc classDoc = methodDoc.overriddenClass();
        if (classDoc != null) {
            int n = 0;
            while (n < this.methlist.size()) {
                ClassDoc classDoc2 = ((MethodDoc)this.methlist.get(n)).containingClass();
                if (classDoc2 == classDoc || classDoc.subclassOf(classDoc2)) {
                    this.methlist.remove(n);
                    return;
                }
                ++n;
            }
        }
    }

    private boolean overridingMethodFound(MethodDoc methodDoc) {
        ClassDoc classDoc = methodDoc.containingClass();
        int n = 0;
        while (n < this.methlist.size()) {
            MethodDoc methodDoc2 = (MethodDoc)this.methlist.get(n);
            if (classDoc == methodDoc2.containingClass()) {
                return true;
            }
            ClassDoc classDoc2 = methodDoc2.overriddenClass();
            if (classDoc2 != null && (classDoc2 == classDoc || classDoc2.subclassOf(classDoc))) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

