/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.PrimitiveTypeImpl;
import com.sun.tools.jdi.ValueContainer;
import com.sun.tools.jdi.ValueImpl;

public abstract class PrimitiveValueImpl
extends ValueImpl
implements PrimitiveValue {
    public abstract byte byteValue();

    byte checkedByteValue() throws InvalidTypeException {
        return this.byteValue();
    }

    public abstract char charValue();

    char checkedCharValue() throws InvalidTypeException {
        return this.charValue();
    }

    final double checkedDoubleValue() throws InvalidTypeException {
        return this.doubleValue();
    }

    public abstract double doubleValue();

    float checkedFloatValue() throws InvalidTypeException {
        return this.floatValue();
    }

    public abstract float floatValue();

    int checkedIntValue() throws InvalidTypeException {
        return this.intValue();
    }

    public abstract int intValue();

    long checkedLongValue() throws InvalidTypeException {
        return this.longValue();
    }

    public abstract long longValue();

    short checkedShortValue() throws InvalidTypeException {
        return this.shortValue();
    }

    public abstract short shortValue();

    public abstract boolean booleanValue();

    final boolean checkedBooleanValue() throws InvalidTypeException {
        if (this instanceof BooleanValue) {
            return this.booleanValue();
        }
        throw new InvalidTypeException("Can't convert non-boolean value to boolean");
    }

    PrimitiveValueImpl(VirtualMachine virtualMachine) {
        super(virtualMachine);
    }

    ValueImpl convertForAssignmentTo(ValueContainer valueContainer) throws InvalidTypeException {
        if (valueContainer.signature().length() > 1) {
            throw new InvalidTypeException("Can't assign primitive value to object");
        }
        try {
            PrimitiveTypeImpl primitiveTypeImpl = (PrimitiveTypeImpl)valueContainer.type();
            return (ValueImpl)((Object)primitiveTypeImpl.convert(this));
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InternalException("Signature and type inconsistent for: " + valueContainer.typeName());
        }
    }

    ValueImpl prepareForAssignmentTo(ValueContainer valueContainer) throws InvalidTypeException {
        return this.convertForAssignmentTo(valueContainer);
    }
}

