/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.javaws.ConfigProperties;
import com.sun.javaws.LaunchErrorDialog;
import com.sun.javaws.cache.CacheImageLoader;
import com.sun.javaws.cache.CacheImageLoaderCallback;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;

class SplashGenerator
extends Thread
implements CacheImageLoaderCallback {
    private File _index;
    private File _dir;
    private final String _key;
    private final LaunchDesc _ld;
    private final Frame _owner;
    private final ConfigProperties _cp;
    private Properties _props;
    private boolean _useAppSplash;

    public void remove() {
        this.addSplashToCacheIndex(this._key, null);
    }

    public void run() {
        InformationDesc informationDesc = this._ld.getInformation();
        IconDesc[] iconDescArray = informationDesc.getIcons();
        try {
            this._dir.mkdirs();
        }
        catch (Throwable throwable) {
            this.splashError(throwable);
        }
        try {
            this._index.createNewFile();
        }
        catch (Throwable throwable) {
            this.splashError(throwable);
        }
        IconDesc iconDesc = informationDesc.getIconLocation(2, 4);
        boolean bl = this._useAppSplash = iconDesc != null;
        if (!this._useAppSplash) {
            iconDesc = informationDesc.getIconLocation(2, 0);
        }
        if (iconDesc == null) {
            try {
                this.create(null, null);
            }
            catch (Throwable throwable) {
                this.splashError(throwable);
            }
        } else {
            CacheImageLoader.getInstance().loadImage(iconDesc, this);
        }
    }

    public boolean needsCustomSplash() {
        return !this._props.containsKey(this._key);
    }

    private void splashError(Throwable throwable) {
        LaunchErrorDialog.showWarning(this._owner, throwable);
        throw new Error(throwable.toString());
    }

    public SplashGenerator(Frame frame, LaunchDesc launchDesc) {
        block3: {
            this._props = new Properties();
            this._useAppSplash = false;
            this._owner = frame;
            this._ld = launchDesc;
            this._cp = ConfigProperties.getInstance();
            this._dir = new File(this._cp.getSplashDir());
            this._key = this._ld.getCanonicalHome().toString();
            String string = this._cp.getSplashCache();
            this._index = new File(string);
            this._cp.setSplashCache(string);
            this._cp.store();
            if (!this._index.exists()) break block3;
            try {
                FileInputStream fileInputStream = new FileInputStream(this._index);
                if (fileInputStream != null) {
                    this._props.load(fileInputStream);
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Debug.ignoredException(iOException);
            }
        }
    }

    private void writeImage(File file, BufferedImage bufferedImage) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            jPEGImageEncoder.encode(bufferedImage);
        }
        catch (Throwable throwable) {
            this.splashError(throwable);
        }
    }

    public void create(Image image, File file) {
        Serializable serializable;
        Rectangle rectangle;
        Object object;
        int n;
        int n2;
        InformationDesc informationDesc = this._ld.getInformation();
        String string = informationDesc.getTitle();
        String string2 = informationDesc.getVendor();
        int n3 = 5;
        JPanel jPanel = new JPanel();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        CompoundBorder compoundBorder = new CompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createBevelBorder(0));
        Insets insets = compoundBorder.getBorderInsets(jPanel);
        int n4 = 320;
        int n5 = 64 + 2 * n3 + insets.top + insets.bottom;
        if (image == null) {
            n2 = 0;
            n = 0;
        } else if (this._useAppSplash) {
            n2 = image.getHeight(this._owner);
            n = image.getWidth(this._owner);
            if (file != null) {
                try {
                    object = file.getCanonicalPath();
                    if (((String)object).endsWith(".jpg")) {
                        this.addSplashToCacheIndex(this._key, (String)object);
                        return;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            n3 = 0;
            n4 = Math.min(n, dimension.width);
            n5 = Math.min(n2, dimension.height);
        } else {
            n2 = 64;
            n = 64;
        }
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 5);
        object = bufferedImage.createGraphics();
        if (this._useAppSplash) {
            rectangle = new Rectangle(0, 0, n4, n5);
        } else {
            ((Graphics)object).setColor(new Color(238, 238, 238));
            ((Graphics)object).fillRect(0, 0, n4, n5);
            ((Graphics)object).setColor(Color.black);
            compoundBorder.paintBorder(jPanel, (Graphics)object, 0, 0, n4, n5);
            serializable = new Rectangle(insets.left, insets.top, n4 - insets.left - insets.right, n5 - insets.top - insets.bottom);
            LineBorder lineBorder = new LineBorder(Color.black);
            Insets insets2 = lineBorder.getBorderInsets(jPanel);
            rectangle = new Rectangle(insets.left + n3, insets.top + n3, n, n2);
            if (image != null) {
                lineBorder.paintBorder(jPanel, (Graphics)object, rectangle.x - insets2.left, rectangle.y - insets2.top, rectangle.width + insets2.left + insets2.right, rectangle.height + insets2.top + insets2.bottom);
                ((Rectangle)serializable).x += n + 2 * n3;
                ((Rectangle)serializable).width -= n + 2 * n3;
            }
            Font font = new Font("SansSerif", 1, 20);
            Font font2 = new Font("SansSerif", 1, 16);
            ((Graphics)object).setColor(Color.black);
            ((Graphics)object).setFont(font);
            Rectangle rectangle2 = new Rectangle(((Rectangle)serializable).x, ((Rectangle)serializable).y + 6, ((Rectangle)serializable).width, ((Rectangle)serializable).height - 12);
            rectangle2.height /= 2;
            this.drawStringInRect((Graphics2D)object, string, rectangle2, 1);
            ((Graphics)object).setFont(font2);
            rectangle2.y += rectangle2.height;
            this.drawStringInRect((Graphics2D)object, string2, rectangle2, 1);
        }
        if (image != null) {
            int n6 = 0;
            while (!((Graphics)object).drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this._owner)) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (++n6 <= 5) continue;
                if (!Globals.TraceSplashScreen) break;
                Debug.println("couldnt draw splash image : " + image);
                break;
            }
        }
        try {
            serializable = File.createTempFile("splash", ".jpg", this._dir);
            this.writeImage((File)serializable, bufferedImage);
            this.addSplashToCacheIndex(this._key, serializable.getCanonicalPath());
        }
        catch (IOException iOException) {
            this.splashError(iOException);
        }
    }

    private void addSplashToCacheIndex(String string, String string2) {
        Object object;
        if (string2 != null) {
            this._props.setProperty(string, string2);
        } else if (this._props.containsKey(string)) {
            this._props.remove(string);
        }
        File[] fileArray = this._dir.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (!fileArray[n].equals(this._index)) {
                try {
                    object = fileArray[n].getCanonicalPath();
                    if (!this._props.containsValue(object)) {
                        fileArray[n].delete();
                    }
                }
                catch (IOException iOException) {
                    this.splashError(iOException);
                }
            }
            ++n;
        }
        try {
            object = new FileOutputStream(this._index);
            this._props.store((OutputStream)object, "");
            ((OutputStream)object).flush();
            ((FileOutputStream)object).close();
        }
        catch (IOException iOException) {
            this.splashError(iOException);
        }
    }

    private void drawStringInRect(Graphics2D graphics2D, String string, Rectangle rectangle, int n) {
        int n2;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        int n3 = fontMetrics.getMaxAscent();
        int n4 = (int)rectangle2D.getWidth();
        int n5 = (int)rectangle2D.getHeight();
        if (n4 > rectangle.width) {
            n2 = rectangle.x;
            String string2 = string.substring(0, string.length() - 3);
            int n6 = string2.length();
            while (n6 > 3 && fontMetrics.stringWidth(string2 + "...") > rectangle.width) {
                string2 = string2.substring(0, --n6);
            }
            string = string2 + "...";
        } else {
            switch (n) {
                default: {
                    n2 = rectangle.x;
                    break;
                }
                case 1: {
                    n2 = rectangle.x + (rectangle.width - n4) / 2;
                    break;
                }
                case 2: {
                    n2 = rectangle.x + (rectangle.width - n4 - 1);
                }
            }
        }
        if (n2 < rectangle.x) {
            n2 = rectangle.x;
        }
        int n7 = rectangle.y + n3 + (rectangle.height - n5) / 2;
        graphics2D.drawString(string, n2, n7);
    }

    public void finalImageAvailable(IconDesc iconDesc, Image image, File file) {
        try {
            this.create(image, file);
        }
        catch (Throwable throwable) {
            this.splashError(throwable);
        }
    }

    public void imageAvailable(IconDesc iconDesc, Image image, File file) {
    }
}

