/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.general.GeneralUtilities;
import java.awt.Window;

public class UnixInstallHandler
extends LocalInstallHandler {
    public boolean isLocalInstallSupported() {
        if (Globals.TraceLocalAppInstall) {
            Debug.println("isLocalInstallSupported called in UnixInstallHandler");
            return true;
        }
        return false;
    }

    public void uninstall(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        if (Globals.TraceLocalAppInstall) {
            Debug.println("uninstall called in UnixInstallHandler");
        }
        localApplicationProperties.setLocallyInstalled(false);
    }

    public void install(Window window, LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        if (Globals.TraceLocalAppInstall) {
            Debug.println("install called in UnixInstallHandler");
        }
        localApplicationProperties.setLocallyInstalled(true);
    }

    public void installIfNecessaryFromLaunch(final Window window, final LaunchDesc launchDesc, final LocalApplicationProperties localApplicationProperties) {
        int n = ConfigProperties.getInstance().getWhenInstall();
        switch (n) {
            case 0: {
                return;
            }
            case 1: {
                this.install(window, launchDesc, localApplicationProperties);
                return;
            }
        }
        if (localApplicationProperties.getAskedForInstall()) {
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                int n = GeneralUtilities.showLocalInstallDialog(window, launchDesc.getInformation().getTitle());
                if (Globals.TraceLocalAppInstall) {
                    Debug.println("showLocalInstallDialog returned: " + n);
                }
                switch (n) {
                    case 1: {
                        UnixInstallHandler.this.install(window, launchDesc, localApplicationProperties);
                        localApplicationProperties.setAskedForInstall(true);
                        break;
                    }
                    case 0: {
                        localApplicationProperties.setAskedForInstall(true);
                        break;
                    }
                    case 2: {
                        localApplicationProperties.setAskedForInstall(false);
                    }
                }
            }
        }).start();
    }
}

