/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public abstract class RoundRectangle2D
extends RectangularShape {
    public abstract double getArcHeight();

    public abstract double getArcWidth();

    public abstract void setRoundRect(double var1, double var3, double var5, double var7, double var9, double var11);

    protected RoundRectangle2D() {
    }

    public boolean contains(double x, double y) {
        double mx = this.getX();
        double mw = this.getWidth();
        if (x < mx || x >= mx + mw) {
            return false;
        }
        double my = this.getY();
        double mh = this.getHeight();
        if (y < my || y >= my + mh) {
            return false;
        }
        double dy = Math.min(Math.abs(my - y), Math.abs(my + mh - y));
        double dx = Math.min(Math.abs(mx - x), Math.abs(mx + mw - x));
        double aw = this.getArcWidth();
        double ah = this.getArcHeight();
        if (dx > aw || dy > ah) {
            return true;
        }
        return (dx = (aw - dx) / aw) * dx + (dy = (ah - dy) / ah) * dy <= 1.0;
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.contains(x, y) && this.contains(x + w, h) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return null;
    }

    public boolean intersects(double x, double y, double w, double h) {
        double mx = this.getX();
        double mw = this.getWidth();
        if (x < mx || x >= mx + mw || x + w < mx || x + w >= mx + mw) {
            return false;
        }
        double my = this.getY();
        double mh = this.getHeight();
        return y >= my && y < my + mh && y + h >= my && y + h < my + mh;
    }

    public void setFrame(double x, double y, double w, double h) {
        this.setRoundRect(x, y, w, h, this.getArcWidth(), this.getArcHeight());
    }

    public void setRoundRect(RoundRectangle2D rr) {
        this.setRoundRect(rr.getX(), rr.getY(), rr.getWidth(), rr.getHeight(), rr.getArcWidth(), rr.getArcHeight());
    }

    public static class Double
    extends RoundRectangle2D {
        public double archeight;
        public double arcwidth;
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
            this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }

        public Double(double x, double y, double w, double h, double arcWidth, double arcHeight) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.arcwidth = arcWidth;
            this.archeight = arcHeight;
        }

        public double getArcHeight() {
            return this.archeight;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.arcwidth = arcWidth;
            this.archeight = arcHeight;
        }
    }

    public static class Float
    extends RoundRectangle2D {
        public float archeight;
        public float arcwidth;
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
            this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        public Float(float x, float y, float w, float h, float arcWidth, float arcHeight) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.arcwidth = arcWidth;
            this.archeight = arcHeight;
        }

        public double getArcHeight() {
            return this.archeight;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRoundRect(float x, float y, float w, float h, float arcWidth, float arcHeight) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.arcwidth = arcWidth;
            this.archeight = arcHeight;
        }

        public void setRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
            this.x = (float)x;
            this.y = (float)y;
            this.width = (float)w;
            this.height = (float)h;
            this.arcwidth = (float)arcWidth;
            this.archeight = (float)arcHeight;
        }
    }
}

