/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.connection.EndPointInfo;
import com.sun.corba.se.connection.GetEndPointInfoAgainException;
import com.sun.corba.se.internal.core.EndPoint;
import com.sun.corba.se.internal.core.IOR;
import com.sun.corba.se.internal.core.ServerGIOP;
import com.sun.corba.se.internal.iiop.Connection;
import com.sun.corba.se.internal.iiop.EndPointImpl;
import com.sun.corba.se.internal.iiop.IIOPConnection;
import com.sun.corba.se.internal.iiop.ORB;
import com.sun.corba.se.internal.orbutil.ORBUtility;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;

public class ConnectionTable {
    protected ORB orb;
    protected Hashtable connectionCache = new Hashtable();
    protected long globalCounter = 0L;
    private int MAX_SOCKET_RETRIES = 5;
    protected ServerGIOP server;

    public void checkConnectionTable() {
        if (this.connectionCache.size() > this.orb.getHighWaterMark()) {
            this.cleanUp();
        }
    }

    void destroyConnections() {
        Enumeration enumeration = this.connectionCache.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            connection.shutdown();
        }
    }

    public synchronized void print() {
        System.out.println("***ConnectionTable***");
        int n2 = this.connectionCache.size();
        System.out.println("  SIZE=" + n2);
        if (n2 < 10) {
            Enumeration enumeration = this.connectionCache.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                connection.print();
            }
        }
    }

    public boolean cleanUp() {
        if (this.orb.transportDebugFlag) {
            this.dprint("Cleanup called");
        }
        if (this.connectionCache.size() < this.orb.getLowWaterMark()) {
            if (this.orb.transportDebugFlag) {
                this.dprint("Cleanup returns false: not enough connections open to start cleanup");
            }
            return false;
        }
        for (int i2 = 0; i2 < this.orb.getNumberToReclaim(); ++i2) {
            Connection connection = null;
            long l2 = Long.MAX_VALUE;
            Enumeration enumeration = this.connectionCache.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection2 = (Connection)enumeration.nextElement();
                if (connection2.isBusy() || connection2.timeStamp >= l2) continue;
                connection = connection2;
                l2 = connection2.timeStamp;
            }
            if (connection == null) {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Cleanup returns false: all connections busy");
                }
                return false;
            }
            try {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Cleanup is cleaning connection " + connection);
                }
                connection.cleanUp();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized void deleteConn(EndPoint endPoint) {
        if (this.orb.transportDebugFlag) {
            this.dprint("DeleteConn called: host = " + endPoint.getHostName() + " port = " + endPoint.getPort());
        }
        this.connectionCache.remove(endPoint);
    }

    public synchronized void stampTime(Connection connection) {
        connection.timeStamp = this.globalCounter++;
    }

    private void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public ConnectionTable(ORB oRB, ServerGIOP serverGIOP) {
        this.orb = oRB;
        this.server = serverGIOP;
    }

    public Connection getConnection(IOR iOR) {
        return this.getConnection(iOR, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(IOR iOR, EndPointInfo endPointInfo) {
        endPointInfo = this.orb.getSocketFactory().getEndPointInfo(this.orb, iOR, endPointInfo);
        EndPointImpl endPointImpl = endPointInfo instanceof EndPointImpl ? (EndPointImpl)endPointInfo : new EndPointImpl(endPointInfo.getType(), endPointInfo.getPort(), endPointInfo.getHost());
        if (this.orb.transportDebugFlag) {
            this.dprint("Client get called: host = " + endPointImpl.getHostName() + " port = " + endPointImpl.getPort());
        }
        Connection connection = null;
        ConnectionTable connectionTable = this;
        synchronized (connectionTable) {
            connection = (Connection)this.connectionCache.get(endPointImpl);
            if (connection != null) {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Returning connection " + connection + " from table");
                }
                return connection;
            }
        }
        int n2 = 0;
        while (true) {
            try {
                Socket socket = this.orb.getSocketFactory().createSocket(endPointInfo);
                try {
                    socket.setTcpNoDelay(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ConnectionTable connectionTable2 = this;
                synchronized (connectionTable2) {
                    connection = new IIOPConnection(this.orb, this.server, this, endPointImpl);
                    this.stampTime(connection);
                    this.connectionCache.put(endPointImpl, connection);
                    connection.setConnection(socket, this);
                    if (this.orb.transportDebugFlag) {
                        this.dprint("Creating new connection " + connection);
                    }
                }
                this.checkConnectionTable();
            }
            catch (GetEndPointInfoAgainException getEndPointInfoAgainException) {
                if (connection != null) {
                    connection.abortConnection();
                }
                this.deleteConn(endPointImpl);
                return this.getConnection(iOR, getEndPointInfoAgainException.getEndPointInfo());
            }
            catch (SocketException socketException) {
                if (this.orb.transportDebugFlag) {
                    this.dprint("SocketException " + socketException + " while creating socket for new connection");
                }
                if (socketException instanceof BindException || socketException instanceof ConnectException || socketException instanceof NoRouteToHostException) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint("Serious error: aborting connection");
                    }
                    throw new COMM_FAILURE(1398079689, CompletionStatus.COMPLETED_NO);
                }
                if (this.orb.transportDebugFlag) {
                    this.dprint("Attempting resource cleanup and retry on socket creation");
                }
                if (n2 == this.MAX_SOCKET_RETRIES || !this.cleanUp()) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint("Out of resources: aborting connection");
                    }
                    throw new COMM_FAILURE(1398079689, CompletionStatus.COMPLETED_NO);
                }
                ++n2;
                continue;
            }
            catch (Exception exception) {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Exception " + exception + " while creating socket for new connection: aborting connection");
                }
                if (connection != null) {
                    connection.abortConnection();
                }
                this.deleteConn(endPointImpl);
                throw new COMM_FAILURE(1398079689, CompletionStatus.COMPLETED_NO);
            }
            break;
        }
        if (this.orb.transportDebugFlag) {
            this.dprint("Succesfully created socket for new connection");
        }
        return connection;
    }

    public synchronized Connection getConnection(Socket socket, String string) {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint("Server getConnection(" + socket + ", " + string + ")");
            }
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                inputStream = socket.getInputStream();
                outputStream = socket.getOutputStream();
            }
            catch (Exception exception) {
                throw new COMM_FAILURE(1398079689, CompletionStatus.COMPLETED_NO);
            }
            String string2 = socket.getInetAddress().getHostName();
            int n2 = socket.getPort();
            EndPointImpl endPointImpl = new EndPointImpl(string, n2, string2);
            if (this.orb.transportDebugFlag) {
                this.dprint("host = " + string2 + " port = " + n2);
            }
            IIOPConnection iIOPConnection = new IIOPConnection(this.orb, this.server, endPointImpl, socket, inputStream, outputStream, this);
            this.connectionCache.put(endPointImpl, iIOPConnection);
            this.stampTime(iIOPConnection);
            if (this.orb.transportDebugFlag) {
                this.dprint("Created connection " + iIOPConnection);
            }
            return iIOPConnection;
        }
        catch (Exception exception) {
            if (this.orb.transportDebugFlag) {
                this.dprint("Exception " + exception + " on creating connection");
            }
            try {
                socket.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
    }
}

