/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.orbutil;

import com.sun.corba.se.internal.orbutil.Collision;

class FastCacheTable {
    static final int kGrowthRate = 101;
    static final int kMaxCacheSize = 30;
    static final int kKeysPos = 0;
    static final int kValsPos = 1;
    static final int kHashCodesPos = 2;
    static final int kCollisionsPos = 3;
    static final Object[][] cache = new Object[31][4];
    static int cacheIndex = -1;
    Object[] keys = null;
    int[] vals;
    int[] hashCodes;
    Collision[] collisions;
    int count;
    int threshold;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkForGrowth() {
        if (this.keys == null) {
            this.count = 0;
            Object[][] objectArray = cache;
            synchronized (cache) {
                if (cacheIndex > -1) {
                    this.keys = (Object[])cache[cacheIndex][0];
                    this.vals = (int[])cache[cacheIndex][1];
                    this.hashCodes = (int[])cache[cacheIndex][2];
                    this.collisions = (Collision[])cache[cacheIndex][3];
                    for (int i2 = this.keys.length; i2 > 0; --i2) {
                        this.keys[i2 - 1] = null;
                    }
                    --cacheIndex;
                    this.threshold = 3 * this.keys.length / 4;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.keys = new Object[101];
                this.vals = new int[101];
                this.hashCodes = new int[101];
                this.collisions = null;
                this.threshold = 3 * this.keys.length / 4;
                return;
            }
        }
        if (this.threshold != this.count) return;
        int n2 = this.keys.length;
        int n3 = n2 + 101;
        Object[] objectArray = new Object[n3];
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        Collision[] collisionArray = null;
        for (int i3 = 0; i3 < n2; ++i3) {
            Collision collision;
            if (this.keys[i3] == null) continue;
            int n4 = this.hashCodes[i3];
            int n5 = (n4 & Integer.MAX_VALUE) % n3;
            if (objectArray[n5] == null) {
                objectArray[n5] = this.keys[i3];
                nArray[n5] = this.vals[i3];
                nArray2[n5] = n4;
                if (collisionArray != null) {
                    collisionArray[n5] = null;
                }
            } else {
                collision = new Collision();
                collision.key = this.keys[i3];
                collision.val = this.vals[i3];
                collision.hash = n4;
                if (collisionArray == null) {
                    collisionArray = new Collision[n3];
                }
                collision.next = collisionArray[n5];
                collisionArray[n5] = collision;
            }
            if (this.collisions == null) continue;
            collision = this.collisions[i3];
            while (collision != null) {
                n4 = collision.hash;
                n5 = (n4 & Integer.MAX_VALUE) % n3;
                if (objectArray[n5] == null) {
                    objectArray[n5] = collision.key;
                    nArray[n5] = collision.val;
                    nArray2[n5] = n4;
                    if (collisionArray != null) {
                        collisionArray[n5] = null;
                    }
                } else {
                    Collision collision2 = new Collision();
                    collision2.key = collision.key;
                    collision2.val = collision.val;
                    collision2.hash = n4;
                    if (collisionArray == null) {
                        collisionArray = new Collision[n3];
                    }
                    collision2.next = collisionArray[n5];
                    collisionArray[n5] = collision2;
                }
                collision = collision.next;
            }
        }
        Object[][] objectArray2 = cache;
        synchronized (cache) {
            if (cacheIndex < 30) {
                FastCacheTable.cache[++FastCacheTable.cacheIndex][0] = this.keys;
                FastCacheTable.cache[FastCacheTable.cacheIndex][1] = this.vals;
                FastCacheTable.cache[FastCacheTable.cacheIndex][2] = this.hashCodes;
                FastCacheTable.cache[FastCacheTable.cacheIndex][3] = this.collisions;
            }
            // ** MonitorExit[var7_11] (shouldn't be in output)
            this.keys = objectArray;
            this.vals = nArray;
            this.hashCodes = nArray2;
            this.collisions = collisionArray;
            this.threshold = 3 * this.keys.length / 4;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Object[][] objectArray = cache;
        synchronized (cache) {
            if (cacheIndex < 30) {
                FastCacheTable.cache[++FastCacheTable.cacheIndex][0] = this.keys;
                FastCacheTable.cache[FastCacheTable.cacheIndex][1] = this.vals;
                FastCacheTable.cache[FastCacheTable.cacheIndex][2] = this.hashCodes;
                FastCacheTable.cache[FastCacheTable.cacheIndex][3] = this.collisions;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.keys = null;
            this.vals = null;
            this.hashCodes = null;
            this.collisions = null;
            return;
        }
    }

    public final int getVal(Object object) {
        Collision collision;
        int n2 = System.identityHashCode(object);
        int n3 = (n2 & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n3] == null) {
            return -1;
        }
        if (this.keys[n3] == object) {
            return this.vals[n3];
        }
        Collision collision2 = collision = this.collisions == null ? null : this.collisions[n3];
        if (collision == null) {
            return -1;
        }
        do {
            if (collision.key != object) continue;
            return collision.val;
        } while ((collision = collision.next) != null);
        return -1;
    }

    public final boolean containsKey(Object object) {
        Collision collision;
        int n2 = System.identityHashCode(object);
        int n3 = (n2 & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n3] == null) {
            return false;
        }
        if (this.keys[n3] == object) {
            return true;
        }
        Collision collision2 = collision = this.collisions == null ? null : this.collisions[n3];
        if (collision == null) {
            return false;
        }
        do {
            if (collision.key != object) continue;
            return true;
        } while ((collision = collision.next) != null);
        return false;
    }

    public final void put(Object object, int n2) {
        this.checkForGrowth();
        int n3 = System.identityHashCode(object);
        int n4 = (n3 & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n4] == null) {
            this.keys[n4] = object;
            this.vals[n4] = n2;
            this.hashCodes[n4] = n3;
            if (this.collisions != null) {
                this.collisions[n4] = null;
            }
        } else {
            Collision collision = new Collision();
            collision.key = object;
            collision.val = n2;
            collision.hash = n3;
            if (this.collisions == null) {
                this.collisions = new Collision[this.keys.length];
            }
            collision.next = this.collisions[n4];
            this.collisions[n4] = collision;
        }
        ++this.count;
    }
}

