/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Vector;

public class RenderableImageOp
implements RenderableImage {
    ParameterBlock paramBlock;
    ContextualRenderedImageFactory myCRIF;
    Rectangle2D boundingBox;

    public float getHeight() {
        if (this.boundingBox == null) {
            this.boundingBox = this.myCRIF.getBounds2D(this.paramBlock);
        }
        return (float)this.boundingBox.getHeight();
    }

    public float getMinX() {
        if (this.boundingBox == null) {
            this.boundingBox = this.myCRIF.getBounds2D(this.paramBlock);
        }
        return (float)this.boundingBox.getMinX();
    }

    public float getMinY() {
        if (this.boundingBox == null) {
            this.boundingBox = this.myCRIF.getBounds2D(this.paramBlock);
        }
        return (float)this.boundingBox.getMinY();
    }

    public float getWidth() {
        if (this.boundingBox == null) {
            this.boundingBox = this.myCRIF.getBounds2D(this.paramBlock);
        }
        return (float)this.boundingBox.getWidth();
    }

    public boolean isDynamic() {
        return this.myCRIF.isDynamic();
    }

    public RenderedImage createDefaultRendering() {
        AffineTransform affineTransform = new AffineTransform();
        RenderContext renderContext = new RenderContext(affineTransform);
        return this.createRendering(renderContext);
    }

    public ParameterBlock getParameterBlock() {
        return this.paramBlock;
    }

    public String[] getPropertyNames() {
        return this.myCRIF.getPropertyNames();
    }

    private Vector getRenderableSources() {
        Vector vector = null;
        if (this.paramBlock.getNumSources() > 0) {
            Object object;
            vector = new Vector();
            for (int i2 = 0; i2 < this.paramBlock.getNumSources() && (object = this.paramBlock.getSource(i2)) instanceof RenderableImage; ++i2) {
                vector.add((RenderableImage)object);
            }
        }
        return vector;
    }

    public Vector getSources() {
        return this.getRenderableSources();
    }

    public RenderedImage createScaledRendering(int n2, int n3, RenderingHints renderingHints) {
        double d2;
        double d3 = (double)n2 / (double)this.getWidth();
        if (Math.abs(d3 / (d2 = (double)n3 / (double)this.getHeight()) - 1.0) < 0.01) {
            d3 = d2;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d3, d2);
        RenderContext renderContext = new RenderContext(affineTransform, renderingHints);
        return this.createRendering(renderContext);
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Object var2_2 = null;
        RenderContext renderContext2 = null;
        ParameterBlock parameterBlock = (ParameterBlock)this.paramBlock.clone();
        Vector vector = this.getRenderableSources();
        try {
            if (vector != null) {
                Vector vector2 = new Vector();
                for (int i2 = 0; i2 < vector.size(); ++i2) {
                    renderContext2 = this.myCRIF.mapRenderContext(i2, renderContext, this.paramBlock, this);
                    RenderedImage renderedImage = ((RenderableImage)vector.elementAt(i2)).createRendering(renderContext2);
                    if (renderedImage == null) {
                        return null;
                    }
                    vector2.addElement(renderedImage);
                }
                if (vector2.size() > 0) {
                    parameterBlock.setSources(vector2);
                }
            }
            return this.myCRIF.create(renderContext, parameterBlock);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public RenderableImageOp(ContextualRenderedImageFactory contextualRenderedImageFactory, ParameterBlock parameterBlock) {
        this.myCRIF = contextualRenderedImageFactory;
        this.paramBlock = (ParameterBlock)parameterBlock.clone();
    }

    public ParameterBlock setParameterBlock(ParameterBlock parameterBlock) {
        ParameterBlock parameterBlock2 = this.paramBlock;
        this.paramBlock = (ParameterBlock)parameterBlock.clone();
        return parameterBlock2;
    }

    public Object getProperty(String string) {
        return this.myCRIF.getProperty(this.paramBlock, string);
    }
}

