/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.BreakIterator;
import java.text.CharSet;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import sun.text.CompactByteArray;

class RuleBasedBreakIterator
extends BreakIterator {
    protected static final byte IGNORE = -1;
    private static final short START_STATE = 1;
    private static final short STOP_STATE = 0;
    private String description;
    private CompactByteArray charCategoryTable = null;
    private short[] stateTable = null;
    private short[] backwardsStateTable = null;
    private boolean[] endStates = null;
    private boolean[] lookaheadStates = null;
    private int numCategories;
    private CharacterIterator text = null;

    public int current() {
        return this.getText().getIndex();
    }

    public int first() {
        CharacterIterator characterIterator = this.getText();
        characterIterator.first();
        return characterIterator.getIndex();
    }

    protected int handleNext() {
        CharacterIterator characterIterator = this.getText();
        if (characterIterator.getIndex() == characterIterator.getEndIndex()) {
            return -1;
        }
        int n2 = characterIterator.getIndex() + 1;
        int n3 = 0;
        int n4 = 1;
        char c2 = characterIterator.current();
        while (c2 != '\uffff' && n4 != 0) {
            int n5 = this.lookupCategory(c2);
            if (n5 != -1) {
                n4 = this.lookupState(n4, n5);
            }
            if (this.lookaheadStates[n4]) {
                if (this.endStates[n4]) {
                    n2 = n3;
                } else {
                    n3 = characterIterator.getIndex() + 1;
                }
            } else if (this.endStates[n4]) {
                n2 = characterIterator.getIndex() + 1;
            }
            c2 = characterIterator.next();
        }
        if (c2 == '\uffff' && n3 == characterIterator.getEndIndex()) {
            n2 = n3;
        }
        characterIterator.setIndex(n2);
        return n2;
    }

    protected int handlePrevious() {
        CharacterIterator characterIterator = this.getText();
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        char c2 = characterIterator.current();
        while (c2 != '\uffff' && n2 != 0) {
            n4 = n3;
            n3 = this.lookupCategory(c2);
            if (n3 != -1) {
                n2 = this.lookupBackwardState(n2, n3);
            }
            c2 = characterIterator.previous();
        }
        if (c2 != '\uffff') {
            if (n4 != -1) {
                characterIterator.setIndex(characterIterator.getIndex() + 2);
            } else {
                characterIterator.next();
            }
        }
        return characterIterator.getIndex();
    }

    public int hashCode() {
        return this.description.hashCode();
    }

    public int last() {
        CharacterIterator characterIterator = this.getText();
        characterIterator.setIndex(characterIterator.getEndIndex());
        return characterIterator.getIndex();
    }

    public int next() {
        return this.handleNext();
    }

    public int previous() {
        int n2;
        CharacterIterator characterIterator = this.getText();
        if (this.current() == characterIterator.getBeginIndex()) {
            return -1;
        }
        int n3 = this.current();
        characterIterator.previous();
        int n4 = n2 = this.handlePrevious();
        while (n4 != -1 && n4 < n3) {
            n2 = n4;
            n4 = this.handleNext();
        }
        characterIterator.setIndex(n2);
        return n2;
    }

    protected int lookupCategory(char c2) {
        return this.charCategoryTable.elementAt(c2);
    }

    public int following(int n2) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n2, characterIterator);
        characterIterator.setIndex(n2);
        if (n2 == characterIterator.getBeginIndex()) {
            return this.handleNext();
        }
        int n3 = this.handlePrevious();
        while (n3 != -1 && n3 <= n2) {
            n3 = this.handleNext();
        }
        return n3;
    }

    public int next(int n2) {
        int n3 = this.current();
        while (n2 > 0) {
            n3 = this.handleNext();
            --n2;
        }
        while (n2 < 0) {
            n3 = this.previous();
            ++n2;
        }
        return n3;
    }

    public int preceding(int n2) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n2, characterIterator);
        characterIterator.setIndex(n2);
        return this.previous();
    }

    public boolean isBoundary(int n2) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n2, characterIterator);
        if (n2 == characterIterator.getBeginIndex()) {
            return true;
        }
        return this.following(n2 - 1) == n2;
    }

    protected int lookupBackwardState(int n2, int n3) {
        return this.backwardsStateTable[n2 * this.numCategories + n3];
    }

    protected int lookupState(int n2, int n3) {
        return this.stateTable[n2 * this.numCategories + n3];
    }

    public Object clone() {
        RuleBasedBreakIterator ruleBasedBreakIterator = (RuleBasedBreakIterator)super.clone();
        if (this.text != null) {
            ruleBasedBreakIterator.text = (CharacterIterator)this.text.clone();
        }
        return ruleBasedBreakIterator;
    }

    public boolean equals(Object object) {
        try {
            RuleBasedBreakIterator ruleBasedBreakIterator = (RuleBasedBreakIterator)object;
            if (!this.description.equals(ruleBasedBreakIterator.description)) {
                return false;
            }
            if (this.text == null) {
                return ruleBasedBreakIterator.text == null;
            }
            return this.text.equals(ruleBasedBreakIterator.text);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return this.description;
    }

    public RuleBasedBreakIterator(String string) {
        this.description = string;
        Builder builder = this.makeBuilder();
        builder.buildBreakIterator();
    }

    public CharacterIterator getText() {
        if (this.text == null) {
            this.text = new StringCharacterIterator("");
        }
        return this.text;
    }

    protected static final void checkOffset(int n2, CharacterIterator characterIterator) {
        if (n2 < characterIterator.getBeginIndex() || n2 >= characterIterator.getEndIndex()) {
            throw new IllegalArgumentException("offset out of bounds");
        }
    }

    public void setText(CharacterIterator characterIterator) {
        boolean bl2;
        int n2 = characterIterator.getEndIndex();
        try {
            characterIterator.setIndex(n2);
            bl2 = characterIterator.getIndex() == n2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl2 = false;
        }
        this.text = bl2 ? characterIterator : new SafeCharIterator(characterIterator);
        this.text.first();
    }

    static /* synthetic */ short[] access$502(RuleBasedBreakIterator ruleBasedBreakIterator, short[] sArray) {
        ruleBasedBreakIterator.stateTable = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$602(RuleBasedBreakIterator ruleBasedBreakIterator, short[] sArray) {
        ruleBasedBreakIterator.backwardsStateTable = sArray;
        return sArray;
    }

    static /* synthetic */ boolean[] access$302(RuleBasedBreakIterator ruleBasedBreakIterator, boolean[] blArray) {
        ruleBasedBreakIterator.endStates = blArray;
        return blArray;
    }

    static /* synthetic */ boolean[] access$402(RuleBasedBreakIterator ruleBasedBreakIterator, boolean[] blArray) {
        ruleBasedBreakIterator.lookaheadStates = blArray;
        return blArray;
    }

    protected Builder makeBuilder() {
        return new Builder();
    }

    protected class Builder {
        protected Vector categories = null;
        protected Hashtable expressions = null;
        protected CharSet ignoreChars = null;
        protected Vector tempStateTable = null;
        protected Vector decisionPointList = null;
        protected Stack decisionPointStack = null;
        protected Vector loopingStates = null;
        protected Vector statesToBackfill = null;
        protected Vector mergeList = null;
        protected boolean clearLoopingStates = false;
        protected static final int END_STATE_FLAG = 32768;
        protected static final int DONT_LOOP_FLAG = 16384;
        protected static final int LOOKAHEAD_STATE_FLAG = 8192;
        protected static final int ALL_FLAGS = 57344;

        private void backfillLoopingStates() {
            short[] sArray = null;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.tempStateTable.size()) {
                short[] sArray2 = (short[])this.tempStateTable.elementAt(n3);
                int n4 = sArray2[RuleBasedBreakIterator.this.numCategories] & 0xFFFF1FFF;
                if (n4 > 0) {
                    if (n4 != n2) {
                        n2 = n4;
                        sArray = (short[])this.tempStateTable.elementAt(n2);
                    }
                    int n5 = RuleBasedBreakIterator.this.numCategories;
                    sArray2[n5] = (short)(sArray2[n5] & 0xE000);
                    int n6 = 0;
                    while (n6 < sArray2.length) {
                        if (sArray2[n6] == 0) {
                            sArray2[n6] = sArray[n6];
                        } else if (sArray2[n6] == 16384) {
                            sArray2[n6] = 0;
                        }
                        ++n6;
                    }
                }
                ++n3;
            }
        }

        public void buildBreakIterator() {
            Vector vector = this.buildRuleList(RuleBasedBreakIterator.this.description);
            this.buildCharCategories(vector);
            this.buildStateTable(vector);
            this.buildBackwardsStateTable(vector);
        }

        private void eliminateBackfillStates(int n2) {
            if (this.statesToBackfill.contains(new Integer(n2))) {
                this.statesToBackfill.removeElement(new Integer(n2));
                short[] sArray = (short[])this.tempStateTable.elementAt(n2);
                int n3 = 0;
                while (n3 < RuleBasedBreakIterator.this.numCategories) {
                    if (sArray[n3] != 0) {
                        this.eliminateBackfillStates(sArray[n3]);
                    }
                    ++n3;
                }
            }
        }

        private int searchMergeList(int n2, int n3) {
            if (this.mergeList == null) {
                return 0;
            }
            int n4 = 0;
            while (n4 < this.mergeList.size()) {
                int[] nArray = (int[])this.mergeList.elementAt(n4);
                if (nArray[0] == n2 && nArray[1] == n3 || nArray[0] == n3 && nArray[1] == n2) {
                    return nArray[2];
                }
                if (nArray[2] == n2 && (nArray[0] == n3 || nArray[1] == n3)) {
                    return nArray[2];
                }
                if (nArray[2] == n3 && (nArray[0] == n2 || nArray[1] == n2)) {
                    return nArray[2];
                }
                ++n4;
            }
            return 0;
        }

        private void finishBuildingStateTable(boolean bl2) {
            int n2;
            int n3;
            int n4;
            short[] sArray;
            this.backfillLoopingStates();
            int[] nArray = new int[this.tempStateTable.size()];
            Stack stack = new Stack();
            stack.push(new Integer(1));
            nArray[1] = 1;
            while (stack.size() != 0) {
                int n5 = (Integer)stack.pop();
                short[] sArray2 = (short[])this.tempStateTable.elementAt(n5);
                int n6 = 0;
                while (n6 < RuleBasedBreakIterator.this.numCategories) {
                    if (sArray2[n6] != 0 && nArray[sArray2[n6]] == 0) {
                        nArray[sArray2[n6]] = sArray2[n6];
                        stack.push(new Integer(sArray2[n6]));
                    }
                    ++n6;
                }
            }
            int[] nArray2 = new int[this.tempStateTable.size()];
            int n7 = RuleBasedBreakIterator.this.numCategories + 1;
            int n8 = 1;
            while (n8 < nArray2.length) {
                if (nArray[n8] != 0) {
                    sArray = (short[])this.tempStateTable.elementAt(n8);
                    n4 = 0;
                    while (n4 < RuleBasedBreakIterator.this.numCategories) {
                        if (sArray[n4] != 0) {
                            int n9 = n8;
                            nArray2[n9] = nArray2[n9] + 1;
                        }
                        ++n4;
                    }
                    if (nArray2[n8] == 0) {
                        nArray2[n8] = n7;
                    }
                }
                ++n8;
            }
            ++n7;
            do {
                n4 = 1;
                n3 = n7;
                while (n4 < n7) {
                    boolean bl3 = false;
                    short[] sArray3 = null;
                    sArray = null;
                    int n10 = 0;
                    while (n10 < nArray2.length) {
                        if (nArray2[n10] == n4) {
                            if (sArray == null) {
                                sArray = (short[])this.tempStateTable.elementAt(n10);
                            } else {
                                sArray3 = (short[])this.tempStateTable.elementAt(n10);
                                n2 = 0;
                                while (n2 < sArray3.length) {
                                    if (n2 == RuleBasedBreakIterator.this.numCategories && sArray[n2] != sArray3[n2] && bl2 || n2 != RuleBasedBreakIterator.this.numCategories && nArray2[sArray[n2]] != nArray2[sArray3[n2]]) {
                                        nArray2[n10] = n7;
                                        bl3 = true;
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                        }
                        ++n10;
                    }
                    if (bl3) {
                        ++n7;
                    }
                    ++n4;
                }
            } while (n3 != n7);
            int[] nArray3 = new int[n7];
            n2 = 1;
            while (n2 < nArray2.length) {
                if (nArray3[nArray2[n2]] == 0) {
                    nArray3[nArray2[n2]] = n2;
                } else {
                    nArray[n2] = nArray3[nArray2[n2]];
                }
                ++n2;
            }
            int n11 = 1;
            while (n11 < nArray.length) {
                if (nArray[n11] != n11) {
                    this.tempStateTable.setElementAt(null, n11);
                }
                ++n11;
            }
            int n12 = 1;
            int n13 = 1;
            while (n13 < nArray.length) {
                if (this.tempStateTable.elementAt(n13) != null) {
                    nArray[n13] = n12++;
                }
                ++n13;
            }
            int n14 = 1;
            while (n14 < nArray.length) {
                if (this.tempStateTable.elementAt(n14) == null) {
                    nArray[n14] = nArray[nArray[n14]];
                }
                ++n14;
            }
            if (bl2) {
                RuleBasedBreakIterator.access$302(RuleBasedBreakIterator.this, new boolean[n12]);
                RuleBasedBreakIterator.access$402(RuleBasedBreakIterator.this, new boolean[n12]);
                RuleBasedBreakIterator.access$502(RuleBasedBreakIterator.this, new short[n12 * RuleBasedBreakIterator.this.numCategories]);
                int n15 = 0;
                int n16 = 0;
                int n17 = 0;
                while (n17 < this.tempStateTable.size()) {
                    short[] sArray4 = (short[])this.tempStateTable.elementAt(n17);
                    if (sArray4 != null) {
                        int n18 = 0;
                        while (n18 < RuleBasedBreakIterator.this.numCategories) {
                            ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).stateTable[n15] = (short)nArray[sArray4[n18]];
                            ++n15;
                            ++n18;
                        }
                        ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).endStates[n16] = (sArray4[RuleBasedBreakIterator.this.numCategories] & 0x8000) != 0;
                        ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).lookaheadStates[n16] = (sArray4[RuleBasedBreakIterator.this.numCategories] & 0x2000) != 0;
                        ++n16;
                    }
                    ++n17;
                }
            } else {
                RuleBasedBreakIterator.access$602(RuleBasedBreakIterator.this, new short[n12 * RuleBasedBreakIterator.this.numCategories]);
                int n19 = 0;
                int n20 = 0;
                while (n20 < this.tempStateTable.size()) {
                    short[] sArray5 = (short[])this.tempStateTable.elementAt(n20);
                    if (sArray5 != null) {
                        int n21 = 0;
                        while (n21 < RuleBasedBreakIterator.this.numCategories) {
                            ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).backwardsStateTable[n19] = (short)nArray[sArray5[n21]];
                            ++n19;
                            ++n21;
                        }
                    }
                    ++n20;
                }
            }
        }

        private void parseRule(String string, boolean bl2) {
            short[] sArray;
            int n2;
            int n3;
            int n4 = 0;
            int n5 = n3 = 1;
            String string2 = "";
            this.decisionPointStack = new Stack();
            this.decisionPointList = new Vector();
            this.loopingStates = new Vector();
            this.statesToBackfill = new Vector();
            boolean bl3 = false;
            if (!bl2) {
                this.loopingStates.addElement(new Integer(1));
            }
            this.decisionPointList.addElement(new Integer(n3));
            n3 = this.tempStateTable.size() - 1;
            while (n4 < string.length()) {
                n2 = string.charAt(n4);
                this.clearLoopingStates = false;
                if (n2 == 91 || n2 == 92 || Character.isLetter((char)n2) || Character.isDigit((char)n2) || n2 < 32 || n2 == 46 || n2 >= 127) {
                    int n6;
                    if (n2 != 46) {
                        n6 = n4;
                        if (n2 == 92) {
                            n6 = n4 + 2;
                            ++n4;
                        } else if (n2 == 91) {
                            int n7 = 1;
                            while (n7 > 0) {
                                if ((n2 = string.charAt(++n6)) == 91) {
                                    ++n7;
                                    continue;
                                }
                                if (n2 == 93) {
                                    --n7;
                                    continue;
                                }
                                if (n2 != 92) continue;
                                ++n6;
                            }
                            ++n6;
                        } else {
                            n6 = n4 + 1;
                        }
                        string2 = (String)this.expressions.get(string.substring(n4, n6));
                        n4 = n6 - 1;
                    } else {
                        n6 = (Integer)this.decisionPointList.lastElement();
                        sArray = (short[])this.tempStateTable.elementAt(n6);
                        if (n4 + 1 < string.length() && string.charAt(n4 + 1) == '*' && sArray[0] != 0) {
                            this.decisionPointList.addElement(new Integer(sArray[0]));
                            string2 = "";
                            ++n4;
                        } else {
                            StringBuffer stringBuffer = new StringBuffer();
                            int n8 = 0;
                            while (n8 < RuleBasedBreakIterator.this.numCategories) {
                                stringBuffer.append((char)(n8 + 256));
                                ++n8;
                            }
                            string2 = stringBuffer.toString();
                        }
                    }
                    if (string2.length() != 0) {
                        if (n4 + 1 < string.length() && string.charAt(n4 + 1) == '*') {
                            this.decisionPointStack.push(this.decisionPointList.clone());
                        }
                        n6 = this.tempStateTable.size();
                        if (this.loopingStates.size() != 0) {
                            this.statesToBackfill.addElement(new Integer(n6));
                        }
                        sArray = new short[RuleBasedBreakIterator.this.numCategories + 1];
                        if (bl3) {
                            sArray[((RuleBasedBreakIterator)RuleBasedBreakIterator.this).numCategories] = 16384;
                        }
                        this.tempStateTable.addElement(sArray);
                        this.updateStateTable(this.decisionPointList, string2, (short)n6);
                        this.decisionPointList.removeAllElements();
                        n5 = n3;
                        do {
                            this.decisionPointList.addElement(new Integer(++n3));
                        } while (n3 + 1 < this.tempStateTable.size());
                    }
                } else if (n2 == 123) {
                    this.decisionPointStack.push(this.decisionPointList.clone());
                } else if (n2 == 125 || n2 == 42) {
                    if (n2 == 42) {
                        int n9 = n5 + 1;
                        while (n9 < this.tempStateTable.size()) {
                            Vector vector = new Vector();
                            vector.addElement(new Integer(n9));
                            this.updateStateTable(vector, string2, (short)(n5 + 1));
                            ++n9;
                        }
                    }
                    Vector vector = (Vector)this.decisionPointStack.pop();
                    int n10 = 0;
                    while (n10 < this.decisionPointList.size()) {
                        vector.addElement(this.decisionPointList.elementAt(n10));
                        ++n10;
                    }
                    this.decisionPointList = vector;
                } else if (n2 == 63) {
                    this.setLoopingStates(this.decisionPointList, this.decisionPointList);
                } else if (n2 == 40) {
                    this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
                    n5 = n3++;
                    this.decisionPointList.insertElementAt(new Integer(n3), 0);
                    this.decisionPointStack.push(this.decisionPointList.clone());
                    this.decisionPointStack.push(new Vector());
                } else if (n2 == 124) {
                    Vector vector = (Vector)this.decisionPointStack.pop();
                    Vector vector2 = (Vector)this.decisionPointStack.peek();
                    this.decisionPointStack.push(vector);
                    int n11 = 0;
                    while (n11 < this.decisionPointList.size()) {
                        vector.addElement(this.decisionPointList.elementAt(n11));
                        ++n11;
                    }
                    this.decisionPointList = (Vector)vector2.clone();
                } else if (n2 == 41) {
                    Vector vector = (Vector)this.decisionPointStack.pop();
                    int n12 = 0;
                    while (n12 < this.decisionPointList.size()) {
                        vector.addElement(this.decisionPointList.elementAt(n12));
                        ++n12;
                    }
                    this.decisionPointList = vector;
                    if (n4 + 1 >= string.length() || string.charAt(n4 + 1) != '*') {
                        this.decisionPointStack.pop();
                    } else {
                        vector = (Vector)this.decisionPointList.clone();
                        Vector vector3 = (Vector)this.decisionPointStack.pop();
                        int n13 = (Integer)vector3.firstElement();
                        short[] sArray2 = (short[])this.tempStateTable.elementAt(n13);
                        int n14 = 0;
                        while (n14 < this.decisionPointList.size()) {
                            vector3.addElement(this.decisionPointList.elementAt(n14));
                            ++n14;
                        }
                        this.decisionPointList = vector3;
                        int n15 = 0;
                        while (n15 < sArray2.length) {
                            if (sArray2[n15] > n13) {
                                this.updateStateTable(vector, new Character((char)(n15 + 256)).toString(), sArray2[n15]);
                            }
                            ++n15;
                        }
                        n5 = n3;
                        n3 = this.tempStateTable.size() - 1;
                        ++n4;
                    }
                } else if (n2 == 47) {
                    bl3 = true;
                    int n16 = 0;
                    while (n16 < this.decisionPointList.size()) {
                        sArray = (short[])this.tempStateTable.elementAt((Integer)this.decisionPointList.elementAt(n16));
                        int n17 = RuleBasedBreakIterator.this.numCategories;
                        sArray[n17] = (short)(sArray[n17] | 0x2000);
                        ++n16;
                    }
                }
                if (this.clearLoopingStates) {
                    this.setLoopingStates(null, this.decisionPointList);
                }
                ++n4;
            }
            this.setLoopingStates(null, this.decisionPointList);
            n2 = 0;
            while (n2 < this.decisionPointList.size()) {
                int n18 = (Integer)this.decisionPointList.elementAt(n2);
                sArray = (short[])this.tempStateTable.elementAt(n18);
                int n19 = RuleBasedBreakIterator.this.numCategories;
                sArray[n19] = (short)(sArray[n19] | 0x8000);
                if (bl3) {
                    int n20 = RuleBasedBreakIterator.this.numCategories;
                    sArray[n20] = (short)(sArray[n20] | 0x2000);
                }
                ++n2;
            }
        }

        protected void mungeExpressionList(Hashtable hashtable) {
        }

        private void mergeStates(int n2, short[] sArray, Vector vector) {
            short[] sArray2 = (short[])this.tempStateTable.elementAt(n2);
            boolean bl2 = this.loopingStates.contains(new Integer(n2));
            int n3 = 0;
            while (n3 < sArray2.length) {
                if (sArray2[n3] != sArray[n3]) {
                    if (bl2 && this.loopingStates.contains(new Integer(sArray2[n3]))) {
                        if (sArray[n3] != 0) {
                            if (sArray2[n3] == 0) {
                                this.clearLoopingStates = true;
                            }
                            sArray2[n3] = sArray[n3];
                        }
                    } else if (sArray2[n3] == 0) {
                        sArray2[n3] = sArray[n3];
                    } else if (n3 == RuleBasedBreakIterator.this.numCategories) {
                        sArray2[n3] = (short)(sArray[n3] & 0xE000 | sArray2[n3]);
                    } else if (sArray2[n3] != 0 && sArray[n3] != 0) {
                        int n4 = this.searchMergeList(sArray2[n3], sArray[n3]);
                        if (n4 != 0) {
                            sArray2[n3] = (short)n4;
                        } else {
                            int n5 = sArray2[n3];
                            int n6 = sArray[n3];
                            n4 = this.tempStateTable.size();
                            if (this.mergeList == null) {
                                this.mergeList = new Vector();
                            }
                            this.mergeList.addElement(new int[]{n5, n6, n4});
                            short[] sArray3 = new short[RuleBasedBreakIterator.this.numCategories + 1];
                            short[] sArray4 = (short[])this.tempStateTable.elementAt(n5);
                            System.arraycopy(sArray4, 0, sArray3, 0, RuleBasedBreakIterator.this.numCategories + 1);
                            this.tempStateTable.addElement(sArray3);
                            sArray2[n3] = (short)n4;
                            if ((this.decisionPointList.contains(new Integer(n5)) || this.decisionPointList.contains(new Integer(n6))) && !this.decisionPointList.contains(new Integer(n4))) {
                                this.decisionPointList.addElement(new Integer(n4));
                            }
                            if ((vector.contains(new Integer(n5)) || vector.contains(new Integer(n6))) && !vector.contains(new Integer(n4))) {
                                this.decisionPointList.addElement(new Integer(n4));
                            }
                            int n7 = 0;
                            while (n7 < this.decisionPointStack.size()) {
                                Vector vector2 = (Vector)this.decisionPointStack.elementAt(n7);
                                if ((vector2.contains(new Integer(n5)) || vector2.contains(new Integer(n6))) && !vector2.contains(new Integer(n4))) {
                                    vector2.addElement(new Integer(n4));
                                }
                                ++n7;
                            }
                            this.mergeStates(n4, (short[])this.tempStateTable.elementAt(sArray[n3]), vector);
                        }
                    }
                }
                ++n3;
            }
        }

        private void buildBackwardsStateTable(Vector vector) {
            int n2;
            int n3;
            int n4;
            int n5;
            this.tempStateTable = new Vector();
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            int n6 = 0;
            while (n6 < vector.size()) {
                String string = (String)vector.elementAt(n6);
                if (string.charAt(0) == '!') {
                    this.parseRule(string.substring(1), false);
                }
                ++n6;
            }
            this.backfillLoopingStates();
            int n7 = this.tempStateTable.size();
            if (n7 > 2) {
                ++n7;
            }
            int n8 = 0;
            while (n8 < RuleBasedBreakIterator.this.numCategories + 1) {
                this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
                ++n8;
            }
            short[] sArray = (short[])this.tempStateTable.elementAt(n7 - 1);
            int n9 = 0;
            while (n9 < RuleBasedBreakIterator.this.numCategories) {
                sArray[n9] = (short)(n9 + n7);
                ++n9;
            }
            int n10 = RuleBasedBreakIterator.this.stateTable.length / RuleBasedBreakIterator.this.numCategories;
            int n11 = 0;
            while (n11 < RuleBasedBreakIterator.this.numCategories) {
                n5 = 0;
                while (n5 < n10) {
                    n4 = RuleBasedBreakIterator.this.lookupState(n5, n11);
                    if (n4 != 0) {
                        n3 = 0;
                        while (n3 < RuleBasedBreakIterator.this.numCategories) {
                            n2 = RuleBasedBreakIterator.this.lookupState(n4, n3);
                            if (n2 != 0) {
                                sArray = (short[])this.tempStateTable.elementAt(n3 + n7);
                                sArray[n11] = (short)(n11 + n7);
                            }
                            ++n3;
                        }
                    }
                    ++n5;
                }
                ++n11;
            }
            if (n7 > 1) {
                sArray = (short[])this.tempStateTable.elementAt(1);
                n5 = n7 - 1;
                while (n5 < this.tempStateTable.size()) {
                    short[] sArray2 = (short[])this.tempStateTable.elementAt(n5);
                    n3 = 0;
                    while (n3 < RuleBasedBreakIterator.this.numCategories) {
                        if (sArray[n3] != 0 && sArray2[n3] != 0) {
                            sArray2[n3] = sArray[n3];
                        }
                        ++n3;
                    }
                    ++n5;
                }
                sArray = (short[])this.tempStateTable.elementAt(n7 - 1);
                n4 = 1;
                while (n4 < n7 - 1) {
                    short[] sArray3 = (short[])this.tempStateTable.elementAt(n4);
                    if ((sArray3[RuleBasedBreakIterator.this.numCategories] & 0x8000) == 0) {
                        n2 = 0;
                        while (n2 < RuleBasedBreakIterator.this.numCategories) {
                            if (sArray3[n2] == 0) {
                                sArray3[n2] = sArray[n2];
                            }
                            ++n2;
                        }
                    }
                    ++n4;
                }
            }
            this.finishBuildingStateTable(false);
        }

        protected void buildCharCategories(Vector vector) {
            Object object;
            CharSet charSet;
            Object object2;
            CharSet charSet2;
            int n2;
            Object object3;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            this.expressions = new Hashtable();
            while (n5 < vector.size()) {
                object3 = (String)vector.elementAt(n5);
                n4 = 0;
                while (n4 < ((String)object3).length()) {
                    char c2 = ((String)object3).charAt(n4);
                    switch (c2) {
                        case '!': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '.': 
                        case '/': 
                        case ';': 
                        case '?': 
                        case '{': 
                        case '|': 
                        case '}': {
                            break;
                        }
                        case '[': {
                            n2 = n4 + 1;
                            ++n3;
                            while (n2 < ((String)object3).length() && n3 != 0) {
                                c2 = ((String)object3).charAt(n2);
                                switch (c2) {
                                    case '\\': {
                                        ++n2;
                                        break;
                                    }
                                    case '[': {
                                        ++n3;
                                        break;
                                    }
                                    case ']': {
                                        --n3;
                                    }
                                }
                                ++n2;
                            }
                            if (this.expressions.get(((String)object3).substring(n4, n2)) == null) {
                                this.expressions.put(((String)object3).substring(n4, n2), CharSet.parseString(((String)object3).substring(n4, n2)));
                            }
                            n4 = n2 - 1;
                            break;
                        }
                        case '\\': {
                            c2 = ((String)object3).charAt(++n4);
                        }
                        default: {
                            this.expressions.put(((String)object3).substring(n4, n4 + 1), CharSet.parseString(((String)object3).substring(n4, n4 + 1)));
                        }
                    }
                    ++n4;
                }
                ++n5;
            }
            CharSet.releaseExpressionCache();
            this.categories = new Vector();
            if (this.ignoreChars != null) {
                this.categories.addElement(this.ignoreChars);
            } else {
                this.categories.addElement(new CharSet());
            }
            this.ignoreChars = null;
            this.mungeExpressionList(this.expressions);
            object3 = this.expressions.elements();
            while (object3.hasMoreElements()) {
                CharSet charSet3 = (CharSet)object3.nextElement();
                n2 = this.categories.size() - 1;
                while (!charSet3.empty() && n2 > 0) {
                    charSet2 = (CharSet)this.categories.elementAt(n2);
                    if (!charSet2.intersection(charSet3).empty()) {
                        object2 = charSet2.difference(charSet3);
                        if (!((CharSet)object2).empty()) {
                            this.categories.addElement(object2);
                        }
                        object2 = charSet3.intersection(charSet2);
                        charSet3 = charSet3.difference(charSet2);
                        if (!((CharSet)object2).equals(charSet2)) {
                            this.categories.setElementAt(object2, n2);
                        }
                    }
                    --n2;
                }
                if (charSet3.empty()) continue;
                this.categories.addElement(charSet3);
            }
            CharSet charSet4 = new CharSet();
            n2 = 1;
            while (n2 < this.categories.size()) {
                charSet4 = charSet4.union((CharSet)this.categories.elementAt(n2));
                ++n2;
            }
            charSet2 = (CharSet)this.categories.elementAt(0);
            charSet2 = charSet2.difference(charSet4);
            this.categories.setElementAt(charSet2, 0);
            object3 = this.expressions.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                charSet = (CharSet)this.expressions.get(object2);
                object = new StringBuffer();
                int n6 = 0;
                while (n6 < this.categories.size()) {
                    CharSet charSet5 = charSet.intersection((CharSet)this.categories.elementAt(n6));
                    if (!charSet5.empty()) {
                        ((StringBuffer)object).append((char)(256 + n6));
                        if (charSet5.equals(charSet)) break;
                    }
                    ++n6;
                }
                this.expressions.put(object2, ((StringBuffer)object).toString());
            }
            RuleBasedBreakIterator.this.charCategoryTable = new CompactByteArray(0);
            int n7 = 0;
            while (n7 < this.categories.size()) {
                charSet = (CharSet)this.categories.elementAt(n7);
                object = charSet.getChars();
                while (object.hasMoreElements()) {
                    char[] cArray = (char[])object.nextElement();
                    if (n7 != 0) {
                        RuleBasedBreakIterator.this.charCategoryTable.setElementAt(cArray[0], cArray[1], (byte)n7);
                        continue;
                    }
                    RuleBasedBreakIterator.this.charCategoryTable.setElementAt(cArray[0], cArray[1], (byte)-1);
                }
                ++n7;
            }
            RuleBasedBreakIterator.this.charCategoryTable.compact();
            RuleBasedBreakIterator.this.numCategories = this.categories.size();
        }

        private void buildStateTable(Vector vector) {
            this.tempStateTable = new Vector();
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            int n2 = 0;
            while (n2 < vector.size()) {
                String string = (String)vector.elementAt(n2);
                if (string.charAt(0) != '!') {
                    this.parseRule(string, true);
                }
                ++n2;
            }
            this.finishBuildingStateTable(true);
        }

        protected void error(String string, int n2, String string2) {
            throw new IllegalArgumentException("Parse error at position (" + n2 + "): " + string + "\n" + string2.substring(0, n2) + " -here- " + string2.substring(n2));
        }

        private void updateStateTable(Vector vector, String string, short s2) {
            short[] sArray = new short[RuleBasedBreakIterator.this.numCategories + 1];
            int n2 = 0;
            while (n2 < string.length()) {
                sArray[string.charAt((int)n2) - 256] = s2;
                ++n2;
            }
            int n3 = 0;
            while (n3 < vector.size()) {
                this.mergeStates((Integer)vector.elementAt(n3), sArray, vector);
                ++n3;
            }
        }

        private Vector buildRuleList(String string) {
            Vector vector = new Vector();
            Stack stack = new Stack();
            int n2 = 0;
            int n3 = 0;
            char c2 = '\u0000';
            int n4 = 0;
            int n5 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (string.length() != 0 && string.charAt(string.length() - 1) != ';') {
                string = string + ";";
            }
            while (n2 < string.length()) {
                c2 = string.charAt(n2);
                switch (c2) {
                    case '\\': {
                        ++n2;
                        break;
                    }
                    case '(': 
                    case '<': 
                    case '[': 
                    case '{': {
                        if (n5 == 60) {
                            this.error("Can't nest brackets inside <>", n2, string);
                        }
                        if (n5 == 91 && c2 != '[') {
                            this.error("Can't nest anything in [] but []", n2, string);
                        }
                        if (c2 == '<' && (bl2 || bl3)) {
                            this.error("Unknown variable name", n2, string);
                        }
                        n5 = c2;
                        stack.push(new Character(c2));
                        if (c2 != '<') break;
                        bl4 = true;
                        break;
                    }
                    case ')': 
                    case '>': 
                    case ']': 
                    case '}': {
                        char c3 = '\u0000';
                        switch (n5) {
                            case 123: {
                                c3 = '}';
                                break;
                            }
                            case 91: {
                                c3 = ']';
                                break;
                            }
                            case 40: {
                                c3 = ')';
                                break;
                            }
                            case 60: {
                                c3 = '>';
                            }
                        }
                        if (c2 != c3) {
                            this.error("Unbalanced parentheses", n2, string);
                        }
                        if (n4 == n5) {
                            this.error("Parens don't contain anything", n2, string);
                        }
                        stack.pop();
                        if (!stack.empty()) {
                            n5 = ((Character)stack.peek()).charValue();
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    case '*': {
                        if ("=/{(|}*;\u0000".indexOf(n4) == -1) break;
                        this.error("Misplaced asterisk", n2, string);
                        break;
                    }
                    case '?': {
                        if (n4 == 42) break;
                        this.error("Misplaced ?", n2, string);
                        break;
                    }
                    case '=': {
                        if (bl2 || bl3) {
                            this.error("More than one = or / in rule", n2, string);
                        }
                        bl2 = true;
                        break;
                    }
                    case '/': {
                        if (bl2 || bl3) {
                            this.error("More than one = or / in rule", n2, string);
                        }
                        if (bl4) {
                            this.error("Unknown variable name", n2, string);
                        }
                        bl3 = true;
                        break;
                    }
                    case '!': {
                        if (n4 == 59 || n4 == 0) break;
                        this.error("! can only occur at the beginning of a rule", n2, string);
                        break;
                    }
                    case '.': {
                        break;
                    }
                    case '-': 
                    case ':': 
                    case '^': {
                        if (n5 == 91 || n5 == 60) break;
                        this.error("Illegal character", n2, string);
                        break;
                    }
                    case ';': {
                        if (n4 == 59 || n4 == 0) {
                            this.error("Empty rule", n2, string);
                        }
                        if (!stack.empty()) {
                            this.error("Unbalanced parenheses", n2, string);
                        }
                        if (!stack.empty()) break;
                        if (bl2) {
                            string = this.processSubstitution(string.substring(n3, n2), string, n2 + 1);
                        } else {
                            if (bl4) {
                                this.error("Unknown variable name", n2, string);
                            }
                            vector.addElement(string.substring(n3, n2));
                        }
                        n3 = n2 + 1;
                        bl4 = false;
                        bl3 = false;
                        bl2 = false;
                        break;
                    }
                    case '|': {
                        if (n4 == 124) {
                            this.error("Empty alternative", n2, string);
                        }
                        if (!stack.empty() && n5 == 40) break;
                        this.error("Misplaced |", n2, string);
                        break;
                    }
                    default: {
                        if (c2 < ' ' || c2 >= '\u007f' || Character.isLetter(c2) || Character.isDigit(c2)) break;
                        this.error("Illegal character", n2, string);
                    }
                }
                n4 = c2;
                ++n2;
            }
            if (vector.size() == 0) {
                this.error("No valid rules in description", n2, string);
            }
            return vector;
        }

        private void setLoopingStates(Vector vector, Vector vector2) {
            if (!this.loopingStates.isEmpty()) {
                int n2 = (Integer)this.loopingStates.lastElement();
                int n3 = 0;
                while (n3 < vector2.size()) {
                    this.eliminateBackfillStates((Integer)vector2.elementAt(n3));
                    ++n3;
                }
                int n4 = 0;
                while (n4 < this.statesToBackfill.size()) {
                    int n5 = (Integer)this.statesToBackfill.elementAt(n4);
                    short[] sArray = (short[])this.tempStateTable.elementAt(n5);
                    sArray[((RuleBasedBreakIterator)RuleBasedBreakIterator.this).numCategories] = (short)(sArray[RuleBasedBreakIterator.this.numCategories] & 0xE000 | n2);
                    ++n4;
                }
                this.statesToBackfill.removeAllElements();
                this.loopingStates.removeAllElements();
            }
            if (vector != null) {
                this.loopingStates = (Vector)vector.clone();
            }
        }

        protected String processSubstitution(String string, String string2, int n2) {
            int n3 = string.indexOf(61);
            String string3 = string.substring(0, n3);
            String string4 = string.substring(n3 + 1);
            this.handleSpecialSubstitution(string3, string4, n2, string2);
            if (string4.length() == 0) {
                this.error("Nothing on right-hand side of =", n2, string2);
            }
            if (string3.length() == 0) {
                this.error("Nothing on left-hand side of =", n2, string2);
            }
            if (string3.length() == 2 && string3.charAt(0) != '\\') {
                this.error("Illegal left-hand side for =", n2, string2);
            }
            if (string3.length() >= 3 && string3.charAt(0) != '<' && string3.charAt(n3 - 1) != '>') {
                this.error("Illegal left-hand side for =", n2, string2);
            }
            if (!(string4.charAt(0) == '[' && string4.charAt(string4.length() - 1) == ']' || string4.charAt(0) == '(' && string4.charAt(string4.length() - 1) == ')')) {
                this.error("Illegal right-hand side for =", n2, string2);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2.substring(0, n2));
            int n4 = n2;
            int n5 = string2.indexOf(string3, n2);
            while (n5 != -1) {
                stringBuffer.append(string2.substring(n4, n5));
                stringBuffer.append(string4);
                n4 = n5 + string3.length();
                n5 = string2.indexOf(string3, n4);
            }
            stringBuffer.append(string2.substring(n4));
            return stringBuffer.toString();
        }

        protected void handleSpecialSubstitution(String string, String string2, int n2, String string3) {
            if (string.equals("<ignore>")) {
                if (string2.charAt(0) == '(') {
                    this.error("Ignore group can't be enclosed in (", n2, string3);
                }
                this.ignoreChars = CharSet.parseString(string2);
            }
        }
    }

    private static final class SafeCharIterator
    implements CharacterIterator,
    Cloneable {
        private CharacterIterator base;
        private int rangeStart;
        private int rangeLimit;
        private int currentIndex;

        public char current() {
            if (this.currentIndex < this.rangeStart || this.currentIndex >= this.rangeLimit) {
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char first() {
            return this.setIndex(this.rangeStart);
        }

        public char last() {
            return this.setIndex(this.rangeLimit - 1);
        }

        public char next() {
            ++this.currentIndex;
            if (this.currentIndex >= this.rangeLimit) {
                this.currentIndex = this.rangeLimit;
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char previous() {
            --this.currentIndex;
            if (this.currentIndex < this.rangeStart) {
                this.currentIndex = this.rangeStart;
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public int getBeginIndex() {
            return this.rangeStart;
        }

        public int getEndIndex() {
            return this.rangeLimit;
        }

        public int getIndex() {
            return this.currentIndex;
        }

        public char setIndex(int n2) {
            if (n2 < this.rangeStart || n2 > this.rangeLimit) {
                throw new IllegalArgumentException("Invalid position");
            }
            this.currentIndex = n2;
            return this.current();
        }

        public Object clone() {
            CharacterIterator characterIterator;
            SafeCharIterator safeCharIterator = null;
            try {
                safeCharIterator = (SafeCharIterator)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("Clone not supported: " + cloneNotSupportedException);
            }
            safeCharIterator.base = characterIterator = (CharacterIterator)this.base.clone();
            return safeCharIterator;
        }

        SafeCharIterator(CharacterIterator characterIterator) {
            this.base = characterIterator;
            this.rangeStart = characterIterator.getBeginIndex();
            this.rangeLimit = characterIterator.getEndIndex();
            this.currentIndex = characterIterator.getIndex();
        }
    }
}

