/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;

public final class SimpleDoc
implements Doc {
    private DocFlavor flavor;
    private DocAttributeSet attributes;
    private Object printData;
    private Reader reader;
    private InputStream inStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getStreamForBytes() throws IOException {
        if (this.printData instanceof InputStream) {
            return (InputStream)this.printData;
        }
        SimpleDoc simpleDoc = this;
        synchronized (simpleDoc) {
            if (this.inStream != null) {
                return this.inStream;
            }
            if (this.printData instanceof byte[]) {
                this.inStream = new ByteArrayInputStream((byte[])this.printData);
            }
        }
        return this.inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getReaderForText() throws IOException {
        if (this.printData instanceof Reader) {
            return (Reader)this.printData;
        }
        SimpleDoc simpleDoc = this;
        synchronized (simpleDoc) {
            if (this.reader != null) {
                return this.reader;
            }
            if (this.printData instanceof char[]) {
                this.reader = new CharArrayReader((char[])this.printData);
            } else if (this.printData instanceof String) {
                this.reader = new StringReader((String)this.printData);
            }
        }
        return this.reader;
    }

    public Object getPrintData() throws IOException {
        return this.printData;
    }

    public DocFlavor getDocFlavor() {
        return this.flavor;
    }

    public DocAttributeSet getAttributes() {
        return this.attributes;
    }

    public SimpleDoc(Object object, DocFlavor docFlavor, DocAttributeSet docAttributeSet) {
        if (docFlavor == null || object == null) {
            throw new IllegalArgumentException("null argument(s)");
        }
        Class clazz = null;
        try {
            clazz = Class.forName(docFlavor.getRepresentationClassName());
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("unknown representation class");
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("data is not of declared type");
        }
        this.flavor = docFlavor;
        if (docAttributeSet != null) {
            this.attributes = AttributeSetUtilities.unmodifiableView(docAttributeSet);
        }
        this.printData = object;
    }
}

