/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.Configuration;
import com.sun.tools.doclets.DocletAbortException;
import java.io.File;

public class DirectoryManager {
    public static final String urlfileseparator = "/";
    public static final String fileseparator = File.separator;

    private DirectoryManager() {
    }

    public static String createPathString(ClassDoc classDoc) {
        if (classDoc == null) {
            return "";
        }
        PackageDoc packageDoc = classDoc.containingPackage();
        return packageDoc == null ? "" : DirectoryManager.getPath(packageDoc.name());
    }

    public static String getPathToClass(ClassDoc classDoc) {
        return DirectoryManager.getPathToPackage(classDoc.containingPackage(), classDoc.name() + ".html");
    }

    public static String createPathString(PackageDoc packageDoc) {
        if (packageDoc == null) {
            return "";
        }
        return DirectoryManager.getPath(packageDoc.name());
    }

    public static String getDirectoryPath(PackageDoc packageDoc) {
        if (packageDoc == null) {
            return "";
        }
        String string = packageDoc.name();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '.') {
                stringBuffer.append(fileseparator);
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void createDirectory(Configuration configuration, String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        File file = new File(string);
        if (file.exists()) {
            return;
        }
        if (file.mkdirs()) {
            return;
        }
        configuration.message.error("doclet.Unable_to_create_directory_0", string);
        throw new DocletAbortException();
    }

    public static String getBackPath(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '/') {
                stringBuffer.append("..");
                stringBuffer.append(urlfileseparator);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getPath(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '.') {
                stringBuffer.append(urlfileseparator);
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getPathNoTrailingSlash(String string) {
        if (string.equals("")) {
            return ".";
        }
        if (string.equals(urlfileseparator)) {
            return "/.";
        }
        if (string.endsWith(urlfileseparator)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getRelativePath(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '.') {
                stringBuffer.append("../");
            }
            ++n;
        }
        stringBuffer.append("../");
        return stringBuffer.toString();
    }

    public static String getPathToPackage(PackageDoc packageDoc, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = DirectoryManager.createPathString(packageDoc);
        if (string2.length() > 0) {
            stringBuffer.append(string2);
            stringBuffer.append(urlfileseparator);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String getRelativePath(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DirectoryManager.getRelativePath(string));
        stringBuffer.append(DirectoryManager.getPath(string2));
        stringBuffer.append(urlfileseparator);
        return stringBuffer.toString();
    }
}

