/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.SocketConnection;
import com.sun.tools.jdi.TransportService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

class SocketTransport
implements TransportService {
    Map listenMap = new HashMap();

    SocketTransport() {
    }

    public boolean supportsMultipleConnections() {
        return true;
    }

    public String name() {
        return "dt_socket";
    }

    public String startListening() throws IOException {
        return this.startListening(0);
    }

    public String toString() {
        return this.name();
    }

    String startListening(int n) throws IOException {
        ServerSocket serverSocket = new ServerSocket(n);
        String string = InetAddress.getLocalHost().getHostName() + ":" + serverSocket.getLocalPort();
        this.listenMap.put(string, serverSocket);
        return string;
    }

    public void stopListening(String string) throws IOException {
        ServerSocket serverSocket = (ServerSocket)this.listenMap.remove(string);
        if (serverSocket == null) {
            throw new IllegalArgumentException("Unknown listen address: " + string);
        }
        serverSocket.close();
    }

    public ConnectionService accept(String string) throws IOException {
        ServerSocket serverSocket = (ServerSocket)this.listenMap.get(string);
        if (serverSocket == null) {
            throw new IllegalArgumentException("Unknown listen address: " + string);
        }
        Socket socket = serverSocket.accept();
        return new SocketConnection(socket);
    }

    public ConnectionService attach(String string) throws IOException {
        int n;
        if (string == null) {
            throw new NullPointerException("address is null");
        }
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            throw new IllegalArgumentException("address string is malformed");
        }
        String string2 = string.substring(0, n2);
        try {
            n = Integer.decode(string.substring(n2 + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("unable to parse port number in address");
        }
        Socket socket = new Socket(string2, n);
        return new SocketConnection(socket);
    }

    public String startListening(String string) throws IOException {
        int n;
        String string2;
        if (string == null) {
            throw new NullPointerException("address is null");
        }
        int n2 = string.indexOf(58);
        if (n2 != -1) {
            String string3 = string.substring(0, n2);
            InetAddress inetAddress = InetAddress.getByName(string3);
            if (!inetAddress.equals(InetAddress.getLocalHost())) {
                throw new IllegalArgumentException("Cannot listen on remote host: " + string3);
            }
            string2 = string.substring(n2 + 1);
        } else {
            string2 = string;
        }
        try {
            n = Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("unable to parse port number in address");
        }
        return this.startListening(n);
    }
}

