/*
 * Decompiled with CFR 0.152.
 */
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.AttributedString;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JWindow;

public final class FontPanel
extends JPanel
implements AdjustmentListener {
    private final String[] STYLES = new String[]{"plain", "bold", "italic", "bold italic"};
    private final int NONE = 0;
    private final int SCALE = 1;
    private final int SHEAR = 2;
    private final int ROTATE = 3;
    private final String[] TRANSFORMS = new String[]{"with no transforms", "with scaling", "with Shearing", "with rotation"};
    private final int DRAW_STRING = 0;
    private final int DRAW_CHARS = 1;
    private final int DRAW_BYTES = 2;
    private final int DRAW_GLYPHV = 3;
    private final int TL_DRAW = 4;
    private final int GV_OUTLINE = 5;
    private final int TL_OUTLINE = 6;
    private final String[] METHODS = new String[]{"drawString", "drawChars", "drawBytes", "drawGlyphVector", "TextLayout.draw", "GlyphVector.getOutline", "TextLayout.getOutline"};
    public final int RANGE_TEXT = 0;
    public final int ALL_GLYPHS = 1;
    public final int USER_TEXT = 2;
    public final int FILE_TEXT = 3;
    private final String[] MS_OPENING = new String[]{" Unicode ", " Glyph Code ", " lines ", " lines "};
    private final String[] MS_CLOSING = new String[]{"", "", " of User Text ", " of LineBreakMeasurer-reformatted Text "};
    private final JScrollBar verticalBar;
    private final FontCanvas fc;
    private boolean updateBackBuffer = true;
    private boolean updateFontMetrics = true;
    private boolean updateFont = true;
    private boolean force16Cols = false;
    public boolean showingError = false;
    private int g2Transform = 0;
    public final int ONE_PAGE = 0;
    public final int CUR_RANGE = 1;
    public final int ALL_TEXT = 2;
    private int printMode = 0;
    private PageFormat page = null;
    private PrinterJob printer = null;
    private String fontName = "Dialog";
    private int fontSize = 12;
    private int fontStyle = 0;
    private int fontTransform = 0;
    private Font testFont = null;
    private boolean useAntialias = false;
    private boolean useFractional = false;
    private int drawMethod = 0;
    private int textToUse = 0;
    private String[] userText = null;
    private String[] fileText = null;
    private int[] drawRange = new int[]{0, 127};
    private String[] fontInfos = new String[2];
    private boolean showGrid = true;
    private final Font2DTest f2dt;
    private final JFrame parent;

    public FontPanel(Font2DTest font2DTest, JFrame jFrame) {
        this.f2dt = font2DTest;
        this.parent = jFrame;
        this.verticalBar = new JScrollBar(1);
        this.fc = new FontCanvas();
        this.setLayout(new BorderLayout());
        this.add("Center", this.fc);
        this.add("East", this.verticalBar);
        this.verticalBar.addAdjustmentListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                FontPanel.this.updateBackBuffer = true;
                FontPanel.this.updateFontMetrics = true;
            }
        });
        this.testFont = new Font(this.fontName, this.fontStyle, this.fontSize);
        this.updateFontInfo();
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 200);
    }

    public void setTransformG2(int n) {
        this.g2Transform = n;
        this.updateBackBuffer = true;
        this.updateFontMetrics = true;
        this.fc.repaint();
    }

    private AffineTransform getAffineTransform(int n) {
        AffineTransform affineTransform = new AffineTransform();
        switch (n) {
            case 1: {
                affineTransform.setToScale(1.5, 1.5);
                break;
            }
            case 3: {
                affineTransform.setToRotation(0.5235987755982988);
                break;
            }
            case 2: {
                affineTransform.setToShear(0.4f, 0.0);
                break;
            }
            case 0: {
                break;
            }
        }
        return affineTransform;
    }

    public void setFontParams(Object object, int n, int n2, int n3) {
        this.setFontParams((String)object, n, n2, n3);
    }

    public void setFontParams(String string, int n, int n2, int n3) {
        boolean bl = false;
        if (!string.equals(this.fontName) || n2 != this.fontStyle) {
            bl = true;
        }
        this.fontName = string;
        this.fontSize = n;
        this.fontStyle = n2;
        this.fontTransform = n3;
        this.testFont = new Font(this.fontName, this.fontStyle, this.fontSize);
        if (this.fontTransform != 0) {
            AffineTransform affineTransform = this.getAffineTransform(this.fontTransform);
            this.testFont = this.testFont.deriveFont(affineTransform);
        }
        this.updateBackBuffer = true;
        this.updateFontMetrics = true;
        this.fc.repaint();
        if (bl) {
            this.updateFontInfo();
            this.f2dt.fireUpdateFontInfo();
        }
    }

    public void setRenderingHints(boolean bl, boolean bl2) {
        this.useAntialias = bl;
        this.useFractional = bl2;
        this.updateBackBuffer = true;
        this.updateFontMetrics = true;
        this.fc.repaint();
    }

    public void setDrawMethod(int n) {
        this.drawMethod = n;
        this.updateBackBuffer = true;
        this.fc.repaint();
    }

    public void setTextToDraw(int n, int[] nArray, String[] stringArray, String[] stringArray2) {
        this.textToUse = n;
        if (this.textToUse == 0) {
            this.drawRange = nArray;
        } else if (this.textToUse == 1) {
            this.drawMethod = 3;
        } else if (this.textToUse == 2) {
            this.userText = stringArray;
        } else if (this.textToUse == 3) {
            this.fileText = stringArray2;
            this.drawMethod = 4;
        }
        this.updateBackBuffer = true;
        this.updateFontMetrics = true;
        this.fc.repaint();
        this.updateFontInfo();
    }

    public void setGridDisplay(boolean bl) {
        this.showGrid = bl;
        this.updateBackBuffer = true;
        this.fc.repaint();
    }

    public void setForce16Columns(boolean bl) {
        this.force16Cols = bl;
        this.updateBackBuffer = true;
        this.updateFontMetrics = true;
        this.fc.repaint();
    }

    public void doPrint(int n) {
        if (this.printer == null) {
            this.printer = PrinterJob.getPrinterJob();
            this.page = this.printer.defaultPage();
        }
        this.printMode = n;
        this.printer.setPrintable(this.fc, this.page);
        if (this.printer.printDialog()) {
            try {
                this.printer.print();
            }
            catch (Exception exception) {
                this.f2dt.fireChangeStatus("ERROR: Printing Failed; See Stack Trace", true);
            }
        }
    }

    public void doPageSetup() {
        if (this.printer == null) {
            this.printer = PrinterJob.getPrinterJob();
            this.page = this.printer.defaultPage();
        }
        this.page = this.printer.pageDialog(this.page);
    }

    private void updateFontInfo() {
        int n = 0;
        int n2 = this.drawRange[1] - this.drawRange[0] + 1;
        this.fontInfos[0] = "Font Face Name: " + this.testFont.getFontName();
        this.fontInfos[1] = "Glyphs in This Range: ";
        if (this.textToUse == 0) {
            for (int i = this.drawRange[0]; i < this.drawRange[1]; ++i) {
                if (!this.testFont.canDisplay((char)i)) continue;
                ++n;
            }
            this.fontInfos[1] = this.fontInfos[1] + n + " / " + n2;
        } else {
            this.fontInfos[1] = null;
        }
    }

    public String[] getFontInfo() {
        return this.fontInfos;
    }

    public String getCurrentOptions() {
        boolean bl = false;
        String string = this.fontName + "\n" + this.fontSize + "\n" + this.fontStyle + "\n" + this.fontTransform + "\n" + this.g2Transform + "\n" + this.textToUse + "\n" + this.drawMethod + "\n" + this.useAntialias + "\n" + this.useFractional + "\n";
        if (this.textToUse == 2) {
            for (int i = 0; i < this.userText.length; ++i) {
                string = string + this.userText[i] + "\n";
            }
        }
        return string;
    }

    public void loadOptions(boolean bl, boolean bl2, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl3, boolean bl4, String[] stringArray) {
        int[] nArray = new int[]{n, n2};
        this.setGridDisplay(bl);
        this.setForce16Columns(bl2);
        if (this.textToUse != 3) {
            this.setTextToDraw(n7, nArray, stringArray, null);
        }
        this.setFontParams(string, n3, n4, n5);
        this.setTransformG2(n6);
        this.setDrawMethod(n8);
        this.setRenderingHints(bl3, bl4);
    }

    public void doSaveJPEG(String string) {
        this.fc.writeJPEG(string);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.updateBackBuffer = true;
        this.fc.repaint();
    }

    public void paintComponent(Graphics graphics) {
        this.fc.repaint();
    }

    private final class CannotDrawException
    extends RuntimeException {
        public final int id;

        public CannotDrawException(int n) {
            this.id = n;
        }
    }

    private class FontCanvas
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    Printable {
        private int numCharAcross;
        private int numCharDown;
        private int drawStart;
        private int drawEnd;
        private int drawLimit;
        private int maxAscent;
        private int maxDescent;
        private int gridWidth = 0;
        private int gridHeight = 0;
        private int canvasInset_X = 5;
        private int canvasInset_Y = 5;
        private BufferedImage backBuffer = null;
        private Vector lineBreakTLs = null;
        private boolean isPrinting = false;
        private int lastPage;
        private int printPageNumber;
        private int currentlyShownChar = 0;
        private final int PR_OFFSET = 10;
        private final int PR_TITLE_LINEHEIGHT = 30;
        private final JWindow zoomWindow;
        private BufferedImage zoomImage = null;
        private int mouseOverCharX = -1;
        private int mouseOverCharY = -1;
        private int currMouseOverChar = -1;
        private int prevZoomChar = -1;
        private float ZOOM = 2.0f;
        private boolean nowZooming = false;
        private boolean firstTime = true;
        private String backupStatusString = null;
        private final String[] ERRORS = new String[]{"ERROR: drawBytes cannot handle characters beyond 0x00FF. Select different range or draw methods.", "ERROR: Cannot fit text with the current font size. Resize the window or use smaller font size.", "ERROR: Cannot print with the current font size. Use smaller font size."};
        private final int DRAW_BYTES_ERROR = 0;
        private final int CANT_FIT_DRAW = 1;
        private final int CANT_FIT_PRINT = 2;
        private final Cursor blankCursor;

        public FontCanvas() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setForeground(Color.black);
            this.setBackground(Color.white);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            byte[] byArray = new byte[]{0};
            this.blankCursor = toolkit.createCustomCursor(toolkit.createImage(byArray), new Point(0, 0), "");
            this.zoomWindow = new JWindow(this, FontPanel.this.parent){
                private final /* synthetic */ FontCanvas this$1;
                {
                    this.this$1 = fontCanvas;
                    super(frame);
                }

                public void paint(Graphics graphics) {
                    graphics.drawImage(FontCanvas.access$300(this.this$1), 0, 0, FontCanvas.access$400(this.this$1));
                }
            };
            this.zoomWindow.setCursor(this.blankCursor);
            this.zoomWindow.pack();
        }

        public boolean firstTime() {
            return this.firstTime;
        }

        public void refresh() {
            this.firstTime = false;
            FontPanel.this.updateBackBuffer = true;
            this.repaint();
        }

        private void setParams(Graphics2D graphics2D) {
            graphics2D.setFont(FontPanel.this.testFont);
            if (FontPanel.this.useAntialias) {
                if (FontPanel.this.drawMethod == 6 || FontPanel.this.drawMethod == 5) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            if (FontPanel.this.useFractional) {
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            }
        }

        private void drawGrid(Graphics2D graphics2D) {
            int n;
            int n2 = this.numCharAcross * this.gridWidth;
            int n3 = this.numCharDown * this.gridHeight;
            graphics2D.setColor(Color.black);
            for (n = 0; n < this.numCharDown + 1; ++n) {
                graphics2D.drawLine(this.canvasInset_X, n * this.gridHeight + this.canvasInset_Y, this.canvasInset_X + n2, n * this.gridHeight + this.canvasInset_Y);
            }
            for (n = 0; n < this.numCharAcross + 1; ++n) {
                graphics2D.drawLine(n * this.gridWidth + this.canvasInset_X, this.canvasInset_Y, n * this.gridWidth + this.canvasInset_X, this.canvasInset_Y + n3);
            }
        }

        public void modeSpecificDrawChar(Graphics2D graphics2D, int n, int n2, int n3) {
            Object object;
            int[] nArray = new int[]{n};
            char[] cArray = new char[]{(char)n};
            GlyphVector glyphVector = FontPanel.this.textToUse == 1 ? FontPanel.this.testFont.createGlyphVector(graphics2D.getFontRenderContext(), nArray) : FontPanel.this.testFont.createGlyphVector(graphics2D.getFontRenderContext(), cArray);
            Rectangle2D rectangle2D = glyphVector.getPixelBounds(graphics2D.getFontRenderContext(), 0.0f, 0.0f);
            int n4 = n2;
            try {
                object = new double[]{rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight()};
                graphics2D.getTransform().inverseTransform((double[])object, 0, (double[])object, 0, 2);
                n4 = n2 - (int)(object[2] / 2.0 + object[0]);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
            object = null;
            object = graphics2D.getTransform();
            graphics2D.translate(n4, n3);
            graphics2D.transform(FontPanel.this.getAffineTransform(FontPanel.this.g2Transform));
            if (FontPanel.this.textToUse == 1) {
                graphics2D.drawGlyphVector(glyphVector, 0.0f, 0.0f);
            } else {
                if (FontPanel.this.testFont.canDisplay((char)n)) {
                    graphics2D.setColor(Color.black);
                } else {
                    graphics2D.setColor(Color.lightGray);
                }
                switch (FontPanel.this.drawMethod) {
                    case 0: {
                        graphics2D.drawString(new String(cArray), 0, 0);
                        break;
                    }
                    case 1: {
                        graphics2D.drawChars(cArray, 0, 1, 0, 0);
                        break;
                    }
                    case 2: {
                        if (n > 255) {
                            throw new CannotDrawException(0);
                        }
                        byte[] byArray = new byte[]{(byte)n};
                        graphics2D.drawBytes(byArray, 0, 1, 0, 0);
                        break;
                    }
                    case 3: {
                        graphics2D.drawGlyphVector(glyphVector, 0.0f, 0.0f);
                        break;
                    }
                    case 4: {
                        TextLayout textLayout = new TextLayout(new String(cArray), FontPanel.this.testFont, graphics2D.getFontRenderContext());
                        textLayout.draw(graphics2D, 0.0f, 0.0f);
                        break;
                    }
                    case 5: {
                        rectangle2D = glyphVector.getVisualBounds();
                        n4 = n2 - (int)(rectangle2D.getWidth() / 2.0 + rectangle2D.getX());
                        graphics2D.draw(glyphVector.getOutline(0.0f, 0.0f));
                        break;
                    }
                    case 6: {
                        rectangle2D = glyphVector.getVisualBounds();
                        n4 = n2 - (int)(rectangle2D.getWidth() / 2.0 + rectangle2D.getX());
                        TextLayout textLayout = new TextLayout(new String(cArray), FontPanel.this.testFont, graphics2D.getFontRenderContext());
                        AffineTransform affineTransform = new AffineTransform();
                        graphics2D.draw(textLayout.getOutline(affineTransform));
                    }
                }
            }
            graphics2D.setTransform((AffineTransform)object);
        }

        private void modeSpecificDrawLine(Graphics2D graphics2D, String string, int n, int n2) {
            AffineTransform affineTransform = null;
            affineTransform = graphics2D.getTransform();
            graphics2D.translate(n, n2);
            graphics2D.transform(FontPanel.this.getAffineTransform(FontPanel.this.g2Transform));
            switch (FontPanel.this.drawMethod) {
                case 0: {
                    graphics2D.drawString(string, 0, 0);
                    break;
                }
                case 1: {
                    graphics2D.drawChars(string.toCharArray(), 0, string.length(), 0, 0);
                    break;
                }
                case 2: {
                    try {
                        byte[] byArray = string.getBytes("ISO-8859-1");
                        graphics2D.drawBytes(byArray, 0, string.length(), 0, 0);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    GlyphVector glyphVector = FontPanel.this.testFont.createGlyphVector(graphics2D.getFontRenderContext(), string);
                    graphics2D.drawGlyphVector(glyphVector, 0.0f, 0.0f);
                    break;
                }
                case 4: {
                    TextLayout textLayout = new TextLayout(string, FontPanel.this.testFont, graphics2D.getFontRenderContext());
                    textLayout.draw(graphics2D, 0.0f, 0.0f);
                    break;
                }
                case 5: {
                    GlyphVector glyphVector = FontPanel.this.testFont.createGlyphVector(graphics2D.getFontRenderContext(), string);
                    graphics2D.draw(glyphVector.getOutline(0.0f, 0.0f));
                    break;
                }
                case 6: {
                    TextLayout textLayout = new TextLayout(string, FontPanel.this.testFont, graphics2D.getFontRenderContext());
                    AffineTransform affineTransform2 = new AffineTransform();
                    graphics2D.draw(textLayout.getOutline(affineTransform2));
                }
            }
            graphics2D.setTransform(affineTransform);
        }

        private void tlDrawLine(Graphics2D graphics2D, TextLayout textLayout, float f, float f2) {
            AffineTransform affineTransform = null;
            affineTransform = graphics2D.getTransform();
            graphics2D.translate(f, f2);
            graphics2D.transform(FontPanel.this.getAffineTransform(FontPanel.this.g2Transform));
            textLayout.draw(graphics2D, 0.0f, 0.0f);
            graphics2D.setTransform(affineTransform);
        }

        private String modeSpecificNumStr(int n) {
            if (FontPanel.this.textToUse == 2 || FontPanel.this.textToUse == 3) {
                return String.valueOf(n + 1);
            }
            StringBuffer stringBuffer = new StringBuffer(Integer.toHexString(n));
            while (stringBuffer.length() < 4) {
                stringBuffer.insert(0, "0");
            }
            return stringBuffer.toString().toUpperCase();
        }

        private void resetScrollbar(int n) {
            int n2 = 1;
            if (FontPanel.this.textToUse == 0 || FontPanel.this.textToUse == 1) {
                int n3 = FontPanel.this.textToUse == 0 ? FontPanel.this.drawRange[1] - FontPanel.this.drawRange[0] : FontPanel.this.testFont.getNumGlyphs();
                n2 = n3 / this.numCharAcross;
                if (n3 % this.numCharAcross != 0) {
                    ++n2;
                }
                if (n / this.numCharAcross > n2) {
                    n = 0;
                }
                FontPanel.this.verticalBar.setValues(n / this.numCharAcross, this.numCharDown, 0, n2);
            } else {
                n2 = FontPanel.this.textToUse == 2 ? FontPanel.this.userText.length : this.lineBreakTLs.size();
                FontPanel.this.verticalBar.setValues(n, this.numCharDown, 0, n2);
            }
            if (n2 <= this.numCharDown && this.drawStart == 0) {
                FontPanel.this.verticalBar.setEnabled(false);
            } else {
                FontPanel.this.verticalBar.setEnabled(true);
            }
        }

        private void calcFontMetrics(Graphics2D graphics2D, int n, int n2) {
            FontMetrics fontMetrics;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            if (FontPanel.this.g2Transform != 0 && FontPanel.this.textToUse != 3) {
                graphics2D2.setFont(graphics2D2.getFont().deriveFont(FontPanel.this.getAffineTransform(FontPanel.this.g2Transform)));
                fontMetrics = graphics2D2.getFontMetrics();
            } else {
                fontMetrics = graphics2D2.getFontMetrics();
            }
            this.maxAscent = fontMetrics.getMaxAscent();
            this.maxDescent = fontMetrics.getMaxDescent();
            if (FontPanel.this.textToUse == 0 || FontPanel.this.textToUse == 1) {
                this.maxAscent += 3;
                this.maxDescent += 3;
                this.gridWidth = fontMetrics.getMaxAdvance() + 6;
                this.gridHeight = this.maxAscent + this.maxDescent;
                this.numCharAcross = FontPanel.this.force16Cols ? 16 : (n - 10) / this.gridWidth;
                this.numCharDown = (n2 - 10) / this.gridHeight;
                this.canvasInset_X = (n - this.numCharAcross * this.gridWidth) / 2;
                this.canvasInset_Y = (n2 - this.numCharDown * this.gridHeight) / 2;
                if (this.numCharDown == 0 || this.numCharAcross == 0) {
                    throw new CannotDrawException(this.isPrinting ? 2 : 1);
                }
                if (!this.isPrinting) {
                    this.resetScrollbar(FontPanel.this.verticalBar.getValue() * this.numCharAcross);
                }
            } else {
                this.maxDescent += fontMetrics.getLeading();
                this.canvasInset_X = 5;
                this.canvasInset_Y = 5;
                this.gridHeight = this.maxAscent + this.maxDescent;
                this.numCharDown = (n2 - this.canvasInset_Y * 2) / this.gridHeight;
                if (this.numCharDown == 0) {
                    throw new CannotDrawException(this.isPrinting ? 2 : 1);
                }
                if (FontPanel.this.textToUse == 3) {
                    if (!this.isPrinting) {
                        FontPanel.this.f2dt.fireChangeStatus("LineBreaking Text... Please Wait", false);
                    }
                    this.lineBreakTLs = new Vector();
                    for (int i = 0; i < FontPanel.this.fileText.length; ++i) {
                        AttributedString attributedString = new AttributedString(FontPanel.this.fileText[i], graphics2D2.getFont().getAttributes());
                        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), graphics2D2.getFontRenderContext());
                        while (lineBreakMeasurer.getPosition() < FontPanel.this.fileText[i].length()) {
                            this.lineBreakTLs.add(lineBreakMeasurer.nextLayout(n));
                        }
                    }
                }
                if (!this.isPrinting) {
                    this.resetScrollbar(FontPanel.this.verticalBar.getValue());
                }
            }
        }

        private void calcTextRange() {
            Object var1_1 = null;
            if (FontPanel.this.textToUse == 0 || FontPanel.this.textToUse == 1) {
                this.drawStart = this.isPrinting ? (FontPanel.this.printMode == 0 ? this.currentlyShownChar : this.numCharAcross * this.numCharDown * this.printPageNumber) : FontPanel.this.verticalBar.getValue() * this.numCharAcross;
                if (FontPanel.this.textToUse == 0) {
                    this.drawStart += FontPanel.this.drawRange[0];
                    this.drawLimit = FontPanel.this.drawRange[1];
                } else {
                    this.drawLimit = FontPanel.this.testFont.getNumGlyphs();
                }
                this.drawEnd = this.drawStart + this.numCharAcross * this.numCharDown - 1;
                if (this.drawEnd >= this.drawLimit) {
                    this.drawEnd = this.drawLimit;
                }
            } else {
                this.drawStart = this.isPrinting ? (FontPanel.this.printMode == 0 ? this.currentlyShownChar : this.numCharDown * this.printPageNumber) : FontPanel.this.verticalBar.getValue();
                this.drawEnd = this.drawStart + this.numCharDown - 1;
                this.drawLimit = FontPanel.this.textToUse == 2 ? FontPanel.this.userText.length - 1 : this.lineBreakTLs.size() - 1;
                if (this.drawEnd >= this.drawLimit) {
                    this.drawEnd = this.drawLimit;
                }
            }
            if (this.drawStart > this.drawEnd) {
                this.drawStart = 0;
                FontPanel.this.verticalBar.setValue(this.drawStart);
            }
            if (!this.isPrinting) {
                this.backupStatusString = "Displaying" + FontPanel.this.MS_OPENING[FontPanel.this.textToUse] + this.modeSpecificNumStr(this.drawStart) + " to " + this.modeSpecificNumStr(this.drawEnd) + FontPanel.this.MS_CLOSING[FontPanel.this.textToUse];
                FontPanel.this.f2dt.fireChangeStatus(this.backupStatusString, false);
            }
        }

        private void drawText(Graphics graphics, int n, int n2) {
            Graphics2D graphics2D;
            if (this.isPrinting) {
                graphics2D = (Graphics2D)graphics;
            } else {
                this.backBuffer = (BufferedImage)this.createImage(n, n2);
                graphics2D = this.backBuffer.createGraphics();
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.setColor(Color.black);
            }
            this.setParams(graphics2D);
            if (FontPanel.this.updateFontMetrics || this.isPrinting) {
                this.calcFontMetrics(graphics2D, n, n2);
                FontPanel.this.updateFontMetrics = false;
            }
            this.calcTextRange();
            if (FontPanel.this.textToUse == 0 || FontPanel.this.textToUse == 1) {
                int n3 = this.drawStart;
                if (FontPanel.this.showGrid) {
                    this.drawGrid(graphics2D);
                }
                if (!this.isPrinting) {
                    graphics.drawImage(this.backBuffer, 0, 0, this);
                }
                for (int i = 0; i < this.numCharDown && n3 <= this.drawEnd; ++i) {
                    for (int j = 0; j < this.numCharAcross && n3 <= this.drawEnd; ++j, ++n3) {
                        int n4 = j * this.gridWidth + this.canvasInset_X;
                        int n5 = i * this.gridHeight + this.canvasInset_Y;
                        this.modeSpecificDrawChar(graphics2D, n3, n4 + this.gridWidth / 2, n5 + this.maxAscent);
                    }
                }
            } else if (FontPanel.this.textToUse == 2) {
                graphics2D.drawRect(0, 0, n - 1, n2 - 1);
                if (!this.isPrinting) {
                    graphics.drawImage(this.backBuffer, 0, 0, this);
                }
                for (int i = this.drawStart; i <= this.drawEnd; ++i) {
                    int n6 = this.canvasInset_Y;
                    int n7 = (i - this.drawStart) * this.gridHeight + this.maxAscent;
                    this.modeSpecificDrawLine(graphics2D, FontPanel.this.userText[i], n6, n7);
                }
            } else {
                float f = this.canvasInset_Y;
                graphics2D.drawRect(0, 0, n - 1, n2 - 1);
                if (!this.isPrinting) {
                    graphics.drawImage(this.backBuffer, 0, 0, this);
                }
                for (int i = this.drawStart; i <= this.drawEnd; ++i) {
                    TextLayout textLayout = (TextLayout)this.lineBreakTLs.elementAt(i);
                    float f2 = textLayout.isLeftToRight() ? (float)this.canvasInset_X : (float)n - textLayout.getAdvance() - (float)this.canvasInset_X;
                    float[] fArray = new float[]{0.0f, textLayout.getAscent(), 0.0f, textLayout.getDescent(), 0.0f, textLayout.getLeading()};
                    if (FontPanel.this.g2Transform != 0) {
                        AffineTransform affineTransform = FontPanel.this.getAffineTransform(FontPanel.this.g2Transform);
                        affineTransform.transform(fArray, 0, fArray, 0, 3);
                    }
                    this.tlDrawLine(graphics2D, textLayout, f2, f += fArray[1]);
                    f += fArray[3] + fArray[5];
                }
            }
            if (!this.isPrinting) {
                graphics.drawImage(this.backBuffer, 0, 0, this);
            }
            graphics2D.dispose();
        }

        public void paintComponent(Graphics graphics) {
            if (FontPanel.this.updateBackBuffer) {
                Dimension dimension = this.getSize();
                this.isPrinting = false;
                try {
                    this.drawText(graphics, dimension.width, dimension.height);
                }
                catch (CannotDrawException cannotDrawException) {
                    FontPanel.this.f2dt.fireChangeStatus(this.ERRORS[cannotDrawException.id], true);
                    return;
                }
            } else {
                graphics.drawImage(this.backBuffer, 0, 0, this);
            }
            FontPanel.this.showingError = false;
            FontPanel.this.updateBackBuffer = false;
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            if (n == 0) {
                this.lastPage = Integer.MAX_VALUE;
                this.currentlyShownChar = FontPanel.this.verticalBar.getValue() * this.numCharAcross;
            }
            if (FontPanel.this.printMode == 0 ? n > 0 : n > this.lastPage) {
                return 1;
            }
            int n2 = (int)pageFormat.getImageableWidth();
            int n3 = (int)pageFormat.getImageableHeight();
            int n4 = this.drawStart;
            int n5 = this.drawEnd;
            int n6 = this.numCharAcross;
            int n7 = this.numCharDown;
            Vector vector = null;
            if (FontPanel.this.textToUse == 3) {
                vector = (Vector)this.lineBreakTLs.clone();
            }
            this.printPageNumber = n;
            this.isPrinting = true;
            graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY() + 60);
            try {
                this.drawText(graphics, n2, n3 - 60);
            }
            catch (CannotDrawException cannotDrawException) {
                FontPanel.this.f2dt.fireChangeStatus(this.ERRORS[cannotDrawException.id], true);
                return 1;
            }
            String string = " with antialias " + (FontPanel.this.useAntialias ? "on" : "off") + " and fractional metrics " + (FontPanel.this.useFractional ? "on" : "off");
            String string2 = "Printing" + FontPanel.this.MS_OPENING[FontPanel.this.textToUse] + this.modeSpecificNumStr(this.drawStart) + " to " + this.modeSpecificNumStr(this.drawEnd) + FontPanel.this.MS_CLOSING[FontPanel.this.textToUse];
            String string3 = "With " + FontPanel.this.fontName + " " + FontPanel.this.STYLES[FontPanel.this.fontStyle] + " at " + FontPanel.this.fontSize + " point size " + FontPanel.this.TRANSFORMS[FontPanel.this.fontTransform];
            String string4 = "Using " + FontPanel.this.METHODS[FontPanel.this.drawMethod] + string;
            String string5 = "Page: " + (n + 1);
            graphics.setFont(new Font("dialog", 0, 12));
            graphics.setColor(Color.black);
            graphics.translate(0, -60);
            graphics.drawString(string2, 15, 10);
            graphics.drawString(string3, 15, 22);
            graphics.drawString(string4, 15, 34);
            graphics.drawString(string5, 15, 46);
            if (this.drawEnd == this.drawLimit) {
                this.lastPage = n;
            }
            this.drawStart = n4;
            this.drawEnd = n5;
            this.numCharAcross = n6;
            this.numCharDown = n7;
            if (FontPanel.this.textToUse == 3) {
                this.lineBreakTLs = vector;
            }
            return 0;
        }

        public void writeJPEG(String string) {
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
                JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(this.backBuffer);
                jPEGEncodeParam.setQuality(1.0f, false);
                jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
                jPEGImageEncoder.encode(this.backBuffer);
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                FontPanel.this.f2dt.fireChangeStatus("ERROR: Failed to Save JPEG image; See stack trace", true);
                exception.printStackTrace();
            }
        }

        private boolean checkMouseLoc(MouseEvent mouseEvent) {
            if (this.gridWidth != 0 && this.gridHeight != 0 && (FontPanel.this.textToUse == 0 || FontPanel.this.textToUse == 1)) {
                int n = (mouseEvent.getX() - this.canvasInset_X) / this.gridWidth;
                int n2 = (mouseEvent.getY() - this.canvasInset_Y) / this.gridHeight;
                if (n >= 0 && n2 >= 0 && n < this.numCharAcross && n2 < this.numCharDown) {
                    int n3 = n + (FontPanel.this.verticalBar.getValue() + n2) * this.numCharAcross;
                    if (FontPanel.this.textToUse == 0) {
                        n3 += FontPanel.this.drawRange[0];
                    }
                    if (n3 > this.drawEnd) {
                        return false;
                    }
                    this.mouseOverCharX = n;
                    this.mouseOverCharY = n2;
                    this.currMouseOverChar = n3;
                    FontPanel.this.f2dt.fireChangeStatus("Pointing to" + FontPanel.this.MS_OPENING[FontPanel.this.textToUse] + this.modeSpecificNumStr(n3), false);
                    return true;
                }
            }
            return false;
        }

        public void showZoomed() {
            Font font = FontPanel.this.testFont;
            Point point = this.getLocationOnScreen();
            int n = (int)((float)this.gridWidth * (this.ZOOM - 1.0f) / 2.0f);
            int n2 = (int)((float)this.gridHeight * (this.ZOOM - 1.0f) / 2.0f);
            int n3 = this.mouseOverCharX * this.gridWidth + this.canvasInset_X - n;
            int n4 = this.mouseOverCharY * this.gridHeight + this.canvasInset_Y - n2;
            int n5 = (int)((float)this.gridWidth * this.ZOOM);
            int n6 = (int)((float)this.gridHeight * this.ZOOM);
            this.zoomWindow.setLocation(point.x + n3, point.y + n4);
            if (!this.nowZooming) {
                if (this.zoomWindow.getWarningString() != null) {
                    this.zoomWindow.setSize(n5 + 1, n6 + 20);
                } else {
                    this.zoomWindow.setSize(n5 + 1, n6 + 1);
                }
            }
            this.zoomImage = (BufferedImage)this.zoomWindow.createImage(n5 + 1, n6 + 1);
            Graphics2D graphics2D = (Graphics2D)this.zoomImage.getGraphics();
            FontPanel.this.testFont = FontPanel.this.testFont.deriveFont((float)FontPanel.this.fontSize * this.ZOOM);
            this.setParams(graphics2D);
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n5, n6);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(0, 0, n5, n6);
            this.modeSpecificDrawChar(graphics2D, this.currMouseOverChar, n5 / 2, (int)((float)this.maxAscent * this.ZOOM));
            graphics2D.dispose();
            if (!this.nowZooming) {
                this.zoomWindow.show();
            }
            this.zoomWindow.getGraphics().drawImage(this.zoomImage, 0, 0, this);
            this.nowZooming = true;
            this.prevZoomChar = this.currMouseOverChar;
            FontPanel.this.testFont = font;
            if (this.firstTime()) {
                this.refresh();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!FontPanel.this.showingError && this.checkMouseLoc(mouseEvent)) {
                this.showZoomed();
                this.setCursor(this.blankCursor);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (FontPanel.this.textToUse == 0 || FontPanel.this.textToUse == 1) {
                if (this.nowZooming) {
                    this.zoomWindow.hide();
                }
                this.nowZooming = false;
            }
            this.setCursor(Cursor.getDefaultCursor());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!FontPanel.this.showingError && !this.nowZooming) {
                FontPanel.this.f2dt.fireChangeStatus(this.backupStatusString, false);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!FontPanel.this.showingError && !this.checkMouseLoc(mouseEvent)) {
                FontPanel.this.f2dt.fireChangeStatus(this.backupStatusString, false);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!FontPanel.this.showingError && this.nowZooming && this.checkMouseLoc(mouseEvent) && this.currMouseOverChar != this.prevZoomChar) {
                this.showZoomed();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        static /* synthetic */ BufferedImage access$300(FontCanvas fontCanvas) {
            return fontCanvas.zoomImage;
        }

        static /* synthetic */ JWindow access$400(FontCanvas fontCanvas) {
            return fontCanvas.zoomWindow;
        }
    }
}

