package Gimp::Config;

=cut

=head1 NAME

  Gimp::Config - config options found during configure time.

=head1 DESCRIPTION

The Gimp::Config module creates a tied hash %Gimp::Config which contains
all the definitions the configure script and perl deduced from the system
configuration at configure time. You can access these values just like you
access any other values, i.e.  C<$Gimp::Config{KEY}>. Some important keys are:

  IN_GIMP	=> true when gimp-perl was part of the Gimp distribution.
  GIMP		=> the path of the gimp executable
  prefix	=> the installation prefix
  libdir	=> the gimp systemwide libdir
  bindir	=> paths where gimp binaries are installed
  gimpplugindir	=> the gimp plug-in directory (without the /plug-ins-suffix)

=head1 SEE ALSO

L<Gimp>.

=cut

sub TIEHASH {
   my $pkg = shift;
   my $self;

   bless \$self, $pkg;
}

sub FETCH {
   $cfg{$_[1]};
}

tie %Gimp::Config, 'Gimp::Config';

%cfg = (
   INC1                 => q[-I/tmp/gimp-1.2.5/plug-ins/perl],
   LIBS                 => q[],
   IN_GIMP              => q[1],
   _GIMP_LIBS_NOUI      => q[-L/tmp/gimp-1.2.5/plug-ins/perl/../../libgimp/.libs -L/tmp/gimp-1.2.5/plug-ins/perl/../../libgimp -lgimp -L/usr/lib -lglib ],
   GIMP                 => q[/usr/bin/gimp],
   _CPPFLAGS            => q[ -DGTK_DISABLE_COMPAT_H],
   _EXTENSIVE_TESTS     => q[0],
   _CFLAGS              => q[-O2 -march=i486 -mcpu=i686 ],
   GLIB_CFLAGS          => q[-I/usr/include/glib-1.2 -I/usr/lib/glib/include],
   pdl_typemaps         => q[],
   _GIMP_LIBS           => q[-L/tmp/gimp-1.2.5/plug-ins/perl/../../libgimp/.libs -L/tmp/gimp-1.2.5/plug-ins/perl/../../libgimp -lgimp -L/usr/lib -lglib  -lgimpui],
   bindir               => q[/usr/bin],
   MSGFMT               => q[/usr/bin/msgfmt],
   INSTALL_PROGRAM      => q[/usr/bin/ginstall -c],
   pdl_inc              => q[],
   gimpplugindir        => q[/usr/lib/gimp/1.2],
   GIMPTOOL             => q[../../gimptool-1.2],
   MSGMERGE             => q[@MSGMERGE@],
   INTLLIBS             => q[],
   GLIB_LIBS            => q[-L/usr/lib -lglib],
   _GIMP_INC            => q[-I/tmp/gimp-1.2.5/plug-ins/perl/../.. -I/usr/include/glib-1.2 -I/usr/lib/glib/include -I/usr/include/gtk-1.2 -I/usr/include/glib-1.2 -I/usr/lib/glib/include -I/usr/X11R6/include],
   exec_prefix          => q[/usr],
   datadir              => q[/usr/share],
   _GIMP_INC_NOUI       => q[-I/tmp/gimp-1.2.5/plug-ins/perl/../.. -I/usr/include/glib-1.2 -I/usr/lib/glib/include -I/usr/include/gtk-1.2 -I/usr/include/glib-1.2 -I/usr/lib/glib/include -I/usr/X11R6/include],
   DEFINE1              => q[ -Ddatadir="\\"/usr/share\\""],
   _LDFLAGS             => q[],
   libdir               => q[/usr/lib],
   _PERL                => q[/usr/bin/perl],
   GIMP_PREFIX          => q[/usr],
   INSTALL              => q[/usr/bin/ginstall -c],
   prefix               => q[/usr],
);

1;
