/*------------------------------ nsContextMenu ---------------------------------
|   This JavaScript "class" is used to implement the IM standalon's            |
|   content-area context menu.                                                 |
|                                                                              |
|   For usage, see references to this class in contextMenu.xul.                |
|                                                                              |
------------------------------------------------------------------------------*/
// global context menu
//var contextMenu = null;

function nsContextMenu( xulMenu ) {
  this.menu		          = null;
  this.onlineTab        = false;
  this.listSetupTab     = false;
  this.sidebar          = false;
  this.screenName       = "";
  this.target           = null;

  // Initialize new menu.
  this.initMenu( xulMenu );
}

// Prototype for nsContextMenu "class."
nsContextMenu.prototype = {

    // onDestroy is a no-op at this point.
    onDestroy : function () {
    },

    // Initialize context menu.
    initMenu : function ( popup, event ) {
        
        this.menu = popup;

        // Get contextual info.
        this.setTarget( document.popupNode );
    
        // Initialize (disable/remove) menu items.
        this.initItems();
    },

    initItems : function () {
        this.initOnlineItems();
        this.initListSetupItems();
        var supportmailim = aimPrefsManager().GetBoolPref("aim.session.supportmailim", null, false);
        if (!supportmailim) {
          this.setItemAttr("menu_switchview","hidden", "true");
          this.setItemAttr("dispNameseparator","hidden", "true");
          this.setItemAttr("context-editbuddyinfo","hidden", "true");
          // this.setItemAttr("context-editdispname","hidden", "true");
          // this.setItemAttr("context-updateemail","hidden", "true");
          this.setItemAttr("preemailseperator","hidden", "true");
          this.setItemAttr("context-sendemail","hidden", "true");
          this.setItemAttr("context-checkemail","hidden", "true");
          this.setItemAttr("gmiseparator","hidden", "true");
        }
    },

    initOnlineItems : function () {
      this.showItem("context-getMemberInfo", this.onlineTab );
      this.showItem( "context-sendIM", this.onlineTab );
      this.showItem( "context-sendChat", this.onlineTab );
      this.showItem("context-block");
      this.showItem("blockseperator");
      if (this.screenName != "" && this.screenName != null) {
        this.setItemAttr("sendfileseparator","hidden", this.listSetupTab);
        this.showItem( "context-sendFile", this.onlineTab );
        this.showItem("context-block", this.menu);
        this.showItem("blockseperator", this.menu);
        var isInList = new Object();
        aimBuddyManager().IsBuddyInAlertList(this.screenName, isInList);
        if ( isInList.value == false ) {
          // Set the appropriate node's screen name to the buddy alert menu item
          this.setItemAttr("context-editbuddyAlert","hidden", "true");
          this.setItemAttr("context-delbuddyAlert","hidden", "true");
          var Msg1=window.document.getElementById("context-buddyAlert").getAttribute("label1");
          var Msg2=window.document.getElementById("context-buddyAlert").getAttribute("label2");
          var newlabel=Msg1+this.screenName+Msg2;
          window.document.getElementById("context-buddyAlert").setAttribute('label', newlabel);
          this.setItemAttr("buddyalertseperator","hidden", "false");
          this.setItemAttr("context-buddyAlert","hidden", "false");
        }
        else {
          // Set the Edit and Del buddy alert menu item
          var Msg1=window.document.getElementById("context-delbuddyAlert").getAttribute("label1");
          var Msg2=window.document.getElementById("context-delbuddyAlert").getAttribute("label2");
          var newlabel=Msg1+this.screenName+Msg2;
          this.setItemAttr("context-buddyAlert","hidden", "true");
          window.document.getElementById("context-delbuddyAlert").setAttribute('label', newlabel);
          this.setItemAttr("context-editbuddyAlert","hidden", "false");
          this.setItemAttr("context-delbuddyAlert","hidden", "false");
        }
      }
      else {
        //selected node has no screen name so it is a group
        this.setItemAttr("sendfileseparator","hidden", "true");
        //this.setItemAttr("buddyalertseperator","hidden", "true");
        this.setItemAttr("context-buddyAlert","hidden", "true");
        this.setItemAttr("context-editbuddyAlert","hidden", "true");
        this.setItemAttr("buddyalertseperator","hidden", "true");
        this.showItem( "context-sendFile", false);
        this.showItem("sendfileseparator", false);
        //this.showItem("context-editdispname", false);
        //this.showItem("context-sendemail", false);
        //this.showItem("context-checkemail", false);
        //this.showItem("context-updateemail", false);
        //this.setItemAttr("dispNameseparator","hidden", "true");
        //this.setItemAttr("preemailseperator","hidden", "true");
        //this.setItemAttr("emailseperator","hidden", "true");
        this.setItemAttr("sendfileseparator","hidden", "true");
      }
      
      this.showItem( "onlineseparator", this.onlineTab );
      //this.showItem( "context-EditList", this.sidebar );
    },

    initListSetupItems : function () {
        //this.showItem("context-buddyAlert", this.listSetupTab );
        //this.showItem( "context-addBuddy", this.listSetupTab );
//        this.showItem( "context-addGroup", this.listSetupTab );
//	    this.showItem( "context-delete", this.listSetupTab );
		//this.showItem( "context-editAB", this.listSetupTab );
      this.setItemAttr("sendfileseparator","hidden", this.listSetupTab);
      this.setItemAttr("dispNameseparator","hidden", this.listSetupTab);
    },

    // Set various context menu attributes based on the state of the world.
    setTarget : function ( node ) {
        // Remember the node that was clicked.
        this.target = node;
		  	var sidebarframe=window; 
	  	// determine if we're in the standalone or sidebar
		var parentState = top.document.getElementById("AimSidebarState");
		if(!parentState)
		{
			var tab = sidebarframe.document.getElementById("OnlineOrgTabPanel");
			if (tab.selectedIndex == 0 )  
				{
				this.sidebar = true;   
				this.onlineTab = true;
				this.listSetupTab = false;
				}        
                       else
				{
				this.sidebar = true;   
                                this.onlineTab = false;
                                this.listSetupTab = true;  
				}
        }
        else
        {
		      var curTab;
		      curTab = parentState.getAttribute("AimSidebarTab");
          // Determine if we're in the Online tab or List Setup tab
		      if(curTab == "Online")
			      {
				      this.onlineTab = true;
				      this.listSetupTab  = false;
              this.sidebar = false;
			      }
		      else
			      {
				      this.listSetupTab = true;
				      this.onlineTab = false;
              this.sidebar = false;
			      }
          }

        // set the screen name based on the target
        //this.screenName = this.target.parentNode.parentNode.getAttribute('ScreenName');
        this.screenName = getSelectedScreenName();
        
    },

    // sendIM
    cmdContextSendIM : function () {
      dump("Context: Send IM\n");
	cmdNewIM();
/*      if (aimIMDoesIMExist(this.screenName))
			  aimErrorBox(aimString("msg.DuplicateIM"));
		  else 
				aimIMInvokeIMForm(this.screenName);
*/
    },

    // sendChat
    cmdContextSendChat : function () {
    	  //window.openDialog('chrome://aim/content/chatInviteBuddy.xul','_blank','chrome,all,dialog=no','', false,'outgoingchat');
     inviteArgsObj = {
     	inviteProposalScreenName: '', 
     	inviteProposalObj: null,
     	invitedScreenNames: getSelectedBuddiesFromList(),
     	inviteToExistingWindow: false,
     	inviteMode: 'outgoingchat'
     	}
    	  window.openDialog('chrome://aim/content/chatInviteBuddy.xul','_blank','chrome,all,dialog=no',inviteArgsObj);


		  dump("Context: Chat\n");
    },

    cmdContextSendFile : function () {
     inviteArgsObj = {
     	inviteProposalScreenName: getSelectedScreenName(), 
     	inviteProposalObj: null,
     	inviteToExistingWindow: false,
     	inviteMode: 'outgoingfile'
     	}
    	  window.openDialog('chrome://aim/content/sendfile.xul','_blank','chrome,all,dialog=no',inviteArgsObj);
    },

    cmdContextGetMemberInfo : function () {
      var screenName = getSelectedScreenName();
      window.openDialog('chrome://aim/content/GetMemberInfo.xul','_blank','chrome,all,dialog=no', screenName);
    },

    // Edit List
    cmdContextEditList : function  () {
      dump("Context: Edit List\n");
      //toOpenWindowByType2('Aim:AimApp', 'chrome://aim/content/App.xul');
    },

    // addbuddy
    cmdContextAddBuddy : function () {
      dump("Context: Add Buddy\n");
      cmdAddBuddy();
    },

    // addGroup
    cmdContextAddGroup : function () {
      dump("Context: Add Group\n");
      cmdAddGroup();
    },

  	// delete
    cmdContextDelete : function () {
      dump("Context: Delete\n");
      cmdDelete();
    },

    cmdContextBuddyAlert : function (isedit) {
      var screenName = getSelectedScreenName();
      var groupName = getGroupForScreenName();
      if (screenName && (screenName != null) && groupName && (groupName != null)) 
      {
        if (isedit == 1) 
          window.openDialog('chrome://aim/content/AimBuddyAlert.xul','_blank','chrome,all,dialog=no', screenName, groupName, 1);
        else
          window.openDialog('chrome://aim/content/AimBuddyAlert.xul','_blank','chrome,all,dialog=no', screenName, groupName, null);
      }	
    },
    
    cmdContextDelBuddyAlert : function () {
      var screenName = getSelectedScreenName();
      var groupName = getGroupForScreenName();
      if (screenName && (screenName != null) && groupName && (groupName != null))
        aimBuddyManager().DeleteBuddyFromAlertList(screenName, groupName);
    },

    cmdContextBlockBuddy : function () {
      var pIAimPrivacy = aimPrivacy();
      if ( !pIAimPrivacy )
        return false;
      pIAimPrivacy.BlockUser(this.screenName);
    },

	//cmdContextEditAB : function () {
      //dump("Context: Edit AddressBook\n");
	  //cmdAbEditCard();
	//},     

    // Utilities

    // Show/hide one item (specified via name or the item element itself).
    showItem : function ( itemOrId, show ) {
        var item = null;
        if ( itemOrId.constructor == String ) {
            // Argument specifies item id.
            item = document.getElementById( itemOrId );
        } else {
            // Argument is the item itself.
            item = itemOrId;
        }
        if ( item ) {
            var styleIn = item.getAttribute( "style" );
            var styleOut = styleIn;
            if ( show ) {
                // Remove style="display:none;".
                styleOut = styleOut.replace( "display:none;", "" );

            } else {
                // Set style="display:none;".
                if ( styleOut.indexOf( "display:none;" ) == -1 ) {
                    // Add style the first time we need to.
                    styleOut += "display:none;";
                }
            }
            // Only set style if it's different.
            if ( styleIn != styleOut ) {
                item.setAttribute( "style", styleOut );
            }
        }
    },

    // Set given attribute of specified context-menu item.  If the
    // value is null, then it removes the attribute (which works
    // nicely for the disabled attribute).
    setItemAttr : function ( id, attr, val ) {
        var elem = document.getElementById( id );
        if ( elem ) {
            if ( val == null ) {
                // null indicates attr should be removed.
                elem.removeAttribute( attr );
            } else {
                // Set attr=val.
                elem.setAttribute( attr, val );
            }
        }
    },

    // Set context menu attribute according to like attribute of another node
    // (such as a broadcaster).
    setItemAttrFromNode : function ( item_id, attr, other_id ) {
        var elem = document.getElementById( other_id );
        if ( elem && elem.getAttribute( attr ) == "true" ) {
            this.setItemAttr( item_id, attr, "true" );
        } else {
            this.setItemAttr( item_id, attr, null );
        }
    }
};
