/*------------------------------ IcqContextMenu ---------------------------------
|   This JavaScript "class" is used to implement the IM standalon's            |
|   content-area context menu.                                                 |
|                                                                              |
|   For usage, see references to this class in IcqcontextMenu.xul.                |
|                                                                              |
------------------------------------------------------------------------------*/

function nsIcqContextMenu( xulMenu ) {
  this.menu		          = null;
  this.sidebar          = false;
  this.screenName       = "";
  this.onlineTab        = false;
  this.listSetupTab     = false;
  this.target           = null;
  this.initMenu( xulMenu );
}

nsIcqContextMenu.prototype = {

    onDestroy : function () {
    },
    initMenu : function ( popup, event ) {
      this.menu = popup;
      this.setTarget( document.popupNode );
      this.initItems();
    },

  
    initItems : function () {
        this.showItem("context-sendICQ");
        this.showItem("onlineseparatoricq");
        this.showItem("context-rerequest");
        this.showItem("rerequestseperatoricq");
        this.showItem("context-editdisplay");
        this.showItem("editseperatoricq");
        this.showItem("context-ignore");
        this.showItem("ignoreseperatoricq");
        if (this.screenName != "" && this.screenName != null) {
          this.showItem("context-sendICQ", this.onlineTab);
          this.showItem("onlineseparatoricq", this.onlineTab);
          this.showItem("context-editdisplay", this.menu);
          this.showItem("editseperatoricq", this.menu);
          this.showItem("context-ignore", this.onlineTab);
          this.showItem("ignoreseperatoricq", this.onlineTab);
          var isInAuthList = new Object();
          aimFeedbagManager().IsInAuthList(this.screenName, isInAuthList);
          if ( isInAuthList.value == true )  {
            this.showItem("context-rerequest", this.menu);
            this.showItem("rerequestseperatoricq", this.menu);
          }
        }
        
    },

    setTarget : function ( node ) {
      this.target = node;
	  	var sidebarframe=window; 
  		var parentState = top.document.getElementById("AimSidebarState");
  		if(!parentState)
		  {
			  var tab = sidebarframe.document.getElementById("OnlineOrgTabPanel");
			  if (tab.selectedIndex == 0 )  
				{
				  this.sidebar = true;   
				  this.onlineTab = true;
				  this.listSetupTab = false;
				}        
        else
				{
				  this.sidebar = true;   
          this.onlineTab = false;
          this.listSetupTab = true;  
				}
      }
      else
      {
        var curTab;
        curTab = parentState.getAttribute("AimSidebarTab");
          // Determine if we're in the Online tab or List Setup tab
		    if(curTab == "Online")
			  {
				  this.onlineTab = true;
				  this.listSetupTab  = false;
          this.sidebar = false;
			  }
		    else
			  {
				  this.listSetupTab = true;
				  this.onlineTab = false;
          this.sidebar = false;
			  }
      }
      this.screenName = getSelectedScreenName();
    },

    
    cmdContextSendIM : function () {
      cmdNewIM();
    },

    cmdContextAddContact : function () {
      cmdAddBuddy();
    },

    cmdContextAddGroup : function () {
      cmdAddGroup();
    },

    cmdContextDelete : function () {
      cmdDelete();
    },
    
    cmdContextReRequest : function () {
      cmdRequestAuth();
    },

    cmdContextEditDisplay : function () {
      cmdRename();
    },

    cmdContextFindUser : function () {
      cmdIcqSearch();
    },
    
    cmdContextIgnore : function () {
      var pIAimPrivacy = aimPrivacy();
      if ( !pIAimPrivacy )
        return false;
      pIAimPrivacy.DenyListAdd(this.screenName);
    },
    
    // Utilities

    // Show/hide one item (specified via name or the item element itself).
    showItem : function ( itemOrId, show ) {
        var item = null;
        if ( itemOrId.constructor == String ) {
            // Argument specifies item id.
            item = document.getElementById( itemOrId );
        } else {
            // Argument is the item itself.
            item = itemOrId;
        }
        if ( item ) {
          var styleIn = item.getAttribute( "style" );
          var styleOut = styleIn;
          if ( show ) {
            // Remove style="display:none;".
            styleOut = styleOut.replace( "display:none;", "" );

           } else {
                // Set style="display:none;".
                if ( styleOut.indexOf( "display:none;" ) == -1 ) {
                    // Add style the first time we need to.
                    styleOut += "display:none;";
                }
            }
            // Only set style if it's different.
            if ( styleIn != styleOut ) {
                item.setAttribute( "style", styleOut );
            }
        }
    },

    // Set given attribute of specified context-menu item.  If the
    // value is null, then it removes the attribute (which works
    // nicely for the disabled attribute).
    setItemAttr : function ( id, attr, val ) {
        var elem = document.getElementById( id );
        if ( elem ) {
            if ( val == null ) {
                // null indicates attr should be removed.
                elem.removeAttribute( attr );
            } else {
                // Set attr=val.
                elem.setAttribute( attr, val );
            }
        }
    },

    // Set context menu attribute according to like attribute of another node
    // (such as a broadcaster).
    setItemAttrFromNode : function ( item_id, attr, other_id ) {
        var elem = document.getElementById( other_id );
        if ( elem && elem.getAttribute( attr ) == "true" ) {
            this.setItemAttr( item_id, attr, "true" );
        } else {
            this.setItemAttr( item_id, attr, null );
        }
    }
};
